import { Routes } from '@appTypes/routing'

export const routes: Routes = {
    siteRoot: '/',
    usersRoot: '/users',
    adminRoot: '/admin',
    adminUsersRoot: '/admin/users',
    adminUsersInvite: '/admin/users/invite',
    adminDomainsRoot: '/admin/domains',
    adminDomainsAdd: '/admin/domains/add',
    adminGroupsRoot: '/admin/groups',
    adminGroupsCreate: '/admin/users/create',
    authApiSignInAzureB2C: '/api/auth/signin/azure-ad-b2c',
    authApiSignOut: '/api/auth/signout/azure-ad-b2c',
    authSignIn: '/auth/signin',
    authSignOut: '/auth/signout',
    groupsRoot: '/groups',
    groupsDiscover: '/groups/discover',
    groupRoot: '/:groupId',
    groupUpdate: '/:groupId/update',
    groupInvite: '/:groupId/invite',
    groupJoin: '/:groupId/join',
    groupLeave: '/:groupId/leave',
    groupForumRoot: '/:groupId/forum',
    groupFoldersRoot: '/:groupId/folders',
    groupFolder: '/:groupId/folders/:folderId',
    groupFilesRoot: '/:groupId/files',
    groupMembersRoot: '/:groupId/members',
    groupWhiteboardRoot: '/:groupId/whiteboard',
    groupAboutRoot: '/:groupId/about',
}
