import { GenericPageTextContent } from '@appTypes/content'

export default {
    title: 'Contact Us',
    metaDescription: 'Contact us',
    mainHeading: 'Contact Us',
    bodyHtml: `
        <p>Thanks for getting in touch.<p>  
        <p>FutureNHS is here to help and there are a number of ways to reach us.<p>   
        <p>Do visit our What is FutureNHS? hyperlink which may give you the answers you are looking for. This tells you a bit about the platform, how to join or register, and lets you explore workgroups, forums and communities.<p>   
        <p>We can be contacted from 9am to 5pm Monday to Friday. We are closed during weekends* and bank holidays.<p>       
        <h2>How can we help you?</h2>
        <h3>FutureNHS Support</h3>
        <p>Got a technical question or need help managing your group/workspace? If you can’t find what you’re after in our <a href="https://support-futurenhs.zendesk.com/hc/en-gb" rel="noreferrer nofollow">support area</a> get in touch. We typically respond within 48 hours. There’s also lots of useful information in our themed FAQs and you can reach us on email <a href="mailto:support@futurenhs.zendesk.com" rel="noreferrer nofollow">support@futurenhs.zendesk.com</a></p>
        <h3>General post</h3> 
        <p>You can write to us at: FutureNHS, NHS England, PO Box 16738, Redditch, B97 9PT.</p>
        <h3>News enquiries</h3>
        <p>Media enquiries should be directed to the <a href="https://www.england.nhs.uk/contact-us/media/" rel="noreferrer nofollow">central NHS England and Improvement media team.</a></p>   
        <h3>Freedom of information requests</h3> 
        <p>FutureNHS is part of NHS England and as a public body is subject to the Freedom of Information Act 2000 which means platform content is subject to Freedom of Information (FOI) requests.</p>  
        <p>Find out how to make a <a href="https://www.england.nhs.uk/contact-us/foi/" rel="noreferrer nofollow">freedom of information request</a> and what’s involved.</p> 
        <h3>How can we improve your FutureNHS experience?</h3> 
        <p>We want you to share your thoughts about how we can make the platform even better. Whether it’s about functionality or design, communications or the support desk; we would love to hear from you so we can develop this collaborative tool even more and continue and improve email <a href="mailto:support@futurenhs.zendesk.com" rel="noreferrer nofollow">support@futurenhs.zendesk.com</a>.</p> 
    `,
} as GenericPageTextContent
