import { GenericPageTextContent } from '@appTypes/content'

export default {
    title: 'Privacy Policy',
    metaDescription: 'Read our privacy policy',
    mainHeading: 'FutureNHS  Privacy Policy',
    bodyHtml: `
        <p>Last updated: 15/03/2022</p>
        <p>FutureNHS (or collaborate.future.nhs.uk) is provided by NHS England.</p>
        <p>NHS England is the data controller for pages starting with collaborate.future.nhs.uk - for example <a href="/contact-us">https://collaborate.future.nhs.uk/contact-us</a>.</p>
        <p>If you follow a link to a service provided by someone other than NHS England, please be aware that a different organisation will:</p>
        <ul>
            <li>Be the data controller</li>
            <li>Be responsible for processing any data you share with them</li>
            <li>Publish and manage their own privacy notice with details of how to contact them</li>
        </ul>
        <p>A data controller determines how and why personal data is processed. For more information, read the Cabinet Office’s entry in <a href="https://ico.org.uk/ESDWebPages/Entry/Z7414053" rel="noreferrer nofollow">the Data Protection Public Register</a>.</p>
        <p>You can find out contact details on our <a href="/contact-us">contact us page</a>.</p>
        <h2>What data we collect</h2>
        <p>Depending on how you use the platform, the types of personal data we may collect from you includes:</p>
        <ul>
            <li>questions, queries or feedback you leave, including your email address if you contact the FutureNHS team</li>
            <li>your email address and subscription preferences when you sign up to our email alerts</li>
            <li>how you use our emails - for example whether you open them and which links you click on</li>
            <li>your Internet Protocol (IP) address, and details of which version of web browser you used</li>
            <li>information on how you use the site, using <a href="/cookies">cookies</a> and page tagging techniques</li>
        </ul>
        <p>When you register with the FutureNHS platform and create an account we also collect</p>
        <ul>
            <li>Your email address and name</li>
            <li>Optional identity and contact data you provide when you register to use FutureNHS, including for example your role, organisation, geographical location, etc.</li>
            <li>Identifiable FutureNHS usage data that is automatically collected by the platform database when you visit, such as pages visited and documents opened, how often you use the Portal and when</li>
        </ul>
        <p>We use <a href="https://support.google.com/analytics/topic/2919631" rel="noreferrer nofollow">Google Analytics</a> to collect information about how you use FutureNHS and how the website performs during your visit. This includes IP addresses. The data is anonymised before being used for analytics and web performance processing.</p>
        <p>Google Analytics processes anonymised information about:</p>
        <ul>
            <li>the pages you visit on FutureNHS</li>
            <li>how long you spend on each FutureNHS page</li>
            <li>how you got to the site</li>
            <li>what you click on while you’re visiting the site</li>
        </ul>
        <p>We do not store your personal information through Google Analytics (for example your name or address).</p>
        <p>We will not identify you through analytics information, and we will not combine analytics information with other data sets in a way that would identify who you are.</p>
        <p>We continuously test and monitor our data protection controls to make sure they’re effective and to detect any weaknesses.</p>
        <h2>Why we need your data</h2>
        <p>Most of the personal information we process is provided to us directly by you for one of the following reasons:</p>
        <ul>
            <li>To support you in being able to use the platform</li>
            <li>To ensure we can help you locate and interact with content on the platform that is most relevant to you</li>
            <li>To ensure the safety of all users of the platform</li>
        </ul>
        <p>We also receive personal information indirectly. From the following sources in order to see how see how you use FutureNHS and how well the site performs on your device:</p>
        <ul>
            <li>Google Analytics</li>
            <li>Azure Monitor</li>
        </ul>
        <p>We use the information that you have given us in order to:</p>
        <ul>
            <li>make sure FutureNHS is meeting the needs of its users</li>
            <li>make improvements, for example improving site search</li>
            <li>make performance improvements, for example improving page load time and data usage</li>
        </ul>
        <p>We also collect data in order to:</p>
        <ul>
            <li>ensure users use the platform safely and securely</li>
            <li>gather feedback to improve our services, for example our email alerts</li>
            <li>respond to any feedback you send us, if you’ve asked us to</li>
            <li>send email alerts to users who request them</li>
            <li>help you get to relevant information on the platform as quickly as possible</li>
            <li>monitor use of the site to identify security threats</li>
            <li>monitor the performance of the site to identify inefficiencies and JavaScript errors</li>
        </ul>
        
        <p>Under the General Data Protection Regulation (GDPR), the lawful bases we rely on for processing this information are:</p>
        <ul>
            <li>Your consent. You can remove your consent at any time. You can do this by <a href="/contact-us">contacting us</a></li>
            <li>To perform a public task</li>
        </ul>
        <h2>Your data protection rights</h2>
        <p>Under data protection law, you have rights including:</p>
        <ul>
            <li><span class="u-text-bold">Your right of access</span> - You have the right to ask us for copies of your personal information.</li>
            <li><span class="u-text-bold">Your right to rectification</span> - You have the right to ask us to rectify personal information you think is inaccurate. You also have the right to ask us to complete information you think is incomplete.</li>
            <li><span class="u-text-bold">Your right to erasure</span> - You have the right to ask us to erase your personal information in certain circumstances.</li>
            <li><span class="u-text-bold">Your right to restriction of processing</span> - You have the the right to object to the processing of your personal information in certain circumstances.</li>
            <li><span class="u-text-bold">Your right to object to processing</span> - You have the the right to object to the processing of your personal information in certain circumstances.</li>
            <li><span class="u-text-bold">Your right to data portability</span> - You have the right to ask that we transfer the personal information you gave us to another organisation, or to you, in certain circumstances.</li>
        </ul>
        <p>You are not required to pay any charge for exercising your rights. If you make a request, we have one month to respond to you.</p>
        <p>Please <a href="/contact-us">contact us</a> if you wish to make a request.</p>
        <h2>How to complain</h2>
        <p>If you have any concerns about our use of your personal information, you can <a href="/contact-us">contact us</a> to make a complaint.</p>
        <p>You can also complain to the ICO if you are unhappy with how we have used your data.</p>
        <p>The ICO's address:</p>
        <p>Information Commissioner’s Office</p>
        <p>Wycliffe House</p>
        <p>Water Lane</p>
        <p>Wilmslow</p>
        <p>Cheshire</p>
        <p>SK9 5AF</p>
        <br>
        <p>Helpline number: 0303 123 1113</p>
        <p>ICO website: <a href="https://www.ico.org.uk" rel="noreferrer nofollow">https://www.ico.org.uk</a></p>

    `,
} as GenericPageTextContent
