import { GenericPageTextContent } from '@appTypes/content'

export default {
    title: 'Cookies',
    metaDescription: 'Cookie policy',
    mainHeading: 'Cookies',
    bodyHtml: `
        <p><a href="/">FutureNHS</a> puts small files (known as 'cookies') on your computer.</p>
        <p>These cookies are used across the FutureNHS platform.</p>
        <p>We only set tracking cookies when JavaScript is running in your browser and you’ve accepted them. If you choose not to run Javascript, the information on this page will not apply to you.</p>
        <p>Find out <a href="https://ico.org.uk/for-the-public/online/cookies" rel="noreferrer nofollow">how to manage cookies</a> from the Information Commissioner's Office.</p>
        <h2>Essential cookies (strictly necessary)</h2>
        <p>We use an essential cookie to remember when you accept or reject cookies on our website.</p>
        <table class="c-table u-mb-6">
            <caption class="c-table_caption u-text-base">Essential cookies we use</caption>
            <thead>
                <tr class="u-sr-only tablet:u-not-sr-only">
                    <th scope="col" class="tablet:u-w-1/4">Name</th>
                    <th scope="col" class="tablet:u-w-2/4">Purpose</th>
                    <th scope="col" class="tablet:u-w-1/4">Expires</th>
                </tr>
            </thead>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>[cookie_name]</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-auto tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Purpose</span>Saves your cookie consent settings</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Expires</span>1 year</td>
            </tr>
        </table>
        <h2 class="u-mt-6">Analytics cookies (optional)</h2>
        <p>We use third party analytics software to understand how people use the FutureNHS platform. We do this to help make sure the site is meeting the needs of its users and to help us make</p>
        <p>We do not actively share your personal data (for example your name or email address) with our analytics providers, so this information cannot be used to identify who you are.</p>
        <h3>Google Analytics</h3>
        <p>Google Analytics is a web analytics service offered by Google that tracks and reports website traffic.</p>
        <p>Google Analytics stores information about:</p>
        <ul>
            <li>the pages you visit</li>
            <li>how long you spend on each page</li>
            <li>how you arrived at the site</li>
            <li>what you click on while you visit the site</li>
            <li>the device and browser you use</li>
        </ul>
        <table class="c-table u-mb-6">
            <caption class="c-table_caption u-text-base">Google Analytics cookies we use</caption>
            <thead>
                <tr class="u-sr-only tablet:u-not-sr-only">
                    <th scope="col" class="tablet:u-w-1/4">Name</th>
                    <th scope="col" class="tablet:u-w-2/4">Purpose</th>
                    <th scope="col" class="tablet:u-w-1/4">Expires</th>
                </tr>
            </thead>
            <tr class="u-flex u-flex-wrap tablet:u-table-row  u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_ga</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-auto tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Purpose</span>Helps us count how many people visit the FutureNHS platform by telling us if you’ve visited before.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Expires</span>2 years</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span> _gid</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-auto tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Purpose</span>Helps us count how many people visit the FutureNHS platform by telling us if you’ve visited before.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Expires</span>24 hours</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_gat_UA-[random number]</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-auto tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Purpose</span>Used to reduce the number of requests.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Expires</span>1 minute</td>
            </tr>
        </table>
        <h3>Hotjar</h3>
        <p>Hotjar is a technology service that helps us better understand our users’ experience (e.g. how much time they spend on which pages, which links they choose to click, what users do and don’t like, etc.) and this enables us to build and maintain our service with user feedback. Hotjar uses cookies and other technologies to collect data on our users’ behavior and their devices.</p>
        <p>Hotjar stores information about:</p>
        <ul>
            <li>your device's IP address (processed during your session and stored in a de-identified form)</li>
            <li>your device screen size</li>
            <li>your device type (unique device identifiers)</li>
            <li>your browser information</li>
            <li>your geographic location (country only)</li>
            <li>the preferred language used to display the FutureNHS platform</li>
        </ul>
        <p>Hotjar stores this information on our behalf in a pseudonymized user profile. Hotjar is contractually forbidden to sell any of the data collected on our behalf.</p>
        <table class="c-table u-mb-6">
            <caption class="c-table_caption u-text-base">Hotjar cookies we use</caption>
            <thead>
                <tr class="u-sr-only tablet:u-not-sr-only">
                    <th scope="col" class="tablet:u-w-2/6">Name</th>
                    <th scope="col" class="tablet:u-w-2/6">Description</th>
                    <th scope="col" class="tablet:u-w-1/6">Duration</th>
                    <th scope="col" class="tablet:u-w-1/6">Data type</th>
                </tr>
            </thead>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjSessionUser{site_id}</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>Hotjar cookie that is set when a user first lands on a page with the Hotjar script. It is used to persist the Hotjar User ID, unique to that site on the browser. This ensures that behavior in subsequent visits to the same site will be attributed to the same user ID.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>365 days</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>JSON</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjSession{site_id}</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>A cookie that holds the current session data. This ensues that subsequent requests within the session window will be attributed to the same Hotjar session.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>30 minutes</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>JSON</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjClosedSurveyInvites</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>Hotjar cookie that is set once a user interacts with an External Link Survey invitation modal. It is used to ensure that the same invite does not reappear if it has already been shown.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>365 days</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjDonePolls</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>Hotjar cookie that is set once a user completes a survey using the On-site Survey widget. It is used to ensure that the same survey does not reappear if it has already been filled in.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>365 days</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjMinimizedPolls</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>Hotjar cookie that is set once a user minimizes an On-site Survey widget. It is used to ensure that the widget stays minimized when the user navigates through your site.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>365 days</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjShownFeedbackMessage</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>Hotjar cookie that is set when a user minimizes or completes Incoming Feedback. This is done so that the Incoming Feedback will load as minimized immediately if the user navigates to another page where it is set to show.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>365 days</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjSessionTooLarge</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>Causes Hotjar to stop collecting data if a session becomes too large. This is determined automatically by a signal from the WebSocket server if the session size exceeds the limit.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjSessionRejected</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>If present, this cookie will be set to '1' for the duration of a user's session, if Hotjar rejected the session from connecting to our WebSocket due to server overload. This cookie is only applied in extremely rare situations to prevent severe performance issues</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjSessionResumed</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>A cookie that is set when a session/recording is reconnected to Hotjar servers after a break in connection.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>      
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjid</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>Hotjar cookie that is set when the customer first lands on a page with the Hotjar script. It is used to persist the Hotjar User ID, unique to that site on the browser. This ensures that behavior in subsequent visits to the same site will be attributed to the same user ID.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>365 days</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>UUID</td>
            </tr>    
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjRecordingLastActivity</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This should be found in Session storage (as opposed to cookies). This gets updated when a user recording starts and when data is sent through the WebSocket (the user performs an action that Hotjar records).</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Numerical value (timestamp)</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjTLDTest</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>When the Hotjar script executes we try to determine the most generic cookie path we should use, instead of the page hostname. This is done so that cookies can be shared across subdomains (where applicable). To determine this, we try to store the _hjTLDTest cookie for different URL substring alternatives until it fails. After this check, the cookie is removed.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>    
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjUserAttributesHash</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>User Attributes sent through the Hotjar Identify API are cached for the duration of the session in order to know when an attribute has changed and needs to be updated.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Hash</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjCachedUserAttributes</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This cookie stores User Attributes which are sent through the Hotjar Identify API, whenever the user is not in the sample. Collected attributes will only be saved to Hotjar servers if the user interacts with a Hotjar Feedback tool, but the cookie will be used regardless of whether a Feedback tool is present.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>JSON</td>
            </tr>    
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjLocalStorageTest</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This cookie is used to check if the Hotjar Tracking Script can use local storage. If it can, a value of 1 is set in this cookie. The data stored in_hjLocalStorageTest has no expiration time, but it is deleted almost immediately after it is created.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Under 100ms</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjIncludedInPageviewSample</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This cookie is set to let Hotjar know whether that user is included in the data sampling defined by your site's pageview limit.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>30 minutes</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>  
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjIncludedInSessionSample</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This cookie is set to let Hotjar know whether that user is included in the data sampling defined by your site's daily session limit.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>30 minutes</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjAbsoluteSessionInProgress</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This cookie is used to detect the first pageview session of a user. This is a True/False flag set by the cookie.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>30 minutes</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>        
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjFirstSeen</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This is set to identify a new user’s first session. It stores a true/false value, indicating whether this was the first time Hotjar saw this user. It is used by Recording filters to identify new user sessions.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjViewportId</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This stores information about the user viewport such as size and dimensions.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>UUID</td>
            </tr>
            <tr class="u-flex u-flex-wrap tablet:u-table-row u-mb-3 tablet:u-mb-0">
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Name</span>_hjRecordingEnabled</td>
                <td class="u-flex-grow u-flex u-flex-col u-w-full tablet:u-w-3/8 tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Description</span>This is added when a Recording starts and is read when the recording module is initialized to see if the user is already in a recording in a particular session.</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Duration</span>Session</td>
                <td class="u-flex-grow u-flex u-flex-col tablet:u-table-cell"><span class="u-text-bold tablet:u-hidden">Data type</span>Boolean true/false</td>
            </tr>                      
        </table>

        
    `,
} as GenericPageTextContent
