import { GenericPageTextContent } from '@appTypes/content'

export default {
    metaDescription: 'The terms and conditions for using FutureNHS',
    title: 'Terms and Conditions',
    mainHeading: 'Terms and Conditions',
    bodyHtml: `
        <p>FutureNHS is owned by NHS England. The content, data and services on the FutureNHS are delivered by NHS England. You may access and use this service if you agree to be legally bound by the terms set out here. If you do not agree to be legally bound by these terms, please do not access and/or use the FutureNHS platform.</p>
        <h2>Services we provide</h2>
        <p>FutureNHS supports people working in health and social care to make change, improve and transform across organisations, places and professions.</p>
        <p>The platform allows members to respond quickly to the changing health and care landscape, most recently supporting its members to collaborate at scale during the COVID-19 pandemic and the implementation of the Long Term Plan.</p>
        <p>FutureNHS is safe, easy to use and supports a growing network of people who want to connect with others to accelerate their work. Members of the platform can join or create groups and communities to connect with others, learn and share.</p>
        <h3>Who can use FutureNHS</h3>
        <p>Access to FutureNHS is restricted to authorised users only who have been invited to use the platform. All accounts created on FutureNHS must be created be owned, managed and represent individuals. Invitations are personal to the account that we send the invitation to. The use of shared log in credentials is prohibited and all log in details must be kept confidential. You are accountable for all activity carried out under your FutureNHS account.  All activity on FutureNHS is auditable against specific user credentials. Authorised users sharing log in credentials may have their access revoked. Unauthorised individuals attempting to access the site may be subject to legal action.</p>
        <p>You must not post personal data about individuals other than where this immediately relevant to their role in the collaboration (e.g. in meeting minutes). You must not post confidential information, or special category personal data information about yourself or others (information revealing a person’s racial or ethnic origin, political opinions, religious or philosophical beliefs, criminal history, trade union membership, or health or sex life).You are responsible for ensuring that your FutureNHS profile is accurate and kept up to date.</p>
        <h3>Contributing to site content</h3>
        <p>Whenever you make use of a feature that allows you to add or upload content to FutureNHS, for example participating in group forums or uploading files, you warrant that any added content:</p>
        <ul>
            <li>complies with all applicable data protection legislation and that all necessary permissions are in place to the extent that the content contains personal data;</li>
            <li>is uploaded or added with the permission from the owner of the content; and</li>
            <li>will not be a violation of any intellectual property rights, or any other rights, of a third party.</li>
        </ul>
        <p>You will be liable to us and shall indemnify us for any breach of any of these warranties.</p>
        <p>Users should report inappropriate content to the FutureNHS administration team upon discovery. Details on how to report inappropriate information can be found on our <a href="/contact-us">contact page</a>. We may remove any content which, in our opinion, does not comply with the FutureNHS policies or any applicable law or regulation and access privileges will be revoked.</p>
        <p>All content on this FutureNHS is classified as OFFICIAL, will be subject to Freedom of Information (FOI) requests and will be made available should an FOI request warrant this. OFFICIAL-SENSITIVE Content must not be uploaded to FutureNHS without prior authorisation from the platform administrators. Please <a href="/contact-us">contact us</a> to if you plan on sharing sensitive content.</p>
        <p>The FutureNHS copyright and database rights is governed under the current version of the Open Government Licence (“OGL”) whereby content uploaded onto the platform is subject to being shared by the public sector free of charge. However, the platform's terms and conditions do take precedent regarding any confidential/sensitive information not accessible to the public.</p>
        <p>Any uploaded content is for the purposes of collaboration and must be removed once no longer needed for these purposes.</p>
        <p>Any records should be held locally by the responsible organisation and maintained in accordance with the Information Governance Alliance’s Records Management Code of Practice for Health and Social Care.</p>
        <p>NHS England is not the controller for personal data uploaded onto FutureNHS, other than user credentials and account profiles. We will not be responsible, or liable to any third party, for the management of content or accuracy of any content posted by you or any other user of FutureNHS.</p>
        <h3>Consuming site content</h3>
        <p>You have permission to use FutureNHS content for the sole purposes described, and on the terms detailed, in these terms and conditions. You need written permission from us or any other owner of FutureNHS content before you may use these items in any other way.</p>
        <p>Copyright and database rights in FutureNHS are released free-of-charge under the current version of the Open Government Licence (“OGL”), except where specified, either in these terms and conditions, elsewhere on this website or in the OGL terms. If there is any conflict between the OGL terms and these terms and conditions these terms and conditions shall take precedence.</p>
        <p>This means that you can use FutureNHS content, including copying it, adapting it, and using it for any purpose, including commercially, provided you follow these terms and conditions and the terms of the OGL.</p>
        <p>The OGL terms do not apply to the following categories of content, and therefore these must not be used without our or the relevant owner’s prior consent:</p>
        <ul>
            <li>any logos, visuals, image rights, trademarks, trade names and design styles (except where these are integral to a document or data set) of the FutureNHS, or any predecessor or linked body, as well as of any partner or contributor;</li>
            <li>any other intellectual property rights, including but not limited to patents, design rights and trademarks;</li>
            <li>personal data (which will include but not be limited to images, videos and audio with identifiable people in them);</li>
            <li>information owned by third parties which we are not authorised to licence on to you.</li>
        </ul>
        <p>If in doubt, contact the content owner or <a href="/contact-us">contact us</a> to ask about permission.</p>
        <p>You must not use FutureNHS content for or in association with i) any purpose; or ii) a site or service; which is illegal, derogatory or otherwise objectionable or that brings the NHS into disrepute. If you process any personal data of your customers or users in association with your use of any FutureNHS content you must do so in compliance with all applicable data protection and privacy legislation and all relevant regulatory guidance, including General Data Protection Regulation and Data Protection Act 2018.</p>
        <p>If you provide any paid-for service to your customers or users, access to the FutureNHS content may be included within the standard purchase and set-up costs but no specific charge may be levied on any customers or users for access to any NHS Website Content.</p>
        <p>You may not directly or indirectly suggest any endorsement or approval by the NHS of your site or service, or any non-NHS entity, product or content or any views expressed within your site or service.</p>
        <p>We reserve the right to alter, adapt, edit, modify or restrict the availability of FutureNHS content for use on third-party sites at any time.</p>
        <h2>Disclaimer</h2>
        <p>Whilst we provide site administration to maintain FutureNHS, we do not provide any guarantees, conditions or warranties that the site and its contents will be:</p>
        <ul>
            <li>current</li>
            <li>secure</li>
            <li>accurate</li>
            <li>complete</li>
            <li>free from bugs or viruses</li>
        </ul>
        <p>We do not publish advice on FutureNHS. You should get professional or specialist advice before doing anything based on the site’s content.</p>
        <p>We’re not liable for any loss or damage that may come from using FutureNHS. This includes:</p>
        <ul>
            <li>any direct, indirect or consequential losses</li>
            <li>any loss or damage caused by civil wrongs (‘tort’, including negligence), breach of contract or otherwise</li>
            <li>the use of FutureNHS and any websites that are linked to or from it</li>
            <li>the inability to use FutureNHS and any websites that are linked to or from it</li>
        </ul>
        <p>This applies if the loss or damage was foreseeable, arose in the normal course of things or you advised us that it might happen.</p>
        <p>This includes (but is not limited to) the loss of your:</p>
        <ul>
            <li>income or revenue</li>
            <li>salary, benefits or other payments</li>
            <li>business</li>
            <li>profits or contracts</li>
            <li>opportunity</li>
            <li>anticipated savings</li>
            <li>data</li>
            <li>goodwill or reputation</li>
            <li>tangible property</li>
            <li>intangible property, including loss, corruption or damage to data or any computer system</li>
            <li>wasted management or office time</li>
        </ul>
        <p>We may still be liable for:</p>
        <ul>
            <li>death or personal injury arising from our negligence</li>
            <li>fraudulent misrepresentation</li>
            <li>any other liability which cannot be excluded or limited under applicable law</li>
        </ul>
        <h3>Requests to remove content</h3>
        <p>You can ask for content to be removed from FutureNHS. We’ll remove content:</p>
        <ul>
            <li>in order to comply with data protection legislation covering the rights and freedoms of individuals</li>
            <li>if it breaches copyright laws, contains sensitive personal data or material that may be considered obscene or defamatory</li>
        </ul>
        <p><a href="/contact-us">Contact us</a> to ask for content to be removed. You’ll need to send us the web address (URL) of the content and explain why you think it should be removed. We’ll reply to let you know whether we’ll remove it.</p>
        <p>We remove content at our discretion in discussion with the site member/s responsible for it. You can still request information under the Freedom of Information Act and the Data Protection Act.</p>
        <h2>Governing law</h2>
        <p>These terms and conditions are governed by and construed in accordance with the laws of England and Wales.</p>
        <p>Any dispute you have which relates to these terms and conditions, or your use of FutureNHS (whether it be contractual or non-contractual), will be subject to the exclusive jurisdiction of the courts of England and Wales.</p>
        <h3>General</h3>
        <p>There may be legal notices elsewhere on FutureNHS that relate to how you use the site.</p>
        <p>We’re not liable if we fail to comply with these terms and conditions because of circumstances beyond our reasonable control.</p>
        <p>We might decide not to exercise or enforce any right available to us under these terms and conditions. We can always decide to exercise or enforce that right later.</p>
        <p>Doing this once will not mean we automatically waive the right on any other occasion.</p>
        <p>If any of these terms and conditions are held to be invalid, unenforceable or illegal for any reason, the remaining terms and conditions will still apply.</p>
        <h2>Changes to terms</h2>
        <p>Please check these terms and conditions regularly. We can update them at any time without notice.</p>
        <p>You’ll agree to any changes if you continue to use FutureNHS after the terms and conditions have been updated.</p>
        <p>Where significant changes to the sites terms and conditions are made that impact site members we will ask you to reconfirm acceptance of the terms and conditions in order to continue using the service.</p>
    `,
} as GenericPageTextContent
