import { GenericPageTextContent } from '@appTypes/content'

export default {
    title: 'Accessibility Statement',
    metaDescription: 'Accessibility statement',
    mainHeading: 'Accessibility',
    bodyHtml: `<h2>Accessibility statement for collaborate.future.nhs.uk</h2>

    <p>This accessibility statement applies to collaborate.future.nhs.uk</p>

    <p>This website is run by Future NHS. We want as many people as possible to be able to use this website. For example, that means you should be able to:</p>
    
    <ul>
      <li>change colours, contrast levels and fonts</li>
      <li>zoom in up to 300% without the text spilling off the screen</li>
      <li>navigate most of the website using just a keyboard</li>
      <li>navigate most of the website using speech recognition software</li>
      <li>listen to most of the website using a screen reader (including the most recent versions of JAWS, NVDA and VoiceOver)</li>
    </ul>
    
    <p>We've also made the website text as simple as possible to understand.</p>
    
    <p><a rel="external" href="https://mcmw.abilitynet.org.uk/" class="govuk-link">AbilityNet</a> has advice on making your device easier to use if you have a disability.</p>
    
    <h3>How accessible this website is</h3>
    
    <p>We know some parts of this website are not fully accessible. The Log In and Forgot your Password pages contain the following errors:</p>
    
    <ul>
      <li>broken Skip to Main Navigation/Content links, which may be confusing for users of assistive technologies and anyone who uses keyboard navigation</li>
      <li>not all the content on these pages is contained within Page Regions/Landmarks, making it possible for assistive technology users to miss the Feedback and Support Site links</li>
    </ul>
    
    <h3>Feedback and contact information</h3>
    
    <p>If you need information on this website in a different format like accessible PDF, large print, easy read, audio recording or braille:</p>
    
    <ul>
      <li>email <a href="mailto:support@futurenhs.zendesk.com" rel="noreferrer nofollow">support@futurenhs.zendesk.com</a></li>
      <li>FutureNHS, NHS England, PO Box 16738, Redditch, B97 9PT.</li>
    </ul>
    
    <p>We'll consider your request and get back to you in 7 days.</p>
    
    <h3>Reporting accessibility problems with this website</h3>
    
    <p>We're always looking to improve the accessibility of this website. If you find any problems not listed on this page or think we're not meeting accessibility requirements, email <a href="mailto:support@futurenhs.zendesk.com" rel="noreferrer nofollow">support@futurenhs.zendesk.com</a></p>
    
    <h3>Enforcement procedure</h3>
    
    <p>The Equality and Human Rights Commission (EHRC) is responsible for enforcing the Public Sector Bodies (Websites and Mobile Applications) (No. 2) Accessibility Regulations 2018
    (the 'accessibility regulations'). If you're not happy with how we respond to your complaint, <a rel="external" href="https://www.equalityadvisoryservice.com/" class="govuk-link">contact the Equality Advisory and Support Service (EASS)</a>.</p>
    
    <h2>Technical information about this website's accessibility</h2>
    
    <p>NHS is committed to making its website accessible, in accordance with the Public Sector Bodies (Websites and Mobile Applications) (No. 2) Accessibility Regulations 2018.</p>
    
    <h3>Compliance status</h3>
    
    
    <p>This website is partially compliant with the <a rel="external" href="https://www.w3.org/TR/WCAG21/" class="govuk-link">Web Content Accessibility Guidelines version 2.1</a> AA standard, due to the non-compliances listed below.</p>
    
    <h2>Non-accessible content</h2>
    

    <p>The content listed below is non-accessible for the following reasons.</p>
    
    <h3>Non-compliance with the accessibility regulations</h3>
    
    <p>The Log In and Forgot your Password pages contain the following issues:</p>
    <ul>
      <li>broken Skip to Main Navigation/Content links - this fails WCAG 2.1 success criterion 2.4.1 Bypass Blocks (Level A)</li>
      <li>not all the content is contained within Page Regions -  this fails WCAG 2.1 success criterion 1.3.1 Info and Relationships (Level A)</li>
    </ul>

    <p>The registration process is in the process of being redeveloped, which will fix these issues. We aim to have this completed before Public Beta is launched later in 2022.</p>
    
    
    <h2>Preparation of this accessibility statement</h2>
    
    <p>This statement was prepared on 25 May 2022.</p>
    
    <p>This website was last tested on 24 May 2022. The test was carried out by CDS.</p>`,
} as GenericPageTextContent
