﻿/*
Post-Deployment Script Template							
--------------------------------------------------------------------------------------
 This file contains SQL statements that will be appended to the build script.		
 Use SQLCMD syntax to include a file in the post-deployment script.			
 Example:      :r .\myfile.sql								
 Use SQLCMD syntax to reference a variable in the post-deployment script.		
 Example:      :setvar TableName MyTable							
               SELECT * FROM [$(TableName)]					
--------------------------------------------------------------------------------------
*/

IF NOT EXISTS (SELECT * FROM [dbo].[Settings])
BEGIN
	-- Disable constraints for all tables:
	EXEC sp_msforeachtable 'ALTER TABLE ? NOCHECK CONSTRAINT all'

	INSERT [dbo].[FileStatus] ([Name]) VALUES (N'Uploading')
	INSERT [dbo].[FileStatus] ([Name]) VALUES (N'Uploaded')
	INSERT [dbo].[FileStatus] ([Name]) VALUES (N'Failed')
	INSERT [dbo].[FileStatus] ([Name]) VALUES (N'Verified')
	INSERT [dbo].[FileStatus] ([Name]) VALUES (N'Quarantined')
	INSERT [dbo].[FileStatus] ([Name]) VALUES (N'Recycled')
	INSERT [dbo].[FileStatus] ([Name]) VALUES (N'Deleted')
	

	INSERT [dbo].[MembershipUser] ([UserName], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC],[ModifiedAtUTC], [LastLoginDateUTC], [Slug],  [HasAgreedToTermsAndConditions], [FirstName], [Surname], [Initials] ,[Pronouns], [ImageId], [IsDeleted]) VALUES (N'admin@futurenhs.co.uk', N'admin@futurenhs.co.uk',1,0,0,(SELECT GETUTCDATE()),NULL,NULL,N'admin',1,N'Admin',N'Account',N'AA',NULL,NULL,0)			
	INSERT [dbo].[MembershipUser] ([UserName], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC],[ModifiedAtUTC], [LastLoginDateUTC], [Slug],  [HasAgreedToTermsAndConditions], [FirstName], [Surname], [Initials] ,[Pronouns], [ImageId], [IsDeleted]) VALUES (N'membershipuser@futurenhs.co.uk', N'membershipuser@futurenhs.co.uk',1,0,0,(SELECT GETUTCDATE()),NULL,NULL,N'membershipuser',1,N'MembershipUser',N'Account',N'MA',NULL,NULL,0)			

	INSERT [dbo].[Identity] ([MembershipUser_Id], [Subject_Id], [Issuer]) VALUES ((SELECT id FROM MembershipUser WHERE UserName ='admin@futurenhs.co.uk'), N'20b6eb88-0218-473c-9d37-51ba5c7f5ffb', N'CDSB2CTEST.onmicrosoft.com');
	INSERT [dbo].[Identity] ([MembershipUser_Id], [Subject_Id], [Issuer]) VALUES ((SELECT id FROM MembershipUser WHERE UserName ='membershipuser@futurenhs.co.uk'), N'9a9a1c10-52ca-4774-aeef-14a745c39d55', N'CDSB2CTEST.onmicrosoft.com');
	
	INSERT [dbo].[MembershipRole] ([RoleName]) VALUES (N'Admin')
	INSERT [dbo].[MembershipRole] ([RoleName]) VALUES (N'Standard Members')
	INSERT [dbo].[MembershipRole] ([RoleName]) VALUES (N'Guest')

	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES ((SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin@futurenhs.co.uk'), (SELECT Id FROM [dbo].[MembershipRole] WHERE [RoleName] = 'Admin'))
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES ((SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='membershipuser@futurenhs.co.uk'), (SELECT Id FROM [dbo].[MembershipRole] WHERE [RoleName] = 'Standard Members'))

	INSERT [dbo].[Language] ([Name], [LanguageCulture], [FlagImageFileName], [RightToLeft]) VALUES ( N'English (United Kingdom)', N'en-GB', NULL, 0)

	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Edit Posts', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Read Only', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Sticky Discussions', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Delete Posts', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Lock Discussions', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Vote In Polls', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Create Polls', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Create Discussions', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Attach Files', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Deny Access', 0)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Edit Members', 1)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Insert Editor Images', 1)
	INSERT [dbo].[Permission] ([Name], [IsGlobal]) VALUES (N'Create Tags', 0)

	INSERT [dbo].[Settings] ([ForumName], [ForumUrl], [PageTitle], [MetaDesc], [IsClosed], [EnableRSSFeeds], [DisplayEditedBy], [EnablePostFileAttachments], [EnableMarkAsSolution], [MarkAsSolutionReminderTimeFrame], [EnableSpamReporting], [EnableMemberReporting], [EnableEmailSubscriptions], [ManuallyAuthoriseNewMembers], [NewMemberEmailConfirmation], [EmailAdminOnNewMemberSignUp], [DiscussionsPerPage], [PostsPerPage], [ActivitiesPerPage], [EnablePrivateMessages], [MaxPrivateMessagesPerMember], [PrivateMessageFloodControl], [EnableSignatures], [EnablePoints], [PointsAllowedForExtendedProfile], [PointsAllowedToVoteAmount], [PointsAddedPerPost], [PointsAddedPostiveVote], [PointsDeductedNagativeVote], [PointsAddedForSolution], [AdminEmailAddress], [NotificationReplyEmail], [SMTP], [SMTPUsername], [SMTPPassword], [SMTPPort], [SMTPEnableSSL], [Theme], [EnableSocialLogins], [SpamQuestion], [SpamAnswer], [EnableAkisment], [AkismentKey], [CurrentDatabaseVersion], [EnablePolls], [SuspendRegistration], [CustomHeaderCode], [CustomFooterCode], [EnableEmoticons], [DisableDislikeButton], [AgreeToTermsAndConditions], [TermsAndConditions], [DisableStandardRegistration], [ExtendedDataString], [DefaultLanguage_Id], [NewMemberStartingRole]) VALUES (N'MvcForum', N'http://www.mydomain.com', NULL, NULL, 0, 1, 1, 0, 1, 7, 1, 1, 1, 0, 0, 1, 5, 7, 1, 1, 50, 0, 0, 1, 1, 1, 1, 2, 2, 4, N'info@futurenhs.cds.co.uk', N'info@futurenhs.cds.co.uk', N'smtp.sendgrid.net', N'apikey', N'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', N'', 0, N'default', 0, NULL, NULL, 0, NULL, NULL, 1, 0, N'<script> console.log("hello"); </script>
	', NULL, 1, 0, 0, NULL, 0, NULL, (SELECT Id FROM [dbo].[Language] WHERE [LanguageCulture] = 'en-GB'), (SELECT Id FROM [dbo].[MembershipRole] WHERE [RoleName] = 'Standard Members'))
    
	INSERT [dbo].[SystemPage] ([Slug], [Title], [Content], [IsDeleted]) VALUES (N'accessibility-statement', N'Accessibility Statement', N'<p><strong style="margin: 0px; padding: 0px;">Lorem Ipsum</strong>&nbsp;is simply dummy text of the printing and typesetting</p>
	<p><strong style="margin: 0px; padding: 0px;">Lorem Ipsum</strong>&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>
	<p><strong style="margin: 0px; padding: 0px;">Lorem Ipsum</strong>&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>', 0)
	INSERT [dbo].[SystemPage] ([Slug], [Title], [Content], [IsDeleted]) VALUES (N'privacy-policy', N'Privacy Policy', N'<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ''Content here, content here'', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for ''lorem ipsum'' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ''Content here, content here'', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for ''lorem ipsum'' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ''Content here, content here'', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for ''lorem ipsum'' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ''Content here, content here'', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for ''lorem ipsum'' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ''Content here, content here'', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for ''lorem ipsum'' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).</p>
	<p>&nbsp;</p>', 0)
	INSERT [dbo].[SystemPage] ([Slug], [Title], [Content], [IsDeleted]) VALUES (N'terms-and-conditions', N'Terms and Conditions', N'<p style="text-align: justify; margin: 0in 0in 11.25pt 0in;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Here is a link to a generic systems page thats not got a reserved url:&nbsp;<a href="/pages/terms-link">https://futurenhs.cds.co.uk/pages/terms-link</a></span></p>
	<p style="text-align: justify; margin: 0in 0in 11.25pt 0in;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="text-align: justify; margin: 0in 0in 11.25pt 0in;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="text-align: justify; margin: 0in 0in 11.25pt 0in;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;"><span style="font-size: 10.5pt; font-family: ''Arial'',''sans-serif''; color: black;">Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</span></p>
	<p style="text-align: justify; margin: 0in 0in 11.25pt 0in;">&nbsp;</p>', 0)
	INSERT [dbo].[SystemPage] ([Slug], [Title], [Content], [IsDeleted]) VALUES (N'cookies', N'Cookies', N'<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>
	<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>
	<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>
	<p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>', 0)
	INSERT [dbo].[SystemPage] ([Slug], [Title], [Content], [IsDeleted]) VALUES (N'contact-us', N'Contact Us', N'<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"</p>
	<p style="margin: 0px 0px 15px; padding: 0px; text-align: justify; color: #000000; font-family: ''Open Sans'', Arial, sans-serif; font-size: 14px;">"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"</p>
	<p>&nbsp;</p>', 0)
	
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'GP Career Support Hub', N'Resources to support GPs at varying stages of their career', 0, 0, 0, 0, CAST(N'2021-06-01T08:58:41.317' AS DateTime), N'2d841d48-9753-463f-aff2-ad3a0093f48b', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Introduction', N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Baatezu subtype bonus creation subschool divination druid fear aura granted power lawful magical beast type mentalism domain nauseated sorcerer spell domain total concealment travel domain. Abjuration alignment alternate form blindsight construct type damage fate domain fly free action halfling domain improved evasion infection lawful melee miniature figure modifier natural reach plant type player character result spell descriptor spell immunity strength domain subschool suffering domain swarm subtype unarmed attack untrained.')
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'PCN Development Support', N'Resources and tools to support Primary Care Network Development', 0, 0, 0, 0, CAST(N'2021-06-07T13:33:43.493' AS DateTime), N'0d1ea1e0-83f9-491f-b99a-ad4000df7f09', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Digital Primary Care', N'Support colleagues to share experiences, learning and resources on the digital transformation', 0, 0, 0, 0, CAST(N'2021-08-31T15:57:29.117' AS DateTime), N'3e4a64dc-664a-4388-bc52-ad950106fb30', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Integrated Care Network', N'A wealth of resources, materials and webinars to help individuals understand Integrated Care', 0, 0, 0, 0, CAST(N'2021-08-31T15:58:02.087' AS DateTime), N'integrated-care-network', 1, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Social Prescribing', N'Supporting social prescribing link workers – a network for news, resources and discussions', 0, 0, 0, 0, CAST(N'2021-11-08T14:53:23.520' AS DateTime), N'41234726-7e93-4767-afbe-adda00f560a2', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Community Services and Ageing Well', N'Supporting fulfilment of ‘out-of-hospital care’ and fully integrated community-based care', 0, 0, 0, 0, CAST(N'2021-12-13T14:34:15.833' AS DateTime), N'b8c36360-ecbe-4ade-a3c2-adfd00f01faf', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), NULL, N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Enhanced Health in Care Homes', N'Resources, case studies and further online support championing the work around EHCH', 0, 0, 0, 0, CAST(N'2021-11-08T14:53:23.520' AS DateTime), N'0cf5179b-b3d5-4610-8370-c6b5d9ce1b60', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Population Health Management', N'Learn about PHM, including resources to support core PHM capabilities', 0, 0, 0, 0, CAST(N'2021-12-13T14:34:15.833' AS DateTime), N'population-health-management', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), NULL, N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)	
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'2021/22 Mental Health Workforce', N'The Operational Planning process for 2021/22 will ', 0, 0, 0, 0, CAST(N'2021-06-01T08:58:41.317' AS DateTime), N'e8a897ae-b6fa-4fa2-9d56-284565494ed8', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Introduction', N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Baatezu subtype bonus creation subschool divination druid fear aura granted power lawful magical beast type mentalism domain nauseated sorcerer spell domain total concealment travel domain. Abjuration alignment alternate form blindsight construct type damage fate domain fly free action halfling domain improved evasion infection lawful melee miniature figure modifier natural reach plant type player character result spell descriptor spell immunity strength domain subschool suffering domain swarm subtype unarmed attack untrained.')
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'The Clinical Digital Resource Collaborative (CDRC)', N'The Clinical Digital Resource Collaborative (CDRC) is a collaboration between the Academic Health Science Network for North East and North Cumbria (AHSN NENC)', 0, 0, 0, 0, CAST(N'2021-06-07T13:33:43.493' AS DateTime), N'ccaead1d-e923-47f7-bdca-a406394128a7', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'GP referral pathway', N'pathway to the NHS Community Pharmacist Consultation Service', 0, 0, 0, 0, CAST(N'2021-08-31T15:57:29.117' AS DateTime), N'abee48ee-041e-497b-926d-afbb954b6640', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Care coordination in primary care', N'NHS England and NHS Improvement in collaboration with Health Education England and Birmingham City University', 0, 0, 0, 0, CAST(N'2021-08-31T15:58:02.087' AS DateTime), N'c21f4b9e-5fcb-4665-a50e-c4a104042905', 1, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Digital first: moving to online triage and consultations', N'Digital first: moving to online triage and consultations', 0, 0, 0, 0, CAST(N'2021-11-08T14:53:23.520' AS DateTime), N'8d696d13-4a4c-4fb6-a7ea-bed5cb43c4c1', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'NHS Long Term Plan', N'As medicine advances, health needs change and society develops, the NHS has to continually move forward so that in 10 years time we have a service fit for the future. The NHS Long Term Plan is drawn up by frontline staff, patients groups, and national experts to be ambitious but realistic', 0, 0, 0, 0, CAST(N'2021-12-13T14:34:15.833' AS DateTime), N'fd7cec57-7e07-4907-853e-0ee2192c5de0', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), NULL, N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'People in health and care guidance', N'Patient and public participation in commissioning health and care: statutory guidance for CCGs and NHS England', 0, 0, 0, 0, CAST(N'2021-11-08T14:53:23.520' AS DateTime), N'77150949-4469-4ee5-9cbc-84eed2a59d27', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), N'Support colleagues to share experiences, learning and resources on the digital transformation', N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'Public Health Outcomes Framework', N'The Public Health Outcomes Framework sets out a vision for public health, that is to improve and protect the nations health and improve the health of the poorest fastest', 0, 0, 0, 0, CAST(N'2021-12-13T14:34:15.833' AS DateTime), N'4f25fc91-1da8-4591-9b24-907e0f51966c', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), NULL, N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL)
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs], [ThemeId]) VALUES (N'Group With Theme 1', N'Showing theme 1', 0, 0, 0, 0, CAST(N'2021-12-13T14:34:15.833' AS DateTime), N'group-theme-1', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), NULL, N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL, N'36d49305-eca8-4176-bfea-d25af21469b9')
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs], [ThemeId]) VALUES (N'Group With Theme 2', N'Showing theme 2', 0, 0, 0, 0, CAST(N'2021-12-13T14:34:15.833' AS DateTime), N'group-theme-2', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), NULL, N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL, N'0fca6809-a71f-4733-a622-343967acbad9')
	INSERT [dbo].[Group] ([Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [IsPublic], [GroupOwner], [Subtitle], [Introduction], [AboutUs], [ThemeId]) VALUES (N'Group With Theme 3', N'Showing theme 3', 0, 0, 0, 0, CAST(N'2021-12-13T14:34:15.833' AS DateTime), N'group-theme-3', 0, (SELECT Id FROM [dbo].[MembershipUser] WHERE [UserName] ='admin'), NULL, N'Support colleagues to share experiences, learning and resources on the digital transformation', NULL, N'9a3c911b-c3d3-4f58-a32a-d541e0f5bf56')

	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'e8a897ae-b6fa-4fa2-9d56-284565494ed8'), N'1ffeeb7b-afe6-4e83-aea5-25dab93dda45', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'e8a897ae-b6fa-4fa2-9d56-284565494ed8'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '77150949-4469-4ee5-9cbc-84eed2a59d27'), N'51431a7a-0b2f-41f5-8341-8c4585e43136', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '77150949-4469-4ee5-9cbc-84eed2a59d27'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'group-theme-1'), N'fa67119a-e630-4227-97d3-05ebfa52151e', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'group-theme-1'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '41234726-7e93-4767-afbe-adda00f560a2'), N'2cd52e7a-01d2-4ce2-99eb-c503a26f60f8', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '41234726-7e93-4767-afbe-adda00f560a2'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'abee48ee-041e-497b-926d-afbb954b6640'), N'fb6073bc-91b5-462b-80ac-37b97772e875', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'abee48ee-041e-497b-926d-afbb954b6640'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '8d696d13-4a4c-4fb6-a7ea-bed5cb43c4c1'), N'40e4d3dd-6968-43b9-ad3e-d1d3070a5e7b', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '8d696d13-4a4c-4fb6-a7ea-bed5cb43c4c1'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '2d841d48-9753-463f-aff2-ad3a0093f48b'), N'74e4dc83-32e7-4f42-bba6-ef04b13ff4c2', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '2d841d48-9753-463f-aff2-ad3a0093f48b'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'population-health-management'), N'78fbcab5-8254-4519-a82e-3fb8922fd434', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'population-health-management'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '0cf5179b-b3d5-4610-8370-c6b5d9ce1b60'), N'4d6d9da6-3cca-4678-95fb-0f1119b950bb', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '0cf5179b-b3d5-4610-8370-c6b5d9ce1b60'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '4f25fc91-1da8-4591-9b24-907e0f51966c'), N'f8b25e05-a90f-4c53-b642-4b2e80cf0e31', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '4f25fc91-1da8-4591-9b24-907e0f51966c'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'integrated-care-network'), N'2be496c5-f2f2-466b-bc80-b088b9e0d708', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'integrated-care-network'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'b8c36360-ecbe-4ade-a3c2-adfd00f01faf'), N'f51fef55-b169-4640-b3f5-2aef7334f9ec', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'b8c36360-ecbe-4ade-a3c2-adfd00f01faf'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'group-theme-3'), N'b02eaec7-4de7-46e5-bfa5-a8632979cb5e', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'group-theme-3'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'c21f4b9e-5fcb-4665-a50e-c4a104042905'), N'ea48d2a8-cdaf-49b1-b4bf-a6704c4819ba', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'c21f4b9e-5fcb-4665-a50e-c4a104042905'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '3e4a64dc-664a-4388-bc52-ad950106fb30'), N'45945ea4-ec8e-46bf-b4a1-119f7149258d', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '3e4a64dc-664a-4388-bc52-ad950106fb30'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'fd7cec57-7e07-4907-853e-0ee2192c5de0'), N'300afd39-dae4-4690-a68b-6bbbef067200', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'fd7cec57-7e07-4907-853e-0ee2192c5de0'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'group-theme-2'), N'1f44a85b-ae9a-4ee5-9341-8e14c90d51aa', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'group-theme-2'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '0d1ea1e0-83f9-491f-b99a-ad4000df7f09'), N'b1d86638-3a50-4d03-ada4-676b200deef4', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = '0d1ea1e0-83f9-491f-b99a-ad4000df7f09'))), GETDATE())
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'ccaead1d-e923-47f7-bdca-a406394128a7'), N'241f6080-dc90-428c-aa86-8a27c7c911ae', (SELECT CreatedBy FROM [dbo].[Group] WHERE [Id] = ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'ccaead1d-e923-47f7-bdca-a406394128a7'))), GETDATE())

	-- Re-enable constraints for all tables:
	EXEC sp_msforeachtable 'ALTER TABLE ? WITH CHECK CHECK CONSTRAINT all';	

END

UPDATE [dbo].[Identity] SET Subject_Id = '51e4087c-a3cb-465d-a9b2-7e4d6b213b04' where MembershipUser_Id = (SELECT id FROM MembershipUser WHERE UserName ='admin@futurenhs.co.uk')

IF '$(RunAutomatedScripts)' = 'true'
BEGIN
		EXEC automationteardown
		EXEC automationseed
END