---
name: Introduction
order: 1
---

# Introduction

Angular Primitives is a low-level headless UI component library with a focus on accessibility, customization, and developer experience. Whether you're building a robust design system from scratch or looking to enhance your existing one, our primitives are here to support you every step of the way.

## Key Features

1. **Accessibility First:** We believe that all users should have equal access to information and functionality. Our primitives are crafted with accessibility best practices, ensuring that your applications are inclusive and usable by everyone.

2. **Customization Made Easy:** We understand the importance of maintaining a consistent look and feel across your applications. With Angular Primitives, we don't provide any styles, you provide your own to seamlessly blend with your brand's identity and visual guidelines.

3. **Developer Experience:** We know developers value simplicity and efficiency. Our library is designed to be intuitive and straightforward, making it a breeze for you to integrate and work with our primitives in your Angular projects. We follow the best practices and standards to ensure the highest quality code and documentation.

## Versioning

Angular Primitives follow [Semantic Versioning](https://semver.org/). As a result you can expect the following:

- **Patch releases** contain bug fixes and minor improvements.
- **Minor releases** contain new features and improvements.
- **Major releases** contain breaking changes.

We release a new major version each time Angular releases a new major version.
This ensures that Angular Primitives is always up-to-date with the latest Angular features and best practices.

## Compatibility

Angular Primitives versions are compatible with the following Angular versions:

| Angular Primitives | Angular |
| ------------------ | ------- |
| 0.x                | 18.0.x  |

## Community

If you would like to stay up-to-date with the latest news and updates, or have any questions, feedback, or suggestions, we invite you to join our community on [Discord](https://discord.gg/NTdjc5r3gC).

## Acknowledgements

Angular Primitives would not have been possible without inspiration from many of the great libraries that came before it.
We would like to thank the following projects for their contributions to the open-source community:

- [Angular CDK](https://material.angular.io/cdk)
- [Radix UI](https://radix-ui.com/)
- [Headless UI](https://headlessui.com/)
- [React Aria](https://react-spectrum.adobe.com/react-aria/)

## Support

If you have any questions, feedback, or need help, feel free to reach out to us on [GitHub](https://github.com/ng-primitives/ng-primitives). We're always happy to help and improve our library based on your feedback.

If you're interested in contributing to Angular Primitives, please check out our [Contributing Guide](https://github.com/ng-primitives/ng-primitives/blob/main/CONTRIBUTING.md).

If you would like to support Angular Primitives to help us maintain and improve the library, please consider [sponsoring us](https://github.com/sponsors/ashley-hunter). Your support is greatly appreciated!
