import React from 'react';
import PropTypes from 'prop-types';

export default function ClockIcon(props) {
    const { className, style } = props;

    return (
        <svg className={className} style={style} width="24px" height="24px" viewBox="0 0 24 24">
            <g transform="translate(-900.000000, -386.000000)">
                <g id="clock" transform="translate(900.000000, 386.000000)">
                    <circle fill="#E3E5ED" cx="12" cy="12" r="12" />
                    <circle fill="#FFFFFF" cx="12" cy="12" r="11.6109844" />
                    <circle fill="#B5BCC9" cx="12" cy="12" r="10.4715" />
                    <path
                        d="M12.0756563,12 L11.9243906,12 C11.6429063,12 11.414625,11.7718125 11.414625,11.4902344 L11.414625,5.29026562 C11.414625,5.00878125 11.6428125,4.7805 11.9243906,4.7805 L12.0756563,4.7805 C12.3571406,4.7805 12.5854219,5.0086875 12.5854219,5.29026562 L12.5854219,11.4903281 C12.5853281,11.7718125 12.3571406,12 12.0756563,12 Z"
                        fill="#FFFFFF"
                    />
                    <path
                        d="M12.0756562,12 L12.182625,12.1069688 C12.3816562,12.306 12.3816562,12.6287812 12.182625,12.8278594 L8.60282812,16.4076562 C8.40379687,16.6066875 8.08101562,16.6066875 7.8819375,16.4076562 L7.77496875,16.3006875 C7.5759375,16.1016562 7.5759375,15.778875 7.77496875,15.5797969 L11.3547656,12 C11.5537969,11.8009688 11.8765312,11.8009688 12.0756562,12 Z"
                        fill="#FFFFFF"
                    />
                    <path
                        d="M19.1144063,10.2682031 L19.1144063,10.2682031 C19.1430469,10.3844531 19.0719844,10.5019219 18.9557344,10.5305625 L12.108375,12.2167969 C11.992125,12.2454375 11.8746563,12.174375 11.8460156,12.058125 L11.8460156,12.058125 C11.817375,11.941875 11.8884375,11.8244063 12.0046875,11.7957656 L18.8520469,10.1095312 C18.9682969,10.0808906 19.0857656,10.1519062 19.1144063,10.2682031 Z"
                        fill="#061C3F"
                    />
                    <circle fill="#061C3F" cx="12" cy="12" r="1" />
                    <path
                        d="M12.0373594,4.16259375 L11.9626406,4.16259375 C11.6599688,4.16259375 11.414625,3.91725 11.414625,3.61457812 L11.414625,2.93282812 C11.414625,2.63015625 11.6599688,2.3848125 11.9626406,2.3848125 L12.0373594,2.3848125 C12.3400312,2.3848125 12.585375,2.63015625 12.585375,2.93282812 L12.585375,3.61457812 C12.5853281,3.91725 12.3399844,4.16259375 12.0373594,4.16259375 Z"
                        fill="#FFFFFF"
                    />
                    <path
                        d="M12.0373594,21.6151875 L11.9626406,21.6151875 C11.6599688,21.6151875 11.414625,21.3698438 11.414625,21.0671719 L11.414625,20.3854688 C11.414625,20.0827969 11.6599688,19.8374531 11.9626406,19.8374531 L12.0373594,19.8374531 C12.3400312,19.8374531 12.585375,20.0827969 12.585375,20.3854688 L12.585375,21.0672188 C12.5853281,21.3697969 12.3399844,21.6151875 12.0373594,21.6151875 Z"
                        fill="#FFFFFF"
                    />
                    <path
                        d="M19.8374063,12.0373594 L19.8374063,11.9626406 C19.8374063,11.6599688 20.08275,11.414625 20.3854219,11.414625 L21.0671719,11.414625 C21.3698437,11.414625 21.6151875,11.6599688 21.6151875,11.9626406 L21.6151875,12.0373594 C21.6151875,12.3400312 21.3698437,12.585375 21.0671719,12.585375 L20.3854219,12.585375 C20.08275,12.5853281 19.8374063,12.3399844 19.8374063,12.0373594 Z"
                        fill="#FFFFFF"
                    />
                    <path
                        d="M2.3848125,12.0373594 L2.3848125,11.9626406 C2.3848125,11.6599688 2.63015625,11.414625 2.93282812,11.414625 L3.61453125,11.414625 C3.91720312,11.414625 4.16254687,11.6599688 4.16254687,11.9626406 L4.16254687,12.0373594 C4.16254687,12.3400312 3.91720312,12.585375 3.61453125,12.585375 L2.93282812,12.585375 C2.63020312,12.5853281 2.3848125,12.3399844 2.3848125,12.0373594 Z"
                        fill="#FFFFFF"
                    />
                </g>
            </g>
        </svg>
    );
}

ClockIcon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

ClockIcon.defaultProps = {
    className: undefined,
    style: undefined,
};
