import styled from 'styled-components';
import attachThemeAttrs from '../../../styles/helpers/attachThemeAttrs';
import { replaceAlpha } from '../../../styles/helpers/color';
import {
    BORDER_RADIUS_2,
    BORDER_RADIUS_SQUARE,
    BORDER_RADIUS_SEMI_SQUARE,
    BORDER_RADIUS_SEMI_ROUNDED,
} from '../../../styles/borderRadius';
import { COLOR_GRAY_2 } from '../../../styles/colors';

const sizeMap = { large: '3rem', medium: '2.5rem', small: '1.8rem', 'x-small': '1.3rem' };
const StyledButtonItemsContainer = attachThemeAttrs(styled.div).attrs(props => {
    const { isDark } = props.palette;
    const inverse = {
        border: isDark ? COLOR_GRAY_2 : 'rgba(0, 0, 0, 0.4)',
        background: isDark ? 'rgba(239,241,245,0.4)' : 'rgba(0, 0, 0, 0.4)',
    };

    return { inverse };
})`
    display: inline-flex;
    justify-content: center;
    align-items: center;
    border-radius: ${BORDER_RADIUS_2};
    border: solid 1px ${props => props.palette.border.divider};
    background-color: ${props => replaceAlpha(props.palette.background.highlight, 0.4)};
    line-height: ${props => sizeMap[props.size] || sizeMap.medium};
    height: ${props => sizeMap[props.size] || sizeMap.medium};
    margin: 0px auto;
    width: calc(100% - 4px);

    ${props =>
        props.variant === 'inverse' &&
        `
            border: solid 1px ${props.inverse.border};
            background-color: ${props.inverse.background};
        `};

        ${props =>
            props.borderRadius === 'square' &&
            `
                border-radius: ${BORDER_RADIUS_SQUARE} !important;
            `};

        ${props =>
            props.borderRadius === 'semi-square' &&
            `
                border-radius: ${BORDER_RADIUS_SEMI_SQUARE} !important;
            `};
        
        ${props =>
            props.borderRadius === 'semi-rounded' &&
            `
                border-radius: ${BORDER_RADIUS_SEMI_ROUNDED} !important;
            `};
`;

export default StyledButtonItemsContainer;
