import React from 'react';
import PropTypes from 'prop-types';

function SvgTuvalu({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M32 16c0 8.837-7.163 16-16 16S0 24.837 0 16C0 16.004 16 .002 16 0c8.837 0 16 7.163 16 16z"
                    fill="#338AF3"
                />
                <g fill="#0052B4">
                    <path d="M7.652 16h5.397l-4.701-5.565-.696 2.087zM16 13.049l-5.565-5.397H16z" />
                </g>
                <g fill="#F0F0F0">
                    <path d="M16.019 0h-.022.022zM15.957 16.3h.343v-.343l-.343.343zM16 8.348V0h-.003C7.162.002 0 7.164 0 16h8.348v-4.7l4.7 4.7h2.91l.042-.043V13.05l-4.7-4.701H16z" />
                </g>
                <g fill="#D80027">
                    <path d="M8.095 2.087a16.076 16.076 0 00-6.008 6.008V16H6.26V6.261H16V2.087H8.095z" />
                    <path d="M16 14.032l-5.685-5.684H8.348L16 16v-1.968z" />
                </g>
                <g fill="#FFDA44">
                    <path d="M17.463 26.435l.345 1.063h1.118l-.904.657.345 1.062-.904-.656-.904.656.345-1.062-.904-.657h1.118zM26.363 19.478l.346 1.063h1.117l-.904.657.345 1.063-.904-.657-.904.657.345-1.063-.904-.657h1.118zM28.593 9.043l.346 1.063h1.117l-.904.657.345 1.063-.904-.657-.904.657.346-1.063-.905-.657h1.118zM29.146 16.696l.345 1.063h1.118l-.904.656.345 1.063-.904-.657-.904.657.345-1.063-.904-.656H28.8zM19.065 23.935l.996.507.79-.79-.174 1.104.995.507-1.103.175-.175 1.104-.508-.996-1.103.175.79-.79zM19.065 19.761l.996.507.79-.79-.174 1.104.995.507-1.103.175-.175 1.104-.508-.996-1.103.175.79-.79zM22.544 22.437l.996.507.79-.79-.175 1.103.996.508-1.104.175-.175 1.104-.507-.996-1.104.175.79-.79zM22.544 13.5l.996.508.79-.79-.175 1.103.996.507-1.104.175-.175 1.104-.507-.996-1.104.175.79-.79zM25.915 13.393l.996.507.79-.79-.175 1.104.996.507-1.104.175L27.243 16l-.507-.996-1.104.175.79-.79z" />
                </g>
            </g>
        </svg>
    );
}
SvgTuvalu.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgTuvalu.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgTuvalu;
