import React from 'react';
import PropTypes from 'prop-types';

function SvgRussia({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M.556 12.17C2.668 3.612 11.293-1.6 19.83.517c8.536 2.117 13.735 10.764 11.623 19.321-2.112 8.55-10.737 13.77-19.273 11.653C3.643 29.374-1.556 20.719.556 12.17"
                    fill="#EF3E43"
                />
                <path
                    d="M1.016 10.642h29.976C29.26 5.778 25.205 1.851 19.83.517 11.817-1.47 3.716 3.007 1.016 10.642"
                    fill="#EFEBE7"
                />
                <path
                    d="M31.573 19.28c.008-.032.016-.064.024-.104.008-.057.024-.121.032-.178a.474.474 0 00.016-.105c.008-.065.025-.121.033-.186.008-.032.008-.065.016-.089.016-.073.024-.153.04-.226 0-.016.008-.032.008-.049.016-.088.024-.185.04-.274 0-.025.008-.049.008-.073l.025-.202c0-.032.008-.065.008-.097.008-.057.016-.121.016-.178 0-.032.008-.064.008-.097.008-.064.008-.121.016-.186 0-.032.008-.064.008-.097.008-.072.008-.137.016-.21 0-.024 0-.04.008-.064.008-.09.008-.186.016-.275v-.049c0-.072.008-.153.008-.226v-.089-.186-.097-.185-.09c0-.064 0-.137-.008-.201v-.073a12.553 12.553 0 00-.032-.55c0-.024 0-.048-.008-.072-.008-.065-.008-.13-.016-.202 0-.033-.008-.057-.008-.09-.008-.064-.016-.12-.016-.185 0-.032-.008-.057-.008-.089l-.025-.202c0-.024-.008-.048-.008-.073-.024-.177-.048-.363-.08-.541 0-.016-.008-.032-.008-.049-.008-.072-.024-.145-.04-.218-.009-.024-.009-.048-.017-.072a1.659 1.659 0 00-.04-.194c-.008-.025-.008-.049-.016-.081-.016-.065-.024-.13-.04-.202-.008-.025-.008-.04-.017-.065-.016-.08-.04-.162-.056-.242l-.008-.016c-.024-.081-.04-.17-.064-.251-.121-.469-.258-.93-.42-1.382H1.008a15.936 15.936 0 00-.734 7.863c0 .008 0 .016.008.024.016.073.024.154.04.226 0 .016.008.033.008.049.017.073.025.137.04.21 0 .024.009.04.017.065.016.064.024.129.04.193.008.025.008.049.016.073.016.065.025.121.04.186l.025.089c.016.057.024.113.04.178.008.04.024.089.032.129l.049.194c.016.065.032.13.056.194.008.032.016.056.024.08.016.065.033.122.057.187l.024.088c.016.057.04.122.056.178.008.024.016.057.025.081.016.057.04.121.056.178l.024.08c.024.065.04.122.065.186.008.017.008.033.016.04.016.041.024.074.04.114h29.856c.016-.04.024-.073.04-.113.033-.097.065-.186.097-.283 0-.008.008-.016.008-.024.04-.121.08-.25.121-.372.008-.016.008-.032.016-.048.032-.114.073-.235.105-.356l.024-.073c.04-.137.073-.282.113-.42.024-.089.048-.186.064-.275.008-.032.016-.056.016-.088a.75.75 0 00.04-.17"
                    fill="#005B95"
                />
            </g>
        </svg>
    );
}
SvgRussia.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgRussia.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgRussia;
