import React from 'react';
import PropTypes from 'prop-types';

function SvgMayotte({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <defs>
                <circle id="mayotte_svg__a" cx={16} cy={16} r={16} />
            </defs>
            <g fill="none" fillRule="evenodd">
                <mask id="mayotte_svg__b" fill="#fff">
                    <use xlinkHref="#mayotte_svg__a" />
                </mask>
                <g fillRule="nonzero" mask="url(#mayotte_svg__b)">
                    <path
                        d="M34.827-2.288H-3.522C-6.547-2.288-9 .14-9 3.136v24.406c0 2.995 2.453 5.424 5.478 5.424h38.35c3.025 0 5.478-2.429 5.478-5.424V3.136c0-2.996-2.453-5.424-5.479-5.424z"
                        fill="#EEE"
                    />
                    <path
                        d="M11.544 23.195h2.739c.7 0 1.032.365 1.187.67.168.333.17.67.17.674 0 .007.006.012.013.012a.012.012 0 00.012-.012c0-.013.015-1.344 1.357-1.344h2.74c.72 0 1.322-.276 1.741-.799.387-.483.6-1.166.6-1.925V9.015a.012.012 0 00-.012-.012H9.185a.012.012 0 00-.012.012v11.456c0 .756.219 1.44.615 1.925.427.523 1.034.8 1.756.8zM9.197 9.027H22.08v11.444c0 1.615-.931 2.7-2.317 2.7h-2.74c-1.096 0-1.323.873-1.37 1.225-.046-.352-.272-1.225-1.369-1.225h-2.739c-1.403 0-2.346-1.085-2.346-2.7V9.027z"
                        fill="#231F20"
                    />
                    <path
                        d="M20.912 16.017c.03.044.056.09.08.137.088-.194.14-.404.14-.611 0-.418-.214-.86-.53-1.103.316-.241.53-.683.53-1.1 0-.418-.214-.775-.53-1.018.316-.242.53-.599.53-1.017 0-.73-.614-1.322-1.37-1.322-.403 0-.756.175-1.007.441a1.351 1.351 0 00-1.048-.508c-.417 0-.778.192-1.03.48a1.35 1.35 0 00-1.024-.48c-.417 0-.777.192-1.027.482a1.356 1.356 0 00-1.028-.482c-.416 0-.776.192-1.027.482a1.356 1.356 0 00-1.027-.482c-.757 0-1.37.606-1.37 1.356 0 .41.196.767.488 1.016a1.332 1.332 0 00-.488 1.017c0 .411.196.768.488 1.017a1.332 1.332 0 00-.488 1.017c0 .241.064.503.176.747.013-.024.027-.047.042-.069h10.52zm-5.26-2.034a2.727 2.727 0 002.643-2.034c.057.218.097.442.097.678 0 1.497-1.226 2.712-2.74 2.712-1.511 0-2.738-1.215-2.738-2.712 0-.236.04-.46.095-.678a2.73 2.73 0 002.644 2.034z"
                        fill="#171796"
                    />
                    <path
                        d="M10.173 20.797c0 .73.614 1.322 1.371 1.322.41 0 .775-.18 1.027-.456a1.385 1.385 0 002.054 0 1.385 1.385 0 002.054 0 1.385 1.385 0 002.054 0c.252.277.616.456 1.028.456.756 0 1.37-.593 1.37-1.322 0-.412-.199-.774-.505-1.017.306-.243.505-.605.505-1.017 0-.412-.199-.774-.505-1.017.306-.243.505-.605.505-1.017a1.263 1.263 0 00-.22-.712h-10.52a1.332 1.332 0 00-.218.712c0 .412.2.775.505 1.017a1.297 1.297 0 00-.505 1.017c0 .412.2.774.505 1.017a1.298 1.298 0 00-.505 1.017zm3.931-1.896c.393.223.65.51.575.641-.076.129-.456.053-.849-.17a2.118 2.118 0 01-.345-.252c.026.125.045.263.045.422 0 .45-.123.814-.274.814-.152 0-.274-.364-.274-.814 0-.159.02-.297.045-.422-.095.084-.208.171-.346.25-.393.225-.774.3-.85.172-.075-.129.183-.416.576-.641.138-.079.27-.133.392-.173a2.074 2.074 0 01-.392-.172c-.393-.225-.65-.51-.575-.641.075-.129.456-.053.849.172.138.079.25.166.346.25a2.034 2.034 0 01-.045-.422c0-.45.122-.814.274-.814.15 0 .274.364.274.814 0 .159-.019.297-.045.422.096-.086.207-.171.345-.25.393-.225.773-.3.85-.172.075.13-.183.417-.576.641a2.065 2.065 0 01-.39.172c.122.04.252.094.39.173zm5.369.641c-.077.129-.456.053-.85-.17a2.197 2.197 0 01-.344-.25c.026.124.045.263.045.42 0 .45-.123.814-.274.814-.15 0-.274-.364-.274-.814 0-.159.019-.297.045-.422-.096.084-.208.171-.347.25-.393.225-.773.3-.849.172-.075-.129.182-.416.576-.641.138-.079.268-.133.391-.173a2.038 2.038 0 01-.391-.172c-.393-.225-.651-.51-.576-.641.076-.129.456-.053.85.172.138.079.25.166.346.25a2.034 2.034 0 01-.045-.422c0-.45.123-.814.274-.814.15 0 .274.364.274.814 0 .157-.02.297-.045.422a2.04 2.04 0 01.345-.25c.393-.225.772-.3.849-.172.075.13-.182.417-.575.641a2.03 2.03 0 01-.39.172c.121.04.253.094.39.173.393.223.652.51.575.641z"
                        fill="#D42E11"
                    />
                    <path
                        d="M12.914 12.627c0 1.497 1.227 2.712 2.739 2.712 1.513 0 2.74-1.215 2.74-2.712 0-.236-.04-.46-.098-.678a2.727 2.727 0 01-2.642 2.034 2.73 2.73 0 01-2.643-2.034 2.7 2.7 0 00-.096.678z"
                        fill="#EEE"
                    />
                    <g fill="#FFAC33">
                        <path d="M14.68 17.915c-.077-.129-.457-.053-.85.172-.138.079-.25.164-.345.25.026-.125.045-.263.045-.422 0-.45-.123-.813-.274-.813-.152 0-.274.363-.274.813 0 .159.02.297.045.422a2.077 2.077 0 00-.346-.25c-.393-.225-.774-.3-.85-.172-.075.13.183.416.576.641.138.079.27.133.392.173-.122.039-.254.093-.392.172-.393.225-.65.512-.575.641.075.129.456.053.849-.172a2.08 2.08 0 00.346-.25 2.034 2.034 0 00-.045.422c0 .45.122.814.274.814.15 0 .274-.364.274-.814 0-.159-.019-.297-.045-.422.096.086.208.171.345.251.393.224.773.3.85.171.075-.13-.183-.417-.576-.641a2.065 2.065 0 00-.39-.172c.122-.04.252-.094.39-.173.393-.223.65-.51.575-.641zM18.898 18.9a2.03 2.03 0 00-.39-.172 2.03 2.03 0 00.39-.172c.393-.223.65-.51.575-.641-.077-.129-.456-.053-.85.172a2.04 2.04 0 00-.344.25c.026-.125.045-.265.045-.422 0-.45-.123-.814-.274-.814-.15 0-.274.364-.274.814 0 .159.019.297.045.422a2.077 2.077 0 00-.347-.25c-.393-.225-.773-.3-.849-.172-.075.13.182.416.576.641.138.079.268.133.391.172-.123.04-.253.094-.391.173-.393.225-.651.512-.576.641.076.129.456.053.85-.172a2.08 2.08 0 00.346-.25 2.034 2.034 0 00-.045.422c0 .45.123.814.274.814.15 0 .274-.364.274-.814 0-.157-.02-.296-.045-.42.095.084.208.17.345.25.393.223.772.299.849.17.077-.13-.182-.418-.575-.641z" />
                    </g>
                    <path
                        d="M7.911 27.793c-1.054.237-4.337 1.997-4.337 1.997l.782 1.642s.935-.478 1.568-.746c.585-.249 2.094-.93 2.914-.961l.068.215c.211.657.785.627 1.447.299.662-.33 1.627-.537 2.532-.537h5.995c.905 0 1.87.207 2.53.537.664.328 1.236.358 1.448-.299l.068-.215c.82.031 2.329.712 2.915.961.632.267 1.568.746 1.568.746l.782-1.642s-3.283-1.76-4.34-1.997c-.767-.174-1.612-.236-1.832.017.032.061.17.282.522.44.358.162.713.448.617.646-.4.012-.87-.309-1.4-.592a4.35 4.35 0 00-.677-.303c-.815-.268-3.043-.419-3.768-.419H14.45c-.723 0-2.951.151-3.766.42a4.358 4.358 0 00-.679.302c-.53.283-1 .604-1.398.592-.096-.198.258-.484.617-.645.353-.16.489-.38.52-.44-.22-.254-1.065-.191-1.833-.018zm7.986.427h4.039v1.11h-4.04v-1.11zm-3.552 0h2.368v1.11h-2.368v-1.11z"
                        fill="#CCD6DD"
                    />
                    <g fill="#66757F">
                        <path d="M9.224 28.25c-.359.162-.714.448-.618.646.398.012.869-.309 1.399-.592-.134-.288-.252-.51-.252-.51l-.009.016c-.031.06-.167.282-.52.44zM23.158 28.896c.096-.198-.259-.484-.617-.645-.353-.16-.49-.38-.522-.44-.006-.01-.008-.017-.008-.017s-.12.222-.253.51c.53.283 1 .604 1.4.592z" />
                    </g>
                    <g fill="#99AAB5">
                        <path d="M12.05 30.857h2.96V29.47h-2.96zM15.391 30.857h5.05V29.47h-5.05z" />
                    </g>
                    <g fill="#CCD6DD">
                        <path d="M-2.586 14.575c-.262-.203-.4 1.668 1.027 3.137 1.426 1.468 3.937 1.822 3.937 1.822l.641-1.228a4.975 4.975 0 00-.77-.51C.891 17.082-.046 15.658-.855 14.56c.171.297.294.552.294.552s-1.427-.07-2.025-.537zM2.236 25.678c.909 0 1.695-.45 2.229-1.154-.576.732-1.431 1.153-2.229 1.153-1.37 0-2.468-1.453-2.468-2.414 0-.469.132-.943.386-1.312-.218.264-.43.647-.43 1.141 0 1.017.813 2.586 2.512 2.586zM4.778 20.5c.238.585.369 1.245.369 2.014 0 .345-.05.668-.14.966.126-.386.195-.802.195-1.235 0-.594-.16-1.187-.424-1.744z" />
                        <path d="M-.575 13.814c.728.762 2.31 2.076 3.467 3.22 1.156 1.144 2.868 3.262 2.868 5.21 0 1.95-.985 3.73-3.638 3.73-1.798 0-2.887-1.838-2.697-2.966.176-1.047.875-1.375 1.116-1.459.224-.163.495-.265.81-.278.513-.022.941.38.728.636-.329.39.083.977.513.127.13-.255-.213-1.272-1.284-1.272-.899 0-2.31.947-2.31 2.5s1.155 3.135 3.295 3.135c3.652 0 4.564-2.16 4.964-5.38.4-3.222-.856-5.551-2.453-6.808-1.352-1.063-1.55-.473-3.154-1.327-1.112-.594-.556-2.346-.556-2.346-.227 1.582 1.54 1.978 1.54 1.978.172.34.914-.17.914-.17s1.441 1.073 2.297 1.13c.856.057.956-.79.043-1.074-.912-.282-.856-1.695-.856-1.695l.115-.62c.114-.622-1.014-1.187-.971-.933.098.583-.685.551-.941.17-.175-.259-.029-.933.656-1.102.685-.17 1.312-.112.571-.508-.742-.396-2.112.112-2.112.112l-1.14.904-1.357-.339s.3.31.471.762c.172.452-.428.764-.656.312-.228-.451-1.156-.028-1.783 1.383-.628 1.413.185 2.628.585 2.855.206.116.457.487.652.82-.04-.14-.385-1.43.303-.707z" />
                    </g>
                    <path
                        d="M2.25 17.796c.253.133.513.306.77.51a6.395 6.395 0 011.758 2.195c.263.557.424 1.15.424 1.744 0 .433-.069.85-.195 1.234-.127.386-.31.74-.542 1.045-.534.704-1.32 1.154-2.23 1.154-1.697 0-2.511-1.569-2.511-2.586 0-.494.212-.876.43-1.14.232-.28.47-.427.47-.427s-.031.007-.083.024c-.241.084-.94.412-1.116 1.46-.19 1.127.899 2.966 2.697 2.966 2.653 0 3.638-1.78 3.638-3.73 0-1.949-1.712-4.067-2.868-5.211-1.156-1.144-2.74-2.458-3.467-3.22-.688-.723-.342.566-.303.707a.935.935 0 00.003.013l.02.026c.809 1.098 1.746 2.522 3.104 3.236z"
                        fill="#99AAB5"
                    />
                    <g fill="#CCD6DD">
                        <path d="M33.813 14.575c-.598.467-2.025.537-2.025.537s.123-.256.295-.553c-.81 1.098-1.746 2.523-3.106 3.237a4.975 4.975 0 00-.77.51l.641 1.228s2.51-.354 3.938-1.822c1.427-1.469 1.289-3.34 1.027-3.137zM26.23 23.51a3.341 3.341 0 01-.148-.996c0-.777.133-1.442.376-2.031-.269.562-.433 1.162-.433 1.762 0 .444.072.871.205 1.265zM26.247 23.535c.004.012.007.024.012.035-.005-.011-.009-.023-.012-.035z" />
                        <path d="M31.802 23.008c.19 1.128-.899 2.967-2.697 2.967-2.653 0-3.638-1.78-3.638-3.73 0-1.949 1.712-4.067 2.868-5.21 1.156-1.145 2.74-2.46 3.467-3.221.689-.724.341.57.303.707.195-.332.447-.703.654-.82.398-.227 1.212-1.442.583-2.854-.626-1.412-1.554-1.835-1.782-1.383-.228.451-.828.14-.657-.312.171-.452.471-.762.471-.762l-1.355.339-1.142-.905s-1.37-.508-2.11-.112c-.743.396-.115.339.57.508.684.17.83.844.655 1.101-.256.383-1.038.414-.94-.169.042-.254-1.085.312-.97.933l.113.62s.058 1.414-.856 1.696c-.913.283-.813 1.13.043 1.074.856-.057 2.297-1.13 2.297-1.13s.742.509.913.17c0 0 1.77-.396 1.541-1.979 0 0 .556 1.752-.556 2.346-1.604.854-1.802.264-3.153 1.327-1.598 1.257-2.854 3.587-2.454 6.809.4 3.22 1.312 5.38 4.965 5.38 2.14 0 3.295-1.583 3.295-3.135 0-1.554-1.412-2.5-2.31-2.5-1.071 0-1.414 1.017-1.285 1.271.43.85.842.263.514-.127-.214-.255.215-.658.727-.636.315.013.586.115.81.279.241.083.94.41 1.116 1.458z" />
                        <path d="M28.993 25.678c1.696 0 2.51-1.569 2.51-2.586a1.78 1.78 0 00-.43-1.14c.253.368.386.842.386 1.31 0 .962-1.097 2.416-2.467 2.416-.804 0-1.668-.43-2.243-1.173.534.715 1.326 1.173 2.244 1.173z" />
                    </g>
                    <path
                        d="M32.083 14.56c.006-.01.012-.018.019-.026l.003-.013c.038-.137.386-1.43-.303-.707-.728.762-2.31 2.076-3.467 3.22-1.156 1.144-2.868 3.262-2.868 5.21 0 1.95.985 3.73 3.638 3.73 1.798 0 2.887-1.838 2.697-2.966-.176-1.047-.875-1.375-1.116-1.459-.052-.017-.083-.024-.083-.024s.238.146.47.426c.218.265.43.647.43 1.141 0 1.017-.814 2.586-2.51 2.586-.918 0-1.71-.458-2.244-1.173a3.546 3.546 0 01-.499-.935c0-.004-.002-.007-.003-.011l-.017-.05a3.958 3.958 0 01-.205-1.264c0-.6.164-1.2.432-1.762a6.4 6.4 0 011.75-2.177c.257-.204.517-.377.77-.51 1.36-.714 2.297-2.139 3.106-3.237z"
                        fill="#99AAB5"
                    />
                </g>
            </g>
        </svg>
    );
}
SvgMayotte.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgMayotte.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgMayotte;
