import React from 'react';
import PropTypes from 'prop-types';

function SvgGermany({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M.501 12.13C2.618 3.571 11.265-1.64 19.822.476c8.558 2.117 13.77 10.763 11.653 19.321-2.117 8.55-10.764 13.77-19.321 11.653C3.604 29.325-1.616 20.679.5 12.129"
                    fill="#FFD203"
                />
                <path
                    d="M.962 10.602h30.052C29.277 5.737 25.212 1.81 19.822.477 11.79-1.511 3.67 2.966.962 10.602"
                    fill="#191407"
                />
                <path
                    d="M31.596 19.24c.008-.032.016-.064.024-.105.016-.056.024-.12.033-.177a.473.473 0 00.016-.105c.008-.065.024-.122.032-.186.008-.033.008-.065.016-.09.016-.072.024-.153.04-.225 0-.017.009-.033.009-.049.016-.089.024-.186.04-.275 0-.024.008-.048.008-.072l.024-.202c0-.033.008-.065.008-.097.009-.057.017-.122.017-.178 0-.033.008-.065.008-.097.008-.065.008-.121.016-.186 0-.032.008-.065.008-.097.008-.073.008-.137.016-.21v-.065c.008-.089.008-.186.016-.275v-.048c0-.073.008-.154.008-.226v-.09V16v-.097-.186-.089c0-.064 0-.137-.008-.202v-.072a12.521 12.521 0 00-.032-.55c0-.024 0-.048-.008-.073-.008-.064-.008-.129-.016-.202 0-.032-.008-.056-.008-.089-.008-.064-.017-.12-.017-.185 0-.033-.008-.057-.008-.09l-.024-.201c0-.025-.008-.049-.008-.073-.024-.178-.048-.364-.08-.542 0-.016-.009-.032-.009-.048-.008-.073-.024-.145-.04-.218-.008-.024-.008-.049-.016-.073-.008-.065-.025-.13-.04-.194-.009-.024-.009-.048-.017-.073-.016-.064-.024-.129-.04-.202-.008-.024-.008-.04-.017-.064-.016-.081-.04-.162-.056-.243l-.008-.016c-.024-.08-.04-.17-.065-.25-.121-.469-.258-.93-.42-1.382H.962a15.896 15.896 0 00-.735 7.863c0 .008 0 .016.007.024.008.072.025.145.04.226 0 .016.009.032.009.048.016.073.024.138.04.21 0 .025.008.041.008.065.016.065.025.13.04.194.009.024.009.049.017.073.016.065.024.121.04.186l.025.089c.016.056.024.113.04.177.008.04.024.09.032.13l.049.194c.016.064.032.129.056.194.008.032.016.056.025.08.016.065.032.122.056.186l.024.09c.017.056.04.12.057.177l.024.08c.016.065.04.122.057.179l.024.08c.024.065.04.122.065.186.008.016.008.032.016.04.016.041.024.073.04.114H30.95c.017-.04.025-.073.04-.113.033-.097.066-.186.098-.283 0-.008.008-.016.008-.024.04-.122.08-.251.121-.372.008-.016.008-.033.016-.049.033-.113.073-.234.105-.355l.025-.073c.04-.137.072-.283.113-.42.024-.09.04-.186.064-.275.008-.032.017-.056.017-.089.016-.056.032-.113.04-.178"
                    fill="#EC463A"
                />
            </g>
        </svg>
    );
}
SvgGermany.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgGermany.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgGermany;
