import React from 'react';
import PropTypes from 'prop-types';

function SvgCanada({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M12.162 31.459C3.604 29.34-1.608 20.695.509 12.137 2.626 3.58 11.273-1.633 19.83.485c8.55 2.117 13.77 10.763 11.653 19.321-2.125 8.55-10.772 13.77-19.321 11.653"
                    fill="#EF3827"
                />
                <path
                    d="M10.634 30.998V.945C5.77 2.683 1.842 6.747.51 12.137c-1.988 8.033 2.489 16.146 10.125 18.861"
                    fill="#EF3827"
                />
                <path
                    d="M19.273.356c-.033-.009-.065-.017-.105-.025C19.11.323 19.046.307 18.99.3a.473.473 0 00-.105-.016c-.065-.008-.121-.024-.186-.032-.032-.009-.065-.009-.089-.017-.073-.016-.153-.024-.226-.04-.016 0-.032-.008-.049-.008-.089-.016-.186-.024-.274-.04-.025 0-.049-.009-.073-.009l-.202-.024c-.032 0-.065-.008-.097-.008A1.321 1.321 0 0017.51.09c-.032 0-.065-.008-.097-.008-.065-.008-.121-.008-.186-.016-.032 0-.064-.008-.097-.008-.072-.009-.137-.009-.21-.017h-.064c-.09-.008-.186-.008-.275-.016h-.049c-.072 0-.153-.008-.226-.008h-.646c-.065 0-.138 0-.202.008h-.073c-.186.008-.364.016-.55.033-.024 0-.048 0-.072.008-.065.008-.13.008-.202.016-.033 0-.057.008-.09.008-.064.008-.12.016-.185.016-.032 0-.057.008-.089.008l-.202.024c-.024 0-.049.008-.073.008-.178.025-.363.049-.541.081-.016 0-.033.008-.049.008-.072.017-.145.025-.218.04-.024.009-.048.009-.073.017-.064.008-.129.024-.194.04-.024.008-.048.008-.08.016-.065.017-.13.025-.202.04-.025.009-.04.009-.065.017-.08.016-.162.04-.242.057l-.017.008c-.08.024-.17.04-.25.064-.469.122-.93.259-1.382.429v30.052c.493.178 1.002.331 1.527.46 2.142.534 4.291.599 6.336.275.008 0 .016 0 .024-.008.073-.008.154-.024.226-.04.016 0 .033-.008.049-.008.072-.016.137-.024.21-.04.024 0 .04-.009.064-.017.065-.016.13-.024.194-.04.025-.008.049-.008.073-.016.065-.016.121-.024.186-.04l.089-.025c.056-.016.113-.024.178-.04.04-.008.089-.024.129-.033l.194-.048c.065-.016.13-.032.194-.057.032-.008.056-.016.08-.024.065-.016.122-.032.186-.056.033-.009.057-.017.09-.025.056-.016.12-.04.177-.056l.081-.024c.057-.017.121-.04.178-.057l.08-.024c.065-.025.122-.04.186-.065.017-.008.033-.008.04-.016.041-.016.074-.024.114-.04V1.017c-.04-.016-.073-.024-.113-.04-.097-.033-.186-.065-.283-.097-.008 0-.016-.008-.024-.008l-.372-.121c-.016-.009-.032-.009-.048-.017-.114-.032-.235-.072-.356-.105l-.073-.024c-.137-.04-.283-.073-.42-.113-.089-.024-.186-.04-.275-.065-.032-.008-.056-.016-.089-.016a.835.835 0 00-.17-.056"
                    fill="#F1F2F2"
                />
                <path
                    d="M16.154 21.972h.21l-.065-2.74.194-.161c.856.105 1.632.194 2.489.299l-.218-.752a.362.362 0 01.113-.355l2.497-2.118-.517-.25c-.227-.089-.162-.218-.081-.541l.38-1.447-1.447.315a.222.222 0 01-.258-.161l-.186-.68-1.148 1.342c-.161.218-.493.218-.388-.283l.493-2.723-.654.356c-.186.105-.372.12-.477-.065l-.921-1.77-.922 1.77c-.105.194-.29.178-.468.065l-.655-.356.493 2.723c.105.501-.226.501-.388.283l-1.147-1.341-.186.679a.222.222 0 01-.259.161l-1.454-.315.38 1.447c.08.323.145.452-.081.54l-.517.251 2.497 2.118c.097.08.145.226.113.355l-.218.752c.856-.105 1.632-.194 2.488-.3l.194.162-.064 2.74h.178z"
                    fill="#EF3827"
                />
            </g>
        </svg>
    );
}
SvgCanada.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgCanada.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgCanada;
