import React from 'react';
import PropTypes from 'prop-types';

function SvgBhutan({ className, style }) {
    return (
        <svg width={32} height={32} viewBox="0 0 32 32" className={className} style={style}>
            <g fillRule="nonzero" fill="none">
                <path
                    d="M4.74 27.26c-6.237-6.236-6.237-16.347 0-22.583 6.236-6.236 16.347-6.236 22.583 0 0 .002 4.24 14.35-1.997 20.587-6.236 6.236-20.582 2-20.587 1.997z"
                    fill="#FFE15A"
                />
                <path
                    d="M4.74 27.26c6.236 6.237 16.347 6.237 22.583 0 6.236-6.236 6.236-16.347 0-22.583L4.739 27.261z"
                    fill="#FF6E55"
                />
                <g transform="translate(12.226 8.047)" fill="#FFF5DC">
                    <path d="M5.301 2.167c-.306.069-.786-.103-.786-.103.099.179.364.299.602.375-.192.02-.412.032-.657.026-.983-.023-1.441.653-1.441.653.35-.229.71-.229 1.245-.149.535.08 1.67-.275 1.67-.275l.099-.458s-.426-.138-.732-.07z" />
                    <path d="M6.311.017S6.82.13 7.335.441a.518.518 0 00-.089.063 1.725 1.725 0 00-.629-.186s.27.074.53.288a1.5 1.5 0 00-.165.261C6.41.224 5.792.654 5.792.654c.767-.062.948.455.99.705a4.021 4.021 0 00-.418-.26c.019-.015.029-.028.051-.044 0 0-.048.002-.115.012C5.322.574 4.842.963 4.842.963c.435-.056.836.063 1.155.21-.14.085-.235.234-.157.487-.548-.156-1.238-.31-1.576-.215-.612.172-.415.768-.415.768s.01-.402.426-.493c.31-.069 1.856.447 1.856.447l.502-.252-.207-.184s-.399-.168-.228-.457c.286.16.468.32.468.32l.123-.189c.006.049.008.086.008.086l.35-.161.076-.115c.03-.174.081-.297.14-.39.1.133.184.298.226.502l.317.035S7.854.977 7.5.672a.465.465 0 01.093-.056c.233.175.451.395.602.671l.584-.009S7.82.155 6.311.018z" />
                    <circle cx={11.886} cy={5.434} r={1} />
                    <ellipse cx={10.178} cy={11.898} rx={1} ry={1.03} />
                    <circle cx={2.695} cy={11.4} r={1} />
                    <circle cx={0.906} cy={15.278} r={1} />
                    <path d="M9.462 3.428s1.682.63 2.088.842c.574.301 1.475-.576 2.105.104 0 0-.11-.453-.633-.488 0 0 .01-.447-.48-.424 0 0 .36.275.152.47 0 0-.142-.332-.546-.275 0 0 .306.126.23.321 0 0-.486.247-.705.086-.218-.16-1.944-1.138-2.49-1.16l.279.524z" />
                </g>
                <path
                    d="M21.271 12.043s.365.111.895.686c.246.267.878.284.779-.231-.1-.516-1.326-.833-1.459-.833-.132 0-.215.378-.215.378z"
                    fill="#F5F5F5"
                />
                <g fill="#FFF5DC">
                    <path d="M23.865 10.894l-.69.24s.077.49-.316.706c-.243.132-.405.476-.394.728 0 0 .23-.333.558-.516.077-.043.148-.081.213-.12a2.47 2.47 0 00.006.51c.065.47-.077.63-.077.63s.383-.309.34-.814a.85.85 0 01.06-.435c.034.351.213.516.213.516-.132-.275.142-.574.251-.814.11-.241-.164-.631-.164-.631zM25.607 9.896c-.271-.097-.533.077-.689.224-.066.062-.241.093-.42.11a1.65 1.65 0 00.313-.282c.148-.198.419-.233.649-.31.23-.077.328-.387.328-.387s-.123.19-.468.172c-.344-.017-.46-.035-.69.224-.07.079-.169.14-.271.19a1.4 1.4 0 01.042-.354c.058-.18.32-.327.337-.688.016-.361.032-.327.23-.542.196-.215.254-.62.196-.49-.057.129-.32.284-.541.499-.222.215-.066.456-.18.645-.116.19-.386.232-.403.585-.016.352-.254.559-.254.559s-.583.335.115.602c.697.267 1.261-.475 1.608-.456.77.043.976-.224.976-.224-.131 0-.467.07-.878-.077zM17.148 15.561c-.044-.034-.799-.906-1.05-1.032l.055.218s-.165-.012-.46-.39c-.295-.378-.514-.482-.514-.482s.208.344.197.562c0 0-.449-.034-.93.207 0 0-.219-.448-.405-.528 0 0 .066.47-.087.585-.153.115 1.444.906 1.663.93.218.022 1.531-.07 1.531-.07zM18.144 13.853c-.016-.005-.097.055-.2.133a43.885 43.885 0 01-.14-.867c0-.035-.743-1.124-.765-1.17l-.004-.002c.073-.183.15-.495-.292-.25-.601.332-.842 1.1-.842 1.1.137-.15.376-.264.567-.338.004.093.005.204-.119.396-.251.39-.109.539-.109.539.197-.356.634-.39.634-.39-.065.424.165.665.165.665l.185-.23c-.022.329.145.681.25.866a.367.367 0 01-.107.04c-.186.024-.482.173-.482.173s.24-.054.376.056.352.194.47.169c0 0-.056.297.005.408 0 0-.154-.046-.333-.04-.18.007-.31-.123-.31-.123s.328.493.57.596c.24.103.656-.275.656-.275s-.132-1.445-.175-1.456zM12.488 21.043s-.208.023-.405.333l-.088-.321s-.24.183-.503.068c0 0 .24-.057.285-.286.043-.23.131-.253.131-.253s-.164-.183-.34-.172c0 0 .482-.263.745-.011.262.252.175.642.175.642zM18.275 18.509s-.208.022-.405.332l-.087-.32s-.241.183-.504.068c0 0 .241-.058.285-.287.044-.23.131-.252.131-.252s-.164-.184-.339-.172c0 0 .481-.264.744-.012.262.253.175.643.175.643zM21.823 15.246s-.101.192.027.538l-.3-.109s.004.312-.236.471c0 0 .094-.239-.06-.408-.154-.17-.122-.258-.122-.258s-.238.035-.33.192c0 0 .071-.564.42-.645.347-.08.601.219.601.219z" />
                </g>
                <path d="M22.893 19.088l.5.5a2.1 2.1 0 00-.5-.5z" fill="#FF6E55" />
                <path
                    d="M10.972 20.218s-.975 1.428-2.093 1.737l.394-.526s-.526.48-1.118.583l.713-.857s-1.59 1.543-3.628 1.863c0 0 1.578-1.04 1.896-1.406 0 0-.767.32-1.458.331 0 0 1.984-.8 2.313-1.12 0 0-.79.183-1.282.012 0 0 1.71-.514 1.95-.446 0 0-.986-.411-1.578-.366 0 0 1.009-.25 2.181 0l-.252-.285s.669-.183 1.326-.229c.658-.046.33-.103.33-.103l.076-.228s-.427.057-.778 0c0 0 1.052-.617 1.348-.892.296-.274.099-.148.099-.148s-.548.194-.746.228c0 0 .494-.594.647-.982 0 0-.45.182-.833 0 0 0 .46-.138.69-.378.23-.24.57-.837.57-.837l-.394.18s.345-.617.65-.771c0 0-.518.043-.683-.086 0 0 .55-.137.715-.274.165-.137.526-.497.896-.36 0 0 .518-.497.346-.823 0 0 .337.026.51.24.172.214.443.394.443.394l-1.408 1.149-1.074 3.634-.768.766z"
                    fill="#FFF5DC"
                />
                <g fill="#F5F5F5">
                    <path d="M24.755 13.341c.404.687-.099.756-.099.756-.077-.653-.602-.572-.602-.572l.143.48c-.876.115-.81-.8-.81-.8-.131.114-.35.583-.35.583s-2.363.824-3.96-1.625c0 0-.045-.435.087-.641l-.985-.779-1.27.184s-.502 1.19.11 1.922c.613.733 1.335 1.763 1.204 2.244-.078.285-.31.4-.631.376-.221-.016-.485-.1-.77-.24-.7-.342-2.407-1.075-3.632-.48s-1.358 1.625-1.598 2.427c-.211.709-.68 2.52-4.026 4.172-.16.08-.079.334.093.289 1.45-.377 3.427-1.006 4.037-1.749l.493.017-.18.79s.64.206.738 1.185c0 0-1.122.32-.487 1.327 0 0 .098-.732.875-.767 0 0 .175.24.558.275 0 0 .197.332.099.607 0 0 .776-.252.12-1.225 0 0 .733-.183.831.778 0 0 .47-1.556-1.209-1.442 0 0 0-.274-.443-.772 0 0-.109-.28 0-.67.033-.117.063-.238.088-.362a.885.885 0 00.416.122s.273.469 1.083.389c0 0-.591-.286-.536-.836.054-.549.744-.846 1.039-.63 0 0-.077-.72-1.149-.25 0 0 0-.539.57-.573 0 0-.92-.733-1.128.664l-.38.1c-.186-.54-.421-1.79.62-2.246 1.1-.48 2.25.6 4.284.704 0 0-.197 1.253.46 1.562.656.309 2.265.6 2.265.6-.017 1.809 1.241 1.569 1.241 1.569-.61-.383-.61-1.113-.233-1.54.513-.581 1.404-.028 1.404-.028-.013-.88-1.193-.744-1.193-.744.186-.572.92-.721.92-.721-1.018-.39-1.86.76-1.86.76l-1.724-.514s-.065-.36.345-.841.755-1.288.64-2.146c0 0 .476-.35 1.067-.006.59.343 1.86-.412 1.86-.412.547.733 1.849.595 2.024-.286.175-.882-.46-.985-.46-.985z" />
                    <path d="M22.95 11.236c-.326-.199-.909-.367-1.106.091-.197.458-.416.916-1.094.893-.678-.023-.985.583-1.455.412 0 0 .438-.149.525-.366.088-.218.438-.619.438-.619l-.044-.411s-.81.045-1.05.286c-.24.24-1.15-.206-1.15-.206l.11-.996s.7-1.122 1.674-1.042c.974.08 1.138-.183 1.609-.148.47.034.71.538 1.214.652.503.115 1.51-.103 1.641.218.132.32-.251.446-.35.892-.098.447-.306.744-.963.344z" />
                </g>
                <g transform="translate(18.027 9.232)" fill="#FFF5DC">
                    <path d="M2.032 1.698s-.47.333-.863.195S.426 1.8.022 1.939c0 0 .743-.092 1.049.206.306.299 1.081.104 1.136-.023l-.175-.424z" />
                    <path d="M2.272 2.467s-.458.345-.917.253a1.56 1.56 0 00-.874.103s.339-.39.797-.321c.46.068.623-.402.623-.402l.306.023.065.344z" />
                    <circle cx={2.644} cy={2.042} r={1} />
                    <path d="M2.283 1.56s-.24-.322-.84-.195C.84 1.49.698 1.26.698 1.26s.284.46.732.402c.448-.057.634.264.634.264l.218-.367zM4.305.756a.714.714 0 01.215-.21.73.73 0 01.166-.072.424.424 0 00-.047-.267C4.536.021 4.321-.05 4.16.05c-.16.1-.208.33-.105.517a.38.38 0 00.25.19zM3.768 1.495a.744.744 0 01.15-.264.756.756 0 01.14-.12.414.414 0 00-.117-.241C3.792.722 3.567.718 3.44.861c-.129.143-.112.379.037.527.084.083.191.116.292.107z" />
                </g>
            </g>
        </svg>
    );
}
SvgBhutan.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgBhutan.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgBhutan;
