import React from 'react';
import PropTypes from 'prop-types';

function SvgAscensionIsland({ className, style }) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="211px"
            height="212px"
            viewBox="0 0 211 212"
            version="1.1"
            className={className}
            style={style}
        >
            <title>AscensionIsland</title>
            <defs>
                <polygon
                    id="path-1"
                    points="0.000221522296 0.115233657 210.599753 0.115233657 210.599753 211 0.000221522296 211"
                />
            </defs>
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="AscensionIsland">
                    <g id="Group-3" transform="translate(0.000000, 0.885000)">
                        <g id="Clip-2" />
                        <path
                            d="M105.1172,10.7973 C105.1892,9.4693 105.3122,8.1423 105.3252,6.8143 C105.3922,-0.2197 105.3822,-0.2197 112.2362,0.3283 C156.1592,3.8393 192.6162,32.4683 205.6172,73.6593 C225.2172,135.7523 184.9412,200.3883 120.7542,209.8483 C64.2562,218.1743 11.8652,180.5253 1.5262,124.0663 C0.6912,119.5053 0.6712,114.8013 0.0962,110.1873 C-0.3198,106.8543 0.5342,105.1703 4.2872,105.6473 C6.2332,105.8943 8.2582,105.5233 10.2472,105.4313 C16.9412,103.5293 23.8282,105.1583 30.5752,104.3043 C34.1202,103.9443 37.9672,106.1513 41.1762,103.0293 C42.2312,100.9853 41.7732,98.7953 41.8102,96.6753 C42.0472,83.3043 41.4042,69.9263 42.1462,56.5673 C44.5732,52.6533 46.0772,56.1013 47.2472,57.5013 C53.9702,65.5463 60.4222,73.8153 66.9762,82.0003 C71.7612,87.9763 76.7262,93.8193 81.2602,99.9813 C83.9042,103.5753 86.9462,105.2913 91.3992,104.8333 C93.8692,104.5793 96.3882,104.7883 98.8832,104.6653 C102.4692,104.9383 103.9042,103.2343 103.7892,99.7083 C103.6662,95.9523 103.7502,92.1883 103.7522,88.4263 C104.7032,82.4283 102.6452,77.6413 98.7482,73.0043 C91.8192,64.7603 85.3092,56.1593 78.5802,47.7423 C77.3612,46.2153 75.4782,44.5253 76.3242,42.5313 C77.3272,40.1673 80.0282,40.8393 82.0932,40.7933 C87.2302,40.6803 92.3722,40.7743 97.5122,40.7503 C103.7482,40.7203 103.8162,40.6393 103.7972,34.2703 C103.7942,33.4413 103.8002,32.6123 103.7802,31.7733 C103.7532,31.1863 103.7272,30.6083 103.6822,30.0233 C103.5752,25.2973 103.6112,20.5803 103.6552,15.8623 C103.6722,14.0343 104.0092,12.3063 105.1172,10.7973"
                            id="Fill-1"
                            fill="#2A5F9D"
                            mask="url(#mask-2)"
                        />
                    </g>
                    <path
                        d="M105.0738,31.9967 C105.2128,32.2437 105.2318,32.4997 105.1338,32.7657 C102.8748,35.1277 99.9068,34.5767 97.1458,34.5847 C78.0368,34.6407 58.9288,34.5967 39.8198,34.6217 C33.0898,34.6307 32.8708,34.8507 32.8618,41.6577 C32.8338,60.5997 32.8788,79.5417 32.8238,98.4847 C32.8168,101.0887 33.3168,103.8507 31.4278,106.1397 C24.3748,107.1047 17.3108,106.7757 10.2458,106.3177 C10.2928,92.3437 10.3348,78.3717 10.3878,64.3997 C10.3948,62.5877 10.2418,60.7867 11.1558,59.0537 C16.4468,49.0167 22.5308,39.5747 31.0898,31.9457 C33.4828,30.5807 36.0928,30.3607 38.7838,30.36367 C58.5198,30.3807 78.2548,30.3517 97.9908,30.3957 C100.4448,30.4017 103.0218,30.1017 105.0738,31.9967"
                        id="Fill-4"
                        fill="#EC4C5C"
                    />
                    <path
                        d="M105.0738,31.9967 C80.4128,31.9797 55.7518,31.9627 31.0898,31.9457 C38.5418,23.7177 47.5828,17.6527 57.3698,12.5887 C59.2578,11.6117 61.2378,11.7707 63.2198,11.7667 C77.1848,11.7297 91.1508,11.7087 105.1168,11.6827 C105.1028,18.4537 105.0878,25.2257 105.0738,31.9967"
                        id="Fill-6"
                        fill="#EC4B5B"
                    />
                    <path
                        d="M31.4283,106.1393 C31.4233,83.5093 31.5333,60.8773 31.3123,38.2483 C31.2703,33.9583 32.2063,32.6083 36.7443,32.6593 C59.5383,32.9093 82.3373,32.7693 105.1333,32.7653 C105.6933,43.1493 105.6933,43.1483 95.5593,43.1493 C89.7503,43.1503 83.9413,43.1523 78.1323,43.1583 C77.8013,43.1593 77.4703,43.2043 77.0903,43.2323 C76.4853,45.0593 78.0703,45.8993 78.9123,46.9643 C86.0083,55.9403 92.9153,65.0873 100.4233,73.7093 C104.3453,78.2143 106.0103,82.8453 105.0723,88.5843 C102.0953,89.0093 101.3383,86.2943 100.0673,84.7023 C90.4373,72.6393 80.4673,60.8483 71.0263,48.6403 C68.5243,45.4043 65.7953,43.8953 61.7493,44.1633 C57.9503,44.4143 54.1233,44.1683 49.8003,44.2433 C54.9753,51.3913 60.5873,57.7713 65.9003,64.3803 C75.9863,76.9263 86.0733,89.4723 96.2993,101.9043 C97.3553,103.1873 98.5013,104.4443 98.0773,106.3263 C94.7743,106.4143 91.4603,106.3683 88.1723,106.6333 C85.4053,106.8573 83.6583,105.8363 81.9283,103.6423 C70.4533,89.0873 58.8243,74.6543 47.2263,60.1973 C45.9943,58.6613 44.6323,57.2293 43.3303,55.7503 C42.0633,57.2043 42.7593,58.9423 42.7513,60.5243 C42.6843,74.0113 42.7273,87.4973 42.6943,100.9843 C42.6903,102.6243 43.0593,104.3163 42.2993,105.9043 C38.6993,107.1123 35.0673,106.7473 31.4283,106.1393"
                        id="Fill-8"
                        fill="#FEFEFE"
                    />
                    <path
                        d="M98.0777,106.3263 C82.7457,87.3253 67.4117,68.3263 52.0837,49.3223 C50.6507,47.5453 49.2507,45.7423 47.1857,43.1293 C54.1587,43.1293 60.2027,43.1743 66.2447,43.1070213 C68.7107,43.0803 69.5927,45.0203 70.8047,46.5043 C82.2477,60.5143 93.6547,74.5543 105.0717,88.5843 C105.1517,92.3373 105.2807,96.0903 105.2997,99.8443 C105.3357,107.1233 105.3097,107.1233 98.0777,106.3263"
                        id="Fill-10"
                        fill="#EC4C5C"
                    />
                    <path
                        d="M129.5103,136.945 C127.5153,137.41 125.6373,139.854 123.6433,138.378 C121.5623,136.836 122.6663,134.19 122.7913,131.907 C123.3433,121.894 127.7633,114.032 135.6373,107.988 C138.3763,105.913 140.0973,107.85 141.8823,109.564 C142.9563,110.918 143.3553,112.498 143.4333,114.186 C143.3593,116.357 143.9503,118.679 142.0453,120.443 C141.0423,123.234 140.0393,126.026 139.0353,128.817 C138.5453,130.846 136.9723,132.085 135.6303,133.497 C133.7823,134.984 132.1933,136.939 129.5103,136.945"
                        id="Fill-12"
                        fill="#D56B3C"
                    />
                    <path
                        d="M180.188,128.9215 C179.161,126.1475 178.133,123.3715 177.107,120.5965 C175.167,118.4325 175.854,115.8635 175.984,113.3765 C176.245,111.9835 176.78,110.6995 177.564,109.5185 C179.114,107.7405 180.764,106.2905 183.28,107.8835 C192.084,114.2335 196,123.0715 196.582,133.6885 C196.859,138.7445 196.073,139.3905 191.043,137.6685 C190.2,137.4785 189.274,137.6975 188.495,137.1685 C186.821,136.0985 185.164,135.0025 183.722,133.6165 C182.377,132.1785 180.774,130.9315 180.188,128.9215"
                        id="Fill-14"
                        fill="#D56B3C"
                    />
                    <path
                        d="M189.2329,136.733 C189.8369,137.046 190.4419,137.359 191.0449,137.67 C191.8159,140.636 194.9839,140.267 196.8229,141.776 C197.9569,142.707 199.7149,143.258 199.6199,144.912 C199.5319,146.416 197.7169,146.455 196.6149,147.08 C189.0109,151.392 181.2859,149.713 173.5869,147.494 C170.5789,146.628 170.8129,145.152 172.5729,142.804 C174.5279,140.198 178.8049,139.896 179.1999,135.898 C181.1619,135.77 181.4929,137.553 182.0979,138.691 C183.0019,140.392 184.0309,139.889 185.2379,139.376 C186.5209,139.41 187.4549,140.336 188.6349,140.889 C188.5639,139.318 187.7209,137.84 189.2329,136.733"
                        id="Fill-16"
                        fill="#73938F"
                    />
                    <path
                        d="M139.2798,137.82 C142.1348,138.869 144.4198,140.73 146.5708,142.82 C149.1898,145.366 148.0578,146.883 145.1838,147.695 C137.4248,149.886 129.6718,151.131 122.0588,147.015 C121.0598,146.475 119.6698,146.428 119.5048,145.037 C119.3448,143.686 120.4908,142.961 121.4648,142.402 C123.8958,141.005 126.2748,139.456 129.0858,138.861 C130.3098,142.411 132.2528,139.412 133.8668,139.382 C136.5868,142.045 137.1708,137.28 139.2798,137.82"
                        id="Fill-18"
                        fill="#73938F"
                    />
                    <path
                        d="M148.315,134.1764 C145.97,133.1934 145.871,130.9104 145.271,128.9164 C146.61,126.4164 149.278,125.0124 150.566,122.4674 C151.937,120.9884 153.402,119.5994 154.774,118.1174 C160.112,113.0434 160.197,113.0444 165.539,118.1584 C166.951,119.6974 168.461,121.1274 170.183,122.3264 C171.277,123.3814 172.294,124.4604 171.195,126.1014 C174.672,128.6804 173.844,131.2594 171.194,133.8374 C170.615,133.4884 169.89,133.4784 169.344,133.0484 C167.947,131.9104 166.723,130.5874 165.405,129.3634 C164.813,128.8094 164.274,128.2044 163.696,127.6384 C159.742,123.7714 159.597,123.7864 156.082,128.4004 C154.611,130.0574 152.785,131.2974 151.066,132.6644 C150.2,133.2564 149.516,134.1944 148.315,134.1764"
                        id="Fill-20"
                        fill="#288549"
                    />
                    <path
                        d="M152.0445,89.9205 C153.5435,84.3815 156.5145,79.4845 158.7235,73.8425 C162.9885,77.6915 162.9365,83.6505 166.7925,87.2005 C168.7225,88.2015 168.7935,89.8275 168.2895,91.6485 C166.6425,92.7895 168.1845,94.6095 167.3785,95.9305 C166.7385,96.6965 166.1225,97.5185 164.9305,96.9405 C164.5365,92.1625 161.8575,91.6285 157.8445,92.8555 C155.2295,93.6545 152.5045,93.7935 152.0445,89.9205"
                        id="Fill-22"
                        fill="#7DCE6C"
                    />
                    <path
                        d="M165.0318,96.8424 C165.8118,96.5384 166.5938,96.2344 167.3758,95.9304 C170.6628,95.7524 171.3548,95.0634 173.6628,89.5424 C176.4848,92.9924 174.6928,95.9094 172.9728,98.8314 C174.0408,100.5934 175.6978,102.0884 175.5108,104.4174 C175.4148,104.8704 175.1858,105.2494 174.8208,105.5364 C173.5768,106.5714 171.6968,106.2414 170.5878,107.5154 C171.8018,110.5564 169.4718,110.7484 167.6258,110.9674 C164.3538,111.3544 162.1048,109.5614 160.3358,107.0094 C158.4148,103.5124 160.0928,99.8954 159.9568,96.3354 C162.2178,90.7414 163.4288,95.7464 165.0318,96.8424"
                        id="Fill-24"
                        fill="#288449"
                    />
                    <path
                        d="M123.187,96.0963 C127.322,95.7823 129.78,94.5313 130.156,89.4453 C130.661,82.6123 135.999,79.0493 141.316,80.7693 C142.041,82.0333 144.071,82.7793 142.911,84.7903 C140.903,84.8143 138.889,84.9123 137.152,86.0543 C136.425,86.5313 135.65,86.8283 135.851,88.2573 C137.018,96.5543 132.46,100.6203 124.104,99.0743 C122.568,98.7903 121.219,98.4133 120.181,97.2193 C120.773,95.7473 122.346,96.9023 123.187,96.0963"
                        id="Fill-26"
                        fill="#FBFCFC"
                    />
                    <path
                        d="M148.315,134.1764 C148.831,133.5084 149.345,132.8394 149.861,132.1714 C156.552,133.1994 163.321,131.8514 170.014,132.8304 C170.407,133.1664 170.799,133.5024 171.193,133.8384 C168.926,135.7374 166.823,137.8904 164.357,139.4834 C159.211,142.8054 152.006,140.3084 148.315,134.1764"
                        id="Fill-28"
                        fill="#1C80B4"
                    />
                    <path
                        d="M142.9107,84.7902 C142.3797,83.4512 141.8477,82.1122 141.3157,80.7712 C145.4027,81.9862 146.4407,85.7742 148.2087,88.9462 C150.4347,92.8262 149.6157,96.2302 146.5977,99.2952 C144.1867,100.3772 141.7417,100.9232 139.2027,99.6942 C138.9697,99.0402 137.1917,98.4782 138.1957,98.0502 C144.7057,95.2702 143.2407,89.8682 142.9107,84.7902"
                        id="Fill-30"
                        fill="#28844A"
                    />
                    <path
                        d="M180.0093,82.8932 C181.3313,90.0082 184.7813,92.1782 191.1113,89.8782 C191.4943,89.5172 191.6523,88.9892 192.0363,88.6282 C192.3793,88.4942 192.7083,88.5282 193.0263,88.7082 C191.4573,93.5682 187.4063,95.9822 182.8723,94.7592 C178.6463,93.6192 177.0623,90.3682 178.0783,84.9162 C177.8023,83.3652 178.4993,82.7422 180.0093,82.8932"
                        id="Fill-32"
                        fill="#288548"
                    />
                    <path
                        d="M165.0318,96.8424 C163.7598,96.9644 163.0428,96.1964 162.2778,95.3124 C160.7878,93.5894 161.2588,95.7214 160.8348,96.1094 C158.1778,98.4504 155.2258,98.7414 152.0338,97.3724 C150.1368,95.1074 148.7028,92.7144 149.9438,89.6024 C150.6438,89.7084 151.3438,89.8144 152.0458,89.9204 C153.6208,92.3494 155.6418,93.0514 158.2408,91.5194 C158.3818,91.4374 158.5258,91.3524 158.6798,91.3064 C164.6018,89.5504 166.1468,90.8984 165.0318,96.8424"
                        id="Fill-34"
                        fill="#916859"
                    />
                    <path
                        d="M180.0093,82.8932 C179.3653,83.5672 178.7223,84.2422 178.0793,84.9162 C172.7723,84.1882 170.9093,88.4692 168.2893,91.6482 C167.7913,90.1632 167.2923,88.6792 166.7933,87.1972 C170.4063,79.2822 175.6083,77.5872 180.0093,82.8932"
                        id="Fill-36"
                        fill="#F9FAFB"
                    />
                    <path
                        d="M139.2027,99.6945 C141.3757,98.6355 143.6507,98.5905 145.9737,99.0035 C147.8517,99.6335 147.3357,100.8405 146.7197,102.0795 C145.9257,103.6755 145.0337,105.2085 143.8527,106.5545 C142.6527,107.6465 142.4987,109.4625 141.1657,110.4635 C139.7567,108.6685 137.9827,107.6875 135.6367,107.9875 C135.4857,104.6475 137.2487,102.1295 139.2027,99.6945"
                        id="Fill-38"
                        fill="#CCBAB7"
                    />
                    <path
                        d="M143.2261,105.9015 C144.2701,103.6535 146.7401,101.9735 145.9741,99.0045 C148.3581,96.0155 148.2331,92.4695 148.2071,88.9465 C148.7881,89.1675 149.3701,89.3885 149.9471,89.6065 C150.6861,92.0385 151.4281,94.4735 152.1701,96.9085 C150.8931,99.0545 150.0391,101.0625 152.1221,103.3915 C153.2031,104.5985 152.8731,106.1465 151.0611,106.8805 C148.3541,107.2855 145.6131,107.9905 143.2261,105.9015"
                        id="Fill-40"
                        fill="#2B5E99"
                    />
                    <path
                        d="M175.0826,104.9279 C175.2286,102.6029 171.5536,101.5979 172.9746,98.8319 C180.0256,98.4229 182.6326,100.7129 183.2796,107.8829 C181.2006,107.6969 179.6446,108.7119 178.2426,110.0799 C176.7466,108.6349 175.9446,106.7619 175.0826,104.9279"
                        id="Fill-42"
                        fill="#CDBBB7"
                    />
                    <path
                        d="M193.0259,88.7086 L192.6209,88.7446 L192.2139,88.7236 C191.2819,84.0766 193.0899,82.5296 199.0289,82.8916 C203.8799,86.7396 204.8509,88.4856 204.9239,93.5666 C201.5269,90.4666 198.9709,85.3606 193.0259,88.7086"
                        id="Fill-44"
                        fill="#F3F6F6"
                    />
                    <path
                        d="M171.1949,126.1012 C170.9759,124.6962 170.6379,123.3482 169.4419,122.4072 C169.3749,120.2802 170.6969,118.6022 171.2849,116.6852 C172.0689,115.2172 173.4409,114.3442 174.6729,113.3242 C175.4609,112.8242 176.2419,112.2702 177.2409,112.7912 C177.1959,115.3932 177.1519,117.9962 177.1069,120.5972 C174.4039,121.6452 173.9219,125.0782 171.1949,126.1012"
                        id="Fill-46"
                        fill="#DCC4BB"
                    />
                    <path
                        d="M42.2989,105.9044 C42.2669,89.4594 42.2319,73.0144 42.2239,56.5694 C42.2239,56.1344 42.5309,55.7004 42.6949,55.2664 C42.9069,55.4274 43.1189,55.5884 43.3309,55.7504 C43.2969,70.7324 43.2849,85.7154 43.1969,100.6964 C43.1869,102.4464 43.8699,104.3934 42.2989,105.9044"
                        id="Fill-48"
                        fill="#005096"
                    />
                    <path
                        d="M120.2437,88.8087 C122.3137,84.6117 121.3617,81.6947 116.4307,80.3167 C118.5597,78.1417 120.9297,77.7297 123.1807,79.4027 C125.2647,80.9527 125.3717,83.2787 124.4897,85.7287 C123.5457,88.3487 122.0557,90.4037 119.5097,91.6177 C119.3067,90.5647 119.5277,89.6217 120.2437,88.8087"
                        id="Fill-50"
                        fill="#F5F7F9"
                    />
                    <path
                        d="M142.0454,120.443 C142.0684,118.033 142.0914,115.623 142.1144,113.213 C142.8584,112.986 143.5754,113.086 144.2764,113.392 C145.8174,114.306 147.0014,115.582 147.9874,117.063 C148.9254,118.697 149.3664,120.461 149.3814,122.34 C149.1364,123.873 149.3364,125.792 147.3794,126.257 C145.5684,126.689 145.1574,124.829 144.2904,123.782 C143.6614,122.589 143.4764,121.097 142.0454,120.443"
                        id="Fill-52"
                        fill="#E1C5BA"
                    />
                    <path
                        d="M134.1773,139.8424 C133.6743,140.2584 133.1883,140.6944 132.6673,141.0854 C131.6553,141.8464 130.6993,143.3914 129.3693,142.7164 C127.6183,141.8294 129.8603,140.1304 129.0853,138.8614 C129.2253,138.2224 129.3653,137.5844 129.5073,136.9464 C131.3563,135.5384 133.2013,134.1324 135.0473,132.7264 C138.2253,135.4534 138.0473,136.9054 134.1773,139.8424"
                        id="Fill-54"
                        fill="#E1C6BB"
                    />
                    <path
                        d="M134.1773,139.8424 C135.6733,137.6184 137.5323,135.4394 135.0473,132.7274 C136.3773,131.4234 137.7063,130.1214 139.0363,128.8184 C140.8303,131.7724 140.6073,134.7804 139.2803,137.8204 C137.7863,139.0184 137.4203,143.0614 134.1773,139.8424"
                        id="Fill-56"
                        fill="#C1A197"
                    />
                    <path
                        d="M185.0826,139.8317 C184.1506,140.4467 183.6476,142.0197 181.9886,140.4277 C180.5956,139.0907 180.4476,137.1937 179.1986,135.8967 C178.7276,133.4587 178.7436,131.0897 180.1876,128.9217 C181.5196,130.2157 182.8516,131.5087 184.1826,132.8027 C183.9146,135.2187 185.4916,137.3967 185.0826,139.8317"
                        id="Fill-58"
                        fill="#C3A196"
                    />
                    <path
                        d="M199.0288,82.8913 C195.5218,83.3933 192.4648,84.4173 192.2148,88.7243 C191.8458,89.1093 191.4778,89.4953 191.1108,89.8793 C190.8688,87.7453 188.8268,85.4533 191.3558,83.5413 C193.7038,81.7663 196.2988,81.0503 199.0288,82.8913"
                        id="Fill-60"
                        fill="#228347"
                    />
                    <path
                        d="M144.2906,123.7819 C145.7296,123.7249 146.3256,125.1649 147.3276,125.8529 C148.5716,124.5759 147.9996,123.2339 148.1996,122.0459 C149.7326,120.8289 150.5986,121.6659 151.2866,123.0479 C149.9216,125.6609 148.1286,127.8369 145.2696,128.9169 C144.0586,127.3749 143.9946,125.6119 144.2906,123.7819"
                        id="Fill-62"
                        fill="#2085AF"
                    />
                    <path
                        d="M120.2437,88.8087 C119.9987,89.7437 119.7527,90.6787 119.5087,91.6157 C120.2657,93.4957 120.3557,95.9227 123.1877,96.0957 C122.4917,97.2877 121.2887,97.1197 120.1827,97.2177 C116.3467,94.2087 116.3677,91.3327 120.2437,88.8087"
                        id="Fill-64"
                        fill="#258150"
                    />
                    <path
                        d="M143.9917,114.2008 C143.3657,113.8738 142.7407,113.5478 142.1147,113.2168 C142.5587,112.0318 142.0547,111.1788 141.1657,110.4608 C141.7827,108.9128 140.9227,106.6938 143.2247,105.9018 C146.2297,105.8408 149.2337,105.7798 152.2377,105.7188 C153.1217,105.9388 153.5747,106.3558 152.9557,107.2678 C152.1447,107.9078 151.1517,108.2388 150.1867,108.1348 C146.4257,107.7248 145.3207,109.9848 144.9787,113.1028 C144.7727,113.5818 144.4417,113.9458 143.9917,114.2008"
                        id="Fill-66"
                        fill="#020303"
                    />
                    <path
                        d="M185.0826,139.8317 C183.6156,137.6387 181.7396,135.4977 184.1826,132.8027 C185.8656,134.1127 187.5486,135.4247 189.2316,136.7337 C188.6776,138.8467 190.5516,140.5437 190.3856,142.6547 C187.6826,143.2417 186.8126,140.7387 185.0826,139.8317"
                        id="Fill-68"
                        fill="#E4C8BB"
                    />
                    <path
                        d="M177.2408,112.7916 C176.5478,113.2346 175.8538,113.6786 175.1608,114.1206 C174.4818,113.6066 174.1738,112.8856 174.0008,112.0836 C173.7628,110.5006 173.7918,108.9126 173.9688,107.3226 C174.0998,106.5176 174.4158,105.8016 175.0178,105.2316 L175.0828,104.9286 C177.2868,105.9376 178.4758,107.5716 178.2428,110.0786 C177.9088,110.9836 177.5748,111.8876 177.2408,112.7916"
                        id="Fill-70"
                        fill="#10325C"
                    />
                    <path
                        d="M174.9478,112.0748 C175.0178,112.7578 175.0898,113.4388 175.1608,114.1208 C174.1348,115.0678 173.1068,116.0138 172.0808,116.9608 C169.9608,118.4148 167.7368,119.5138 165.0458,118.9988 C161.8218,114.7888 158.5738,114.5068 155.2988,118.9398 C152.1408,120.2408 149.7258,118.3848 147.1918,117.0358 C146.1258,116.0918 145.0588,115.1458 143.9918,114.2008 C144.1148,113.7028 144.2378,113.2058 144.3618,112.7078 C147.0358,109.0438 150.3348,110.7798 153.5348,111.6318 C158.9738,110.4288 164.5838,112.9018 170.0188,110.7558 C171.7498,110.0728 173.6078,110.4998 174.9478,112.0748"
                        id="Fill-72"
                        fill="#1B81B5"
                    />
                    <path
                        d="M170.0142,132.8307 C167.4262,134.0727 164.8112,134.8027 162.0322,133.3807 C160.4502,132.5717 158.9612,132.7307 157.3442,133.5497 C154.5842,134.9447 151.9932,134.5967 149.8632,132.1697 C151.6362,130.8837 152.8372,128.8087 155.1772,128.2917 C158.8722,124.2197 162.4512,126.6017 166.0382,128.4877 C167.6332,129.6887 169.0682,131.0357 170.0142,132.8307"
                        id="Fill-74"
                        fill="#FAFBFC"
                    />
                    <path
                        d="M166.0386,128.4879 C162.4156,128.5839 158.8486,125.6229 155.1776,128.2909 C159.0166,121.1989 159.4076,121.2059 166.0386,128.4879"
                        id="Fill-76"
                        fill="#1680B2"
                    />
                    <path
                        d="M147.1919,117.0358 C150.2779,116.0368 152.3959,119.1538 155.2969,118.9388 C154.2649,120.6078 153.0829,122.1288 151.2859,123.0478 C150.2569,122.7148 149.2279,122.3808 148.1999,122.0458 L147.1919,117.0358 Z"
                        id="Fill-78"
                        fill="#F9FAFB"
                    />
                    <path
                        d="M165.0454,118.9987 C167.4264,118.4427 169.3204,116.2057 172.0814,116.9607 C171.6194,118.9827 171.3964,121.1207 169.4384,122.4097 C166.7224,122.8897 166.2194,120.5107 165.0454,118.9987"
                        id="Fill-80"
                        fill="#F7F9FB"
                    />
                    <path
                        d="M153.0191,106.8693 C152.7581,106.4853 152.4981,106.1013 152.2381,105.7183 C151.8791,105.0173 151.7001,104.0743 151.1331,103.6563 C147.1071,100.6833 148.7711,98.6843 152.1701,96.9093 C155.1381,97.4893 157.9301,96.1663 160.8361,96.1073 C162.0421,99.7133 159.5021,103.4013 161.0791,106.9973 C159.8731,111.6263 157.9101,112.7233 152.6981,111.6743 C151.6711,109.9953 151.9241,108.4043 153.0191,106.8693"
                        id="Fill-82"
                        fill="#6BA9A5"
                    />
                    <path
                        d="M153.2554,111.6071 C156.8544,111.7521 159.2144,109.7951 161.0784,106.9981 C163.7384,109.4611 166.5314,111.2831 170.2774,109.0071 C169.7934,107.3141 167.6694,108.5491 167.2264,107.0521 C169.8324,106.2821 172.4384,105.5901 175.0314,107.0941 C175.0034,108.7531 174.9764,110.4111 174.9474,112.0721 C172.0444,111.5231 169.3014,112.2811 166.4564,112.6281 C162.1554,113.1531 157.5994,112.5181 153.1464,112.7621 C152.8824,112.4781 152.8114,112.2121 152.9314,111.9641 C153.0464,111.7261 153.1544,111.6071 153.2554,111.6071"
                        id="Fill-84"
                        fill="#F5F8F8"
                    />
                    <path
                        d="M175.0318,107.0944 C172.4288,107.0804 169.8268,107.0674 167.2248,107.0524 C169.5028,105.0684 172.3438,105.5024 175.0188,105.2314 C175.0228,105.8524 175.0268,106.4734 175.0318,107.0944"
                        id="Fill-86"
                        fill="#1C191D"
                    />
                    <path
                        d="M153.2554,111.6071 C153.2194,111.9921 153.1834,112.3771 153.1464,112.7621 C150.2264,111.4201 147.3014,110.8661 144.3614,112.7081 C144.0904,107.0621 144.0904,107.0621 153.0204,106.8691 C153.0984,108.4481 153.1764,110.0281 153.2554,111.6071"
                        id="Fill-88"
                        fill="#EBF0F1"
                    />
                </g>
            </g>
        </svg>
    );
}
SvgAscensionIsland.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

SvgAscensionIsland.defaultProps = {
    className: undefined,
    style: undefined,
};

export default SvgAscensionIsland;
