##### Basic:

```js
/* eslint-disable react/jsx-no-undef */
import React, { useState } from 'react';
import { Option } from 'react-rainbow-components';

function BasicInternalDropdown() {
    const [value, setValue] = useState();
    return (
        <div className="rainbow-m-around_xx-large">
            <InternalDropdown id="internal-dropdown-1" value={value} onChange={setValue}>
                <Option name="option-1" label="All Buildings" icon={<DashboardIcon />} />
                <Option name="option-2" label="New Building" icon={<AddFilledIcon />} />
                <Option name="header" label="Your Buildings" variant="header" />
                <Option name="option-3" label="Experimental" icon={<BuildingIcon />} />
                <Option name="option-4" label="Bennet Towers" icon={<BuildingIcon />} />
                <Option name="option-5" label="Empire State" icon={<BuildingIcon />} />
                <Option name="option-6" label="Central Park" icon={<BuildingIcon />} />
                <Option name="option-7" label="Chrysler" icon={<BuildingIcon />} />
                <Option name="option-8" label="Plaza" icon={<BuildingIcon />} />
            </InternalDropdown>
        </div>
    );
}

    <BasicInternalDropdown />
```

##### With search input:

```js
/* eslint-disable react/jsx-no-undef */
import React, { useState } from 'react';
import { Option } from 'react-rainbow-components';

function InternalDropdownWithSearch() {
    const [value, setValue] = useState();
    return (
        <div className="rainbow-m-around_xx-large">
            <InternalDropdown id="internal-dropdown-3" value={value} onChange={setValue} enableSearch>
                <Option name="option-1" label="All Buildings" icon={<DashboardIcon />} />
                <Option name="option-2" label="New Building" icon={<AddFilledIcon />} />
                <Option name="header" label="Your Buildings" variant="header" />
                <Option name="option-3" label="Experimental" icon={<BuildingIcon />} />
                <Option name="option-4" label="Bennet Towers" icon={<BuildingIcon />} />
                <Option name="option-5" label="Empire State" icon={<BuildingIcon />} />
                <Option name="option-6" label="Central Park" icon={<BuildingIcon />} />
                <Option name="option-7" label="Chrysler" icon={<BuildingIcon />} />
                <Option name="option-8" label="Plaza" icon={<BuildingIcon />} />
            </InternalDropdown>
        </div>
    );
}

    <InternalDropdownWithSearch />
```

##### With search input and custom empty component:

```js
/* eslint-disable react/jsx-no-undef */
import React, { useState } from 'react';
import { Option } from 'react-rainbow-components';

const textStyle = { fontSize: '16px' };
const searchValueStyle = { fontFamily: 'Lato Bold' };

const CustomEmptyComponent = ({ searchValue }) => {
   return (
       <div className="rainbow-flex rainbow-justify_center rainbow-align_center rainbow-m-around_small">
           <h1 style={textStyle}>
               Sorry, but nothing matched your search terms:
               <span style={searchValueStyle}>“{searchValue}”</span>
           </h1>
       </div>
    )
}

function InternalDropdownWithSearch() {
    const [value, setValue] = useState();
    return (
        <div className="rainbow-m-around_xx-large">
            <InternalDropdown id="internal-dropdown-5" value={value} onChange={setValue} enableSearch emptyComponent={CustomEmptyComponent}>
                <Option name="option-1" label="All Buildings" icon={<DashboardIcon />} />
                <Option name="option-2" label="New Building" icon={<AddFilledIcon />} />
                <Option name="header" label="Your Buildings" variant="header" />
                <Option name="option-3" label="Experimental" icon={<BuildingIcon />} />
                <Option name="option-4" label="Bennet Towers" icon={<BuildingIcon />} />
                <Option name="option-5" label="Empire State" icon={<BuildingIcon />} />
                <Option name="option-6" label="Central Park" icon={<BuildingIcon />} />
                <Option name="option-7" label="Chrysler" icon={<BuildingIcon />} />
                <Option name="option-8" label="Plaza" icon={<BuildingIcon />} />
            </InternalDropdown>
        </div>
    );
}

    <InternalDropdownWithSearch />
```

##### With search input and custom search:

```js
/* eslint-disable no-undef, react/jsx-no-undef */
import React, { useState } from 'react';
import algoliasearch from 'algoliasearch/lite';
import { Option } from 'react-rainbow-components';

const client = algoliasearch(LIBRARY_ALGOLIA_APP_ID, LIBRARY_ALGOLIA_SEARCH_KEY);
const index = client.initIndex(LIBRARY_ALGOLIA_SEARCH_COMPONENTS_INDEX);

const search = async ({ query, page = 1 }) => {
    const result = await index.search(query, {
        page: page - 1,
    });
    const { hits } = result;
    return hits.map(hit => ({
        label: hit.text,
        name: hit.objectID,
    }));
};

function InternalDropdownWithAlgoliaSearch() {
    const [value, setValue] = useState();
    const [isLoading, setIsLoading] = useState();
    const [options, setOptions] = useState([]);
    const onSearch = async query => {
        if (!query) {
            setOptions([]);
            return;
        }
        setIsLoading(true);
        const result = await search({ query });
        setOptions(result);
        setIsLoading(false);
    };

    return (
        <div className="rainbow-m-around_xx-large">
            <InternalDropdown id="internal-dropdown-7" isLoading={isLoading} value={value} onChange={setValue} enableSearch onSearch={onSearch} debounce >
                {options.map(option => <Option key={option.name} name={option.name} label={option.label} />)}
            </InternalDropdown>
        </div>
    );
}

    <InternalDropdownWithAlgoliaSearch />

```

##### With multiple selection:

```js
/* eslint-disable react/jsx-no-undef */
import React, { useState } from 'react';
import { Option } from 'react-rainbow-components';

function InternalDropdownWithMultipleSelection() {
    const [value, setValue] = useState();
    return (
        <div className="rainbow-m-around_xx-large">
            <InternalDropdown value={value} onChange={setValue} enableSearch multiple>
                <Option name="option-1" label="All Buildings" icon={<DashboardIcon />} />
                <Option name="option-2" label="New Building" icon={<AddFilledIcon />} />
                <Option name="header" label="Your Buildings" variant="header" />
                <Option name="option-3" label="Experimental" icon={<BuildingIcon />} />
                <Option name="option-4" label="Bennet Towers" icon={<BuildingIcon />} />
                <Option name="option-5" label="Empire State" icon={<BuildingIcon />} />
                <Option name="option-6" label="Central Park" icon={<BuildingIcon />} />
                <Option name="option-7" label="Chrysler" icon={<BuildingIcon />} />
                <Option name="option-8" label="Plaza" icon={<BuildingIcon />} />
            </InternalDropdown>
        </div>
    );
}

    <InternalDropdownWithMultipleSelection />
```

##### With different border radius
:

```js
/* eslint-disable react/jsx-no-undef */
// eslint-disable arrow-parens
import React, { useState } from 'react';
import styled from 'styled-components'
import { Option } from 'react-rainbow-components';

const Title = styled.h2`
    font-size: 1rem;
    text-align: center;
    margin-bottom: 10px;
`

const InternalDropdownBorderRadius = props => {
    const { borderRadius } = props;
    const [value, setValue] = useState();
    return (
        <div className="rainbow-m-around_xx-large">
            <Title>Border radius {borderRadius}</Title>
            <InternalDropdown value={value} onChange={setValue} borderRadius={borderRadius}>
                <Option name="option-1" label="All Buildings" icon={<DashboardIcon />} />
                <Option name="option-2" label="New Building" icon={<AddFilledIcon />} />
                <Option name="header" label="Your Buildings" variant="header" />
                <Option name="option-3" label="Experimental" icon={<BuildingIcon />} />
                <Option name="option-4" label="Bennet Towers" icon={<BuildingIcon />} />
                <Option name="option-5" label="Empire State" icon={<BuildingIcon />} />
                <Option name="option-6" label="Central Park" icon={<BuildingIcon />} />
                <Option name="option-7" label="Chrysler" icon={<BuildingIcon />} />
                <Option name="option-8" label="Plaza" icon={<BuildingIcon />} />
            </InternalDropdown>
        </div>
    );
}

    <>
        <InternalDropdownBorderRadius borderRadius="square" />
        <InternalDropdownBorderRadius borderRadius="semi-square" />
        <InternalDropdownBorderRadius borderRadius="semi-rounded" />
        <InternalDropdownBorderRadius borderRadius="rounded" />
    </>
```
