import React from 'react';
import PropTypes from 'prop-types';

export default function Trash(props) {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            fill="#01b6f5"
            width="18px"
            height="20px"
            viewBox="0 0 18 20"
        >
            <g fill="currentColor" fillRule="nonzero">
                <path d="M17.24846,2.87474333 L13.0924025,2.87474333 L13.0924025,2.19712526 C13.0924025,0.985626283 12.1067762,0 10.8952772,0 L6.94455852,0 C5.73305955,0 4.74743326,0.985626283 4.74743326,2.19712526 L4.74743326,2.87474333 L0.59137577,2.87474333 C0.283367556,2.87474333 0.0369609856,3.1211499 0.0369609856,3.42915811 C0.0369609856,3.73716632 0.283367556,3.9835729 0.59137577,3.9835729 L1.59342916,3.9835729 L1.59342916,17.0102669 C1.59342916,18.6447639 2.92402464,19.9753593 4.55852156,19.9753593 L13.2813142,19.9753593 C14.9158111,19.9753593 16.2464066,18.6447639 16.2464066,17.0102669 L16.2464066,3.9835729 L17.24846,3.9835729 C17.5564682,3.9835729 17.8028747,3.73716632 17.8028747,3.42915811 C17.8028747,3.1211499 17.5564682,2.87474333 17.24846,2.87474333 Z M5.85626283,2.19712526 C5.85626283,1.59753593 6.3449692,1.10882957 6.94455852,1.10882957 L10.8952772,1.10882957 C11.4948665,1.10882957 11.9835729,1.59753593 11.9835729,2.19712526 L11.9835729,2.87474333 L5.85626283,2.87474333 L5.85626283,2.19712526 Z M15.137577,17.0102669 C15.137577,18.0328542 14.3039014,18.8665298 13.2813142,18.8665298 L4.55852156,18.8665298 C3.53593429,18.8665298 2.70225873,18.0328542 2.70225873,17.0102669 L2.70225873,3.9835729 L15.1416838,3.9835729 L15.1416838,17.0102669 L15.137577,17.0102669 Z" />
                <path d="M8.91991786,16.8788501 C9.22792608,16.8788501 9.47433265,16.6324435 9.47433265,16.3244353 L9.47433265,6.52566735 C9.47433265,6.21765914 9.22792608,5.97125257 8.91991786,5.97125257 C8.61190965,5.97125257 8.36550308,6.21765914 8.36550308,6.52566735 L8.36550308,16.3203285 C8.36550308,16.6283368 8.61190965,16.8788501 8.91991786,16.8788501 Z" />
                <path d="M5.30184805,16.2669405 C5.60985626,16.2669405 5.85626283,16.0205339 5.85626283,15.7125257 L5.85626283,7.13347023 C5.85626283,6.82546201 5.60985626,6.57905544 5.30184805,6.57905544 C4.99383984,6.57905544 4.74743326,6.82546201 4.74743326,7.13347023 L4.74743326,15.7125257 C4.74743326,16.0205339 4.99794661,16.2669405 5.30184805,16.2669405 Z" />
                <path d="M12.5379877,16.2669405 C12.8459959,16.2669405 13.0924025,16.0205339 13.0924025,15.7125257 L13.0924025,7.13347023 C13.0924025,6.82546201 12.8459959,6.57905544 12.5379877,6.57905544 C12.2299795,6.57905544 11.9835729,6.82546201 11.9835729,7.13347023 L11.9835729,15.7125257 C11.9835729,16.0205339 12.2299795,16.2669405 12.5379877,16.2669405 Z" />
            </g>
        </svg>
    );
}

Trash.propTypes = {
    style: PropTypes.object,
    className: PropTypes.string,
};

Trash.defaultProps = {
    style: undefined,
    className: undefined,
};
