import React from 'react';
import PropTypes from 'prop-types';

export default function CsvIcon(props) {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="64"
            height="64"
            viewBox="0 0 64 64"
            fill="none"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <g id="ImportRecordsFlow/Iconly/Regular/Bulk/Property 411">
                <g id="Paper">
                    <path
                        id="fill3"
                        opacity="0.4"
                        d="M50.1568 24.0547C48.9528 24.0547 47.358 24.028 45.3724 24.028C40.5299 24.028 36.5481 20.02 36.5481 15.132V6.55603C36.5481 5.88136 36.0095 5.33203 35.3414 5.33203H21.2363C14.6538 5.33203 9.33333 10.7347 9.33333 17.356V46.0894C9.33333 53.036 14.9073 58.6654 21.7855 58.6654H42.7901C49.3489 58.6654 54.6667 53.2974 54.6667 46.6707V25.2547C54.6667 24.5774 54.1307 24.0307 53.46 24.0334C52.3325 24.0414 50.9806 24.0547 50.1568 24.0547Z"
                        fill="currentColor"
                    />
                    <path
                        id="fill1"
                        opacity="0.4"
                        d="M42.8907 6.84632C42.0933 6.01699 40.7013 6.58765 40.7013 7.73699V14.769C40.7013 17.7183 43.1307 20.145 46.08 20.145C47.9387 20.1663 50.52 20.1717 52.712 20.1663C53.8347 20.1637 54.4053 18.8223 53.6267 18.0117C50.8133 15.0863 45.776 9.84365 42.8907 6.84632Z"
                        fill="currentColor"
                    />
                </g>
                <path
                    id="vector"
                    d="M26.6504 33.3404C26.7492 33.4532 26.8056 33.5942 26.8056 33.7494C26.8056 34.0455 26.5658 34.3134 26.2548 34.3134C26.1138 34.3134 25.9587 34.257 25.86 34.1301C25.31 33.4673 24.3785 33.0435 23.5043 33.0435C21.4447 33.0435 19.8794 34.6237 19.8794 36.8666C19.8794 39.0954 21.4454 40.6888 23.5043 40.6888C24.3926 40.6888 25.2669 40.3081 25.86 39.6164C25.9579 39.5035 26.1138 39.4338 26.2548 39.4338C26.5799 39.4338 26.8056 39.7151 26.8056 40.012C26.8056 40.153 26.7492 40.294 26.6504 40.4068C25.9164 41.1683 24.9152 41.7331 23.505 41.7331C20.7968 41.7331 18.6667 39.7582 18.6667 36.8666C18.6667 33.975 20.7968 32 23.505 32C24.9152 32.0008 25.9305 32.5648 26.6504 33.3404ZM31.9792 41.7339C30.5832 41.7339 29.4825 41.2686 28.6787 40.5627C28.5518 40.4499 28.4954 40.2948 28.4954 40.1397C28.4954 39.8569 28.7069 39.5466 29.0453 39.5466C29.1582 39.5466 29.2851 39.5748 29.3838 39.6594C30.0324 40.2384 30.9349 40.6888 32.0215 40.6888C33.7004 40.6888 34.2362 39.7864 34.2362 39.0664C34.2362 36.6402 28.6646 37.9806 28.6646 34.6229C28.6646 33.0717 30.0465 32.0133 31.8946 32.0133C33.1073 32.0133 34.1516 32.3792 34.9131 33.0145C35.04 33.1273 35.1105 33.2824 35.1105 33.4376C35.1105 33.7196 34.8708 34.0016 34.5598 34.0016C34.447 34.0016 34.3201 33.9593 34.2214 33.8747C33.5304 33.3107 32.6702 33.0568 31.8092 33.0568C30.6811 33.0568 29.8765 33.6632 29.8765 34.5524C29.8765 36.6684 35.4482 35.4549 35.4482 38.9677C35.449 40.3371 34.5183 41.7339 31.9792 41.7339ZM45.2926 32.9174L42.0344 41.014C41.8792 41.3947 41.4977 41.6485 41.1037 41.6485H41.0755C40.6665 41.6485 40.2858 41.3947 40.1299 41.014L36.885 32.9174C36.8568 32.8469 36.8427 32.7764 36.8427 32.6918C36.8427 32.4097 37.0957 32.0705 37.4772 32.0705C37.717 32.0705 37.9426 32.2115 38.0413 32.4512L41.088 40.2791L44.1347 32.4512C44.2193 32.2256 44.4449 32.0705 44.6987 32.0705C45.0654 32.0705 45.3333 32.3666 45.3333 32.6918C45.3341 32.7623 45.32 32.8469 45.2926 32.9174Z"
                    fill="currentColor"
                />
            </g>
        </svg>
    );
}

CsvIcon.propTypes = {
    style: PropTypes.object,
    className: PropTypes.string,
};

CsvIcon.defaultProps = {
    style: undefined,
    className: undefined,
};
