import React from 'react';
import PropTypes from 'prop-types';

export default function CalendarIcon(props) {
    const { className, style } = props;

    return (
        <svg className={className} style={style} width="21px" height="21px" viewBox="0 0 21 21">
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="Components-DateTimePicker"
                    transform="translate(-814.000000, -438.000000)"
                    fillRule="nonzero"
                >
                    <g id="date-time" transform="translate(814.000000, 438.000000)">
                        <g id="calendar">
                            <path
                                d="M15.6521739,4.34485394 L15.6521739,13.871314 C15.6521739,14.8548292 14.8548292,15.6520545 13.8710752,15.6520545 L1.7808599,15.6520545 C0.797344698,15.6520545 0.00011941661,14.8548292 0.00011941661,13.871314 L0.00011941661,4.34485394"
                                id="Shape"
                                fill="#E3E5ED"
                            />
                            <path
                                d="M14.6644791,6.53507398 L0.98757538,6.53507398 C0.442199715,6.53507398 0,6.0929937 0,5.54749863 L0,3.49807075 C0,2.95269512 0.442199715,2.5104954 0.98757538,2.5104954 L14.6644791,2.5104954 C15.2099742,2.5104954 15.6520545,2.95269512 15.6520545,3.49807075 L15.6520545,5.54749863 C15.6520545,6.0929937 15.2099742,6.53507398 14.6644791,6.53507398 Z"
                                id="Shape"
                                fill="#EA4243"
                            />
                            <path
                                d="M14.6644791,5.51298724 L0.98757538,5.51298724 C0.442199715,5.51298724 0,5.07090693 0,4.52541185 L0,2.47598401 C0,1.93060834 0.442199715,1.48840863 0.98757538,1.48840863 L14.6644791,1.48840863 C15.2099742,1.48840863 15.6520545,1.93060834 15.6520545,2.47598401 L15.6520545,4.52541185 C15.6520545,5.07090693 15.2099742,5.51298724 14.6644791,5.51298724 Z"
                                id="Shape"
                                fill="#FE4849"
                            />
                            <path
                                d="M4.5660135,0.934315557 L4.5660135,2.71004056 C4.5660135,2.96809985 4.46128514,3.20167874 4.29231063,3.37089207 C4.12333612,3.53986658 3.88951841,3.64435612 3.63169794,3.64435612 C3.11545993,3.64435612 2.69738239,3.22627855 2.69738239,2.71004056 L2.69738239,0.934315557 C2.69738239,0.418435802 3.11545993,0 3.63169794,0 C4.1475777,0 4.5660135,0.418435802 4.5660135,0.934315557 Z"
                                id="Shape"
                                fill="#000000"
                            />
                            <path
                                d="M12.9549109,0.934315557 L12.9549109,2.71004056 C12.9549109,2.96809985 12.8501826,3.20167874 12.6812081,3.37089207 C12.5122336,3.53986658 12.2782964,3.64435612 12.0205954,3.64435612 C11.5043574,3.64435612 11.0862798,3.22627855 11.0862798,2.71004056 L11.0862798,0.934315557 C11.0862798,0.418435802 11.5043574,0 12.0205954,0 C12.5364751,0 12.9549109,0.418435802 12.9549109,0.934315557 Z"
                                id="Shape"
                                fill="#000000"
                            />
                            <path
                                d="M4.5660135,0.934315557 L4.5660135,2.34147314 C4.5660135,2.59917417 4.46128514,2.83299188 4.29231063,3.00196639 C4.12333612,3.1709409 3.88951841,3.2757887 3.63169794,3.2757887 C3.11545993,3.2757887 2.69738239,2.85735289 2.69738239,2.34147314 L2.69738239,0.934315557 C2.69738239,0.418435802 3.11545993,0 3.63169794,0 C4.1475777,0 4.5660135,0.418435802 4.5660135,0.934315557 Z"
                                id="Shape"
                                fill="#061C3F"
                            />
                            <path
                                d="M12.9549109,0.934315557 L12.9549109,2.34147314 C12.9549109,2.59917417 12.8501826,2.83299188 12.6812081,3.00196639 C12.5122336,3.1709409 12.2782964,3.2757887 12.0205954,3.2757887 C11.5043574,3.2757887 11.0862798,2.85735289 11.0862798,2.34147314 L11.0862798,0.934315557 C11.0862798,0.418435802 11.5043574,0 12.0205954,0 C12.5364751,0 12.9549109,0.418435802 12.9549109,0.934315557 Z"
                                id="Shape"
                                fill="#061C3F"
                            />
                            <g
                                id="Group-68"
                                transform="translate(1.956522, 8.217391)"
                                fill="#061C3F"
                                fillOpacity="0.203096694"
                            >
                                <path
                                    d="M5.55626144,1.95770194 C5.55626144,2.18652424 5.37320359,2.36958208 5.14438129,2.36958208 L3.5985595,2.36958208 C3.3697372,2.36958208 3.18667935,2.18652424 3.18667935,1.95770194 L3.18667935,0.411880147 C3.18667935,0.183057843 3.3697372,0 3.5985595,0 L5.14438129,0 C5.37320359,0 5.55626144,0.183057843 5.55626144,0.411880147 L5.55626144,1.95770194 Z"
                                    id="Path"
                                />
                                <path
                                    d="M8.76088643,0.411880147 C8.76088643,0.183057843 8.57782859,0 8.34900628,0 L6.8031845,0 C6.57436219,0 6.39130435,0.183057843 6.39130435,0.411880147 L6.39130435,1.95770194 C6.39130435,2.18652424 6.57436219,2.36958208 6.8031845,2.36958208 L8.34900628,2.36958208 C8.57782859,2.36958208 8.76088643,2.18652424 8.76088643,1.95770194 L8.76088643,0.411880147 Z"
                                    id="Path-Copy-6"
                                />
                                <path
                                    d="M5.55626144,3.55770464 C5.55626144,3.32888233 5.37320359,3.14582449 5.14438129,3.14582449 L3.5985595,3.14582449 C3.3697372,3.14582449 3.18667935,3.32888233 3.18667935,3.55770464 L3.18667935,5.10352642 C3.18667935,5.33234873 3.3697372,5.51540657 3.5985595,5.51540657 L5.14438129,5.51540657 C5.37320359,5.51540657 5.55626144,5.33234873 5.55626144,5.10352642 L5.55626144,3.55770464 Z"
                                    id="Path"
                                />
                                <path
                                    d="M2.36958208,3.55770464 C2.36958208,3.32888233 2.18652424,3.14582449 1.95770194,3.14582449 L0.411880147,3.14582449 C0.183057843,3.14582449 0,3.32888233 0,3.55770464 L0,5.10352642 C0,5.33234873 0.183057843,5.51540657 0.411880147,5.51540657 L1.95770194,5.51540657 C2.18652424,5.51540657 2.36958208,5.33234873 2.36958208,5.10352642 L2.36958208,3.55770464 L2.36958208,3.55770464 Z"
                                    id="Path"
                                />
                            </g>
                        </g>
                        <g id="clock" transform="translate(7.000000, 7.000000)">
                            <circle id="Oval" cx="7" cy="7" r="7" />
                            <circle id="Oval" fill="#FFFFFF" cx="7" cy="7" r="6.77307422" />
                            <circle id="Oval" fill="#B5BCC9" cx="7" cy="7" r="6.108375" />
                            <path
                                d="M7.04413281,7 L6.95589453,7 C6.79169531,7 6.65853125,6.86689062 6.65853125,6.70263672 L6.65853125,3.08598828 C6.65853125,2.92178906 6.79164062,2.788625 6.95589453,2.788625 L7.04413281,2.788625 C7.20833203,2.788625 7.34149609,2.92173437 7.34149609,3.08598828 L7.34149609,6.70269141 C7.34144141,6.86689062 7.20833203,7 7.04413281,7 Z"
                                id="Path"
                                fill="#FFFFFF"
                            />
                            <path
                                d="M7.04413281,7 L7.10653125,7.06239844 C7.22263281,7.1785 7.22263281,7.36678906 7.10653125,7.48291797 L5.01831641,9.57113281 C4.90221484,9.68723437 4.71392578,9.68723437 4.59779687,9.57113281 L4.53539844,9.50873437 C4.41929687,9.39263281 4.41929687,9.20434375 4.53539844,9.08821484 L6.62361328,7 C6.73971484,6.88389844 6.92797656,6.88389844 7.04413281,7 Z"
                                id="Path"
                                fill="#FFFFFF"
                            />
                            <path
                                d="M11.1500703,5.98978516 L11.1500703,5.98978516 C11.1667773,6.05759766 11.1253242,6.12612109 11.0575117,6.14282812 L7.06321875,7.12646484 C6.99540625,7.14317188 6.92688281,7.10171875 6.91017578,7.03390625 L6.91017578,7.03390625 C6.89346875,6.96609375 6.93492188,6.89757031 7.00273438,6.88086328 L10.9970273,5.89722656 C11.0648398,5.88051953 11.1333633,5.92194531 11.1500703,5.98978516 Z"
                                id="Path"
                                fill="#061C3F"
                            />
                            <circle id="Oval" fill="#061C3F" cx="7" cy="7" r="1" />
                            <path
                                d="M7.02179297,2.42817969 L6.97820703,2.42817969 C6.80164844,2.42817969 6.65853125,2.2850625 6.65853125,2.10850391 L6.65853125,1.71081641 C6.65853125,1.53425781 6.80164844,1.39114063 6.97820703,1.39114063 L7.02179297,1.39114063 C7.19835156,1.39114063 7.34146875,1.53425781 7.34146875,1.71081641 L7.34146875,2.10850391 C7.34144141,2.2850625 7.19832422,2.42817969 7.02179297,2.42817969 Z"
                                id="Path"
                                fill="#FFFFFF"
                            />
                            <path
                                d="M7.02179297,12.6088594 L6.97820703,12.6088594 C6.80164844,12.6088594 6.65853125,12.4657422 6.65853125,12.2891836 L6.65853125,11.8915234 C6.65853125,11.7149648 6.80164844,11.5718477 6.97820703,11.5718477 L7.02179297,11.5718477 C7.19835156,11.5718477 7.34146875,11.7149648 7.34146875,11.8915234 L7.34146875,12.2892109 C7.34144141,12.4657148 7.19832422,12.6088594 7.02179297,12.6088594 Z"
                                id="Path"
                                fill="#FFFFFF"
                            />
                            <path
                                d="M11.5718203,7.02179297 L11.5718203,6.97820703 C11.5718203,6.80164844 11.7149375,6.65853125 11.8914961,6.65853125 L12.2891836,6.65853125 C12.4657422,6.65853125 12.6088594,6.80164844 12.6088594,6.97820703 L12.6088594,7.02179297 C12.6088594,7.19835156 12.4657422,7.34146875 12.2891836,7.34146875 L11.8914961,7.34146875 C11.7149375,7.34144141 11.5718203,7.19832422 11.5718203,7.02179297 Z"
                                id="Path"
                                fill="#FFFFFF"
                            />
                            <path
                                d="M1.39114063,7.02179297 L1.39114063,6.97820703 C1.39114063,6.80164844 1.53425781,6.65853125 1.71081641,6.65853125 L2.10847656,6.65853125 C2.28503516,6.65853125 2.42815234,6.80164844 2.42815234,6.97820703 L2.42815234,7.02179297 C2.42815234,7.19835156 2.28503516,7.34146875 2.10847656,7.34146875 L1.71081641,7.34146875 C1.53428516,7.34144141 1.39114063,7.19832422 1.39114063,7.02179297 Z"
                                id="Path"
                                fill="#FFFFFF"
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
}

CalendarIcon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

CalendarIcon.defaultProps = {
    className: undefined,
    style: undefined,
};
