import React from 'react';
import PropTypes from 'prop-types';

const PuzzleIcon = props => {
    const { className } = props;
    return (
        <svg className={className} width="18px" height="18px" viewBox="0 0 18 18" version="1.1">
            <g id="re-design-layout" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="re-design-layout-componentes-V2"
                    transform="translate(-34.000000, -187.000000)"
                >
                    <g id="Group-27" transform="translate(27.000000, 180.000000)">
                        <g id="puzzle" transform="translate(7.000000, 7.000000)">
                            <path
                                d="M16.0379287,8.36169505 C16.1047248,7.99453069 16.0366812,7.6156396 15.8461663,7.29456238 C15.7521386,7.15195248 15.7914178,6.9601901 15.9340277,6.86616238 C15.9875287,6.83091089 16.0509386,6.81294653 16.1152752,6.81512079 L17.9123881,6.81512079 L17.9123881,1.86611881 C17.9123881,0.841045545 17.0815723,0.010229703 16.056499,0.010229703 L11.135299,0.010229703 L11.135299,1.81044356 C11.1365465,1.98117624 11.2760554,2.11883168 11.4467881,2.11758416 C11.4978297,2.11726337 11.5482297,2.10428911 11.593105,2.07955248 C11.9191366,1.88126733 12.3076158,1.81293861 12.6818733,1.8877901 C13.5222772,2.03966733 14.080598,2.84417822 13.9287208,3.68490297 C13.7768436,4.52530693 12.9723327,5.08362772 12.1316079,4.9317505 C11.9562416,4.89988515 11.7876475,4.83832871 11.6333109,4.74893465 C11.4854614,4.66324752 11.2961584,4.71368317 11.2107921,4.86153267 C11.181101,4.91257426 11.1668792,4.9713505 11.1693386,5.03041188 L11.135299,6.81515644 L12.8922059,6.81515644 C13.0626535,6.80588911 13.2086495,6.93641584 13.2179168,7.10714851 C13.221303,7.16717228 13.206796,7.2271604 13.1767842,7.27912871 C13.0400554,7.51391287 12.968305,7.78084752 12.9695525,8.05241584 C12.9695525,8.90643564 13.6621069,9.5989901 14.5164119,9.59866931 C15.2640356,9.59866931 15.9046218,9.06355248 16.0379287,8.32769109 L16.0379287,8.36169505 Z"
                                fill="#5C56B6"
                            />
                            <path
                                d="M1.88372673,17.9792434 L6.80489109,17.9792434 L1.66719208,17.9792434 C1.73926337,17.9931434 1.81165545,17.9931434 1.88372673,17.9792434 Z"
                                fill="#FFA83D"
                            />
                            <path
                                d="M6.83287005,13.0014178 C6.85027005,12.9633861 6.85027005,12.9250337 6.83287005,12.8869663 L6.83287005,12.9240713 C6.84157005,12.9497347 6.84157005,12.9757188 6.83287005,13.0014178 Z"
                                fill="#FFA83D"
                            />
                            <path
                                d="M9.56705347,7.40901386 C9.54477624,7.31127921 9.51291089,7.21568317 9.47117228,7.12443564 C9.26825347,6.6586099 8.84976238,6.32238416 8.35146535,6.22432871 C7.98430099,6.15503762 7.60448317,6.22340198 7.28433267,6.41609109 C7.14172277,6.51011881 6.9499604,6.4708396 6.85593267,6.3282297 C6.82068119,6.27472871 6.80271683,6.21131881 6.80489109,6.14698218 L6.80489109,4.34060198 L1.85588911,4.34060198 C0.830815842,4.34060198 0,5.17141782 0,6.19649109 L0,7.12443564 L0,11.1455287 L1.85588911,11.1455287 L1.92083168,11.1455287 C1.96321188,11.1306653 2.0021703,11.1077822 2.03528317,11.0774851 L2.05385347,11.0589149 C2.12809901,10.9429307 2.12809901,10.7944396 2.05385347,10.6784554 C1.99197624,10.5748396 1.94435644,10.4634891 1.91156436,10.347505 C1.72721584,9.8689901 1.8249505,9.32738614 2.16520396,8.9432198 C2.38327129,8.64784158 2.70064158,8.44150099 3.05910891,8.36169505 C3.12622574,8.34683168 3.1945901,8.33756436 3.2632396,8.33385743 C4.12777426,8.25868515 4.8896198,8.89866535 4.96475644,9.7632 C4.96906931,9.81146139 4.97095842,9.86000792 4.97063762,9.90826931 C4.97188515,10.1798376 4.90009901,10.4467723 4.76340594,10.6815564 C4.67771881,10.8294059 4.72815446,11.0187089 4.87600396,11.104396 C4.92829307,11.1346931 4.9879604,11.1489505 5.04798416,11.1455287 L5.95425743,11.1455287 L6.80485545,11.1455287 L6.80485545,9.2896396 C6.80485545,9.05146931 7.08013069,8.96485545 7.28739802,9.08550891 C7.52218218,9.22223762 7.78911683,9.29398812 8.06068515,9.29274059 C8.91470495,9.29120792 9.60601188,8.59740594 9.60415842,7.74306535 C9.60419406,7.63078812 9.59150495,7.51883168 9.56705347,7.40901386 Z"
                                fill="#01B6F5"
                            />
                            <path
                                d="M11.8219723,11.1455287 C11.6512396,11.1467762 11.5135842,11.2862851 11.5148317,11.4570178 C11.5151525,11.5080594 11.5281267,11.5584594 11.5528634,11.6033347 C11.9905307,12.3370218 11.7505069,13.2863168 11.0168198,13.7236634 C10.876099,13.807497 10.7229743,13.8687327 10.5630416,13.9046257 C10.3437267,13.9510337 10.1173188,13.9510337 9.89800396,13.9046257 C9.0631604,13.7236634 8.53331881,12.900297 8.71424554,12.0654535 C8.74764356,11.910796 8.80488713,11.7623406 8.88344554,11.6250059 C8.9784,11.4830376 8.94036832,11.2909545 8.7984,11.196 C8.75726733,11.1684832 8.70993267,11.1511604 8.66074455,11.1455644 L6.80485545,11.1455644 L6.80485545,12.8777347 C6.81226931,12.9185465 6.81226931,12.9606416 6.80485545,13.0014535 C6.75413465,13.1876554 6.56173069,13.2974733 6.37552871,13.2464317 C6.35727921,13.2414772 6.3393505,13.2349901 6.32231287,13.2272554 C6.0881703,13.0889941 5.82091485,13.0172436 5.54902574,13.0200238 C4.70334653,13.0249782 4.02194851,13.7144317 4.02690297,14.5601109 C4.03185743,15.4057901 4.72131089,16.0871881 5.5669901,16.0822337 C5.8444396,16.080701 6.11600792,16.0036752 6.35325149,15.8595327 C6.50327525,15.7775525 6.6910099,15.8326218 6.7729901,15.9823248 C6.79804752,16.0280911 6.81102178,16.0794535 6.81102178,16.1317069 L6.8048198,17.9504554 L11.7538218,17.9504554 C12.778895,17.9504554 13.6097109,17.1196396 13.6097109,16.0945663 L13.6097109,11.1455287 L11.8219723,11.1455287 Z"
                                fill="#F8752D"
                            />
                            <polygon
                                fill="#FFA83D"
                                points="6.83706931 11.1810738 6.83706931 11.1810738 6.83706931 11.1897738"
                            />
                            <path
                                d="M6.35328713,15.8594614 C5.63877624,16.3277465 4.68021386,16.1279287 4.21189307,15.4137386 C3.74360792,14.6995485 3.94342574,13.7406653 4.65761584,13.2723446 C4.9217703,13.0991168 5.23293861,13.0109703 5.54874059,13.0199525 C5.8206297,13.0171723 6.08788515,13.0889228 6.32202772,13.2271842 C6.49771485,13.307596 6.70494653,13.2302851 6.78539406,13.054598 C6.79312871,13.0372752 6.79961584,13.0196317 6.8045703,13.0013822 C6.80767129,12.9757188 6.80767129,12.9497347 6.8045703,12.9240713 L6.8045703,11.1455287 L5.95397228,11.1455287 L5.04769901,11.1455287 C4.87725149,11.154796 4.73125545,11.0242693 4.72198812,10.8535366 C4.71860198,10.7935129 4.73310891,10.7335248 4.76312079,10.6815564 C4.8998495,10.4467723 4.9716,10.1798376 4.97035248,9.90826931 C4.97003168,9.04034851 4.26667723,8.33695842 3.39872079,8.33727921 C3.3532396,8.33727921 3.30807921,8.33913267 3.26291881,8.3431604 C3.19423366,8.34686733 3.12590495,8.35613465 3.05878812,8.37099802 C2.70926733,8.44830891 2.39809901,8.64659406 2.18035248,8.93085149 C1.84009901,9.31469703 1.74236436,9.85630099 1.92671287,10.3351366 C1.95950495,10.4511208 2.00712475,10.5624713 2.06900198,10.6660871 C2.14324752,10.7820713 2.14324752,10.9305624 2.06900198,11.0465465 L2.05043168,11.0651168 C2.01731881,11.0954139 1.9783604,11.1183327 1.9359802,11.1331604 L1.85585347,11.1455287 L0,11.1455287 L0,16.0945307 C0.0117623762,17.043505 0.72470495,17.8372158 1.66719208,17.9504198 L6.80489109,17.9504198 L6.80489109,16.1316713 C6.80364356,15.9609386 6.6638495,15.823604 6.49311683,15.8248158 C6.44453465,15.8251366 6.39659406,15.8371842 6.35328713,15.8594614 Z"
                                fill="#FFCC00"
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

PuzzleIcon.propTypes = {
    className: PropTypes.string,
};

PuzzleIcon.defaultProps = {
    className: undefined,
};

export default PuzzleIcon;
