import React from 'react';
import PropTypes from 'prop-types';

const DesignIcon = props => {
    const { className } = props;
    return (
        <svg className={className} width="25px" height="26px" viewBox="0 0 25 26" version="1.1">
            <g id="design">
                <g
                    id="Group-74"
                    transform="translate(16.671466, 16.589692) rotate(146.000000) translate(-16.671466, -16.589692) translate(14.171466, 7.089692)"
                >
                    <polygon
                        fill="#576574"
                        points="2.18762025 0.0240833604 0.00787509845 2.978783 1.46108178 5.93361462 2.91415869 5.93361462 4.36736537 2.978783"
                    />
                    <path
                        d="M2.19766773,6.30355762 C1.98598232,6.30355762 1.81441584,6.13822376 1.81441584,5.93422844 L1.81441584,3.71812121 C1.81441584,3.51412589 1.98598232,3.34879199 2.19766773,3.34879199 C2.4093531,3.34879199 2.58091962,3.51412589 2.58091962,3.71812121 L2.58091962,5.93422844 C2.58091962,6.13822376 2.4093531,6.30355762 2.19766773,6.30355762 Z"
                        fill="#A4A7B5"
                    />
                    <path
                        d="M2.89788518,3.29458585 C2.89788518,3.70924638 2.57619802,4.0453199 2.1792879,4.0453199 C1.78237778,4.0453199 1.46069059,3.70924638 1.46069059,3.29458585 C1.46069059,2.87992532 1.78237778,2.5437177 2.1792879,2.5437177 C2.57619802,2.5437177 2.89788518,2.87992532 2.89788518,3.29458585 Z"
                        fill="#A4A7B5"
                    />
                    <polygon
                        fill="#FF6837"
                        points="0.712880267 8.18533494 1.08412239 8.55898644 3.31170769 8.55898644 3.61956559 8.14201626 2.94046557 5.94329228 1.45549713 5.94329228"
                    />
                    <path
                        d="M0.717200806,8.1289949 L3.61975509,8.1289949 L3.73530946,16.6717345 C3.73530946,17.4913233 3.08555933,18.1558225 2.28403233,18.1558225 C1.48250533,18.1558225 0.832755169,17.4913233 0.832755169,16.6717345 L0.717200806,8.1289949 Z"
                        fill="#FFB900"
                    />
                </g>
                <path
                    d="M10.5861838,0 C11.1145736,0 11.5443135,0.434514749 11.5443135,0.968775617 L11.5443135,3.92579044 C11.5439911,3.92579044 11.5439911,3.92546441 11.5436687,3.92546441 C11.2274085,3.88569641 10.9076021,3.86516043 10.5861838,3.86516043 C10.264443,3.86516043 9.9443142,3.88569641 9.62805404,3.92546441 L9.62805404,0.968775617 C9.62805404,0.434514749 10.0577939,0 10.5861838,0 Z"
                    fill="#576574"
                />
                <g id="Group-75" transform="translate(0.000000, 8.137037)">
                    <path
                        d="M0.0749786405,13.9075161 C-0.0794315654,14.1778066 0.0123252896,14.5234842 0.279713746,14.6795703 L2.29879951,15.7012967 C2.56618796,15.8573828 2.90815414,15.7648344 3.06256439,15.4945439 L10.8607532,1.59697778 C9.90599659,1.25130018 8.78979139,0.548957241 7.9047619,-5.1159077e-13 L0.0749786405,13.9075161 Z"
                        fill="#01B6F5"
                    />
                    <g
                        id="Group"
                        transform="translate(5.764408, 8.727005) rotate(30.000000) translate(-5.764408, -8.727005) translate(4.764408, 2.708486)"
                        fill="#000000"
                        fillOpacity="0.130463089"
                    >
                        <polygon points="0.0094401599 0.010233727 1.86867616 0.010233727 1.86867616 0.585077499 0.0094401599 0.585077499" />
                        <polygon points="0.00445643452 1.88353396 1.86369244 1.88353396 1.86369244 2.45837773 0.00445643452 2.45837773" />
                        <polygon points="0.0952380952 7.07777778 1.9544741 7.07777778 1.9544741 7.65262155 0.0952380952 7.65262155" />
                        <polygon points="0.0952380952 9.33626319 1.9544741 9.33626319 1.9544741 9.91110697 0.0952380952 9.91110697" />
                        <polygon points="0.0952380952 11.4592593 1.9544741 11.4592593 1.9544741 12.034103 0.0952380952 12.034103" />
                    </g>
                </g>
                <path
                    d="M9.40239669,11.1007277 C9.77327349,11.2169429 10.167588,11.2795057 10.57634,11.2795057 C10.9700919,11.2795057 11.3503438,11.2213033 11.7094081,11.1132403 C12.6651003,10.8252618 13.4694793,10.1825711 13.9732942,9.33626692 C14.331796,8.73376814 14.538047,8.02813546 14.538047,7.27377964 C14.538047,5.06152081 12.7642883,3.26805362 10.57634,3.26805362 C8.38839168,3.26805362 6.61463292,5.06152081 6.61463292,7.27377964 C6.61463292,8.01088328 6.81150887,8.70134921 7.15501057,9.294748 C7.65001301,10.1493938 8.44914198,10.8021325 9.40239669,11.1007277 Z M10.57634,5.64354454 C11.4667819,5.64354454 12.1886604,6.37344396 12.1886604,7.27377964 C12.1886604,8.17411537 11.4667819,8.90401478 10.57634,8.90401478 C9.68589809,8.90401478 8.9640195,8.17411537 8.9640195,7.27377964 C8.9640195,6.37344396 9.68589809,5.64354454 10.57634,5.64354454 Z"
                    id="Shape"
                    fill="#FF6837"
                    fillRule="nonzero"
                />
                <path
                    d="M3.46376639,12.2042494 C3.49238361,12.2172704 3.52100082,12.2310146 3.54961804,12.2462055 C3.52100082,12.2310146 3.49238361,12.2172704 3.46376639,12.2042494 Z"
                    fill="#FBB868"
                />
                <path
                    d="M3.63351748,12.3106098 C3.5745581,12.2628667 3.51308996,12.2209107 3.4503673,12.1840183 C3.51308996,12.2209107 3.5745581,12.2628667 3.63351748,12.3106098 Z"
                    fill="#FBB868"
                />
                <g id="Group-76" transform="translate(1.579764, 12.061256)">
                    <path
                        d="M17.5029302,3.00310963 L17.767119,2.7951357 C17.9598699,2.64327866 18.0095577,2.36951898 17.8824321,2.15832213 L17.3285543,1.23770091 C14.8593546,3.12046226 11.9274027,4.29474725 8.99601316,4.29474725 C6.06406119,4.29474725 3.13323421,3.12103102 0.664222018,1.23826963 L0.109969281,2.15794293 C-0.0171563227,2.36876064 0.0321564328,2.6427099 0.224719848,2.79456694 L0.478221099,2.99476792 C0.895410647,3.32388622 1.3262878,3.62570437 1.76860249,3.90003277 C2.58966906,4.40944572 3.45048577,4.82463529 4.33624015,5.14522226 C5.84131009,5.69027704 7.41856788,5.96270962 8.99601316,5.96270962 C10.5593959,5.96270962 12.1231536,5.69482706 13.616786,5.15906194 C14.5038529,4.84112914 15.3659821,4.42840414 16.1887362,3.92145583 C16.6394884,3.64371484 17.0784281,3.33753628 17.5029302,3.00310963 Z"
                        fill="#FF6837"
                    />
                    <path
                        d="M8.99601316,4.29474725 C11.9274027,4.29474725 14.8593546,3.12065188 17.3285543,1.23770091 L16.7529265,0.281248239 C16.6091133,0.0421824878 16.2959867,-0.02511994 16.0683606,0.133751702 L16.057673,0.141145501 C15.5885457,0.510834802 15.0982308,0.83862604 14.5917908,1.12489826 C13.7439116,1.60397772 12.8504697,1.96627323 11.9337777,2.21178487 C9.99595558,2.73048743 7.95388303,2.72669574 6.01756096,2.200789 C5.10236895,1.95205444 4.21061455,1.58672554 3.36479786,1.10480231 C2.8677329,0.821563431 2.38641801,0.498132644 1.92535327,0.134320467 C1.90772816,0.121807881 1.88935309,0.110812018 1.870603,0.101143208 C1.86310296,0.0971619502 1.85560292,0.093559837 1.84810289,0.0901472958 C1.84041531,0.0867348033 1.83272779,0.0835118828 1.82504026,0.0804785345 C1.81735274,0.0774451862 1.80966521,0.07460141 1.80179015,0.0721368266 C1.78622756,0.0668284671 1.77047748,0.0626575889 1.7547274,0.0590555242 C1.7466649,0.0573492294 1.73878984,0.0558325552 1.73072728,0.0545055017 C1.72285227,0.0531783997 1.71478972,0.0520408698 1.70691465,0.0510929606 C1.65891442,0.0455950289 1.6105392,0.0474908474 1.56366399,0.0564013201 C1.55578893,0.0577284222 1.54791387,0.0594346685 1.54022634,0.0613304869 C1.51697623,0.0670180392 1.49410114,0.0744118379 1.47197601,0.0833223107 C1.46447597,0.086355659 1.45716347,0.0895785794 1.44985092,0.092991072 C1.36641297,0.131855884 1.29272512,0.195556198 1.2411624,0.28143786 L0.664222018,1.23845925 C3.13323421,3.12103102 6.06406119,4.29474725 8.99601316,4.29474725 Z"
                        fill="#FF7B50"
                    />
                </g>
                <path
                    d="M3.41639779,12.1899756 C3.44644596,12.1993795 3.47577856,12.2102302 3.50511116,12.2218043 C3.47577856,12.2102302 3.44644596,12.1993795 3.41639779,12.1899756 Z"
                    fill="#FBB868"
                />
                <path
                    d="M3.33536007,12.1702218 C3.39617161,12.1839659 3.45626776,12.1998804 3.51564853,12.220135 C3.45626776,12.1998804 3.39617161,12.1839659 3.33536007,12.1702218 Z"
                    fill="#FBB868"
                />
                <path
                    d="M3.32027895,12.175871 C3.3510425,12.1794879 3.38180606,12.1838282 3.41185404,12.1888919 C3.38180606,12.1838282 3.3510425,12.1794879 3.32027895,12.175871 Z"
                    fill="#FBB868"
                />
                <path
                    d="M10.57634,9.38935051 C9.42264679,9.38935051 8.48401713,8.44029169 8.48401713,7.27377964 C8.48401713,6.10726764 9.42264679,5.15820881 10.57634,5.15820881 C11.7300332,5.15820881 12.6686628,6.10726764 12.6686628,7.27377964 C12.6686628,8.44029169 11.7300332,9.38935051 10.57634,9.38935051 Z M10.57634,6.12888027 C9.95196191,6.12888027 9.44402187,6.64246405 9.44402187,7.27377964 C9.44402187,7.90509528 9.95196191,8.41867906 10.57634,8.41867906 C11.200718,8.41867906 11.7086581,7.90509528 11.7086581,7.27377964 C11.7086581,6.64246405 11.200718,6.12888027 10.57634,6.12888027 Z"
                    id="Shape"
                    fill="#576574"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

DesignIcon.propTypes = {
    className: PropTypes.string,
};

DesignIcon.defaultProps = {
    className: undefined,
};

export default DesignIcon;
