import React from 'react';
import PropTypes from 'prop-types';

const CustomWorkIcon = props => {
    const { className } = props;
    return (
        <svg className={className} width="24px" height="22px" viewBox="0 0 24 22" version="1.1">
            <g id="pages" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="react-rainbow-custom-work"
                    transform="translate(-31.000000, -530.000000)"
                    fillRule="nonzero"
                >
                    <g id="Group-13" transform="translate(13.500000, 530.000000)">
                        <g id="custom" transform="translate(18.500000, 0.000000)">
                            <g id="Group-215">
                                <path
                                    d="M12.0959274,5.94786169 C12.9666214,5.07716773 13.0802237,3.71428274 12.1716623,2.80572133 C10.3923641,1.02642309 9.37024321,1.21571744 7.36382606,1.21571744 C10.3923641,-0.109257223 12.5880756,-0.412111024 14.7837871,0.610009834 C15.7302159,1.02642309 16.1088046,1.40501178 16.8659391,2.16214629 L18.2287812,3.52498839 C18.5695025,3.86570964 18.7966214,4.31999034 18.8723563,4.77427104 C18.9859157,5.4935381 18.7966214,5.644965 19.2887695,6.17498059 C19.4401964,6.32640749 19.6673582,6.32640749 19.8187851,6.17498059 C19.970212,6.02355369 20.1973738,6.02355369 20.3488007,6.17498059 L21.6738183,7.5 C21.9766721,7.80285194 21.9766721,8.25713264 21.6738183,8.55998644 L18.9859586,11.2478461 C18.6831048,11.5506999 18.2288241,11.5506999 17.9259703,11.2478461 L16.6766877,9.96069599 C16.5252608,9.80926909 16.5252608,9.5821073 16.6766877,9.4306804 C16.8281146,9.2792535 16.8281146,9.01426714 16.6766877,8.86284024 C16.1466721,8.33282465 15.9952452,8.522119 15.2759781,8.44642699 C14.78383,8.37069209 14.3674167,8.14357319 14.0266955,7.80285194 L12.0959274,5.94786169"
                                    id="Path"
                                    fill="#7F7C79"
                                />
                                <path
                                    d="M12.0959274,5.94786169 L0.360235412,19.0843061 C-0.0940452894,19.5385868 -0.131912736,20.2957213 0.322367966,20.7121775 L0.85238356,21.2421931 C1.30666426,21.6964738 2.0259742,21.6586063 2.48025491,21.2043256 L14.2538144,8.03005662 L12.0959274,5.94786169 Z"
                                    id="Path"
                                    fill="#565656"
                                />
                            </g>
                            <g id="maintenance-copy">
                                <polygon
                                    id="Path"
                                    fill="#E0E0E0"
                                    points="15.9963633 15.0848242 4.13251953 3.22098047 4.94952734 2.40397266 1.89964844 4.296875e-05 4.296875e-05 1.89960547 2.40401563 4.94952734 3.22102344 4.13247656 15.0848672 15.9963203"
                                />
                                <polygon
                                    id="Path"
                                    fill="#C3C7CB"
                                    points="15.5405937 15.5405937 0.949824219 0.949824219 4.296875e-05 1.89960547 2.40401563 4.94952734 3.22102344 4.13247656 15.0848672 15.9963203"
                                />
                                <polygon
                                    id="Path"
                                    fill="#9E9E9E"
                                    points="13.0813633 16.1975 15.3036211 18.4197148 16.2689141 18.4066523 18.4215625 16.2540039 18.4197578 15.3035781 16.1975 13.0813633"
                                />
                                <polygon
                                    id="Path"
                                    fill="#898D91"
                                    points="13.0813633 16.1975 15.3036211 18.4197148 16.2689141 18.4066523 17.3378047 17.3377617 14.6394531 14.6394102"
                                />
                                <path
                                    d="M15.3036211,18.4197148 L18.2383438,21.3544375 C18.6688906,21.7849844 19.2328125,22.0000859 19.7967344,22.0000859 C20.3606563,22.0000859 20.9245781,21.7849844 21.3547813,21.3547383 C22.2152305,20.4942891 22.2152305,19.0990508 21.3544805,18.2383008 L18.4197578,15.3035781 L15.3036211,18.4197148 Z"
                                    id="Path"
                                    fill="#BC342E"
                                />
                                <path
                                    d="M15.3036211,18.4197148 L18.2383437,21.3544375 C18.6688906,21.7849844 19.2328125,22.0000859 19.7967344,22.0000859 C20.3606562,22.0000859 20.9245781,21.7849844 21.3547812,21.3547383 L16.861668,16.861668 L15.3036211,18.4197148 Z"
                                    id="Path"
                                    fill="#BC342E"
                                />
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

CustomWorkIcon.propTypes = {
    className: PropTypes.string,
};

CustomWorkIcon.defaultProps = {
    className: undefined,
};

export default CustomWorkIcon;
