import React from 'react';
import PropTypes from 'prop-types';

const TypeScript = props => {
    const { className } = props;
    return (
        <svg
            className={className}
            width="174px"
            height="100px"
            viewBox="0 0 174 100"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <g id="pages" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="getting-started-(overview)"
                    transform="translate(-983.000000, -601.000000)"
                    fillRule="nonzero"
                >
                    <g id="typescript" transform="translate(983.000000, 601.000000)">
                        <g id="Group-133">
                            <path
                                d="M22.4986217,0.015124082 C29.6882107,0.015124082 36.8777998,0.024554288 44.0673888,1.77058297e-05 C44.6992126,1.77058297e-05 44.8425518,0.160349254 44.8425518,0.78274285 C44.8211766,15.210958 44.8211766,29.6391732 44.8425518,44.0673884 C44.8425518,44.7010982 44.6822383,44.8425513 44.0598447,44.8425513 C29.6316295,44.8236909 15.2034143,44.8236909 0.775199138,44.8425513 C0.141489295,44.8425513 -0.0018498364,44.6841239 1.7927693e-05,44.0617303 C0.0188966168,29.6335151 0.0188966168,15.2046712 1.7927693e-05,0.775198685 C1.7927693e-05,0.143374884 0.158463666,-0.0018502888 0.780857261,1.77058297e-05 C8.02136943,0.024554288 15.2599956,0.015124082 22.4986217,0.015124082 Z M34.3599348,41.1930616 C34.992996,41.2213529 35.6270407,41.166825 36.245976,41.030862 C38.5092254,40.525403 40.3481156,39.4861943 41.0459508,37.1003522 C41.8588346,34.3203275 40.8573467,31.7458812 38.4243536,30.1861252 C37.2154012,29.4109622 35.8932863,28.8658963 34.5881458,28.2774515 C33.9902707,28.0096336 33.3848515,27.755018 32.8756204,27.3344309 C32.239302,26.8374584 32.0040065,25.9821169 32.2966057,25.2296089 C32.5700817,24.4751924 33.1660707,24.1753118 33.9280313,24.1168446 C34.965354,24.0395169 35.8310469,24.365802 36.3798849,25.2616716 C36.7231444,25.8180537 37.024911,25.7991933 37.5001934,25.4389595 C38.1023777,24.9846427 38.7322779,24.5682787 39.3862346,24.1922862 C39.9746794,23.8527988 40.0256025,23.5642345 39.6106735,22.990878 C38.0641197,20.8634235 35.9102606,20.2806368 33.4433188,20.4239759 C30.9763769,20.567315 28.8583526,22.0497434 28.2755659,24.2526395 C27.6060212,26.789365 28.1661755,29.0262098 30.2596812,30.6651796 C31.0482853,31.2467438 31.9013944,31.7353196 32.8020647,32.1212034 C33.8016666,32.5889416 34.8106986,33.0359334 35.7989842,33.5319622 C36.6873096,33.977068 37.1908826,34.6749032 37.0135947,35.7235421 C36.8476231,36.7231439 36.1158391,37.1267568 35.23883,37.3247911 C33.2773471,37.7661247 31.7213631,37.0777197 30.5859663,35.4783568 C30.2257325,34.9691256 29.976775,34.9861 29.518467,35.2897526 C28.8250876,35.7450309 28.1038323,36.1563669 27.3589498,36.5213375 C26.7459865,36.817446 26.8044537,37.0984661 27.1345109,37.6001531 C28.8583526,40.2085481 31.395078,41.1251641 34.3599348,41.1930616 Z M15.646634,32.6436368 C15.646634,35.1822483 15.6617223,37.7227458 15.6334317,40.2613572 C15.6334317,40.7951069 15.784315,40.9516483 16.3086345,40.9271298 C17.1881021,40.8780229 18.0696245,40.8780229 18.9490921,40.9271298 C19.6205228,40.9705087 19.8279873,40.7894488 19.8223292,40.0784112 C19.7883805,35.1520716 19.8015828,30.2219599 19.8072409,25.2937343 C19.8072409,24.2054885 19.6676738,24.3620299 20.7823242,24.3507137 C21.8139887,24.3412835 22.8456533,24.3507137 23.8754317,24.3507137 C25.6596267,24.3507137 25.6596267,24.3507137 25.6445384,22.5382281 C25.6294501,20.6672752 25.6294501,20.6521869 23.7584972,20.6521869 C19.3828816,20.6521869 15.007266,20.6653892 10.6335365,20.6352125 C9.95833374,20.6352125 9.75841337,20.8238166 9.80933648,21.482045 C9.86780024,22.2095129 9.86780024,22.9404989 9.80933648,23.6679668 C9.76029941,24.2696139 9.9979406,24.3695741 10.5354623,24.3563718 C12.0178907,24.3224231 13.5022052,24.3676881 14.9846335,24.3337393 C15.5221553,24.320537 15.6617223,24.4940528 15.6579502,25.0146002 C15.6334317,27.5645279 15.646634,30.1087975 15.646634,32.6436368 Z"
                                id="Shape"
                                fill="#017ACB"
                            />
                            <path
                                d="M34.3599348,41.1930616 C31.395078,41.1251641 28.8583526,40.2085481 27.1345109,37.6095833 C26.8044537,37.1078964 26.7459865,36.8268762 27.3589498,36.5307677 C28.1020944,36.1631451 28.8214586,35.7492903 29.5128089,35.2916387 C29.9711169,34.9955302 30.2200743,34.9785558 30.5803082,35.4802428 C31.7119329,37.0796057 33.271689,37.7680108 35.2331719,37.3266771 C36.110181,37.1286428 36.841965,36.72503 37.0079366,35.7254282 C37.1852245,34.6767892 36.6816515,33.978954 35.7933261,33.5338483 C34.8050405,33.0378194 33.7960085,32.5908277 32.7964066,32.1230895 C31.896091,31.7395821 31.0429965,31.253546 30.2540231,30.6746098 C28.1605174,29.0299819 27.6003631,26.793137 28.2699077,24.2620697 C28.8526945,22.0591736 30.9631746,20.5767452 33.4376606,20.4334061 C35.9121467,20.290067 38.0584616,20.8728537 39.6050154,23.0003082 C40.0199444,23.5661205 39.9690213,23.862229 39.3805765,24.2017164 C38.7266198,24.5777089 38.0967196,24.9940729 37.4945353,25.4483897 C37.0192529,25.8086235 36.7174863,25.8255979 36.3742268,25.2711018 C35.8197307,24.3752322 34.9540378,24.0489471 33.9223732,24.1262748 C33.1679567,24.1847421 32.5644236,24.4789645 32.2909476,25.2390391 C31.9983483,25.9915471 32.2336439,26.8468886 32.8699622,27.3438611 C33.3791934,27.7625622 33.9846126,28.0171778 34.5824876,28.2868817 C35.8876281,28.8696684 37.209743,29.4185064 38.4186954,30.1955554 C40.8535746,31.7553114 41.8531765,34.3297577 41.0402927,37.1097824 C40.3424575,39.4956245 38.4960231,40.5348332 36.2403179,41.0402923 C35.6228089,41.1726001 34.9907028,41.2239548 34.3599348,41.1930616 L34.3599348,41.1930616 Z"
                                id="Path"
                                fill="#FEFEFE"
                            />
                            <path
                                d="M15.646634,32.6436368 C15.646634,30.1031393 15.6334317,27.5645279 15.6579502,25.0240304 C15.6579502,24.503483 15.5221553,24.3299672 14.9846335,24.3431695 C13.5022052,24.3771183 12.0178907,24.3318533 10.5354623,24.365802 C9.99982664,24.3790043 9.76029941,24.2790441 9.80933648,23.677397 C9.86780024,22.9499291 9.86780024,22.2189431 9.80933648,21.4914752 C9.75841337,20.8351329 9.95833374,20.6389846 10.6335365,20.6445244 C15.007266,20.6748194 19.3828816,20.655959 23.7584972,20.6616171 C25.6219059,20.6616171 25.6219059,20.6616171 25.6445384,22.5476583 C25.6596267,24.3601439 25.6596267,24.3601439 23.8754317,24.3601439 C22.8456533,24.3601439 21.8139887,24.3601439 20.7823242,24.3601439 C19.6676738,24.3695741 19.8072409,24.2130327 19.8072409,25.3031645 C19.8072409,30.2313901 19.7883805,35.1615018 19.8223292,40.0878414 C19.8223292,40.798879 19.6205228,40.9799389 18.9490921,40.93656 C18.0696245,40.8874531 17.1881021,40.8874531 16.3086345,40.93656 C15.784315,40.9610785 15.6277736,40.8045371 15.6334317,40.2707874 C15.6617223,37.7227458 15.646634,35.1822483 15.646634,32.6436368 Z"
                                id="Path"
                                fill="#FEFEFE"
                            />
                        </g>
                        <path
                            d="M38.1047503,68.4884279 C36.2593637,73.0644877 34.4563712,77.6580039 32.6359223,82.2440388 C31.2061634,85.8450363 29.7764045,89.4460338 28.3466455,93.0470313 C27.6932789,94.6904229 26.8852989,96.2465326 25.6932789,97.5707221 C23.8877927,99.5806972 21.628441,100.194164 19.0149747,99.7427919 C18.5835533,99.667979 18.3715832,99.5407969 18.3990146,99.0595002 C18.4364211,98.3313206 18.149638,97.4535151 18.4763213,96.9048867 C18.8852989,96.1916698 19.7232041,96.944787 20.3940271,96.9223431 C21.8584785,96.9348999 23.2101495,96.1377114 23.9077428,94.8500239 C24.8279423,93.273964 25.3815582,91.5233406 26.1296879,89.8624927 C26.3541268,89.3637396 26.022456,88.9572558 25.862855,88.5432907 C23.2676763,81.8716365 20.6658475,75.2049698 18.0573687,68.5432907 C17.9551243,68.273964 17.8603612,68.0021436 17.7232041,67.625585 C18.9501368,67.625585 20.0698375,67.6455351 21.1870445,67.625585 C21.7830545,67.6106224 21.7805607,68.0844378 21.8977677,68.4210962 C23.9609431,74.2964079 26.0199622,80.1841885 28.0748251,86.0844378 C28.458865,85.6305725 28.416471,85.0121186 28.6109847,84.4834403 C30.6059971,79.075294 32.5918658,73.6654852 34.5685907,68.2540139 C34.745648,67.7552608 35.0025059,67.5906722 35.5112341,67.6230912 C36.17539,67.6705927 36.8420906,67.6705927 37.5062465,67.6230912 C38.2768201,67.5632408 38.3965208,67.7677296 38.1047503,68.4884279 Z M60.1596131,73.0669815 C61.5162195,76.9080159 61.308424,81.1284129 59.5810595,84.8176049 C57.6871827,88.9086762 53.1185404,91.0370566 48.7680919,89.8550114 C47.1920321,89.4410463 46.2593637,88.7552608 44.2793139,86.508378 L44.2793139,87.5732159 C44.2793139,91.3313206 44.2593637,95.0869316 44.2967702,98.8450363 C44.2967702,99.5532658 44.1047503,99.7702234 43.4114834,99.710373 C42.5586156,99.6380538 41.4339273,99.9747121 40.9177178,99.5457845 C40.4015084,99.1168568 40.7481418,97.9273306 40.7481418,97.0744628 C40.7331792,87.6330663 40.7481418,78.1916698 40.7182166,68.7502732 C40.7182166,67.9323181 40.8877927,67.6106224 41.7381667,67.7228418 C42.5511343,67.8300737 43.6259473,67.3811959 44.1346755,67.8899241 C44.6434036,68.3986523 44.2394136,69.4684777 44.2867952,70.2889266 C44.2818076,70.6081286 44.266845,70.9373057 44.266845,71.2664827 C45.6010096,69.593166 47.0623563,68.1692259 49.1271942,67.5806972 C53.1546256,66.4161087 58.2194635,67.3737146 60.1596131,73.0669815 Z M153.765598,67.391171 C157.538665,68.0545126 159.685798,70.5208468 160.461359,74.1393007 C161.319214,78.1293256 161.137169,82.0794503 158.965099,85.6979042 C156.79303,89.316358 152.87283,90.9348119 148.882805,89.8924179 C146.675823,89.306383 145.137169,87.8824428 143.810486,85.9821934 L143.810486,90.1293256 C143.810486,92.954762 143.780561,95.7777047 143.830436,98.6081286 C143.845399,99.4310712 143.715723,99.7502732 142.775573,99.7378044 C141.890286,99.7378044 141.778067,99.4310712 141.790536,98.6604977 C141.817967,91.1517695 141.807992,83.6455351 141.807992,76.1368069 L141.807992,70.9472807 C141.807992,67.8099888 141.807992,67.7251971 142.703816,67.7229055 L142.780561,67.7228418 C143.753268,67.7228418 143.807307,67.7228418 143.810309,70.4013629 L143.810486,71.9921685 C144.134675,72.0395501 144.132182,71.7702234 144.219463,71.6305725 C146.326695,68.23157 149.705748,66.6704727 153.765598,67.391171 Z M98.4239523,58.9921685 C99.2069947,59.189176 99.543653,59.5457845 99.4040021,60.358752 C99.3734815,60.7480134 99.3734815,61.1390668 99.4040021,61.5283281 C96.5960221,60.4909216 93.8927802,59.9323181 91.0773188,60.7303231 C88.9775682,61.3288269 87.4638525,62.6156099 87.0124809,64.8026423 C86.5311842,67.1268318 87.1571193,69.1393007 89.1247004,70.6280787 C90.6882914,71.8151111 92.3940271,72.7752109 94.0848001,73.7577545 C95.446565,74.5187211 96.7413159,75.3938459 97.9551243,76.3737146 C100.498765,78.4909216 101.311733,81.2091261 100.498765,84.3338144 C99.703254,87.3712209 97.5586156,89.1717196 94.5461468,89.8475301 C91.3042515,90.5732159 88.149638,90.1343131 85.1172191,88.7777047 C84.7406605,88.6081286 84.5137278,88.4285775 84.5536281,87.9747121 C84.5935283,87.5208468 84.5536281,87.1118693 84.5536281,86.6804478 C84.5536281,86.5557595 84.5810595,86.4310712 84.6059971,86.199151 C86.0823064,86.9996498 87.5261967,87.7328169 89.1421567,87.9846872 C91.0324311,88.2789515 92.9177178,88.2914204 94.7581168,87.6954104 C96.5770635,87.1054195 97.965554,85.6226391 98.4349374,83.7689036 C98.9043209,81.9151681 98.3888135,79.9502774 97.0698375,78.5657346 C95.9401617,77.3712209 94.5261967,76.550772 93.1346755,75.7078792 C91.3466455,74.625585 89.5386655,73.5782034 87.8678425,72.3113705 C85.1596131,70.2590014 84.0000121,67.5582533 84.8927802,64.2689765 C85.7855483,60.9796997 88.2419074,59.2016448 91.5212091,58.5707221 C93.8528799,58.1243381 96.1421567,58.4186024 98.4239523,58.9921685 Z M118.987543,67.8849366 C119.423952,68.0395501 119.523703,68.2914204 119.501259,68.7053855 C119.476321,69.2041386 119.501259,69.7028917 119.501259,70.2964079 C118.082306,69.5757097 116.670835,69.0220937 115.129688,68.9323181 C110.092281,68.6480289 106.234426,72.0345625 105.758117,77.199151 C105.586047,79.0595002 105.62096,80.9173555 106.177069,82.7253356 C107.738167,87.8001486 112.992531,89.8475301 118.029937,87.3462832 C118.433927,87.1442882 118.830436,86.9223431 119.251882,86.6979042 C119.354127,88.9198493 119.710735,88.6181037 117.630935,89.3637396 C111.059862,91.7228418 104.062356,88.5333156 103.596022,79.8874303 C103.364102,75.6056348 104.566097,71.8350613 108.114725,69.1642383 C111.44889,66.6704727 115.149638,66.5407969 118.987543,67.8849366 Z M76.8503862,67.6754603 C80.3715832,68.9223431 81.8753238,71.6979042 82.3740769,75.1692259 C82.5237029,76.2191012 82.4713338,77.2939141 82.576072,78.3512707 C82.6633538,79.2191012 82.4339273,79.5283281 81.4738276,79.5158593 C77.0199622,79.4560089 72.5660969,79.5158593 68.1122316,79.4734653 C67.384052,79.4734653 67.097269,79.5582533 67.1770695,80.4210962 C67.6508849,85.6305725 71.735673,88.263989 77.0848001,86.7727171 C78.5087403,86.3762084 79.7631044,85.6604977 81.1197129,84.6954104 L81.1192106,86.4509465 C81.1116763,88.2421198 80.9911281,88.3419191 79.0623563,89.0619939 C76.2861923,90.1424629 73.2442888,90.3401474 70.3516331,89.6280787 C68.259522,89.1220479 66.45498,87.8038618 65.3366705,85.9647371 C62.7980171,81.9747121 62.9177178,75.2714702 65.6010096,71.3811959 C68.1446505,67.6954104 72.6259473,66.1941635 76.8503862,67.6754603 Z M167.211982,61.4360588 C167.433927,61.593166 167.314227,61.8624927 167.314227,62.0769565 C167.314227,63.7053855 167.346646,65.3338144 167.314227,66.9622433 C167.299264,67.5707221 167.463853,67.7627421 168.087294,67.7402982 C169.513728,67.6929166 170.947643,67.7801984 172.371583,67.7053855 C173.229439,67.6604977 173.052381,68.1767072 173.06485,68.6505226 C173.077319,69.1243381 173.179563,69.6205974 172.354127,69.5757097 C170.927693,69.5033904 169.496271,69.5757097 168.067344,69.5457845 C167.541159,69.5457845 167.319214,69.6380538 167.319214,70.2390513 C167.349139,74.9572558 167.344152,79.6754603 167.354127,84.3936648 C167.354127,84.7253356 167.376571,85.0570064 167.40899,85.391171 C167.64091,87.6954104 169.19702,88.7876797 171.451384,88.2166074 C171.937668,88.0794503 172.418965,87.8599989 172.990037,87.6505226 C173.137169,89.5383032 173.122207,89.5582533 171.413977,89.8949116 C167.798017,90.593166 165.461359,88.6754603 165.406496,84.8250862 C165.341658,80.1093755 165.356621,75.391171 165.406496,70.6729665 C165.406496,69.7378044 165.234426,69.3462832 164.241907,69.4909216 C163.655872,69.5782034 163.042406,69.4510214 162.451384,69.5208468 C161.603503,69.6205974 161.401508,69.2889266 161.413977,68.4784528 C161.413977,67.7477795 161.663354,67.5732159 162.33667,67.6181037 C163.129688,67.6704727 163.93268,67.6006473 164.725698,67.6405476 C165.249389,67.667979 165.406496,67.4984029 165.394027,66.9747121 C165.361608,65.4784528 165.376571,63.9821934 165.394027,62.4859341 C165.394027,62.0520189 166.875324,61.1966573 167.211982,61.4360588 Z M136.000012,67.7178543 C136.591035,67.7303231 137.047394,67.6031411 137.039912,68.5283281 C136.995025,75.2764578 136.995025,82.0237562 137.039912,88.7702234 C137.039912,89.710373 136.598516,89.6455351 135.960112,89.667979 C135.321708,89.6904229 134.962606,89.6056348 134.98505,88.7826922 C135.042406,85.4285775 135.009987,82.0694752 135.009987,78.7128668 C135.009987,75.3238393 135.049887,71.9323181 134.98505,68.5432907 C134.967593,67.6430413 135.40899,67.7053855 136.000012,67.7178543 Z M20.3790645,58.8126174 C21.0848001,58.8126174 21.3541268,58.9323181 21.3441518,59.7228418 C21.3067453,62.1368069 21.3441518,62.1368069 18.9152241,62.1368069 C17.0872939,62.1368069 15.25687,62.1792009 13.4289398,62.1193505 C12.6808101,62.0944129 12.5037528,62.2964079 12.5062465,63.0420438 C12.5361717,71.5208468 12.5062465,79.9996498 12.5486405,88.4784528 C12.5486405,89.348777 12.3566206,89.6704727 11.46884,89.5557595 C10.6558725,89.4485276 9.57607196,89.8924179 9.07233131,89.3936648 C8.56859067,88.8949116 8.93018668,87.8200987 8.92769291,86.997156 C8.91273032,83.263989 8.92270538,79.550772 8.92270538,75.8101236 C8.92270538,71.5208468 8.91023655,67.2340638 8.93766797,62.944787 C8.93766797,62.3138643 8.7980171,62.0994004 8.12719416,62.1118693 C5.70325401,62.1542633 3.27432633,62.1118693 0.850386176,62.1417944 C0.224451014,62.1592508 1.13686838e-13,62.0270812 1.13686838e-13,61.3462832 L0.000701681957,60.8086083 C0.0110687987,58.82758 0.169204515,58.82758 2.52869042,58.82758 C8.4788151,58.82758 14.4289398,58.8525176 20.3790645,58.8126174 Z M131.304252,67.2964079 C132.321708,67.4061336 132.820461,67.7677296 132.630935,68.837555 C132.610553,69.0906782 132.610553,69.3450304 132.630935,69.5981535 C131.783055,69.2889266 131.019962,68.954762 130.182057,68.9946623 C128.583553,69.0694752 127.341658,69.8051361 126.384052,71.0595002 C124.977568,72.8974054 124.38904,75.029575 124.321708,77.2939141 C124.224451,81.0744628 124.21697,84.8624927 124.25687,88.6455351 C124.25687,89.550772 123.880311,89.5407969 123.209488,89.5707221 C122.478815,89.6056348 122.27682,89.4186024 122.279291,88.6530164 C122.315889,81.948112 122.315889,75.2415451 122.279291,68.5333156 C122.279291,67.7602483 122.496271,67.5956598 123.221957,67.6106224 C123.947643,67.625585 124.314227,67.710373 124.246895,68.5732159 C124.152132,69.6754603 124.21697,70.8001486 124.21697,71.9173555 C124.83293,71.0071311 125.271833,70.0919191 125.962606,69.3188518 C127.38904,67.6979042 129.154626,67.0744628 131.304252,67.2964079 Z M144.259364,74.5782034 C143.486296,77.2365575 143.541159,79.9996498 144.119713,82.6704727 C144.837917,85.9946623 147.483803,88.1118693 150.820461,88.3886772 C153.795523,88.6380538 156.306745,86.9697246 157.70076,83.8051361 C158.521209,81.9722184 158.815473,80.0171062 158.81298,77.7402982 C158.828816,76.9298998 158.754375,76.1202575 158.591035,75.3263331 C158.022456,71.9023929 155.847892,69.5383032 152.89278,69.0919191 C148.81298,68.4959092 145.411483,70.5881785 144.259364,74.5782034 Z M44.6708351,74.6979042 C44.2219572,76.0794503 44.2543762,77.5033904 44.2693388,78.9298244 L44.266845,78.9298244 L44.266845,80.6205974 C44.3142266,83.8824428 46.3566206,86.5058842 49.2543762,87.0470313 C52.4189647,87.6380538 55.2169697,86.0794503 56.46884,82.9298244 C57.5155706,80.285044 57.6688269,77.3705464 56.905249,74.6305725 C56.3516331,72.5283281 55.1122316,70.954762 52.9152241,70.306383 C49.4239523,69.273964 45.8852989,71.1717196 44.6708351,74.6979042 Z M73.6334286,70.1243381 C70.0399124,70.0794503 67.9102366,72.944787 67.2643513,76.1093755 C67.1571193,76.63556 67.5361717,76.5158593 67.8030046,76.5158593 C69.5611094,76.5208468 71.3217079,76.5158593 73.0673438,76.5158593 L78.3391642,76.5158593 C78.6309348,76.5158593 78.9650994,76.6654852 79.0149747,76.0919191 C79.1707801,74.5686142 78.6745358,73.0505354 77.6490536,71.9133812 C76.6235715,70.776227 75.1646796,70.1262608 73.6334286,70.1243381 Z M135.910237,58.9397994 C136.922705,58.9273306 137.628441,59.5333156 137.64091,60.4360588 C137.631863,61.3364425 136.926419,62.0756867 136.027444,62.1268345 C135.123625,62.1284182 134.384457,61.406981 134.364102,60.5033904 C134.334177,59.6006473 134.962606,58.954762 135.910237,58.9397994 Z"
                            id="Combined-Shape"
                            fill="#017ACB"
                        />
                        <g id="Group-5" transform="translate(123.000000, 0.000000)">
                            <path
                                d="M0,11 C0,4.92486775 4.92817249,0 10.991074,0 L38.1815451,0 C44.1522361,0 49.0109701,4.76342789 49.1686683,10.7021035 L49.172619,11 C49.172619,17.0751322 44.2444466,22 38.1815451,22 L10.991074,22 C5.02038296,22 0.161648924,17.2365721 0.00395076211,11.2978965 L0,11 Z"
                                id="Path"
                                fill="#FFB900"
                            />
                            <path
                                d="M8.9375,15.8125 L12.1325784,15.8125 C12.6349885,15.8125 13.0823824,15.7502178 13.4747605,15.6256533 C13.8671385,15.5010889 14.1982725,15.3266986 14.468162,15.1024826 C14.7380519,14.8782666 14.9435833,14.6094149 15.0847561,14.2959277 C15.2259289,13.9824404 15.2965157,13.6346981 15.2965157,13.2527003 C15.2965157,12.7046167 15.1314678,12.2592988 14.801372,11.9167465 C14.4712761,11.5741943 13.9844366,11.3385599 13.3408537,11.2098432 C13.6190477,11.1226481 13.8619484,11.0095019 14.0695557,10.8704051 C14.2771634,10.7313082 14.4494774,10.5756026 14.5864983,10.4032883 C14.7235192,10.230974 14.8262848,10.0441273 14.8947953,9.84274826 C14.9633057,9.64138096 14.997561,9.43273549 14.997561,9.21681185 C14.997561,8.85557491 14.9363165,8.52963099 14.8138284,8.23898084 C14.6913403,7.94833068 14.5013795,7.70231587 14.243946,7.50093641 C13.9865129,7.29955695 13.658493,7.14488992 13.2598868,7.0369338 C12.8612805,6.92897768 12.3837833,6.875 11.8273955,6.875 L8.9375,6.875 L8.9375,15.8125 Z M10.2205139,11.7641551 L12.1138937,11.7641551 C12.7574766,11.7641551 13.2370498,11.8949477 13.5526132,12.1565331 C13.8681767,12.4181185 14.0259582,12.7731272 14.0259582,13.2215592 C14.0259582,13.4499273 13.989627,13.659611 13.9169643,13.8506098 C13.8443244,14.0416085 13.7311782,14.2066564 13.5775261,14.3457535 C13.4239071,14.4848504 13.22668,14.5938443 12.9858449,14.6727352 C12.7450202,14.751626 12.4543697,14.7910714 12.1138937,14.7910714 L10.2205139,14.7910714 L10.2205139,11.7641551 Z M10.2205139,10.8548345 L10.2205139,7.88397213 L11.8273955,7.88397213 C12.4709784,7.88397213 12.9474374,8.00334615 13.2567726,8.24209495 C13.5661079,8.48084375 13.7207753,8.85765124 13.7207753,9.37251742 C13.7207753,9.59673345 13.68133,9.80018886 13.602439,9.98288328 C13.5235697,10.1655777 13.4041953,10.3212833 13.2443162,10.45 C13.0844584,10.5787167 12.8820411,10.6783683 12.6370645,10.7489547 C12.3920878,10.8195411 12.1035132,10.8548345 11.7713415,10.8548345 L10.2205139,10.8548345 Z M23.2935526,6.875 L17.7628906,6.875 L17.7628906,15.8125 L23.2935526,15.8125 L23.2997808,14.7661585 L19.0521327,14.7661585 L19.0521327,11.8077526 L22.4714272,11.8077526 L22.4714272,10.7987805 L19.0521327,10.7987805 L19.0521327,7.92134146 L23.2935526,7.92134146 L23.2935526,6.875 Z M31.776391,6.875 L24.7696402,6.875 L24.7696402,7.95248258 L27.6346227,7.95248258 L27.6346227,15.8125 L28.9176367,15.8125 L28.9176367,7.95248258 L31.776391,7.95248258 L31.776391,6.875 Z M40.2841425,15.8125 L36.7153707,6.875 L35.4136721,6.875 L31.8511286,15.8125 L32.8476442,15.8125 C32.9555979,15.8125 33.0479832,15.7813589 33.1248002,15.7190767 C33.2016149,15.6567944 33.2524787,15.5862079 33.2773916,15.5073171 L34.0808324,13.4084059 L38.0482104,13.4084059 L38.8516512,15.5073171 C38.8890205,15.5986643 38.9429982,15.672365 39.013585,15.728419 C39.0841718,15.784473 39.1755188,15.8125 39.2876268,15.8125 L40.2841425,15.8125 Z M37.6932017,12.4866289 L34.4358411,12.4866289 L35.7873655,8.97391115 C35.8329778,8.86180314 35.8786513,8.73101045 35.9243864,8.5815331 L36.0614073,8.09573171 L36.0614073,8.09573171 C36.1070808,8.27012195 36.1537925,8.43101797 36.2015423,8.57841899 L36.2489461,8.71993794 L36.2489461,8.71993794 L37.6932017,12.4866289 Z"
                                id="BETA"
                                fill="#FFFFFF"
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

TypeScript.propTypes = {
    className: PropTypes.string,
};

TypeScript.defaultProps = {
    className: undefined,
};

export default TypeScript;
