import React from 'react';
import PropTypes from 'prop-types';

const PageObject = (props) => {
    const { className } = props;
    return (
        <svg className={className} fill="#01B6F5" width="100px" height="100px" viewBox="0 0 100 100" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
            <defs>
                <polygon id="path-1" points="0 0.107439926 83.4060706 0.107439926 83.4060706 74.6964202 0 74.6964202" />
                <polygon id="path-3" points="0.0870622537 0.170308123 39.7016542 0.170308123 39.7016542 22.2325505 0.0870622537 22.2325505" />
            </defs>
            <g id="get-started" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="getting-started---overview" transform="translate(-869.000000, -504.000000)">
                    <g id="Group-28" transform="translate(280.000000, 504.000000)">
                        <g id="Group-27" transform="translate(589.000000, 0.000000)">
                            <g id="webdrive-io">
                                <g id="Group-39" transform="translate(0.307692, 0.000000)">
                                    <g id="Group-3" transform="translate(0.000000, 24.068886)">
                                        <g id="Fill-1-Clipped">
                                            <g id="path-11" />
                                            <path d="M71.3064694,50.280933 C71.2787327,50.9326333 71.745963,51.2148202 72.1246146,51.4993527 C72.2622247,51.602737 72.5757397,51.5083741 72.7872549,51.4381881 C72.8305601,51.4237541 72.7817076,51.1132401 72.766855,50.9400307 C72.7494971,50.7361489 72.64535,50.4990685 72.7156762,50.3365043 C72.885139,49.9438964 73.1222436,49.5785328 73.3550534,49.2173191 C73.5470634,48.9196156 73.807968,48.6626883 73.9720623,48.3523548 C74.1468934,48.0223548 73.979936,47.6544653 73.6680315,47.5315949 C73.0964752,47.3060619 72.5852239,47.4543725 72.4019823,47.8785549 C72.1729303,48.4084674 71.924731,48.9298999 71.6845842,49.4549407 C71.5586057,49.7302715 71.4324481,50.0056022 71.3064694,50.280933 M12.1587968,50.2820156 C12.0324603,50.0061436 11.9113133,49.7275651 11.7783557,49.4547604 C11.5645142,49.0163241 11.2527887,48.6029672 11.1459574,48.1408951 C10.9911684,47.471513 10.6798008,47.3156244 9.84107671,47.5200477 C9.40802524,47.6254167 9.26719404,48.1378278 9.54098278,48.4992219 C9.74695066,48.7709441 10.0135815,49.0060398 10.1732021,49.3013979 C10.4507488,49.815072 10.9793579,50.2636121 10.6730008,50.9710641 C10.6137694,51.1078274 10.6159167,51.4084178 10.6774745,51.4362035 C10.8650108,51.521004 11.1679679,51.6101346 11.295736,51.5168541 C11.6908507,51.227811 12.1799125,50.9542844 12.1587968,50.2820156 M51.4444386,68.1166277 C51.4190282,68.7022919 51.6275013,69.0259769 52.0199318,69.1789785 C52.6625301,69.4299517 53.3201599,69.6439374 53.9774318,69.8546756 C54.4289148,69.9995579 54.6871351,69.7511107 54.6509879,69.2827237 C54.5717145,68.2544735 54.0329054,67.4497715 53.3885177,66.7224726 C53.2063497,66.5167864 52.9425819,66.1270653 52.5410251,66.3525984 C51.8098481,66.7634294 51.6632907,67.5374588 51.4444386,68.1166277 M27.7821127,70.0553098 L27.7803232,69.8258073 C27.4975872,69.7628385 27.2146721,69.6455612 26.9315782,69.6446591 C23.31023,69.6322098 19.6885239,69.6363595 16.0669968,69.63654 C15.992555,69.63654 15.9030815,69.6129041 15.8463553,69.6457417 C15.6815452,69.7410069 15.5299772,69.8593667 15.3730407,69.9685246 C15.5283666,70.0639702 15.6817242,70.1628438 15.8402711,70.2525158 C15.8751658,70.2723627 15.928134,70.2615372 15.9728708,70.2615372 C19.6688398,70.2626198 23.3649877,70.2671304 27.0609568,70.2552222 C27.3016404,70.2543201 27.5417871,70.124774 27.7821127,70.0553098 M61.9615051,69.6367204 C60.1584363,69.6367204 58.3553674,69.6334727 56.5524775,69.6410506 C56.3329097,69.6421332 56.1108366,69.6899462 55.8959214,69.7413678 C55.8247006,69.7585083 55.7166166,69.8636968 55.7241324,69.9134946 C55.7368377,69.9981146 55.8157532,70.1213458 55.8882267,70.1390275 C56.1451945,70.2019964 56.4112884,70.2611763 56.6739824,70.2617175 C60.2205308,70.2685738 63.7669002,70.2671304 67.3136276,70.2613567 C67.6110373,70.2609958 67.9836047,70.341466 68.066994,69.9295525 C68.0761202,69.8846263 67.5861637,69.6536805 67.3257959,69.650072 C65.5381166,69.6244514 63.7497214,69.63654 61.9615051,69.6367204 M32.1371431,68.487404 C31.8803543,67.8503183 31.7148284,67.26718 31.4209977,66.75946 C31.1353984,66.2656328 30.729547,66.200138 30.3473163,66.5131779 C29.4479294,67.2491373 28.9236149,68.2084647 28.8071205,69.3767259 C28.7690048,69.75923 29.0290146,69.9959494 29.3869084,69.8898586 C30.1198748,69.6726253 30.8580308,69.4582786 31.5618289,69.1645444 C31.7992914,69.0656707 31.9395857,68.7304384 32.1371431,68.487404 M26.6060737,20.6098053 C26.5495265,20.5286133 26.4856425,20.3400678 26.3677166,20.2947807 C26.2465695,20.2482307 26.0153701,20.2904505 25.9332335,20.3839114 C25.7403287,20.6034904 25.5701503,20.8611393 25.4581295,21.131779 C25.2088565,21.7331402 25.0052149,22.3534464 24.7743734,22.9627464 C24.6378369,23.3228777 24.485911,23.6772352 24.3388167,24.0332165 C24.1462699,24.4987167 23.9590914,24.9663821 23.7559867,25.4270107 C23.4882821,26.034687 23.1917671,26.6297333 22.9371258,27.242642 C22.6925054,27.8315538 22.4936954,28.439591 22.2607065,29.0335548 C21.9529179,29.8182294 21.6351082,30.5989346 21.3137196,31.3780159 C21.2136882,31.6208699 21.1986567,31.8175347 21.4926665,31.9167693 C21.7882868,32.0165451 21.9781494,31.9093719 22.0890965,31.6181636 C22.1735594,31.3967802 22.2841486,31.185501 22.3750535,30.9662828 C22.6091161,30.4031719 22.8467575,29.841324 23.0677569,29.2728002 C23.2930511,28.6930901 23.4798716,28.0971416 23.721271,27.524468 C23.9623125,26.9523358 24.27708,26.4115978 24.5109636,25.83712 C24.9184257,24.8357533 25.28813,23.8186895 25.6755499,22.8090231 C25.7020341,22.7397394 25.7474866,22.678214 25.7782655,22.6101932 C26.0334437,22.0447368 26.288801,21.4792802 26.5398634,20.9118391 C26.5693897,20.8449009 26.5727897,20.7660546 26.6060737,20.6098053 M21.0445835,25.9830851 L21.0546044,25.9830851 C21.0546044,24.479772 21.0549623,22.9764589 21.0538887,21.4731458 C21.0537098,21.3228506 21.0583623,21.1707511 21.0363519,21.0231622 C20.9903626,20.7128288 20.8516788,20.4808004 20.4964692,20.4764701 C20.1333858,20.471779 20.0106283,20.7205872 19.9542601,21.0215384 C19.9295654,21.1528889 19.934218,21.2909151 19.934218,21.4258741 C19.9333233,24.4175248 19.9329654,27.4091756 19.9349338,30.4008263 C19.9351127,30.5958673 19.9009339,30.8170701 19.9791337,30.9787322 C20.0616282,31.149596 20.2416487,31.3493281 20.4109326,31.3854135 C20.8552576,31.4804981 21.0347414,31.3020564 21.039394,30.7634835 C21.0535308,29.1701377 21.0445835,27.5766114 21.0445835,25.9830851 M6.93122138,47.8043998 L6.93122138,47.8197359 C6.64866425,47.8197359 6.36592816,47.8188338 6.08337103,47.8200968 C5.66696161,47.8220815 5.46707794,48.0443669 5.4200149,48.4526719 C5.38386764,48.7648096 5.31550993,49.0727975 5.26021534,49.3825898 C5.09433157,50.3101621 4.91019522,51.235028 4.7677535,52.1663893 C4.66933271,52.8105116 5.02096335,53.2014957 5.55189877,53.1273405 C5.95757136,53.0705062 6.05259216,52.7904843 6.05831846,52.452726 C6.0703079,51.7411242 6.1481498,51.0712007 6.61001172,50.467494 C6.93372663,50.0445743 7.83705052,49.6804738 8.29282825,49.9646454 C8.6602062,50.1939674 8.96692117,50.5196372 9.31926759,50.7765644 C9.47083561,50.8871658 9.66946665,50.932092 9.84680302,51.006969 C9.91981334,50.8045305 10.0341604,50.6057006 10.0511604,50.398571 C10.0627919,50.2592819 9.95757114,50.0940112 9.86863454,49.9653672 C9.6234773,49.6104684 9.3249939,49.2893093 9.11043658,48.9179917 C8.65698516,48.1338584 8.0827446,47.6185605 7.10963142,47.8031367 C7.05218948,47.8139623 6.9908107,47.8043998 6.93122138,47.8043998 M76.5444238,47.8278552 L76.5444238,47.8116168 C76.2609719,47.8116168 75.9768043,47.7962805 75.694605,47.8154057 C75.3127324,47.8412067 75.0138911,47.9590252 74.7810812,48.3402662 C74.417461,48.9356735 73.9296519,49.452956 73.5427687,50.0360943 C73.4194743,50.222114 73.3947797,50.5187351 73.4234111,50.7523873 C73.4629584,51.0739072 73.7317366,51.1561816 73.9811886,50.9434589 C74.1830406,50.7715125 74.3691455,50.5737651 74.5316292,50.3633879 C74.866081,49.9309057 75.5883105,49.7490358 76.0934777,49.9570675 C76.8949808,50.2870675 77.2671903,50.9097191 77.3505796,51.7431089 C77.3790321,52.0272805 77.392453,52.3128956 77.4085583,52.5979693 C77.426632,52.9196696 77.5928736,53.0899922 77.9099675,53.1213864 C78.2191877,53.1518785 78.4995975,53.0952246 78.5913973,52.7592705 C78.656355,52.5207468 78.6993023,52.2526331 78.6610076,52.0126659 C78.464166,50.7839619 78.2394087,49.5597685 78.0203777,48.3348535 C77.9670516,48.0371498 77.8034942,47.8383199 77.4830002,47.8296594 C77.1703801,47.8213598 76.857223,47.8278552 76.5444238,47.8278552 M60.3685199,59.0574162 C60.3685199,60.7712869 60.3640463,62.4851577 60.3712041,64.198848 C60.3735305,64.7857752 60.7045822,65.0246598 61.250549,64.8523526 C61.6449481,64.7278583 61.6766217,64.402369 61.6762638,64.0530635 C61.6737585,60.7305106 61.6757269,57.4081381 61.6728638,54.0857657 C61.6726848,53.9219385 61.6610533,53.7530594 61.6209691,53.5951862 C61.5356114,53.2597735 61.3155068,53.0975701 60.9622657,53.1195821 C60.5589194,53.1448419 60.3742462,53.3801179 60.3717409,53.9609106 C60.3642252,55.6598059 60.3690567,57.3587012 60.3685199,59.0574162 M79.7153627,54.7060719 C80.9821276,54.7869028 81.8552095,53.6051096 81.8720305,52.4915177 C81.8806199,51.9199268 81.681631,51.3477946 81.6129154,50.7716928 C81.5223684,50.0124584 81.479421,49.2472699 81.3928108,48.4876746 C81.3375162,47.9994406 80.9010647,47.5478333 80.5929182,47.6115238 C80.2491612,47.6826119 79.9064779,47.7587519 79.5609314,47.8197359 C79.0883328,47.9032733 78.9342594,48.1363843 79.0273119,48.6154165 C79.1701115,49.34885 79.2950164,50.085892 79.4405002,50.8186038 C79.4866686,51.0515343 79.555742,51.2839236 79.6470049,51.5026004 C79.9021833,52.1133438 79.9105937,52.7022558 79.5136895,53.2532781 C79.313448,53.5314957 79.0831433,53.7878816 78.8637545,54.0522064 C78.6486603,54.3114791 78.7290074,54.5108504 79.0138908,54.6035896 C79.235785,54.6755798 79.4807633,54.6746777 79.7153627,54.7060719 M3.74077732,54.7827531 C4.05608174,54.6546502 4.37138615,54.5265475 4.68669056,54.3986252 C4.53118572,54.1440435 4.4025229,53.8670889 4.21498657,53.6390299 C3.64128284,52.9420425 3.41187294,52.2156457 3.89288217,51.3669198 C3.97770299,51.2171658 3.98915559,51.0221248 4.02118709,50.8456678 C4.15772357,50.0952742 4.28209166,49.3425351 4.42507022,48.5934046 C4.5177647,48.10914 4.37639666,47.8897414 3.88250325,47.8237053 C3.64754599,47.7923111 3.39809403,47.8164883 3.17709462,47.7457611 C2.5919383,47.5584785 2.18519202,47.7784183 2.0805081,48.4061219 C2.01393985,48.8045035 1.99980305,49.2115454 1.94379268,49.6120922 C1.8442982,50.3213485 1.78989835,51.0439564 1.61077252,51.7330049 C1.24142614,53.1538632 2.32405481,54.745044 3.74077732,54.7827531 M23.0969253,59.0909756 C23.0969253,57.4536056 23.0988938,55.8160552 23.094599,54.1786853 C23.0940622,53.9697515 23.0813569,53.7570288 23.0389465,53.5535077 C22.9750625,53.2462415 22.7705262,53.1091174 22.4536112,53.1192212 C21.9865599,53.1343772 21.7564342,53.4551753 21.7551815,54.1761594 C21.7496342,57.4812109 21.7494553,60.7862623 21.7519605,64.0913138 C21.7523184,64.6616419 21.9643705,64.8763493 22.4904743,64.8763493 C22.9584204,64.8763493 23.0942411,64.7098157 23.0956727,64.0938398 C23.0994305,62.4261583 23.0969253,60.758657 23.0969253,59.0909756 M52.4173728,59.0868257 C52.4173728,60.7853602 52.4139728,62.4838947 52.4196992,64.1824291 C52.4213097,64.6722869 52.810877,65.0952065 53.2256759,65.0887111 C53.5628118,65.0832984 53.9182004,64.6726478 53.936095,64.2302422 C53.9527371,63.8102094 53.966874,63.3860269 53.926253,62.9690614 C53.9010215,62.7119537 53.8222848,62.4295863 53.6784116,62.220833 C53.2967179,61.6669238 53.3260651,60.5706527 53.7422956,60.0539114 C53.8679163,59.8976621 53.9352004,59.6497562 53.9369898,59.4429875 C53.9520213,57.6995268 53.9480846,55.9558857 53.9418214,54.2122447 C53.9411056,54.0204514 53.9255372,53.8138631 53.8546742,53.6397516 C53.710801,53.2870179 53.4327175,53.1049675 53.0401081,53.1430375 C52.6401617,53.1818293 52.4848358,53.4560774 52.433657,53.8116979 C52.410215,53.9742622 52.4173728,54.1415175 52.4171938,54.3066077 C52.4162992,55.900134 52.4166571,57.4934799 52.4173728,59.0868257 M31.0491461,59.0754589 C31.0491461,57.4669572 31.0505776,55.8584554 31.0471776,54.2499538 C31.0466407,54.0558149 31.0435986,53.8555416 30.9985041,53.6688002 C30.874315,53.1558479 30.3199375,52.9344646 29.9255386,53.2814247 C29.7265497,53.4566188 29.5486764,53.7781386 29.5442027,54.0365093 C29.5114554,55.8701832 29.5207607,57.7045788 29.5341817,59.5384331 C29.5354343,59.7148901 29.6164972,59.9220198 29.7272654,60.060948 C30.0515172,60.468351 30.2249167,61.600166 29.9162334,61.9996301 C29.3214139,62.7691489 29.502687,63.6362784 29.5760553,64.4693072 C29.6283078,65.0623689 30.1816116,65.2249331 30.6792628,64.8945723 C30.9815041,64.6939381 31.0529039,64.4164422 31.0520092,64.0813904 C31.0477145,62.4128067 31.0500407,60.744223 31.0491461,59.0754589 M30.9711252,31.5073817 C32.5182999,31.5968732 33.6816337,31.1163977 34.7490519,30.135419 C35.9404802,29.0405915 36.2389637,27.6354304 36.4125422,26.1712698 C36.4783946,25.6168194 36.2531004,25.030253 36.1822375,24.4554143 C36.0405116,23.3064588 35.4804079,22.416776 34.6599364,21.6174869 C33.7612651,20.7420579 32.6777417,20.3949174 31.5013449,20.2796249 C30.3058006,20.1623477 29.2285404,20.501369 28.1917221,21.15758 C26.8807573,21.9873611 26.1830433,23.2007289 25.9579281,24.6416144 C25.7616234,25.8975628 25.7415814,27.1805753 26.3047273,28.4305696 C26.7943259,29.5172781 27.4789767,30.3811599 28.4907424,30.933806 C29.2847297,31.3671904 30.1520853,31.6825758 30.9711252,31.5073817 M62.7408188,69.1284591 L62.7408188,69.125031 C64.24272,69.125031 65.7449791,69.1347741 67.2468804,69.1203399 C67.8264894,69.1147467 67.9968468,68.803872 67.7033739,68.2986779 C67.5033113,67.953883 67.2712171,67.6211767 67.0115652,67.3198644 C66.5160613,66.7448454 65.8840209,66.3296842 65.1651913,66.1382517 C64.5970348,65.9870544 63.986647,65.9506083 63.3945118,65.9460977 C60.8031819,65.9271528 58.2113152,65.9358133 55.6199852,65.9423086 C55.3540702,65.9430304 55.0836815,65.9731616 54.8238506,66.0298154 C54.353936,66.1322977 54.2948836,66.409974 54.556325,66.8197225 C54.8499769,67.2796294 55.1396918,67.7593833 55.3223966,68.2699901 C55.597617,69.0398698 55.641459,69.1259331 56.4467199,69.1273765 C58.5448721,69.1309851 60.6426666,69.1284591 62.7408188,69.1284591 M21.7501711,69.1297221 C22.8372734,69.1297221 23.9241968,69.1304438 25.0112991,69.1295417 C25.7555392,69.1290004 26.4996004,69.1205204 27.2438405,69.1273765 C27.696934,69.1317068 27.9191861,68.9168189 28.0848908,68.4863215 C28.3123323,67.8957857 28.6220894,67.3312314 28.9495622,66.7881478 C29.1786143,66.4085306 29.1464038,66.1642332 28.7086997,66.0541731 C28.4086058,65.9787548 28.091154,65.9432107 27.7813969,65.9421283 C25.2766773,65.934009 22.7721367,65.9387001 20.2675961,65.9385196 C19.3290197,65.9385196 18.4222958,65.9809199 17.5565508,66.4801599 C16.7520055,66.944397 16.1392913,67.5434128 15.7252082,68.3582186 C15.4991984,68.8033306 15.6740294,69.0840742 16.1634492,69.1203399 C16.3266487,69.1324285 16.4912799,69.1291809 16.6551952,69.1291809 C18.3534012,69.1297221 20.0517861,69.1295417 21.7501711,69.1297221 M27.3798401,46.653279 L27.4177769,46.653279 C27.4177769,47.298484 27.3982716,47.9444106 27.4267242,48.5881721 C27.4390715,48.8732459 27.582229,49.1678823 27.9426281,48.9944925 C28.3132271,48.8160507 28.6548367,48.5704904 28.9935831,48.3317862 C29.7333495,47.8110754 30.1733799,47.0332572 30.3865057,46.2063627 C30.5459474,45.5871393 30.4874318,44.8641705 30.3460638,44.2278064 C30.2317167,43.7130498 29.8752545,43.2415956 29.5798132,42.7813277 C29.1240354,42.0704475 28.397511,41.5899719 27.6391342,41.4671015 C26.6765788,41.3112131 25.682171,41.2256909 24.6954578,41.7696767 C23.4838085,42.4377957 22.8184839,43.451251 22.5831687,44.7052148 C22.3337168,46.0333338 22.8646523,47.2091728 23.8531548,48.1250175 C24.1698908,48.4185712 24.5879108,48.5986369 24.9468783,48.8492493 C25.2840142,49.0850665 25.4377296,49.0488009 25.5332871,48.6480737 C25.5812449,48.4461765 25.5919818,48.2320104 25.5937712,48.0230765 C25.6016449,47.1370023 25.6091606,46.2505672 25.5971712,45.3646735 C25.5916239,44.9630442 25.6458448,44.6002065 26.05957,44.4405291 C26.2873694,44.352842 26.5738634,44.2440448 26.7783996,44.3126068 C27.0783146,44.4132848 27.417061,44.5657452 27.3877137,45.0314258 C27.3537138,45.5701791 27.3798401,46.1123606 27.3798401,46.653279 M36.9715722,41.3557784 C36.2994478,41.3727385 35.6860178,41.4569977 35.0502194,41.7931321 C33.8736437,42.4152425 33.326961,43.4436731 33.0070039,44.620234 C32.7017205,45.7435689 33.1746772,46.7310428 33.8208544,47.6248754 C34.4904736,48.5506435 35.3662398,49.1287298 36.5413839,49.1462311 C36.8987408,49.1514635 37.2586031,49.172393 37.612739,49.1373902 C37.919275,49.1070785 38.252832,49.0708128 38.5158839,48.9277347 C39.5453653,48.3678715 40.3187738,47.6124259 40.7269516,46.4261221 C41.0733927,45.4193426 40.9327406,44.5493263 40.5197311,43.6554937 C40.4069946,43.411918 40.2055004,43.3209831 39.981101,43.5329842 C39.593681,43.8987086 39.2232609,44.282656 38.8365567,44.6492826 C38.3446318,45.1155044 37.861833,45.5941758 37.3407397,46.0252146 C36.9452671,46.3521473 36.4783946,46.2698728 36.1666692,45.8913381 C35.9605223,45.6409063 36.0417642,44.9320109 36.301774,44.6761662 C37.0293721,43.9598732 37.7585807,43.2450236 38.4806314,42.522957 C38.8580303,42.1453244 38.6960834,41.5576756 38.1699796,41.4582606 C37.777907,41.3841053 37.3715185,41.3871726 36.9715722,41.3557784 M52.5308251,32.3860584 L52.5308251,32.3822695 C55.9601633,32.3822695 59.3896804,32.3846151 62.8191975,32.3804652 C63.6215953,32.3793827 63.9009314,32.0946698 63.9064788,31.2961023 C63.9118473,30.5143146 63.9197209,29.7321659 63.8986052,28.9509195 C63.8932368,28.7562394 63.8026896,28.55344 63.7141109,28.3730136 C63.3733961,27.6803565 62.7132609,27.3218491 62.1195152,26.9140854 C61.5291694,26.5086673 60.0913312,26.580116 59.6026272,27.0237847 C59.0010078,27.5695747 58.4244409,28.1465784 57.8723898,28.7436095 C57.1258234,29.5508374 56.3651201,30.3474201 55.270681,30.6312309 C54.8472927,30.7409302 54.3444518,30.7454409 53.926253,30.6256377 C52.9704977,30.3526525 52.224826,29.7018543 51.4707438,29.0660316 C50.9067033,28.590247 50.270905,28.1963762 49.6462014,27.799438 C48.9651295,27.3669558 48.1451948,27.3519804 47.4097232,27.1033527 C46.4795572,26.7885086 45.6521068,27.0927077 44.9089404,27.435157 C43.7858697,27.9528005 42.9050932,28.8462722 42.3174315,29.9804327 C42.1055584,30.3894595 41.9403905,30.8289783 41.6846753,31.2071521 C41.4660022,31.5304763 41.3470026,31.8727452 41.5783809,32.15403 C41.7184964,32.3243526 42.0731691,32.3759546 42.3319263,32.3770372 C45.7315593,32.39093 49.1311922,32.3860584 52.5308251,32.3860584 M52.2183839,19.7015386 L52.2183839,19.6993735 C49.5214753,19.6993735 46.8243878,19.6972084 44.1274794,19.7006364 C43.2184292,19.701719 42.309379,19.7121837 41.4005077,19.7267983 C40.692057,19.7383456 40.5238469,19.907766 40.523489,20.6004231 C40.5218785,23.0047858 40.5188364,25.4093289 40.5317206,27.8136916 C40.5329732,28.0179344 40.6494676,28.2216358 40.712278,28.4255177 C40.9270143,28.341439 41.1757504,28.3004822 41.3473605,28.1620951 C41.5495705,27.9993505 41.6592649,27.723298 41.854496,27.5472019 C42.3927682,27.0622156 42.9143984,26.538618 43.5201335,26.1544901 C44.0313849,25.8300835 44.6346148,25.5578199 45.2263921,25.4760868 C46.7016303,25.2723853 48.1908263,25.1962453 49.5932331,25.9036974 C50.0950001,26.1568357 50.6531355,26.317776 51.1133868,26.6291921 C52.0705738,27.276923 52.983203,27.9921335 53.9067478,28.689662 C54.3943781,29.0580928 54.9020503,29.0858785 55.3610491,28.6622372 C55.9505002,28.1177102 56.5390565,27.562538 57.0571077,26.9510728 C57.7689585,26.1113683 58.5951562,25.3817237 59.6164062,25.0728337 C60.5961403,24.7765735 61.6674954,24.6991705 62.6432927,25.2859173 C63.4043538,25.7436591 63.9048683,25.4569615 63.9057631,24.577924 C63.9068367,23.3755621 63.9068367,22.1733807 63.9066577,20.9711994 C63.9066577,19.7558469 63.8264896,19.6952237 62.5883561,19.6984714 C59.131818,19.7074927 55.674922,19.7015386 52.2183839,19.7015386 M80.4293607,28.5243914 C80.3112558,24.7888425 80.7197915,20.5020907 80.0056145,16.253048 C79.9660672,16.0170502 79.9415515,15.7729333 79.8608465,15.5508284 C79.613005,14.867734 79.3542479,14.187887 79.0745538,13.5174225 C78.8744912,13.0380294 78.6848075,12.5418567 78.4022503,12.1122613 C77.4978528,10.735788 76.4080662,9.52512664 75.0527226,8.57878998 C74.7270393,8.35127223 74.3936612,8.13223453 74.0486516,7.93647185 C73.5497477,7.65374362 73.0512016,7.36181364 72.5261714,7.13610017 C71.917752,6.87448184 71.2662064,6.71444359 70.6597554,6.4490363 C69.8276524,6.08529659 69.5162848,6.24930423 69.5107375,7.15179727 C69.5016112,8.66990532 69.5064427,10.1880134 69.5060848,11.7061214 C69.5059058,12.7197572 69.6528213,12.9267063 70.6189556,13.259954 C70.7592498,13.3084886 70.920302,13.308669 71.0496806,13.3748856 C71.4821953,13.5960884 71.934931,13.7954596 72.3246773,14.0798116 C73.0470858,14.6062959 73.6759052,15.2399536 74.0948198,16.0484444 C74.3539349,16.548767 74.6855236,17.0425942 74.8027338,17.5795432 C75.1482802,19.1608005 75.3701743,20.7555899 75.357827,22.3940423 C75.3164902,27.8649327 75.3417217,33.3360037 75.3429744,38.8070746 C75.3431534,39.4665332 75.4524898,39.5809235 76.0868566,39.5830886 C77.2346219,39.5866972 78.3825663,39.5944556 79.5301526,39.5792996 C80.2441506,39.5699175 80.4286449,39.3667573 80.4288239,38.662553 C80.4300766,35.4610662 80.4293607,32.2595795 80.4293607,28.5243914 M3.04163183,29.0609796 L3.04342129,29.0609796 C3.04342129,32.2325156 3.04252656,35.4040515 3.04395814,38.5754069 C3.04449498,39.4154725 3.19588405,39.576052 4.0261976,39.5825474 C5.09952103,39.5908469 6.17284447,39.5845321 7.2461679,39.5830886 C8.04498681,39.5818257 8.11907082,39.5071291 8.11907082,38.7089226 C8.11960766,33.1175073 8.13410235,27.5259115 8.11083926,21.9346767 C8.10457612,20.4328069 8.40520689,18.9823588 8.64499572,17.5180178 C8.65931147,17.430511 8.68847982,17.3393957 8.73375338,17.2639774 C9.19024688,16.50348 9.60504577,15.711047 10.1288233,15.0003473 C10.4469909,14.5689477 10.8977581,14.2025016 11.3578305,13.9212168 C11.854945,13.6168374 12.4320487,13.4459736 12.9740788,13.2164711 C13.846087,12.847499 13.9584656,12.6836719 13.9598972,11.7465369 C13.9620446,10.2585601 13.9611499,8.77058327 13.9590025,7.28242601 C13.9588235,7.11751625 13.957392,6.95044137 13.9325184,6.78805758 C13.8731079,6.40086244 13.610235,6.17009702 13.2448255,6.26662517 C12.7026164,6.40988377 12.1679231,6.59644469 11.6487982,6.81079131 C11.0793892,7.04606738 10.5228644,7.31742874 9.97636057,7.60340464 C9.50787761,7.84860417 9.02633153,8.09127774 8.61314318,8.4158649 C7.90558718,8.97193917 7.21735745,9.56085107 6.57780127,10.1941479 C6.12882353,10.6387186 5.7279825,11.150408 5.38834132,11.6855528 C4.97640558,12.335088 4.62388021,13.0275647 4.29551266,13.7252737 C3.82577708,14.7230319 3.42762026,15.7492974 3.40077823,16.8794886 C3.39648351,17.059013 3.36999936,17.2383569 3.34780996,17.416979 C3.19463142,18.6487504 3.0026214,19.8693352 3.02642134,21.1249227 C3.07634752,23.7694331 3.04163183,26.4155672 3.04163183,29.0609796 M41.7830961,39.7564784 L41.7830961,39.7839032 C39.859775,39.7839032 37.936275,39.7860684 36.0129537,39.783362 C30.8691255,39.7763253 25.7254762,39.7662215 20.5816479,39.7602674 C20.048744,39.7597262 19.8882287,39.9150733 19.8866181,40.4642914 C19.880355,42.5689658 19.8975339,44.674001 19.880176,46.7784949 C19.8739129,47.5509005 20.2427225,48.1448644 20.6437424,48.7446019 C21.0542466,49.3587735 21.6680345,49.746149 22.3138538,49.9570675 C22.865189,50.1373136 23.5070716,50.0472807 24.1088699,50.0469199 C24.199775,50.0469199 24.3262905,49.8982485 24.3656587,49.7917969 C24.3835535,49.7430817 24.2423643,49.6110096 24.1516383,49.5493038 C23.8740917,49.3600364 23.5705977,49.2068544 23.3045038,49.0033333 C22.4267692,48.3319665 21.9008443,47.3863516 21.6802028,46.3492605 C21.3852983,44.964668 21.6136346,43.6219344 22.4727585,42.4267898 C23.2585143,41.3335859 24.233238,40.5763362 25.6064764,40.465374 C27.1121356,40.3434057 28.5651842,40.3836407 29.7770127,41.5288073 C30.4679265,42.181951 31.022304,42.9152041 31.2923349,43.8101193 C31.7828283,45.4350398 31.4829134,46.9545912 30.4239056,48.2789212 C30.0746014,48.7159141 29.607192,49.0576417 29.1879195,49.4361764 C29.0338462,49.5754656 28.862594,49.6954491 28.6992155,49.8240932 C28.9017834,49.9285601 29.1004144,50.0418679 29.3088875,50.1326225 C29.3858347,50.1661817 29.4855082,50.1508456 29.5748026,50.1508456 C31.0210514,50.1522889 32.4674791,50.1553562 33.9137279,50.1495826 C34.0898116,50.1490412 34.27699,50.1295552 34.4380422,50.0656842 C34.5595472,50.0171495 34.647768,49.8834536 34.7506624,49.7876472 C34.6620837,49.6947275 34.5894313,49.5713158 34.4822421,49.5137598 C33.3062032,48.8831694 32.5565946,47.8749464 32.1663115,46.6368602 C31.6584602,45.0251109 32.0385434,43.5392991 33.0644459,42.2205623 C33.6141707,41.5141928 34.2845057,40.8345264 35.1275246,40.6476046 C36.8708251,40.2616725 38.6350625,40.125631 40.14609,41.4716121 C41.1714556,42.3849307 41.8068961,43.4730826 41.870959,44.8650726 C41.8895696,45.2699495 41.9355589,45.6934104 41.844475,46.0784404 C41.7018543,46.6825081 41.5617388,47.3361931 41.2233503,47.8321853 C40.7453831,48.5329616 40.2060373,49.2405942 39.3453026,49.5585056 C39.2576187,49.5909823 39.1484612,49.741097 39.1593769,49.8212064 C39.1713663,49.9083523 39.3030713,50.0277947 39.398271,50.0451157 C39.718407,50.1035738 40.0453429,50.1524694 40.3697737,50.1528302 C46.8709141,50.1589647 53.3720545,50.1584235 59.873195,50.1575214 C60.5726983,50.1573409 61.2260334,50.0792162 61.8902842,49.7371277 C63.1760176,49.0749627 63.7869423,47.9566796 63.8699737,46.6500314 C64.0006049,44.5987632 63.9023631,42.5330609 63.9086262,40.4733127 C63.9098788,40.044439 63.6853004,39.8391137 63.2975226,39.7806556 C63.1219756,39.7541328 62.9408814,39.757561 62.7622924,39.7573806 C55.769227,39.7564784 48.7761616,39.7564784 41.7830961,39.7564784 M41.7820225,12.3065806 L41.7820225,12.3379748 C45.6429806,12.3379748 49.5037596,12.3383357 53.3647177,12.3379748 C56.5392354,12.337614 59.7135743,12.336351 62.8879131,12.3354488 C63.676711,12.3352684 63.9000367,12.1232673 63.9039735,11.3234369 C63.9116683,9.71511568 63.8955631,8.10643356 63.9122052,6.49811228 C63.922405,5.48231144 63.7234161,4.52388621 63.0750916,3.73830949 C62.7223872,3.31087926 62.2841463,2.87514942 61.7913266,2.66513304 C61.0939706,2.3679707 60.3386358,2.221284 59.539459,2.22290784 C47.9701847,2.24726541 36.4009106,2.24040921 24.8316364,2.24221347 C24.0016807,2.2423939 23.1949882,2.29489799 22.3644958,2.49210409 C21.2632565,2.753542 19.8393761,4.38712296 19.8744497,5.66129447 C19.9274181,7.58391859 19.8778497,9.50924911 19.8889445,11.4331362 C19.8934181,12.2197955 20.0331756,12.3386965 20.8124894,12.3368922 C25.1796881,12.3275101 29.5468869,12.3146998 33.9142646,12.3073023 C36.5367313,12.3029721 39.1593769,12.3065806 41.7820225,12.3065806 M41.6666017,0.114264063 C48.6002567,0.114805342 55.5339119,0.107047006 62.4673879,0.123104959 C63.5240693,0.125630928 64.5898769,0.171278817 65.6338532,0.321213188 C66.5058613,0.446248709 67.2740802,0.899119068 67.911847,1.53710695 C68.0589413,1.68415449 68.2146251,1.82254158 68.3581406,1.97265637 C68.9483073,2.58863223 69.1864857,3.36825488 69.330538,4.18107598 C69.4017588,4.58360736 69.6089793,4.72452041 70.0003361,4.82573963 C70.839597,5.04261221 71.6598896,5.33977456 72.4764242,5.63603477 C72.9611914,5.81195054 73.4518636,6.00212001 73.8911783,6.26770773 C74.8633968,6.85571749 75.8318574,7.45780051 76.7514654,8.12483705 C77.719389,8.8266959 78.4972711,9.74236007 79.1371852,10.7500417 C79.6128261,11.4991723 80.020825,12.299544 80.3840871,13.1111021 C80.711381,13.84219 81.0030645,14.60377 81.1880955,15.3814079 C81.3708004,16.1494833 81.3890529,16.9561699 81.4991052,17.74319 C81.9430725,20.9125609 81.6302734,24.0976288 81.68861,27.2745774 C81.7465888,30.4457526 81.7018521,33.6189123 81.7032836,36.7909895 C81.7038204,38.0231216 81.7172415,39.254893 81.7048942,40.4866642 C81.6993468,41.0456253 82.2165033,41.1822081 82.4695342,41.5304312 C82.6055338,41.717353 82.7511966,41.8974185 82.8829015,42.0874075 C82.9840065,42.2331921 83.0761642,42.3860133 83.1611639,42.5419017 C83.24849,42.7024814 83.3869948,42.8691953 83.3898581,43.0351877 C83.3988054,43.5371341 83.4968683,44.0140011 83.0783115,44.498446 C82.7012704,44.935078 82.6126917,45.6118577 82.3229767,46.1417701 C81.9777882,46.7732626 82.1511877,47.3589268 82.2836084,47.9922236 C82.4149554,48.6199272 82.392766,49.2786641 82.4781237,49.9182758 C82.5407551,50.3873846 82.6950073,50.8438635 82.7592492,51.3129722 C82.8200912,51.7571821 82.8249227,52.209872 82.8399542,52.6594947 C82.8752068,53.7131851 82.3471345,54.4742238 81.5624524,55.0883954 C80.5270657,55.8986905 79.3501321,55.7588601 78.2517561,55.3841143 C77.7515995,55.213431 77.3833268,54.6113479 76.9892858,54.173453 C76.527066,53.6599593 76.5469291,52.9940053 76.4708767,52.352048 C76.4282873,51.9933602 76.2849508,51.6312444 76.1181723,51.3070181 C75.9043308,50.8909548 75.6011947,50.8465699 75.2436588,51.1630379 C74.9473228,51.4253779 74.6840919,51.7283138 74.42444,52.0294456 C73.9552412,52.5737921 73.3103167,52.5564712 72.6913394,52.5750552 C71.9567625,52.5970672 71.2837433,52.3536719 70.8469339,51.7472586 C70.6277239,51.4428793 70.523219,51.0150881 70.4804506,50.630419 C70.4106613,50.0030763 70.4786612,49.3955805 70.8646496,48.8299436 C71.1617014,48.3945746 71.3304484,47.8706162 71.5616478,47.3885168 C71.6450369,47.2145857 71.7332577,47.0415567 71.837226,46.8798947 C72.143583,46.4039296 72.1194251,45.766844 71.7398788,45.3489763 C71.0448491,44.5839681 70.870018,43.6661389 71.10927,42.7131264 C71.2207538,42.2705404 71.5700582,41.8589878 71.8914469,41.5076974 C72.2328775,41.1345756 72.5172241,40.8152207 72.5154346,40.2421864 C72.4953926,33.612056 72.5145399,26.9819258 72.4907399,20.3517954 C72.4868031,19.2699585 72.0261938,18.3290347 71.1787014,17.6304235 C70.8388812,17.3500409 70.4677454,17.0969025 70.0805044,16.88851 C69.3473589,16.4935565 68.8958759,16.7715937 68.8958759,17.5842343 C68.895518,22.1997231 68.895518,26.8153922 68.8958759,31.4308809 C68.8960549,37.2792235 68.8878234,43.1277464 68.9078654,48.976089 C68.9103706,49.7459686 68.5311822,50.3202659 68.0648466,50.7899159 C67.1887226,51.6723817 66.1425991,52.2811405 64.8956972,52.5802875 C64.2198148,52.7426714 63.572385,53.003207 62.8621447,53.0098828 C62.5622298,53.0127696 62.4069039,53.2078106 62.383283,53.5029883 C62.3677146,53.6976684 62.3571567,53.8930702 62.3571567,54.0882917 C62.3566198,57.4108446 62.3573356,60.7335778 62.3596619,64.0561306 C62.3601988,64.7486073 62.4893984,64.9196516 63.1651019,64.8655237 C64.0997414,64.7906467 64.9812338,65.0663383 65.829979,65.3256111 C66.8950708,65.65092 67.7420265,66.403659 68.3588564,67.362806 C69.0973701,68.5110399 69.4130325,69.7765509 69.3512958,71.1450854 C69.3264222,71.7002575 69.3568431,72.2577753 69.3421695,72.8136691 C69.3335801,73.1431278 69.3053065,73.4751125 69.2516224,73.8000605 C69.1238543,74.5703009 68.96996,74.6935322 68.214983,74.6935322 C63.8012581,74.6933517 59.387533,74.6935322 54.9738081,74.6922691 C54.6517036,74.6922691 54.3077678,74.7483819 54.1127157,74.378688 C54.0885578,74.3330401 54.0189474,74.3034502 53.9641898,74.2841446 C53.4049807,74.0869385 52.8436244,73.8962278 52.2847732,73.6981195 C51.7703009,73.5157084 51.2488497,73.3480922 50.7511984,73.1265285 C50.6146619,73.0659053 50.4673886,72.8344181 50.469357,72.6830404 C50.4908306,70.9855884 50.4983465,69.285791 50.6085777,67.5930301 C50.6406092,67.1031723 50.9938503,66.6362288 51.1908709,66.1550314 C51.2841022,65.926792 51.4261861,65.6897116 51.4270807,65.4562399 C51.443007,61.6676454 51.4439018,57.8788707 51.4369228,54.0902764 C51.4356703,53.4308178 51.1133868,53.1215668 50.4647044,53.1212059 C44.6494674,53.1181388 38.8342304,53.1183191 33.0188144,53.1212059 C32.3438268,53.1215668 32.0304908,53.4304569 32.029775,54.1186033 C32.0254802,57.8922222 32.009554,61.6660216 32.0582276,65.4390993 C32.0646697,65.9332873 32.4232791,66.4217017 32.6113524,66.9155289 C32.7113836,67.1780493 32.8645622,67.4441783 32.8752991,67.7131941 C32.9409726,69.3642764 32.9787303,71.016261 33.0046777,72.6682454 C33.0070039,72.8156538 32.8933727,73.0164684 32.771152,73.103434 C32.5326158,73.2737565 32.2599007,73.4099785 31.9830699,73.50795 C31.3553242,73.7305963 30.7109364,73.9054295 30.0846223,74.131143 C29.758581,74.248781 29.4599188,74.4416569 29.1419301,74.5840133 C29.0116567,74.6422911 28.8622362,74.6870368 28.7215839,74.6872173 C24.1140594,74.69263 19.506535,74.6902844 14.8990105,74.696419 C14.6339902,74.6967799 14.4722222,74.6182943 14.4174644,74.3489177 C14.3201173,73.8698854 14.1569178,73.3950031 14.1318652,72.9129037 C14.085339,72.013117 14.0556338,71.1039481 14.1318652,70.2084917 C14.2612438,68.6865948 14.822958,67.3436807 16.0081233,66.3222867 C16.7428793,65.6891704 17.5379402,65.2045449 18.5362849,65.1222705 C19.1067676,65.0751791 19.6697345,64.923621 20.2402172,64.8902421 C20.991973,64.8463985 21.1056043,64.7637632 21.1063201,63.9785473 C21.1086464,61.7084219 21.1077518,59.4382964 21.1081095,57.1679905 C21.1082885,56.1005878 21.1145516,55.0331849 21.106678,53.9657821 C21.1005938,53.1320316 20.965489,53.0241365 20.1512806,52.9595438 C19.7431028,52.9270672 19.3401143,52.8050989 18.9394523,52.7051426 C18.2216962,52.5254379 17.5177193,52.2986419 16.8842473,51.9038688 C16.1205019,51.4280843 15.5160193,50.8139127 15.0344732,50.0247274 C14.5822745,49.283716 14.6032113,48.5181667 14.6033903,47.7264554 C14.6033903,37.6985344 14.5983797,27.6706135 14.6128745,17.6425121 C14.614306,16.6579251 14.3761276,16.4628841 13.4051618,16.8830972 C12.4333013,17.3036712 11.6738507,17.9781053 11.2660308,19.0705873 C11.0078104,19.7627032 10.9328317,20.4248681 10.9328317,21.1290726 C10.9331896,27.4735878 10.9378422,33.8181031 10.9256738,40.1624379 C10.9247791,40.6338922 11.0457472,40.9931212 11.379841,41.3249254 C11.6901349,41.6329133 11.9578394,41.9897969 12.2130177,42.347763 C12.5440694,42.8125415 12.5030906,44.2297911 12.1677441,44.6904198 C11.9748394,44.9549249 11.7756715,45.2150999 11.5797247,45.4774399 C11.3510305,45.7839844 11.3923673,46.462027 11.6031667,46.8519285 C11.9129238,47.4246021 12.1453758,48.0420214 12.4778591,48.5997194 C12.7602373,49.0726172 12.9526052,49.5552579 12.9985946,50.1001457 C13.0096892,50.2340221 13.017563,50.3686202 13.0159524,50.5028575 C12.9980577,51.9347217 11.9132817,52.6003148 10.6248641,52.5808288 C9.74068751,52.5674773 9.01112105,52.2722996 8.51508028,51.4881663 C8.40645952,51.3167611 8.24021786,51.1237048 8.06252359,51.0710204 C7.87337674,51.0149078 7.52138821,51.0390849 7.44658842,51.158888 C7.23238898,51.50242 6.9927791,51.9128901 6.99510542,52.2955746 C7.00333697,53.625137 6.45611739,54.6739559 5.3607835,55.2859623 C4.7852903,55.6074823 3.98503982,55.6067606 3.28732591,55.6017086 C1.92464535,55.592146 1.1630474,54.6582588 0.740911694,53.5096641 C0.5306491,52.9378927 0.586122635,52.2253888 0.665396107,51.5949788 C0.857406117,50.0692927 1.13459485,48.5547932 1.37527841,47.0352419 C1.38905732,46.9479154 1.41410988,46.8441702 1.38243628,46.7707367 C1.00933202,45.9066744 0.839869322,44.943919 0.134102798,44.2404363 C-0.124296508,43.9829678 0.023513621,42.797566 0.299628668,42.5354064 C0.373354786,42.4657619 0.454059833,42.3777137 0.477680822,42.2844332 C0.608669943,41.7682332 1.01255307,41.4680036 1.37724683,41.1544225 C1.63278298,40.9348435 1.72851957,40.7028151 1.72834062,40.3776867 C1.72297221,33.5371791 1.69791964,26.6963107 1.74462479,19.8561641 C1.75428791,18.4298931 1.92285589,16.9814296 2.2209814,15.5874549 C2.50926484,14.2400304 2.97488464,12.9090244 3.6990827,11.7167666 C4.61421707,10.2102058 5.66356162,8.80720984 7.13862082,7.79158942 C7.79589274,7.33889949 8.43240682,6.85066554 9.11652076,6.44380393 C9.59466686,6.15945186 10.1318654,5.97072581 10.6531377,5.76684394 C11.3816305,5.48195059 12.1172811,5.21528032 12.855437,4.95672923 C13.0784048,4.87860458 13.317299,4.83421968 13.5526142,4.80823827 C13.8876027,4.7716117 14.031118,4.58721589 14.1148652,4.26966536 C14.270907,3.67858835 14.3884751,3.05377159 14.6760427,2.5283698 C14.9313999,2.06196746 15.355683,1.6616012 15.7754923,1.3196931 C16.6650373,0.594920094 17.6839609,0.24254726 18.8587472,0.238397452 C23.6432502,0.221437367 28.4275742,0.149808072 33.212077,0.11697046 C36.0301327,0.0976648309 38.8483671,0.113542357 41.6666017,0.114264063" id="Fill-1" fill="#E65C24" fillRule="nonzero" mask="url(#mask-2)" />
                                        </g>
                                    </g>
                                    <g id="Group-6" transform="translate(22.340014, 0.000000)">
                                        <g id="Fill-4-Clipped">
                                            <g id="path-13" />
                                            <path d="M19.8884425,21.3085759 C25.1081526,21.3085759 30.3278628,21.3089344 35.547573,21.307321 C35.7726881,21.3071417 36.0005111,21.305349 36.2225573,21.2736179 C36.8590897,21.1827272 37.3912785,20.8510746 37.783199,20.382279 C38.4430192,19.5927664 38.7470239,18.654279 38.7448576,17.6148616 C38.737456,13.955209 38.744677,10.295377 38.7421497,6.6355451 C38.7416081,5.53786442 38.8000983,4.44376919 38.4296603,3.36742185 C38.1465966,2.54474398 37.6400425,1.92661512 36.8661302,1.6448 C36.1478198,1.38324258 35.3553135,1.30095686 34.5869975,1.20612213 C34.1149238,1.14785882 33.6271442,1.22297367 33.1464052,1.22261513 C32.2598452,1.22171877 31.3732852,1.20415014 30.4867252,1.20325378 C29.795313,1.2025367 29.1037204,1.22422857 28.4123083,1.22207731 C27.0605344,1.21759552 25.7085799,1.1942902 24.3566256,1.1955451 C22.6299006,1.19697927 20.902995,1.2240493 19.1760895,1.22351149 C17.7044466,1.22315294 16.2328039,1.18568515 14.7611612,1.1885535 C12.1475152,1.19357311 9.53332747,1.24663753 6.9200424,1.21902969 C5.68705422,1.20612213 4.47374329,1.14893445 3.26693129,1.52038543 C2.40853321,1.78445267 1.77723604,2.30021737 1.48045234,3.07682241 C1.19450018,3.82510252 0.989784427,4.61533221 0.99628334,5.45970196 C1.0273337,9.53759552 0.984729717,13.6160269 1.03256894,17.6935619 C1.04069258,18.3842958 1.24649148,19.130604 1.56475769,19.7474779 C2.13467625,20.8521501 3.11222105,21.3320605 4.40983732,21.3230969 C9.56925202,21.2877804 14.7288473,21.3085759 19.8884425,21.3085759 M19.9458496,22.2305702 C14.7263199,22.2298532 9.50660972,22.2271642 4.28689954,22.2325423 C3.38553644,22.2334386 2.49572695,22.1622678 1.78608177,21.5557916 C1.28530443,21.12787 0.804204361,20.6770017 0.545872575,20.0171025 C0.148355738,19.0024247 0.0821029323,17.9673098 0.0873381678,16.8977748 C0.107737533,12.8944583 0.107376482,8.8907832 0.0904070988,4.88746667 C0.0831860846,3.19281121 0.746797297,1.86494565 2.1379257,0.894368627 C2.25580875,0.812082914 2.41683738,0.792900841 2.55295349,0.733203362 C2.85118138,0.602335014 3.14489614,0.461248179 3.44330455,0.330738375 C3.54981451,0.284307002 3.66228181,0.23464874 3.77547121,0.224071709 C4.01448678,0.201483473 4.25602971,0.19700168 4.49648949,0.19700168 C14.6653023,0.195926051 24.8341152,0.212060504 35.0027474,0.170290196 C35.9631424,0.166346219 36.7847132,0.506245378 37.5499602,0.878234174 C38.3861537,1.28464314 39.0232277,2.02431821 39.3599074,2.9983014 C39.6371945,3.80143865 39.7009199,4.59238543 39.7003783,5.41488404 C39.6971289,9.56753389 39.709224,13.7203631 39.6927962,17.8730128 C39.6872,19.2813715 39.2351644,20.5430857 38.1236698,21.471534 C37.4923727,21.998772 36.7256815,22.2337972 35.8759487,22.2300325 C32.8373458,22.2164079 29.798743,22.2293154 26.7601402,22.2309289 C24.4887701,22.2320044 22.2172196,22.2311081 19.9458496,22.2305702" id="Fill-4" fill="#E65C24" fillRule="nonzero" mask="url(#mask-4)" />
                                        </g>
                                    </g>
                                    <path d="M20.6843988,13.1807128 C20.6843988,14.4854684 20.6874071,15.7902238 20.6817444,17.0949794 C20.6806826,17.3401543 20.6732502,17.5912496 20.6201617,17.8291111 C20.5270799,18.2458041 20.3180881,18.3347844 19.8997508,18.2022716 C19.5509593,18.0916991 19.1860644,18.024659 18.84559,17.8947581 C18.5221041,17.7713 18.1738436,17.6443593 17.9190187,17.4256521 C17.2499266,16.8518941 16.6164038,16.2654244 16.1718762,15.4583322 C15.5518025,14.3322341 15.7185003,13.1673048 15.8206073,12.022923 C15.8717492,11.4489908 16.2428378,10.8625212 16.592691,10.3659026 C16.9331653,9.88251798 17.3768081,9.42612346 17.8726548,9.10206767 C18.587226,8.63522535 19.3785986,8.2578858 20.2862351,8.3033337 C20.5822919,8.31813475 20.67909,8.53161804 20.6796208,8.78880794 C20.6826292,10.2528923 20.6810366,11.7168026 20.6810366,13.1807128 L20.6843988,13.1807128 Z" id="Fill-7" fill="#E65C24" />
                                    <path d="M62.887281,13.1780377 C62.8879867,11.7832484 62.8860459,10.3884593 62.8886924,8.99367014 C62.8901039,8.33686743 62.98132,8.24258953 63.6298891,8.32464622 C64.9757231,8.49487021 66.0283247,9.13910253 66.8720292,10.201824 C67.9736793,11.589455 67.9791487,13.1677369 67.6767419,14.74759 C67.5064837,15.6367704 66.8647954,16.3583454 66.1719414,16.9859919 C65.6121183,17.4929974 65.0290059,17.925279 64.2410544,18.0061136 C64.0709726,18.0235725 63.9056545,18.1072005 63.7429829,18.1717983 C63.2253274,18.37694 62.9467391,18.2255716 62.9040421,17.6668878 C62.869814,17.2188932 62.8878102,16.7667084 62.8871045,16.3162695 C62.8855167,15.2701341 62.8865753,14.2241731 62.887281,13.1780377" id="Fill-9" fill="#E65C24" />
                                    <path d="M24.7818852,33.2958564 C24.8525067,33.2958564 24.9232981,33.2930523 24.9939198,33.2962302 C25.5319002,33.3207184 25.6407185,33.4308216 25.6490369,33.9561017 C25.6597321,34.6271891 25.5325792,34.801971 24.9990127,34.8503864 C24.1512138,34.9275895 23.7919942,34.442313 24.1086032,33.5590573 C24.1743017,33.3758635 24.5226562,33.3154843 24.7408023,33.1984646 C24.7545532,33.2309909 24.7681343,33.263517 24.7818852,33.2958564" id="Fill-11" fill="#E65C24" />
                                    <path d="M22.4873446,33.1984646 C22.7012272,33.295296 23.0742455,33.3581786 23.0987145,33.4953243 C23.1682482,33.8878583 23.231973,34.4379843 23.0399188,34.6837279 C22.8656439,34.9067102 22.3496852,34.8604164 21.9886372,34.8401628 C21.7221201,34.8253101 21.5263691,34.633769 21.515983,34.261103 C21.4915141,33.3878838 21.5790036,33.2806363 22.4873446,33.1984646" id="Fill-13" fill="#E65C24" />
                                    <path d="M28.1061606,33.1984916 C28.8849895,33.1969028 28.9568724,33.263233 28.9592486,33.9845241 C28.961427,34.7264689 28.8348895,34.8561504 28.1061606,34.8583348 C27.378818,34.860718 27.3071333,34.7856496 27.3045589,34.0184836 C27.3019846,33.2431751 27.3441638,33.1998817 28.1061606,33.1984916" id="Fill-15" fill="#E65C24" />
                                    <path d="M31.4414265,33.9882007 C31.4391927,34.7772398 31.3646678,34.8597627 30.653533,34.8583709 C29.9080804,34.85678 29.7813676,34.7207662 29.7868503,33.927949 C29.7913178,33.2548399 29.8664519,33.1955825 30.7103914,33.1985652 C31.4081237,33.2011502 31.4434571,33.2391307 31.4414265,33.9882007" id="Fill-17" fill="#E65C24" />
                                    <path d="M53.784483,67.2245219 C51.9987515,67.2245219 50.2128415,67.2258141 48.4269313,67.2235527 C48.068462,67.2230681 47.7389563,67.1939947 47.4487839,66.9305567 C47.2074206,66.7112135 47.1056903,66.4962312 47.1932964,66.215026 C47.2866235,65.9155691 47.4625505,65.6728056 47.8505199,65.6377559 C48.1161983,65.6136895 48.3818768,65.5708869 48.6477342,65.5705638 C52.1598393,65.5657183 55.6721232,65.567172 59.1840496,65.567172 C59.2584252,65.567172 59.3329797,65.5662028 59.4073554,65.5694332 C60.2033182,65.6036753 60.4091028,65.7776316 60.400521,66.4083647 C60.3935482,66.9339486 60.0520638,67.2174151 59.3653403,67.2212915 C57.713521,67.2306596 56.061344,67.2253295 54.4095247,67.2258141 L53.784483,67.2258141 L53.784483,67.2245219 Z" id="Fill-19" fill="#E65C24" />
                                    <path d="M53.7049238,69.6774126 C51.8445889,69.6774126 49.9838962,69.680162 48.1235614,69.6757953 C47.5364166,69.6745016 47.2914004,69.5179511 47.1882074,69.1121816 C47.0914528,68.7324499 47.2593873,68.468352 47.7896597,68.2474348 C48.011605,68.1549278 48.2643115,68.0714774 48.503426,68.0706688 C52.078338,68.0583777 55.6536076,68.0480272 59.2283409,68.0684046 C60.1298933,68.0735799 60.547494,68.5210746 60.3545214,69.237519 C60.3119564,69.3953632 60.1087898,69.5430186 59.9403188,69.639407 C59.8133394,69.7120219 59.6239438,69.7146095 59.46209,69.7150947 C58.3015714,69.7192995 57.1410529,69.7144478 55.9805344,69.713154 C55.2218784,69.7123453 54.4632223,69.7129922 53.704745,69.7129922 C53.704745,69.7010246 53.704745,69.6892185 53.7049238,69.6774126" id="Fill-21" fill="#E65C24" />
                                    <path d="M50.0381163,73.0303883 C49.3230919,73.0303883 48.6073367,73.0149123 47.8932261,73.0358694 C47.4301871,73.0494107 47.2618923,72.7631068 47.1791154,72.4763193 C47.1230171,72.2814199 47.216027,72.023166 47.3232897,71.827783 C47.514974,71.478447 47.8879269,71.3747909 48.3138716,71.3767253 C49.5158726,71.3820452 50.7178737,71.3726951 51.9196919,71.3815615 C52.4914556,71.3860753 52.8934626,71.7110689 52.9427999,72.1730886 C53.009131,72.7906732 52.7909509,73.0197486 52.0920068,73.0310331 C51.4074985,73.0419952 50.7228074,73.0334512 50.0381163,73.0334512 L50.0381163,73.0303883 Z" id="Fill-23" fill="#E65C24" />
                                    <path d="M35.5754742,50.027476 C35.6179252,51.3131072 35.2164907,52.3996694 34.5517194,53.3720778 C34.1932644,53.8962748 33.6350608,54.2515173 32.9956544,54.4323777 C32.6035556,54.5432048 32.2195595,54.7405228 31.8232332,54.7667852 C30.6479936,54.8441717 29.5699862,54.4987338 28.6262012,53.8061074 C28.366035,53.6150923 28.1884809,53.3036205 27.9968351,53.0311921 C27.4847815,52.3031989 27.3095172,51.4617522 27.3049375,50.6013967 C27.3010623,49.8762048 27.3170914,49.1272017 27.4930603,48.4308984 C27.7215204,47.5269473 28.3135438,46.7973784 29.098446,46.2779085 C30.316841,45.4714783 31.6865446,45.545188 32.987904,45.9112857 C33.6687045,46.1028259 34.3121622,46.5624177 34.7174719,47.2795557 C35.2214228,48.1710759 35.6045382,49.0678486 35.5754742,50.027476" id="Fill-25" fill="#E65C24" />
                                    <path d="M33.3684826,17.3249556 C34.5018828,17.3270743 35.4290832,17.0569314 35.9445829,16.6619578 C36.6596421,16.1139032 37.1910436,15.4463148 37.6011716,14.624586 C38.2825049,13.2590402 37.9267227,11.494813 37.1657055,10.4276604 C36.7150364,9.79538478 36.1714027,9.24962552 35.4711969,8.96129656 C34.8382682,8.70086469 34.124607,8.44555317 33.4675633,8.49181294 C32.7229722,8.544429 31.961955,8.71163509 31.2582542,9.1659342 C30.0724303,9.93151559 29.4585488,11.0066136 29.1235614,12.318484 C28.9379815,13.0461041 29.2205452,13.6937407 29.3928444,14.3795153 C29.6663214,15.4682088 30.4544242,16.1213189 31.2533614,16.7172223 C31.8852416,17.1884716 32.6661798,17.4833335 33.3684826,17.3249556 M33.566819,18.2591556 C32.9878866,18.2068926 32.3872858,18.2354959 31.835439,18.0832978 C31.0656846,17.8708914 30.4081167,17.4098828 29.8085643,16.8604157 C29.0293735,16.1462144 28.5302999,15.2349678 28.3040043,14.2534486 C28.0597099,13.194771 28.0329738,12.0905399 28.5053113,11.0163247 C28.7927679,10.3625083 29.1328229,9.76625172 29.5918798,9.23885512 C30.122757,8.62900315 30.7663452,8.16587584 31.5441381,7.92433632 C32.0028454,7.78202575 32.4652224,7.64677775 32.9330165,7.54030968 C33.5897106,7.39093656 34.2224646,7.49051863 34.8564417,7.72534872 C35.3964058,7.9253957 35.9865218,7.98772279 36.4382394,8.40335438 C36.8834912,8.81262968 37.3972434,9.16046072 37.7813344,9.62005674 C38.9785168,11.05305 39.0554048,12.7673096 38.7073115,14.4833349 C38.5035582,15.4874542 37.9134421,16.3856352 37.0818276,17.0127904 C35.7107732,18.0469256 35.2852676,18.2591556 33.566819,18.2591556" id="Fill-27" fill="#E65C24" fillRule="nonzero" />
                                    <path d="M49.9591236,17.2976144 C51.0381177,17.4085991 51.9142734,17.0182088 52.7424855,16.3613138 C53.7694967,15.5466015 54.2566597,14.4565481 54.4828551,13.2261733 C54.5541558,12.838434 54.5030511,12.3860123 54.3715136,12.0117041 C54.16288,11.4184309 53.8782041,10.8423003 53.5545409,10.302222 C53.1200633,9.57764044 52.3917774,9.15508573 51.67157,8.79244152 C51.2286626,8.5694118 50.6837215,8.54944163 50.1823334,8.4485304 C50.0562401,8.42325841 49.9023991,8.39233115 49.79457,8.44022422 C49.1059738,8.74702263 48.3265833,8.69630193 47.6525632,9.14996064 C46.625552,9.8418476 45.9404681,10.7664843 45.6485918,11.9143274 C45.2653943,13.4212802 45.6965354,14.8197225 46.7648167,15.9251511 C47.6183178,16.8082569 48.6397093,17.4741649 49.9591236,17.2976144 M55.3753433,13.0591662 C55.6006606,13.9071032 55.1558214,14.7292381 54.7879028,15.4619491 C54.3112768,16.4113277 53.5355743,17.1724916 52.5312177,17.7069147 C51.1287362,18.4534104 49.6777844,18.3148562 48.2659952,18.0347436 C47.2842933,17.8399902 46.4192015,17.1912247 45.8015546,16.3358651 C45.4794721,15.8896289 45.1638875,15.4204183 44.9540245,14.9158621 C44.7780558,14.4933074 44.6934081,14.0053636 44.6869103,13.5448125 C44.6769001,12.7979633 44.6524892,12.0203637 44.8375902,11.3092135 C45.0839815,10.3619557 45.6327862,9.54017428 46.3788094,8.87249894 C47.2707707,8.07386875 48.3469548,7.69690964 49.491981,7.50869519 C49.8988868,7.44171557 50.3440772,7.46380647 50.7483487,7.55287698 C51.8327868,7.79163542 52.9260059,8.09313201 53.7082063,8.93824146 C54.1930862,9.46241432 54.5574926,10.1087057 54.9261137,10.7300785 C55.3340732,11.4175473 55.4513857,12.1877244 55.3753433,13.0591662" id="Fill-29" fill="#E65C24" fillRule="nonzero" />
                                    <path d="M57.918573,13.9917519 C57.9194614,13.2825995 57.923015,13.2790414 58.6776198,13.2793972 C59.5215973,13.279753 59.5756119,13.3217399 59.573302,13.9753841 C59.5708145,14.7516088 59.3924244,14.940372 58.6626948,14.9393046 C57.9690341,14.938593 57.9173294,14.8727659 57.918573,13.9917519" id="Fill-31" fill="#E65C24" />
                                    <path d="M57.8656828,10.8913438 C57.9366671,10.8913438 58.0076513,10.889238 58.078465,10.8915352 C58.6391723,10.9106786 58.738994,11.0085013 58.745478,11.5441332 C58.7541804,12.25933 58.6490692,12.4057768 58.0974054,12.4450207 C58.0832427,12.4459779 58.06908,12.4457865 58.0547467,12.4465522 C57.2143681,12.4886677 56.9060303,12.0677047 57.1995228,11.1758145 C57.2616341,10.9870607 57.6058054,10.915273 57.8197819,10.789501 C57.8351391,10.8233848 57.8503257,10.8572686 57.8656828,10.8913438" id="Fill-33" fill="#E65C24" />
                                    <path d="M29.8018652,12.8506006 C29.5994917,10.8383751 31.4558025,9.21746611 33.2572198,9.13436589 C35.6932046,9.02253517 37.2146658,10.8883807 37.2331466,12.765682 C37.254921,14.9757479 35.5665839,16.5744726 33.4928954,16.5990209 C31.8051072,16.6188412 29.6307809,15.2445053 29.8018652,12.8506006" id="Fill-35" fill="#E65C24" />
                                    <path d="M50.2763118,9.16434937 C51.3364916,8.97373719 52.2164373,9.59445333 52.9609785,10.3505423 C53.5241876,10.9223789 53.8175028,11.6999094 53.7779793,12.5383123 C53.7516304,13.0948853 53.746141,13.6658133 53.6090898,14.1994911 C53.5132089,14.5730838 53.2645406,14.945041 52.99117,15.2295965 C52.1029903,16.1532206 51.021402,16.7568562 49.7024898,16.5629732 C48.4648204,16.3810831 47.11407,15.5782951 46.5892865,14.1953119 C46.1547115,13.0501851 46.3164649,12.0367969 46.775376,11.0524821 C47.0245934,10.5182592 47.5876194,10.1168652 48.043603,9.6923942 C48.6379185,9.13945531 49.4018555,9.15744446 50.2763118,9.16434937" id="Fill-37" fill="#E65C24" />
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

PageObject.propTypes = {
    className: PropTypes.string,
};

PageObject.defaultProps = {
    className: undefined,
};

export default PageObject;
