import React from 'react';
import PropTypes from 'prop-types';

const InteractiveExamples = props => {
    const { className } = props;
    return (
        <svg
            className={className}
            width="125px"
            height="99px"
            viewBox="0 0 125 99"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <g id="pages" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="Group-156">
                    <path
                        d="M5.84349903,7.10266797e-14 C2.6159068,7.10266797e-14 0,2.6159068 0,5.84349903 L0,66.2265786 L124.508744,66.2265786 L124.508744,5.84349903 C124.508744,2.6159068 121.892837,7.10266797e-14 118.665245,7.10266797e-14 L5.84349903,7.10266797e-14 Z"
                        id="Path"
                        fill="#1DE9B6"
                        fillRule="nonzero"
                    />
                    <path
                        d="M4.3708726e-14,66.2263864 L4.3708726e-14,72.0698854 C4.3708726e-14,75.2974777 2.6159068,77.9133845 5.84349903,77.9133845 L118.665245,77.9133845 C121.892837,77.9133845 124.508744,75.2974777 124.508744,72.0698854 L124.508744,66.2263864 L4.3708726e-14,66.2263864 Z"
                        id="Path"
                        fill="#E3E5ED"
                        fillRule="nonzero"
                    />
                    <g id="Group-152" transform="translate(41.125177, 77.842450)">
                        <path
                            d="M40.8135254,18.7320299 C39.555702,17.9034637 32.3548293,15.1848347 32.3548293,15.1848347 L32.318226,15.1837255 L30.4237265,0 L11.6329095,0 L9.73841004,15.1837255 L9.70180671,15.1848347 C9.70180671,15.1848347 2.49982483,17.9034637 1.24200141,18.7320299 L0.174958972,20.3636509 C-0.265390143,20.6531499 0.182723314,21.1456311 0.882623293,21.1456311 L21.0277634,21.1456311 L41.1729036,21.1456311 C41.8728035,21.1456311 42.320917,20.6531499 41.8816771,20.3636509 L40.8135254,18.7320299 Z"
                            id="Fill-2"
                            fill="#D5D7DF"
                        />
                        <polygon
                            id="Path"
                            fillOpacity="0.0871394231"
                            fill="#000000"
                            fillRule="nonzero"
                            points="31.1482104 5.91462524 30.4237265 6.0782447e-14 11.5820054 0.0711262136 10.9215495 5.91462524"
                        />
                    </g>
                    <g id="Group-155" transform="translate(34.409709, 18.250217)" fill="#FFFFFF">
                        <path
                            d="M1.20090496,12.7359223 L11.0378094,5.46359861 C11.2319029,5.28671858 11.5025511,5.24271845 11.7739726,5.24271845 C12.9362137,5.24271845 14.407767,6.65335921 14.407767,8.46000007 C14.407767,9.20976045 14.1363454,9.87064084 13.7102677,10.179521 L6.89379776,15.2034435 L13.7102677,20.2282462 C14.1363454,20.5371262 14.407767,21.1980065 14.407767,21.9477669 C14.407767,23.7544078 12.9362137,25.1650485 11.7739726,25.1650485 C11.5025511,25.1650485 11.2319029,25.1210486 11.0378094,24.9441684 L1.20090496,17.6718447 C0.310085532,17.0109645 0,15.9532039 0,15.2034435 C0,14.4545631 0.310085532,13.3968027 1.20090496,12.7359223 L1.20090496,12.7359223 Z"
                            id="Path"
                        />
                        <path
                            d="M38.0776699,2.24227276 C38.0776699,2.49648141 38.0372044,2.7920728 37.9158081,3.04628166 L23.6476919,33.5437242 C23.3636245,34.1788237 22.5939716,34.6019417 21.8235095,34.6019417 C20.4452564,34.6019417 19.5533981,33.417042 19.5533981,32.359669 C19.5533981,32.1054603 19.6351382,31.8098687 19.7565346,31.5556601 L33.9841853,1.05737304 C34.3087183,0.338663357 34.9569747,0 35.686162,0 C36.8216225,0 38.0776699,0.888463612 38.0776699,2.24227276 Z"
                            id="Path"
                        />
                        <path
                            d="M54.3719106,21.8665687 L44.5350062,29.1392136 C44.3409126,29.3152214 44.0702645,29.3592233 43.7988429,29.3592233 C42.6366019,29.3592233 41.1650485,27.9485202 41.1650485,26.1417996 C41.1650485,25.3928861 41.4364701,24.7310965 41.8625479,24.4230828 L48.6790178,19.3980583 L41.8625479,14.3730339 C41.4364701,14.06502 41.1650485,13.4032304 41.1650485,12.6543169 C41.1650485,10.8467163 42.6366019,9.4368932 43.7988429,9.4368932 C44.0702645,9.4368932 44.3409126,9.48089528 44.5350062,9.65690314 L54.3719106,16.930428 C55.2635032,17.5913376 55.5728155,18.649145 55.5728155,19.3980583 C55.5728155,20.1478517 55.2635032,21.2047791 54.3719106,21.8665687 L54.3719106,21.8665687 Z"
                            id="Path"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

InteractiveExamples.propTypes = {
    className: PropTypes.string,
};

InteractiveExamples.defaultProps = {
    className: undefined,
};

export default InteractiveExamples;
