import React from 'react';
import PropTypes from 'prop-types';

const UserAvatar = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="17px"
            height="16px"
            viewBox="0 0 17 16"
            version="1.1"
        >
            <g id="pages" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="user" transform="translate(-4.000000, -5.000000)" fillRule="nonzero">
                    <rect id="Rectangle" x="0" y="0" width="24" height="24" />
                    <path
                        d="M12.2082506,13.2387566 C10.001703,13.2387566 8.20692791,11.4439814 8.20692791,9.23743386 C8.20692791,7.03088625 10.001703,5.23611111 12.2082506,5.23611111 C14.4147983,5.23611111 16.2095734,7.03088625 16.2095734,9.23743386 C16.2095734,11.4439814 14.4147983,13.2387566 12.2082506,13.2387566 Z M12.2082506,5.96362434 C10.4032903,5.96362434 8.93444114,7.43247355 8.93444114,9.23743386 C8.93444114,11.0423942 10.4032903,12.5112434 12.2082506,12.5112434 C14.013211,12.5112434 15.4820602,11.0423942 15.4820602,9.23743386 C15.4820602,7.43247355 14.013211,5.96362434 12.2082506,5.96362434 Z"
                        id="Shape"
                        fill="#FFFFFF"
                    />
                    <path
                        d="M4.81705834,19.9502474 C4.70646477,20.1253539 4.47485911,20.1776519 4.29975263,20.0670583 C4.12464614,19.9564648 4.07234809,19.7248591 4.18294166,19.5497526 C6.24848468,16.2793095 8.94762126,14.625 12.25,14.625 C15.5523787,14.625 18.2515153,16.2793095 20.3170583,19.5497526 C20.4276519,19.7248591 20.3753539,19.9564648 20.2002474,20.0670583 C20.0251409,20.1776519 19.7935352,20.1253539 19.6829417,19.9502474 C17.7484847,16.8873572 15.2809546,15.375 12.25,15.375 C9.21904541,15.375 6.75151532,16.8873572 4.81705834,19.9502474 Z"
                        id="Line-2"
                        fill="#FFFFFF"
                    />
                </g>
            </g>
        </svg>
    );
};

UserAvatar.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

UserAvatar.defaultProps = {
    className: undefined,
    style: undefined,
};

export default UserAvatar;
