import React from 'react';
import PropTypes from 'prop-types';

const User = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="20px"
            height="21px"
            viewBox="0 0 20 21"
            version="1.1"
        >
            <defs>
                <ellipse
                    id="path-1"
                    cx="9.91701388"
                    cy="9.83002253"
                    rx="9.91701388"
                    ry="9.83002253"
                />
            </defs>
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="Components-Accordion" transform="translate(-367.000000, -2251.000000)">
                    <g id="user" transform="translate(367.000000, 2251.000000)">
                        <g id="Group-12" transform="translate(0.000000, 0.000104)">
                            <g id="Path">
                                <mask id="mask-2" fill="white">
                                    <use href="#path-1" />
                                </mask>
                                <use id="Mask" fill="#F0F2F6" fillRule="nonzero" href="#path-1" />
                                <path
                                    d="M13.2444268,17.4247834 L13.2423363,17.4247834 C13.0289964,17.2647056 12.8056218,17.1223451 12.5703312,16.9938684 C12.5642686,16.9899312 12.5583106,16.985994 12.5503665,16.9840254 C11.4375704,16.3752116 10.6838251,15.2009966 10.6838251,13.850955 L8.99874282,13.842977 C8.99874282,15.1970594 8.23893492,16.3771802 7.11620875,16.9839218 C7.11620875,16.9839218 7.11422273,16.9839218 7.11223671,16.9858904 C6.87485554,17.1143671 6.64761351,17.2586962 6.43218304,17.4168054 C5.93809447,17.781325 5.50572082,18.2231001 5.15327193,18.7241678 C4.50993862,19.6387786 15.2254626,19.8529019 14.6910034,18.9928971 C14.3125519,18.3839261 13.8206589,17.8516846 13.2444268,17.4247834 Z"
                                    fill="#ECC19C"
                                    fillRule="nonzero"
                                    mask="url(#mask-2)"
                                />
                                <path
                                    d="M15.533676,21.95079 L4.13279467,21.95079 C4.13279467,20.0926438 5.03611835,18.4460697 6.43207851,17.4161838 C6.64750898,17.2580745 6.87475102,17.1137454 7.11202766,16.9852687 C7.1141182,16.9833001 7.11610422,16.9833001 7.11610422,16.9833001 C7.29954938,16.8824874 7.47505047,16.7677908 7.63654493,16.6373455 C8.19492899,17.2047152 8.97470157,17.5565756 9.8382004,17.5565756 C10.6997132,17.5565756 11.4774998,17.2047152 12.0357793,16.6393141 C12.1952878,16.7697594 12.3689074,16.884456 12.550262,16.9833001 C12.558206,16.9852687 12.5642686,16.9892059 12.5702267,16.9931431 C12.8055173,17.1216198 13.0288918,17.2639803 13.2422317,17.4240581 L13.2443223,17.4240581 C14.6343244,18.453944 15.533676,20.0965809 15.533676,21.95079 Z"
                                    fill="#01AEEB"
                                    fillRule="nonzero"
                                    mask="url(#mask-2)"
                                />
                            </g>
                        </g>
                        <path
                            d="M5.45809448,5.42112144 L5.45809448,9.85937013 C5.45809448,12.8615808 8.11695173,15.2952819 9.83339215,15.2952819 C11.5496235,15.2952819 14.2086898,12.8615808 14.2086898,9.85937013 L14.2086898,5.42112144 L5.45809448,5.42112144 Z"
                            id="Path"
                            fill="#ECC19C"
                            fillRule="nonzero"
                        />
                        <path
                            d="M13.4959192,4.60425822 C12.5423179,3.42071833 11.0947213,2.66405267 9.47549117,2.66405267 C6.59879933,2.66405267 4.26899356,5.04418734 4.26899356,7.97936213 C4.26899356,9.53724586 4.92406524,10.9380564 5.97006849,11.9095062 C5.70059748,11.2391478 5.55007837,10.4877663 5.55007837,9.694319 C5.55007837,8.41918765 5.94100994,7.25139651 6.59085526,6.35330286 C7.28031638,6.65708811 8.39771167,6.76701859 9.62329257,6.59948082 C10.8384208,6.4345333 11.8738668,6.03656632 12.4576509,5.56265304 C13.52226,6.49473085 14.2143343,7.99770115 14.2143343,9.694319 C14.2143343,10.563609 14.0346521,11.3805758 13.7123949,12.0979732 C14.7398968,11.6763831 15.4954191,10.1735164 15.4954191,8.38509987 C15.4954191,6.47110771 14.6289935,4.89229472 13.4959192,4.60425822 Z"
                            id="Path"
                            fill="#494846"
                            fillRule="nonzero"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

User.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

User.defaultProps = {
    className: undefined,
    style: undefined,
};

export default User;
