import React from 'react';
import PropTypes from 'prop-types';

const TrashBorder = props => {
    const { className, style } = props;
    return (
        <svg className={className} style={style} width="13px" height="14px" viewBox="0 0 13 14">
            <g id="app-import-export" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="import-export-/-export-1-select_date-1"
                    transform="translate(-372.000000, -218.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g id="Group" transform="translate(86.000000, 160.000000)">
                        <path
                            d="M293.382812,58 C294.061293,58 294.613281,58.5519883 294.613281,59.2304688 L294.613281,59.2304688 L294.613281,59.640625 L297.074219,59.640625 C297.752699,59.640625 298.304688,60.1926133 298.304688,60.8710938 L298.304688,60.8710938 L298.304688,61.6914062 C298.304688,61.9179219 298.121047,62.1015625 297.894531,62.1015625 L297.894531,62.1015625 L297.452027,62.1015625 L296.73048,70.8774023 L296.73048,70.8774023 C296.672156,71.5189141 296.145352,72 295.50477,72 L295.50477,72 L288.799891,72 C288.159336,72 287.632504,71.5189141 287.57448,70.8809297 L287.57448,70.8809297 L287.57418,70.8774023 L286.85266,62.1015625 L286.410156,62.1015625 C286.183641,62.1015625 286,61.9179219 286,61.6914062 L286,61.6914062 L286,60.8710938 C286,60.1926133 286.551988,59.640625 287.230469,59.640625 L287.230469,59.640625 L289.691406,59.640625 L289.691406,59.2304688 C289.691406,58.5519883 290.243395,58 290.921875,58 L290.921875,58 Z M296.628953,62.1015625 L287.675734,62.1015625 L288.391539,70.8080312 C288.4115,71.0200273 288.586828,71.1796875 288.799891,71.1796875 L288.799891,71.1796875 L295.50477,71.1796875 C295.717832,71.1796875 295.893188,71.0200273 295.913121,70.8080312 L295.913121,70.8080312 L296.628953,62.1015625 Z M292.152344,62.921875 C292.378859,62.921875 292.5625,63.1055156 292.5625,63.3320312 L292.5625,63.3320312 L292.5625,69.1289062 C292.5625,69.3554219 292.378859,69.5390625 292.152344,69.5390625 C291.925828,69.5390625 291.742188,69.3554219 291.742188,69.1289062 L291.742188,69.1289062 L291.742188,63.3320312 C291.742188,63.1055156 291.925828,62.921875 292.152344,62.921875 Z M294.613281,62.921875 C294.839797,62.921875 295.023438,63.1055156 295.023438,63.3320312 L295.023438,63.3320312 L295.023438,69.1289062 C295.023438,69.3554219 294.839797,69.5390625 294.613281,69.5390625 C294.386766,69.5390625 294.203125,69.3554219 294.203125,69.1289062 L294.203125,69.1289062 L294.203125,63.3320312 C294.203125,63.1055156 294.386766,62.921875 294.613281,62.921875 Z M289.691406,62.921875 C289.917922,62.921875 290.101562,63.1055156 290.101562,63.3320312 L290.101562,63.3320312 L290.101562,69.1289062 C290.101562,69.3554219 289.917922,69.5390625 289.691406,69.5390625 C289.464891,69.5390625 289.28125,69.3554219 289.28125,69.1289062 L289.28125,69.1289062 L289.28125,63.3320312 C289.28125,63.1055156 289.464891,62.921875 289.691406,62.921875 Z M297.074219,60.4609375 L287.230469,60.4609375 C287.004309,60.4609375 286.820312,60.6449336 286.820312,60.8710938 L286.820312,60.8710938 L286.820312,61.28125 L297.484375,61.28125 L297.484375,60.8710938 C297.484375,60.6449336 297.300379,60.4609375 297.074219,60.4609375 L297.074219,60.4609375 Z M293.382812,58.8203125 L290.921875,58.8203125 C290.695715,58.8203125 290.511719,59.0043086 290.511719,59.2304688 L290.511719,59.2304688 L290.511719,59.640625 L293.792969,59.640625 L293.792969,59.2304688 C293.792969,59.0043086 293.608973,58.8203125 293.382812,58.8203125 L293.382812,58.8203125 Z"
                            id="trash"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

TrashBorder.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

TrashBorder.defaultProps = {
    className: undefined,
    style: undefined,
};

export default TrashBorder;
