import React from 'react';
import PropTypes from 'prop-types';

const Puzzle = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="22px"
            height="22px"
            viewBox="0 0 22 22"
            version="1.1"
        >
            <title>puzzle</title>
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="sidebar-component" transform="translate(-156.000000, -655.000000)">
                    <g id="Group-31" transform="translate(124.000000, 458.000000)">
                        <g id="puzzle" transform="translate(32.000000, 197.000000)">
                            <path
                                d="M19.6019129,10.1756077 C19.6835525,9.72879397 19.6003881,9.26770957 19.3675366,8.87698067 C19.2526139,8.70343423 19.3006218,8.47007261 19.4749228,8.35564734 C19.5403129,8.3127487 19.6178139,8.29088732 19.6964475,8.29353324 L21.8929188,8.29353324 L21.8929188,2.27093824 C21.8929188,1.02349458 20.8774772,0.0124488449 19.6246099,0.0124488449 L13.6098099,0.0124488449 L13.6098099,2.20318529 C13.6113347,2.41095521 13.7818455,2.57847242 13.9905188,2.57695427 C14.052903,2.57656388 14.114503,2.56077511 14.1693505,2.53067232 C14.5678337,2.28937294 15.0426416,2.20622159 15.5000673,2.2973107 C16.5272277,2.48213484 17.2096198,3.46116926 17.0239921,4.48427346 C16.8383644,5.50698727 15.8550733,6.18642527 14.8275208,6.00160113 C14.6131842,5.9628232 14.4071248,5.88791325 14.2184911,5.77912683 C14.0377861,5.67485149 13.8064158,5.73622819 13.7020792,5.91615087 C13.6657901,5.97826497 13.6484079,6.04979161 13.6514139,6.12166525 L13.6098099,8.29357661 L15.7571406,8.29357661 C15.9654653,8.28229892 16.143905,8.44114097 16.1552317,8.64891089 C16.1593703,8.72195568 16.1416396,8.7949571 16.1049584,8.85819896 C15.9378455,9.14391513 15.8501505,9.46875625 15.8516752,9.79923621 C15.8516752,10.8385196 16.6981307,11.6813107 17.7422812,11.6809203 C18.6560436,11.6809203 19.4389822,11.0297199 19.6019129,10.1342273 L19.6019129,10.1756077 Z"
                                fill="#FFDA45"
                            />
                            <path
                                d="M2.30233267,21.8740523 L8.31708911,21.8740523 L2.03767921,21.8740523 C2.12576634,21.8892761 2.21424554,21.8892761 2.30233267,21.8740523 Z"
                                fill="#FFA83D"
                            />
                            <path
                                d="M8.345972,15.8218312 C8.365112,15.7755493 8.365112,15.7288769 8.345972,15.6825516 L8.345972,15.7277058 C8.355542,15.7589364 8.355542,15.7905573 8.345972,15.8218312 Z"
                                fill="#FFA83D"
                            />
                            <path
                                d="M11.6930653,9.01626025 C11.6658376,8.8973239 11.6268911,8.7809901 11.5758772,8.66994814 C11.3278653,8.10307025 10.8163762,7.69390665 10.2073465,7.57457992 C9.7585901,7.49025743 9.29436832,7.57345215 8.90307327,7.80794154 C8.72877228,7.92236681 8.49439604,7.87456671 8.37947327,7.70102027 C8.33638812,7.63591325 8.31443168,7.55874776 8.31708911,7.4804545 L8.31708911,5.28221405 L2.26830891,5.28221405 C1.01544158,5.28221405 0,6.29325978 0,7.54070344 L0,8.66994814 L0,13.5633418 L2.26830891,13.5633418 L2.34768317,13.5633418 C2.39948119,13.5452541 2.44709703,13.5174069 2.48756832,13.4805375 L2.51026535,13.4579387 C2.6010099,13.316794 2.6010099,13.1360905 2.51026535,12.9949458 C2.43463762,12.8688524 2.37643564,12.7333465 2.33635644,12.5922018 C2.11104158,12.0098821 2.23049505,11.3507874 2.6463604,10.8832834 C2.91288713,10.5238284 3.30078416,10.2727261 3.73891089,10.1756077 C3.82094257,10.15752 3.90449901,10.1462423 3.98840396,10.1417313 C5.04505743,10.0502518 5.97620198,10.8290636 6.06803564,11.8811429 C6.07330693,11.9398736 6.07561584,11.9989514 6.07522376,12.0576822 C6.07674851,12.3881622 5.9890099,12.7130033 5.82194059,12.9987195 C5.71721188,13.1786421 5.77885545,13.4090108 5.9595604,13.5132862 C6.02346931,13.5501556 6.09639604,13.5675059 6.16975842,13.5633418 L7.27742574,13.5633418 L8.31704554,13.5633418 L8.31704554,11.3048524 C8.31704554,11.0150156 8.65349307,10.9096124 8.9068198,11.0564394 C9.19377822,11.2228289 9.52003168,11.3101443 9.85194851,11.3086261 C10.8957505,11.306761 11.7406812,10.4624517 11.7384158,9.42277793 C11.7384594,9.28614427 11.7229505,9.14990099 11.6930653,9.01626025 Z"
                                fill="#01B6F5"
                            />
                            <path
                                d="M14.4490772,13.5633418 C14.240404,13.56486 14.0721584,13.7346327 14.0736832,13.9424026 C14.0740752,14.0045167 14.0899327,14.0658501 14.1201663,14.1204602 C14.6550931,15.0133069 14.3617307,16.1685337 13.465002,16.7007544 C13.2930099,16.8027742 13.1058574,16.8772937 12.9103842,16.9209731 C12.6423327,16.9774484 12.3656119,16.9774484 12.0975604,16.9209731 C11.077196,16.7007544 10.4296119,15.6987742 10.6507446,14.682827 C10.6915644,14.4946195 10.7615287,14.3139595 10.8575446,14.1468326 C10.9736,13.9740669 10.9271168,13.7403149 10.7536,13.6247619 C10.7033267,13.5912758 10.6454733,13.5701952 10.5853545,13.5633852 L8.31704554,13.5633852 L8.31704554,15.6713173 C8.32610693,15.7209826 8.32610693,15.7722093 8.31704554,15.8218746 C8.25505347,16.0484696 8.01989307,16.1821103 7.79231287,16.1199962 C7.77000792,16.113967 7.74809505,16.1060726 7.72727129,16.0966601 C7.44109703,15.9284055 7.11445149,15.8410901 6.78214257,15.8444734 C5.74853465,15.8505026 4.91571485,16.68952 4.9217703,17.7186535 C4.92782574,18.7477869 5.77049109,19.5770014 6.80409901,19.5709722 C7.14320396,19.569107 7.47512079,19.475372 7.76508515,19.2999604 C7.94844752,19.2001961 8.17790099,19.2672117 8.27809901,19.4493899 C8.30872475,19.5050844 8.32458218,19.5675889 8.32458218,19.6311777 L8.31700198,21.8444696 L14.3657822,21.8444696 C15.6186495,21.8444696 16.6340911,20.8334239 16.6340911,19.5859802 L16.6340911,13.5633418 L14.4490772,13.5633418 Z"
                                fill="#35CBFF"
                            />
                            <polygon
                                fill="#FFA83D"
                                points="8.35030693 13.6010424 8.35030693 13.6010424 8.35030693 13.610571"
                            />
                            <path
                                d="M7.76512871,19.2998736 C6.89183762,19.8697445 5.72026139,19.6265799 5.14786931,18.7574597 C4.57552079,17.8883395 4.81974257,16.7214446 5.69264158,16.1515304 C6.01549703,15.9407242 6.39581386,15.8334559 6.78179406,15.8443866 C7.11410297,15.8410033 7.44074851,15.9283187 7.72692277,16.0965733 C7.94165149,16.194429 8.19493465,16.100347 8.29325941,15.8865479 C8.30271287,15.8654672 8.31064158,15.8439962 8.31669703,15.8217878 C8.32048713,15.7905573 8.32048713,15.7589364 8.31669703,15.7277058 L8.31669703,13.5633418 L7.27707723,13.5633418 L6.1694099,13.5633418 C5.96108515,13.5746195 5.78264554,13.4157775 5.77131881,13.2080075 C5.7671802,13.1349628 5.78491089,13.0619613 5.82159208,12.9987195 C5.98870495,12.7130033 6.0764,12.3881622 6.07487525,12.0576822 C6.07448317,11.0014823 5.21482772,10.145505 4.15399208,10.1458953 C4.09840396,10.1458953 4.04320792,10.1481509 3.98801188,10.1530523 C3.90406337,10.1575634 3.8205505,10.1688411 3.73851881,10.1869288 C3.31132673,10.2810108 2.9310099,10.5223102 2.66487525,10.868232 C2.2490099,11.3353456 2.12955644,11.9944404 2.35487129,12.5771504 C2.3949505,12.7182951 2.45315248,12.853801 2.5287802,12.9798944 C2.61952475,13.1210391 2.61952475,13.3017426 2.5287802,13.4428873 L2.50608317,13.4654861 C2.46561188,13.5023555 2.41799604,13.5302461 2.36619802,13.5482904 L2.26826535,13.5633418 L0,13.5633418 L0,19.5859368 C0.0143762376,20.7407732 0.885750495,21.7066648 2.03767921,21.8444262 L8.31708911,21.8444262 L8.31708911,19.6311344 C8.31556436,19.4233645 8.14470495,19.2562376 7.93603168,19.2577124 C7.87665347,19.2581028 7.81805941,19.2727638 7.76512871,19.2998736 Z"
                                fill="#FFCC00"
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

Puzzle.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Puzzle.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Puzzle;
