import React from 'react';
import PropTypes from 'prop-types';

const Picture = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            fill="currentColor"
            width="50px"
            height="40px"
            viewBox="0 0 50 40"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
        >
            <title>picture</title>
            <g id="Campaigns" stroke="none" strokeWidth="1" fillRule="evenodd">
                <g
                    id="new-campaign-with-upload-image-gallery"
                    transform="translate(-384.000000, -305.000000)"
                >
                    <path
                        d="M427.749514,305 C431.194617,305 433.999771,307.805154 433.999771,311.250257 L433.999771,311.250257 L433.999771,338.749743 C433.999771,342.194846 431.194617,345 427.749514,345 L427.749514,345 L390.2498,345 C386.805154,345 384,342.194846 384,338.749743 L384,338.749743 L384,311.250257 C384,307.805154 386.805154,305 390.2498,305 L390.2498,305 Z M427.749514,310.000114 L390.2498,310.000114 C389.559955,310.000114 389.000114,310.559955 389.000114,311.250257 L389.000114,311.250257 L389.000114,334.847337 L395.899934,327.949807 C397.607379,326.240072 400.390103,326.240072 402.099838,327.949807 L402.099838,327.949807 L405.124717,330.967362 L414.409924,319.822732 C415.239844,318.827562 416.454739,318.252615 417.749743,318.245291 C419.05207,318.275045 420.264677,318.800096 421.102378,319.782449 L421.102378,319.782449 L428.999657,328.99762 L428.999657,311.250257 C428.999657,310.559955 428.439816,310.000114 427.749514,310.000114 L427.749514,310.000114 Z M396.500057,312.499943 C399.257605,312.499943 401.499714,314.74251 401.499714,317.500057 C401.499714,320.257604 399.257605,322.500172 396.500057,322.500172 C393.74251,322.500172 391.499943,320.257604 391.499943,317.500057 C391.499943,314.74251 393.74251,312.499943 396.500057,312.499943 Z"
                        id="picture"
                    />
                </g>
            </g>
        </svg>
    );
};

Picture.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};
Picture.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Picture;
