import React from 'react';
import PropTypes from 'prop-types';

const Photographer = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="56px"
            height="56px"
            viewBox="0 0 56 56"
            version="1.1"
        >
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="Components-VisualPicker" transform="translate(-526.000000, -997.000000)">
                    <g id="Group-6-Copy" transform="translate(203.000000, 796.000000)">
                        <g id="Group-51" transform="translate(65.000000, 66.000000)">
                            <g id="card-2" transform="translate(213.000000, 102.000000)">
                                <g id="photographer" transform="translate(45.000000, 33.000000)">
                                    <polygon
                                        fill="#E7ECED"
                                        points="7.72413793 0 56 0 56 32.8275862 7.72413793 32.8275862"
                                    />
                                    <polygon
                                        fill="#01B6F5"
                                        points="11.5862069 3.86206897 52.137931 3.86206897 52.137931 28.9655172 11.5862069 28.9655172"
                                    />
                                    <polygon
                                        fill="#4DCF8C"
                                        points="11.5862069 19.3103448 24.137931 9.65517241 38.6206897 19.3103448 44.4137931 15.4482759 52.137931 20.2758621 52.137931 28.9655172 11.5862069 28.9655172"
                                    />
                                    <path
                                        d="M41.5172414,10.6206897 C41.5172414,12.220299 40.220299,13.5172414 38.6206897,13.5172414 C37.0210803,13.5172414 35.7241379,12.220299 35.7241379,10.6206897 C35.7241379,9.02108031 37.0210803,7.72413793 38.6206897,7.72413793 C40.220299,7.72413793 41.5172414,9.02108031 41.5172414,10.6206897 Z"
                                        fill="#FFC453"
                                    />
                                    <path
                                        d="M47.9387796,28.9655172 L11.5862069,28.9655172 L11.5862069,25.1034483 L9.65517241,25.1034483 C8.99703664,25.1048626 8.34408678,25.2184806 7.72413793,25.4405307 L7.72413793,32.8275862 L48.2758621,32.8275862 L48.2758621,30.8965517 C48.2744477,30.2384159 48.1608297,29.5854661 47.9387796,28.9655172 Z"
                                        fill="#C2C2C0"
                                    />
                                    <path
                                        d="M47.9387796,28.9655172 C47.1212958,26.6530846 44.9356816,25.1058055 42.4827586,25.1034483 L37.6551724,25.1034483 L34.9052398,20.2904769 C34.2178744,19.0873519 32.937904,18.3448276 31.5523303,18.3448276 L24.4476697,18.3448276 C23.062096,18.3448276 21.7821256,19.0873519 21.0947602,20.2904769 L18.3448276,25.1034483 L11.5862069,25.1034483 L11.5862069,28.9655172 L47.9387796,28.9655172 Z"
                                        fill="#3EBA7A"
                                    />
                                    <path
                                        d="M33.7931034,25.1034483 L31.0431708,20.2904769 C30.3558055,19.0873519 29.0758351,18.3448276 27.6902613,18.3448276 L20.5856007,18.3448276 C19.200027,18.3448276 17.9200566,19.0873519 17.2326912,20.2904769 L14.4827586,25.1034483 L5.79310345,25.1034483 C2.59388476,25.1034483 -2.84217094e-14,27.697333 -2.84217094e-14,30.8965517 L-2.84217094e-14,50.2068966 C-2.84217094e-14,53.4061152 2.59388476,56 5.79310345,56 L38.6206897,56 C41.8199083,56 44.4137931,53.4061152 44.4137931,50.2068966 L44.4137931,30.8965517 C44.4137931,27.697333 41.8199083,25.1034483 38.6206897,25.1034483 L33.7931034,25.1034483 Z"
                                        fill="#5C5C5B"
                                    />
                                    <g
                                        id="Group"
                                        transform="translate(3.862069, 23.172414)"
                                        fill="#878787"
                                    >
                                        <path d="M3.86206897,7.72413793 C3.86206897,8.79054424 2.99744079,9.65517241 1.93103448,9.65517241 C0.864628172,9.65517241 0,8.79054424 0,7.72413793 C0,6.65773162 0.864628172,5.79310345 1.93103448,5.79310345 C2.99744079,5.79310345 3.86206897,6.65773162 3.86206897,7.72413793 Z" />
                                        <polygon points="16.4137931 0 24.137931 0 24.137931 1.93103448 16.4137931 1.93103448" />
                                        <polygon points="32.8275862 6.75862069 37.6551724 6.75862069 37.6551724 8.68965517 32.8275862 8.68965517" />
                                    </g>
                                    <polygon
                                        fill="#4A4A49"
                                        points="7.72413793 35.7241379 9.65517241 35.7241379 9.65517241 51.1724138 7.72413793 51.1724138"
                                    />
                                    <polygon
                                        fill="#4A4A49"
                                        points="11.5862069 28.9655172 13.5172414 28.9655172 13.5172414 30.8965517 11.5862069 30.8965517"
                                    />
                                    <path
                                        d="M36.6896552,37.6551724 L35.3446256,37.6551724 C35.8504849,39.5532058 35.8504849,41.5502425 35.3446256,43.4482759 L36.6896552,43.4482759 C38.2892645,43.4482759 39.5862069,42.1513335 39.5862069,40.5517241 C39.5862069,38.9521148 38.2892645,37.6551724 36.6896552,37.6551724 Z"
                                        fill="#4A4A4A"
                                    />
                                    <path
                                        d="M35.7241379,40.5517241 C35.7241379,46.9506331 30.5368399,52.137931 24.137931,52.137931 C17.7390221,52.137931 12.5517241,46.9506331 12.5517241,40.5517241 C12.5517241,34.1528152 17.7390221,28.9655172 24.137931,28.9655172 C30.5368399,28.9655172 35.7241379,34.1528152 35.7241379,40.5517241 Z"
                                        fill="#CFCFCD"
                                    />
                                    <path
                                        d="M14.5520609,47.0581223 C16.9125808,50.5538793 20.9867996,52.4896282 25.1878368,52.1115302 C29.3884024,51.7334322 33.0515221,49.1013605 34.7496632,45.2407058 C36.4482759,41.3795797 35.9127155,36.9008621 33.3527747,33.5488954 C28.3667833,39.6536234 21.2046066,44.0276805 14.5520609,47.0581223 L14.5520609,47.0581223 Z"
                                        fill="#C2C2C0"
                                    />
                                    <path
                                        d="M30.8965517,40.5517241 C30.8965517,44.2846175 27.8708244,47.3103448 24.137931,47.3103448 C20.4050377,47.3103448 17.3793103,44.2846175 17.3793103,40.5517241 C17.3793103,36.8188308 20.4050377,33.7931034 24.137931,33.7931034 C27.8708244,33.7931034 30.8965517,36.8188308 30.8965517,40.5517241 Z"
                                        fill="#757574"
                                    />
                                    <polygon
                                        fill="#04A4DB"
                                        points="11.5862069 3.86206897 52.137931 3.86206897 52.137931 5.79310345 11.5862069 5.79310345"
                                    />
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

Photographer.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Photographer.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Photographer;
