import React from 'react';
import PropTypes from 'prop-types';

const PhoneSolid = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="12px"
            height="12px"
            viewBox="0 0 12 12"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
        >
            <title>PhoneSolid</title>
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="Components-WeeklyCalendar-PhoneSolid"
                    transform="translate(-1177.000000, -170.000000)"
                    fillRule="nonzero"
                >
                    <g id="Group-29" transform="translate(1151.000000, 0.000000)">
                        <g id="Group-26">
                            <g id="Group-25">
                                <g id="Group-22" transform="translate(21.000000, 162.000000)">
                                    <g id="Group-20" transform="translate(0.000000, 3.000000)">
                                        <g id="phone" transform="translate(5.000000, 5.000000)">
                                            <path
                                                d="M8.07180144,11.9084727 C6.40362144,11.5368327 4.58970144,10.5255927 3.02895144,8.9648427 C1.46799144,7.4038827 0.456751444,5.5899327 0.0851414439,3.9216927 C-0.245458556,2.4375327 0.406261444,0.907472703 1.70058144,0.109472703 C1.99071144,-0.0694172966 2.36574144,-0.0255272966 2.60676144,0.215492703 L4.39683144,2.0055627 C4.73262144,2.3413527 4.66698144,2.9026227 4.26273144,3.1518327 L3.53127144,3.6028227 C3.22428144,3.7920927 3.09930144,4.1759127 3.23709144,4.5091827 C3.53616144,5.2324527 4.07655144,6.2334627 5.04375144,7.1640027 C5.90889144,7.9963227 6.81060144,8.4789627 7.48737144,8.7581127 C7.81959144,8.8951527 8.20224144,8.7687327 8.39085144,8.4628227 L8.84199144,7.7310927 C9.09123144,7.3268427 9.65247144,7.2612027 9.98826144,7.5969927 L11.7780614,9.3867927 C12.0190814,9.6278127 12.0629414,10.0028427 11.8840814,10.2929727 C11.0860214,11.5873227 9.55596144,12.2391027 8.07180144,11.9084727 Z"
                                                id="Path"
                                                fill="#9398A5"
                                            />
                                            <path
                                                d="M8.74401144,7.8901527 L11.5743614,10.7204727 C11.6866814,10.5870327 11.7905414,10.4446227 11.8840214,10.2930027 L11.8840814,10.2929127 C12.0629714,10.0027827 12.0191114,9.6277527 11.7780614,9.3867327 L9.98826144,7.5969327 C9.65247144,7.2611427 9.09120144,7.3267827 8.84199144,7.7310327 L8.74401144,7.8899427 L8.74401144,7.8901527 Z"
                                                id="Path"
                                                fill="#D3D4D7"
                                            />
                                            <path
                                                d="M4.10373144,3.2498127 L4.26273144,3.1518027 C4.66695144,2.9025627 4.73262144,2.3413227 4.39683144,2.0055327 L2.60676144,0.215462703 C2.36574144,-0.0255572966 1.99071144,-0.0694172966 1.70058144,0.109442703 C1.54893144,0.202922703 1.40649144,0.306812703 1.27305144,0.419162703 L4.10367144,3.2498127 L4.10373144,3.2498127 Z"
                                                id="Path"
                                                fill="#D3D4D7"
                                            />
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

PhoneSolid.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

PhoneSolid.defaultProps = {
    className: undefined,
    style: undefined,
};

export default PhoneSolid;
