import React from 'react';
import PropTypes from 'prop-types';

const Phone = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="20px"
            height="20px"
            viewBox="0 0 20 20"
            version="1.1"
        >
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="Components-BadgeOverlay"
                    transform="translate(-503.000000, -1785.000000)"
                    fill="#A8ACB3"
                    fillRule="nonzero"
                >
                    <path
                        d="M521.395208,1798.12771 C520.170729,1798.12771 518.968438,1797.9362 517.829115,1797.55969 C517.261094,1797.36599 516.614375,1797.5163 516.243802,1797.89391 L513.995,1799.59151 C511.387031,1798.19937 509.780573,1796.59344 508.407448,1794.00505 L510.055104,1791.81484 C510.483177,1791.38734 510.636719,1790.76286 510.45276,1790.17693 C510.074635,1789.03161 509.882552,1787.8299 509.882552,1786.6049 C509.882604,1785.71995 509.162656,1785 508.27776,1785 L504.604792,1785 C503.719948,1785 503,1785.71995 503,1786.60479 C503,1796.74807 511.251979,1805 521.395208,1805 C522.280104,1805 523.000052,1804.28005 523.000052,1803.39516 L523.000052,1799.7325 C523.000052,1798.84766 522.280052,1798.12771 521.395208,1798.12771 Z M521.888906,1803.39521 C521.888906,1803.66755 521.667552,1803.88891 521.395208,1803.88891 C511.864479,1803.88891 504.111146,1796.13552 504.111146,1786.60484 C504.111146,1786.3325 504.3325,1786.11115 504.604844,1786.11115 L508.277812,1786.11115 C508.550156,1786.11115 508.77151,1786.3325 508.77151,1786.60484 C508.77151,1787.9487 508.982552,1789.2676 509.395417,1790.51708 C509.452917,1790.70156 509.40625,1790.8925 509.219635,1791.08677 L507.309896,1793.61599 C507.181875,1793.78578 507.161771,1794.01312 507.257812,1794.20245 C508.81651,1797.26615 510.710521,1799.16016 513.795885,1800.74109 C513.983594,1800.83927 514.213646,1800.8187 514.38401,1800.6901 L516.971354,1798.72995 C517.102083,1798.59922 517.297969,1798.55255 517.474844,1798.61276 C518.732969,1799.02833 520.051875,1799.23885 521.395208,1799.23885 C521.667552,1799.23885 521.888906,1799.46021 521.888906,1799.73255 L521.888906,1803.39521 Z"
                        id="Shape"
                    />
                </g>
            </g>
        </svg>
    );
};

Phone.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Phone.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Phone;
