import React from 'react';
import PropTypes from 'prop-types';

const PencilBorder = props => {
    const { className, style } = props;
    return (
        <svg className={className} style={style} width="14px" height="14px" viewBox="0 0 14 14">
            <g id="app-import-export" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="import-export-/-export-1-select_date-1"
                    transform="translate(-861.000000, -218.000000)"
                    fill="currentColor"
                    fillRule="nonzero"
                >
                    <g id="Group" transform="translate(86.000000, 160.000000)">
                        <path
                            d="M788.976274,60.1855896 C788.975739,59.6006902 788.747483,59.0511455 788.333482,58.6381058 C787.479632,57.786178 786.091511,57.7873529 785.238622,58.6413101 L776.428282,67.487111 C776.141707,67.7734724 775.922957,68.1279794 775.795638,68.5123937 L775.787414,68.5373876 L775,72 L778.472225,71.2226265 L778.498074,71.2140816 C778.882595,71.0867624 779.237316,70.8682263 779.524638,70.5810104 L788.336153,61.7341414 C788.749406,61.320354 788.976808,60.770382 788.976274,60.1855896 Z M776.925489,70.4488847 L776.55731,70.0804921 L776.823164,68.9111207 L778.097745,70.186449 L776.925489,70.4488847 Z M787.562304,60.9623222 L779.007885,69.5511347 L777.458799,68.0010875 L783.31858,62.117808 L784.210882,63.0101106 L784.983663,62.23733 L784.089758,61.3434253 L784.921071,60.5089077 L785.816578,61.4044146 L786.589359,60.631634 L785.69225,59.734525 L786.012364,59.4131294 C786.439075,58.9858838 787.134097,58.9852429 787.561556,59.4117408 C787.76877,59.6185277 787.883059,59.8936739 787.883379,60.1864441 C787.883593,60.4793209 787.769839,60.7545739 787.562304,60.9623222 Z M780.749231,70.8952495 L788.976273,70.8952495 L788.976273,71.9881439 L779.660075,71.9881439 L780.749231,70.8952495 Z"
                            id="pencil"
                        />
                    </g>
                </g>
            </g>
        </svg>
    );
};

PencilBorder.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

PencilBorder.defaultProps = {
    className: undefined,
    style: undefined,
};

export default PencilBorder;
