import React from 'react';
import PropTypes from 'prop-types';

const Pencil = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="16px"
            height="18px"
            viewBox="0 0 16 18"
            version="1.1"
        >
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="Components-Button-Menu"
                    transform="translate(-1044.000000, -3013.000000)"
                    fillRule="nonzero"
                >
                    <g id="Group-33" transform="translate(204.000000, 2851.000000)">
                        <g id="Group-32" transform="translate(823.000000, 110.000000)">
                            <g id="Group-167" transform="translate(17.000000, 51.000000)">
                                <g
                                    id="Group-166"
                                    transform="translate(0.000000, 17.779514)"
                                    fill="#35495E"
                                >
                                    <path
                                        d="M2.08711274,1.12552524 L0.347852123,1.12552524 C0.1557387,1.12552524 0,0.969786518 0,0.777673113 C0,0.585559707 0.1557387,0.42982099 0.347852123,0.42982099 L2.08711274,0.42982099 C2.27922614,0.42982099 2.43496486,0.585559707 2.43496486,0.777673113 C2.43496486,0.969786518 2.27922614,1.12552524 2.08711274,1.12552524 Z"
                                        id="Shape"
                                    />
                                    <path
                                        d="M9.57575726,1.12552524 L4.01012329,1.12552524 C3.81800988,1.12552524 3.66227116,0.969786518 3.66227116,0.777673113 C3.66227116,0.585559707 3.81800988,0.42982099 4.01012329,0.42982099 L9.57575726,0.42982099 C9.76787066,0.42982099 9.92360938,0.585559707 9.92360938,0.777673113 C9.92360938,0.969786518 9.76787066,1.12552524 9.57575726,1.12552524 Z"
                                        id="Shape"
                                    />
                                </g>
                                <g
                                    id="Group-164"
                                    transform="translate(9.150484, 9.876543) rotate(-150.000000) translate(-9.150484, -9.876543) translate(6.826592, 0.000000)"
                                >
                                    <polygon
                                        id="Path"
                                        fill="#FADFB2"
                                        points="4.58232328 3.92770567 2.29116164 0 0 3.92770567 1.30923522 4.90963208 2.29116164 3.92770567 3.27308806 4.90963208"
                                    />
                                    <polygon
                                        id="Path"
                                        fill="#35495E"
                                        points="3.43674246 1.96385283 1.14558082 1.96385283 2.29116164 0"
                                    />
                                    <path
                                        d="M4.58232328,3.92770567 L4.58232328,17.3473667 C4.58232328,18.6127425 3.55653748,19.6385283 2.29116164,19.6385283 C1.0257858,19.6385283 0,18.6127425 0,17.3473667 L0,3.92770567 L1.30923522,4.90963208 L2.29116164,3.92770567 L3.27308806,4.90963208 L4.58232328,3.92770567 Z"
                                        id="Path"
                                        fill="#243242"
                                    />{' '}
                                    <polygon
                                        id="Path"
                                        fill="#F7B500"
                                        points="3.27308806 17.3473667 3.27308806 4.90963208 2.29116164 3.92770567 1.30923522 4.90963208 1.30923522 17.3473667"
                                    />
                                    <path
                                        d="M0,17.3473667 C0,18.6127425 1.0257858,19.6385283 2.29116164,19.6385283 C3.55653748,19.6385283 4.58232328,18.6127425 4.58232328,17.3473667 L0,17.3473667 Z"
                                        id="Path"
                                        fill="#B8B8B8"
                                    />
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

Pencil.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Pencil.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Pencil;
