import React from 'react';
import PropTypes from 'prop-types';

const Paris = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            height="480pt"
            viewBox="0 0 480 480"
            width="480pt"
            version="1.1"
        >
            <path
                d="m440 312c17.671875 0 32 14.328125 32 32v48c0 17.671875-14.328125 32-32 32s-32-14.328125-32-32v-48c0-17.671875 14.328125-32 32-32zm0 0"
                fill="#85bc94"
            />
            <path
                d="m40 328c17.671875 0 32 14.328125 32 32v48c0 17.671875-14.328125 32-32 32s-32-14.328125-32-32v-48c0-17.671875 14.328125-32 32-32zm0 0"
                fill="#fd9226"
            />
            <path d="m256 72h-32v-24l8-8h16l8 8zm0 0" fill="#5d9aa4" />
            <path
                d="m276.3125 268.367188-20.3125-196.367188h-32l-20.3125 196.367188c-2.445312 23.660156-7.914062 46.90625-16.261719 69.175781l-11.425781 30.457031 11 8 18.9375 2.777344 10.0625-10.777344 16-56h16l20 56 11.113281 8 13.734375 3.585938 11.152344-11.585938-11.425781-30.457031c-8.347657-22.269531-13.816407-45.515625-16.261719-69.175781zm0 0"
                fill="#64a8b2"
            />
            <path
                d="m320 400-9.503906 8.488281-146-.488281-4.496094-8-8-32h176zm0 0"
                fill="#5d9aa4"
            />
            <path
                d="m160 400-32 72h56l7.535156-12.558594c10.214844-17.027344 28.613282-27.441406 48.464844-27.441406s38.25 10.414062 48.464844 27.441406l7.535156 12.558594h56l-32-72zm0 0"
                fill="#64a8b2"
            />
            <path
                d="m416 144c0 17.671875-14.328125 32-32 32s-32-14.328125-32-32 14.328125-32 32-32 32 14.328125 32 32zm0 0"
                fill="#fd9226"
            />
            <g fill="#fbedbf">
                <path d="m338.683594 98.804688 39.597656-40.398438 11.429688 11.203125-39.59375 40.398437zm0 0" />
                <path d="m319.425781 87.511719 16-.160157.570313 56.574219-16 .160157zm0 0" />
                <path d="m298.398438 149.714844 11.203124-11.433594 40.402344 39.597656-11.207031 11.429688zm0 0" />
                <path d="m327.347656 192.582031 56.574219-.578125.164063 16-56.574219.578125zm0 0" />
                <path d="m378.289062 218.402344 39.59375-40.398438 11.433594 11.203125-39.597656 40.398438zm0 0" />
                <path d="m432.007812 144.078125 16-.160156.570313 56.570312-16 .164063zm0 0" />
                <path d="m418 110.117188 11.207031-11.433594 40.398438 39.59375-11.207031 11.433594zm0 0" />
                <path d="m383.917969 80.007812 56.574219-.578124.164062 16-56.574219.578124zm0 0" />
            </g>
            <path
                d="m240 48c-4.417969 0-8-3.582031-8-8v-32c0-4.417969 3.582031-8 8-8s8 3.582031 8 8v32c0 4.417969-3.582031 8-8 8zm0 0"
                fill="#5d9aa4"
            />
            <path
                d="m88 192c0-17.671875-14.328125-32-32-32s-32 14.328125-32 32c-8.835938 0-16 7.164062-16 16v16h96v-16c0-8.835938-7.164062-16-16-16zm0 0"
                fill="#ebebeb"
            />
            <path
                d="m120 224c0-17.671875-14.328125-32-32-32s-32 14.328125-32 32c-8.835938 0-16 7.164062-16 16v16h96v-16c0-8.835938-7.164062-16-16-16zm0 0"
                fill="#ebebeb"
            />
            <path
                d="m88 192c0-17.671875-14.328125-32-32-32s-32 14.328125-32 32c-8.835938 0-16 7.164062-16 16v16h96v-16c0-8.835938-7.164062-16-16-16zm0 0"
                fill="#eaeae8"
            />
            <path
                d="m120 224c0-17.671875-14.328125-32-32-32s-32 14.328125-32 32c-8.835938 0-16 7.164062-16 16v16h96v-16c0-8.835938-7.164062-16-16-16zm0 0"
                fill="#f5f5f5"
            />
            <path
                d="m40 480c-4.417969 0-8-3.582031-8-8v-128c0-4.417969 3.582031-8 8-8s8 3.582031 8 8v128c0 4.417969-3.582031 8-8 8zm0 0"
                fill="#a45e14"
            />
            <path
                d="m32 329.128906v109.742188c2.609375.714844 5.296875 1.09375 8 1.128906 2.703125-.035156 5.390625-.414062 8-1.128906v-109.742188c-2.609375-.714844-5.296875-1.09375-8-1.128906-2.703125.035156-5.390625.414062-8 1.128906zm0 0"
                fill="#a45e14"
            />
            <path
                d="m72 360c-.035156-5.195312-1.347656-10.296875-3.824219-14.863281-.335937.132812-.660156.285156-.976562.464843l-32 24c-3.535157 2.648438-4.25 7.664063-1.597657 11.199219 2.648438 3.535157 7.664063 4.25 11.199219 1.597657l27.199219-20.398438zm0 0"
                fill="#a45e14"
            />
            <path
                d="m468.175781 329.136719c-.335937.132812-.660156.285156-.976562.464843l-19.199219 14.398438v-30.871094c-5.226562-1.503906-10.773438-1.503906-16 0v62.871094l-19.199219-14.398438c-1.398437-1.003906-3.082031-1.515624-4.800781-1.464843v17.863281l24 18v76c0 4.417969 3.582031 8 8 8s8-3.582031 8-8v-108l24-18v-2c-.035156-5.195312-1.347656-10.296875-3.824219-14.863281zm0 0"
                fill="#a45e14"
            />
            <path
                d="m472 480h-464c-4.417969 0-8-3.582031-8-8s3.582031-8 8-8h464c4.417969 0 8 3.582031 8 8s-3.582031 8-8 8zm0 0"
                fill="#85bc94"
            />
            <path
                d="m200.886719 288h78.226562c-.9375-5.304688-1.679687-10.640625-2.304687-16h-73.609375c-.632813 5.359375-1.375 10.695312-2.3125 16zm0 0"
                fill="#5d9aa4"
            />
            <path
                d="m264 149.335938-1.375-13.335938h-45.25l-1.375 13.335938v2.664062h48zm0 0"
                fill="#5d9aa4"
            />
            <path d="m323.550781 408-3.550781-8h-160l-3.550781 8zm0 0" fill="#4e838b" />
            <path
                d="m199.273438 296h81.453124c-.550781-2.664062-1.140624-5.320312-1.597656-8h-78.242187c-.472657 2.679688-1.0625 5.335938-1.613281 8zm0 0"
                fill="#4e838b"
            />
            <path d="m214.894531 160h50.210938l-.832031-8h-48.546876zm0 0" fill="#4e838b" />
            <path d="m232 144h16v136h-16zm0 0" fill="#5d9aa4" />
            <path d="m222.34375 88h35.3125l-.832031-8h-33.648438zm0 0" fill="#4e838b" />
            <path d="m208 64h64v16h-64zm0 0" fill="#5d9aa4" />
            <path
                d="m12.800781 377.601562c-1.398437-1.003906-3.082031-1.515624-4.800781-1.464843v17.863281l27.199219 20.398438c3.535156 2.652343 8.550781 1.9375 11.199219-1.597657 2.652343-3.535156 1.9375-8.550781-1.597657-11.199219zm0 0"
                fill="#a45e14"
            />
        </svg>
    );
};

Paris.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Paris.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Paris;
