import React from 'react';
import PropTypes from 'prop-types';

const Info = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="7px"
            height="14px"
            viewBox="0 0 7 14"
            version="1.1"
        >
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M3.41100529,4.79906878 C4.09172487,4.79906878 4.61693122,4.9648254 4.98662434,5.29261376 C5.35445503,5.62133333 5.5397672,6.0487619 5.5397672,6.57396825 C5.5397672,6.68292063 5.52673016,6.87475132 5.5015873,7.1485291 C5.47644444,7.4232381 5.42895238,7.67373545 5.36004233,7.90374603 L4.65511111,10.3994074 C4.59737566,10.599619 4.54615873,10.8286984 4.49959788,11.0847831 C4.45396825,11.3408677 4.43161905,11.5364233 4.43161905,11.6677249 C4.43161905,11.9992381 4.50518519,12.2255238 4.65417989,12.3456508 C4.80131217,12.4657778 5.05925926,12.5263069 5.4242963,12.5263069 C5.59657143,12.5263069 5.78933333,12.4955767 6.0072381,12.4359788 C6.22328042,12.376381 6.37972487,12.3233016 6.47843386,12.277672 L6.28939683,13.0477884 C5.72321693,13.2712804 5.27250794,13.4407619 4.93447619,13.5580952 C4.59737566,13.6754286 4.20533333,13.7340952 3.75928042,13.7340952 C3.07390476,13.7340952 2.54031746,13.5664762 2.16038095,13.2321693 C1.78044444,12.8978624 1.59140741,12.4741587 1.59140741,11.9591958 C1.59140741,11.7589841 1.60537566,11.5541164 1.63331217,11.3455238 C1.66217989,11.1369312 1.70780952,10.9022646 1.77020106,10.6387302 L2.47885714,8.13561905 C2.54124868,7.89536508 2.59525926,7.66721693 2.63809524,7.45489947 C2.68093122,7.24071958 2.70141799,7.0442328 2.70141799,6.86543915 C2.70141799,6.54696296 2.63530159,6.3234709 2.504,6.19775661 C2.37083598,6.07204233 2.12033862,6.01058201 1.74692063,6.01058201 C1.56440212,6.01058201 1.3762963,6.0375873 1.18353439,6.09439153 C0.992634921,6.1530582 0.826878307,6.20613757 0.690920635,6.25828571 L0.878095238,5.4872381 C1.34184127,5.29820106 1.78603175,5.13616931 2.20973545,5.00207407 C2.63343915,4.8661164 3.03386243,4.79906878 3.41100529,4.79906878 Z M4.97731217,0.230518519 C5.44012698,0.230518519 5.8368254,0.384169312 6.16461376,0.693333333 C6.49333333,1.00156614 6.65815873,1.37405291 6.65815873,1.80706878 C6.65815873,2.24194709 6.49333333,2.61257143 6.16461376,2.91801058 C5.83589418,3.22344974 5.44012698,3.37616931 4.97731217,3.37616931 C4.51542857,3.37616931 4.11686772,3.22344974 3.7853545,2.91801058 C3.4557037,2.61257143 3.28901587,2.24101587 3.28901587,1.80706878 C3.28901587,1.37405291 3.45663492,1.00156614 3.7853545,0.693333333 C4.11686772,0.384169312 4.51542857,0.230518519 4.97731217,0.230518519 Z"
                    id="info"
                    fill="currentColor"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

Info.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Info.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Info;
