import React from 'react';
import PropTypes from 'prop-types';

const HomeBorder = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="32px"
            height="32px"
            viewBox="0 0 32 32"
            version="1.1"
        >
            <title>home-border</title>
            <g id="modules" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M31.137484,13.918457 C31.1365075,13.9177246 31.135775,13.9167481 31.1350426,13.9160156 L18.0815759,0.863037125 C17.5251794,0.3063965 16.7854332,0 15.998568,0 C15.2117028,0 14.4719567,0.3063965 13.915316,0.863037125 L0.868685237,13.9094238 C0.864290674,13.9138184 0.859651987,13.918457 0.855501612,13.9228516 C-0.287076513,15.0720215 -0.285123388,16.9365234 0.861116862,18.0827637 C1.38479849,18.6066894 2.07620474,18.9099121 2.81570667,18.9418945 C2.84598011,18.9448242 2.87625355,18.9462891 2.90677111,18.9462891 L3.42679067,18.9462891 L3.42679067,28.5522461 C3.42679067,30.4533691 4.97366567,32 6.87478874,32 L11.9817223,32 C12.4995446,32 12.9192223,31.5800781 12.9192223,31.0625 L12.9192223,23.53125 C12.9192223,22.6638184 13.6250329,21.9582519 14.4924645,21.9582519 L17.5046715,21.9582519 C18.3721032,21.9582519 19.0776696,22.6638184 19.0776696,23.53125 L19.0776696,31.0625 C19.0776696,31.5800781 19.4973473,32 20.0151696,32 L25.1221032,32 C27.0234704,32 28.5701012,30.4533691 28.5701012,28.5522461 L28.5701012,18.9462891 L29.0525231,18.9462891 C29.8391442,18.9462891 30.5788903,18.6398926 31.135775,18.0830078 C32.283236,16.9350586 32.2837242,15.0671387 31.137484,13.918457 L31.137484,13.918457 Z M29.8098473,16.7573243 C29.6074547,16.9597168 29.3384117,17.0712891 29.0525231,17.0712891 L27.6326012,17.0712891 C27.114779,17.0712891 26.6951012,17.4909668 26.6951012,18.0087891 L26.6951012,28.5522461 C26.6951012,29.4194336 25.9895348,30.125 25.1221032,30.125 L20.9526696,30.125 L20.9526696,23.53125 C20.9526696,21.6301269 19.4060387,20.0832519 17.5046715,20.0832519 L14.4924645,20.0832519 C12.5910973,20.0832519 11.0442223,21.6301269 11.0442223,23.53125 L11.0442223,30.125 L6.87478874,30.125 C6.00760124,30.125 5.30179067,29.4194336 5.30179067,28.5522461 L5.30179067,18.0087891 C5.30179067,17.4909668 4.88211292,17.0712891 4.36429067,17.0712891 L2.96878286,17.0712891 C2.95413442,17.0703125 2.93973011,17.0695801 2.92483755,17.0693359 C2.64554067,17.0644531 2.3835778,16.9536132 2.18728874,16.7570801 C1.76980824,16.3395996 1.76980824,15.6601562 2.18728874,15.2424316 C2.18753286,15.2424316 2.18753286,15.2421875 2.18777699,15.2419434 L2.18850942,15.2412109 L15.2414879,2.18872069 C15.4436364,1.98632812 15.7124352,1.875 15.998568,1.875 C16.2844567,1.875 16.5532555,1.98632812 16.7556481,2.18872069 L29.8056969,15.2385254 C29.80765,15.2404785 29.8098473,15.2424316 29.8118004,15.2443847 C30.2270836,15.6625976 30.2263512,16.3405762 29.8098473,16.7573243 Z"
                    id="home-border"
                    fill="#01B6F5"
                    fillRule="nonzero"
                />
            </g>
        </svg>
    );
};

HomeBorder.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

HomeBorder.defaultProps = {
    className: undefined,
    style: undefined,
};

export default HomeBorder;
