import React from 'react';
import PropTypes from 'prop-types';

const Email = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="25px"
            height="18px"
            viewBox="0 0 25 18"
            version="1.1"
        >
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="Components-BadgeOverlay"
                    transform="translate(-576.000000, -1780.000000)"
                    fill="#A8ACB3"
                    fillRule="nonzero"
                >
                    <path
                        d="M598.274984,1780 L578.025016,1780 C576.908165,1780 576,1780.89695 576,1782.00002 L576,1796.00003 C576,1797.10305 576.908165,1798 578.025016,1798 L598.275032,1798 C599.391835,1798 600.3,1797.10305 600.3,1795.99998 L600.3,1782.00002 C600.3,1780.89695 599.391835,1780 598.274984,1780 Z M578.025016,1780.99998 L598.275032,1780.99998 C598.34964,1780.99998 598.415374,1781.02684 598.485379,1781.04203 C596.732219,1782.62673 590.919013,1787.87917 588.884695,1789.68944 C588.725511,1789.83105 588.468937,1789.99998 588.150047,1789.99998 C587.831157,1789.99998 587.574584,1789.83105 587.414878,1789.68897 C585.380749,1787.87898 579.567212,1782.62627 577.814337,1781.04212 C577.884484,1781.02694 577.95036,1780.99998 578.025016,1780.99998 Z M577.012484,1795.99998 L577.012484,1782.00002 C577.012484,1781.90205 577.042385,1781.81317 577.069153,1781.72364 C578.410968,1782.93658 582.46717,1786.60145 585.097265,1788.96363 C582.475713,1791.1877 578.418467,1794.98683 577.065973,1796.26061 C577.0421,1796.17558 577.012484,1796.09242 577.012484,1795.99998 Z M598.274984,1797.00002 L578.025016,1797.00002 C577.944142,1797.00002 577.872239,1796.97217 577.796729,1796.95436 C579.194311,1795.63848 583.277375,1791.81752 585.852843,1789.64144 C586.188582,1789.94223 586.495274,1790.2165 586.73704,1790.43166 C587.154317,1790.80375 587.642737,1791.00002 588.15,1791.00002 C588.657262,1791.00002 589.145683,1790.8037 589.562437,1790.43213 C589.804298,1790.21688 590.111228,1789.94238 590.447157,1789.64144 C593.022767,1791.81728 597.105262,1795.63797 598.503271,1796.95436 C598.427761,1796.97217 598.355953,1797.00002 598.274984,1797.00002 Z M599.287516,1795.99998 C599.287516,1796.09237 599.2579,1796.17558 599.234075,1796.26061 C597.881058,1794.98617 593.824287,1791.18747 591.202782,1788.96367 C593.832973,1786.6015 597.888557,1782.93695 599.230847,1781.72355 C599.257615,1781.81308 599.287516,1781.902 599.287516,1781.99997 L599.287516,1795.99998 L599.287516,1795.99998 Z"
                        id="email"
                    />
                </g>
            </g>
        </svg>
    );
};

Email.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Email.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Email;
