import React from 'react';
import PropTypes from 'prop-types';

const Design = props => {
    const { className, style } = props;
    return (
        <svg className={className} style={style} width="49px" height="53px" viewBox="0 0 49 53">
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="Components-VisualPicker" transform="translate(-363.000000, -537.000000)">
                    <g id="Group-6" transform="translate(203.000000, 333.000000)">
                        <g id="Group-51" transform="translate(65.000000, 66.000000)">
                            <g id="card-1" transform="translate(48.000000, 102.000000)">
                                <g id="Group-4" transform="translate(47.000000, 36.000000)">
                                    <g id="design">
                                        <g
                                            id="Group-74"
                                            transform="translate(36.484723, 35.899204) rotate(146.000000) translate(-36.484723, -35.899204) translate(31.484723, 15.899204)"
                                        >
                                            <polygon
                                                fill="#576574"
                                                points="4.71179747 0.0518718531 0.0169617505 6.41584032 3.14694538 12.780093 6.27664948 12.780093 9.40663311 6.41584032"
                                            />
                                            <path
                                                d="M4.73343818,13.5768933 C4.27750038,13.5768933 3.90797257,13.2207896 3.90797257,12.7814151 L3.90797257,8.00826107 C3.90797257,7.56888653 4.27750038,7.21278275 4.73343818,7.21278275 C5.18937591,7.21278275 5.5589038,7.56888653 5.5589038,8.00826107 L5.5589038,12.7814151 C5.5589038,13.2207896 5.18937591,13.5768933 4.73343818,13.5768933 L4.73343818,13.5768933 Z"
                                                fill="#A4A7B5"
                                            />
                                            <path
                                                d="M6.24159886,7.09603106 C6.24159886,7.98914605 5.5487342,8.71299672 4.69385087,8.71299672 C3.83896753,8.71299672 3.14610281,7.98914605 3.14610281,7.09603106 C3.14610281,6.20291608 3.83896753,5.47877658 4.69385087,5.47877658 C5.5487342,5.47877658 6.24159886,6.20291608 6.24159886,7.09603106 Z"
                                                fill="#A4A7B5"
                                            />
                                            <polygon
                                                fill="#FF6837"
                                                points="1.53543442 17.6299522 2.33503283 18.43474 7.13290887 18.43474 7.79598743 17.5366504 6.33331046 12.8009372 3.13491689 12.8009372"
                                            />
                                            <path
                                                d="M1.5447402,17.5086044 L7.79639559,17.5086044 L8.04528191,35.9083511 C8.04528191,37.6736194 6.64582009,39.1048485 4.91945425,39.1048485 C3.1930884,39.1048485 1.79362652,37.6736194 1.79362652,35.9083511 L1.5447402,17.5086044 Z"
                                                fill="#FFB900"
                                            />
                                        </g>
                                        <path
                                            d="M22.8010112,0 C23.9390817,0 24.8646752,0.935877922 24.8646752,2.08659364 L24.8646752,8.45554865 C24.8639809,8.45554865 24.8639809,8.45484643 24.8632864,8.45484643 C24.1821107,8.36919227 23.4932968,8.32496094 22.8010112,8.32496094 C22.1080311,8.32496094 21.4185229,8.36919227 20.7373472,8.45484643 L20.7373472,2.08659364 C20.7373472,0.935877922 21.6629407,0 22.8010112,0 Z"
                                            fill="#576574"
                                        />
                                        <g id="Group-75" transform="translate(0.000000, 17.525926)">
                                            <path
                                                d="M0.161492456,29.9546501 C-0.171083372,30.5368142 0.0265467775,31.2813505 0.602460376,31.617536 L4.95126048,33.8181775 C5.52717408,34.154363 6.2637166,33.9550279 6.59629254,33.3728638 L23.3923915,3.43964444 C21.3359927,2.69510807 18.9318584,1.18236944 17.025641,-5.1159077e-13 L0.161492456,29.9546501 Z"
                                                fill="#01B6F5"
                                            />
                                            <g
                                                id="Group"
                                                transform="translate(12.696907, 19.001778) rotate(30.000000) translate(-12.696907, -19.001778) translate(10.196907, 6.001778)"
                                                fill="#000000"
                                                fillOpacity="0.130463089"
                                            >
                                                <polygon points="0.0203326521 0.0220418735 4.02484096 0.0220418735 4.02484096 1.26016692 0.0203326521 1.26016692" />
                                                <polygon points="0.00959847436 4.05684237 4.01410679 4.05684237 4.01410679 5.29496742 0.00959847436 5.29496742" />
                                                <polygon points="0.205128205 15.2444444 4.20963652 15.2444444 4.20963652 16.4825695 0.205128205 16.4825695" />
                                                <polygon points="0.205128205 20.1088746 4.20963652 20.1088746 4.20963652 21.3469996 0.205128205 21.3469996" />
                                                <polygon points="0.205128205 24.6814815 4.20963652 24.6814815 4.20963652 25.9196065 0.205128205 25.9196065" />
                                            </g>
                                        </g>
                                        <path
                                            d="M20.2513159,23.9092597 C21.0501275,24.1595693 21.8994202,24.29432 22.7798092,24.29432 C23.6278903,24.29432 24.4468943,24.168961 25.2202636,23.9362099 C27.2786775,23.3159485 29.0111861,21.9316916 30.096326,20.1088826 C30.8684837,18.8111929 31.3127167,17.2913687 31.3127167,15.6666023 C31.3127167,10.9017371 27.4923132,7.03888473 22.7798092,7.03888473 C18.0673052,7.03888473 14.2469017,10.9017371 14.2469017,15.6666023 C14.2469017,17.2542101 14.6709422,18.7413675 15.410792,20.0194572 C16.4769511,21.8602329 18.198152,23.2661315 20.2513159,23.9092597 Z M22.7798092,12.1553267 C24.697684,12.1553267 26.2524994,13.7274178 26.2524994,15.6666023 C26.2524994,17.605787 24.697684,19.177878 22.7798092,19.177878 C20.8619343,19.177878 19.3071189,17.605787 19.3071189,15.6666023 C19.3071189,13.7274178 20.8619343,12.1553267 22.7798092,12.1553267 L22.7798092,12.1553267 Z"
                                            id="Shape"
                                            fill="#FF6837"
                                            fillRule="nonzero"
                                        />
                                        <path
                                            d="M7.46041992,26.2860757 C7.522057,26.3141208 7.58369408,26.3437238 7.64533116,26.3764427 C7.58369408,26.3437238 7.522057,26.3141208 7.46041992,26.2860757 Z"
                                            fill="#FBB868"
                                        />
                                        <path
                                            d="M7.82603765,26.5151596 C7.69904821,26.4123282 7.56665531,26.3219616 7.43156033,26.242501 C7.56665531,26.3219616 7.69904821,26.4123282 7.82603765,26.5151596 Z"
                                            fill="#FBB868"
                                        />
                                        <g id="Group-76" transform="translate(3.402569, 25.978091)">
                                            <path
                                                d="M37.6986189,6.46823613 L38.2676409,6.02029228 C38.6827968,5.69321558 38.7898165,5.10357934 38.5160075,4.64869381 L37.32304,2.66581736 C32.0047638,6.72099563 25.6897903,9.25022484 19.3760283,9.25022484 C13.0610549,9.25022484 6.74850445,6.72222066 1.43063204,2.66704228 L0.236856913,4.64787709 C-0.0369520797,5.101946 0.069260009,5.69199055 0.484011979,6.01906725 L1.03001468,6.45026937 C1.92857678,7.15913954 2.85661987,7.80920942 3.80929768,8.40007059 C5.57774875,9.4972677 7.43181551,10.3915222 9.33959417,11.0820172 C12.5812833,12.2559813 15.9784539,12.8427592 19.3760283,12.8427592 C22.7433142,12.8427592 26.1114078,12.2657814 29.3284621,11.1118257 C31.2390677,10.4270474 33.0959614,9.53810123 34.8680472,8.44621256 C35.8388981,7.8480012 36.7843066,7.18853969 37.6986189,6.46823613 L37.6986189,6.46823613 Z"
                                                fill="#FF6837"
                                            />
                                            <path
                                                d="M19.3760283,9.25022484 C25.6897903,9.25022484 32.0047638,6.72140405 37.32304,2.66581736 L36.0832263,0.605765439 C35.7734747,0.0908545891 35.0990482,-0.0541044861 34.6087767,0.288080589 L34.5857573,0.304005694 C33.5753292,1.10025957 32.5192664,1.80627147 31.4284725,2.4228578 C29.6022712,3.45472125 27.6779347,4.23505002 25.7035211,4.76384433 C21.5297505,5.88104984 17.1314404,5.87288314 12.9609005,4.74016093 C10.9897177,4.20442495 9.06901596,3.41756271 7.24725694,2.3795742 C6.17665547,1.76952124 5.13997725,1.07290108 4.14691473,0.289305621 C4.10895295,0.262355436 4.06937589,0.238672038 4.02899107,0.217846909 C4.01283715,0.209271893 3.99668322,0.201513495 3.9805293,0.194163406 C3.96397144,0.186813422 3.9474137,0.179871748 3.93085595,0.173338382 C3.9142982,0.166805016 3.89774045,0.16067996 3.88077878,0.155371627 C3.84725935,0.143938237 3.81333611,0.134954807 3.77941287,0.127196514 C3.76204747,0.123521417 3.7450858,0.120254734 3.7277203,0.117396465 C3.71075873,0.114538092 3.69339324,0.112088027 3.67643156,0.110046377 C3.57304644,0.0982046777 3.46885367,0.102287979 3.36789168,0.121479766 C3.35093001,0.12433814 3.33396833,0.128013132 3.31741058,0.132096433 C3.26733341,0.144346546 3.21806399,0.160271651 3.17040986,0.179463438 C3.15425593,0.185996804 3.13850593,0.192938479 3.12275583,0.200288463 C2.94304333,0.283997288 2.78433103,0.421197965 2.67327287,0.606173852 L1.43063204,2.6674507 C6.74850445,6.72222066 13.0610549,9.25022484 19.3760283,9.25022484 Z"
                                                fill="#FF7B50"
                                            />
                                        </g>
                                        <path
                                            d="M7.35839524,26.255332 C7.42311438,26.2755865 7.48629229,26.2989573 7.54947019,26.3238861 C7.48629229,26.2989573 7.42311438,26.2755865 7.35839524,26.255332 Z"
                                            fill="#FBB868"
                                        />
                                        <path
                                            d="M7.18385246,26.2127855 C7.31483116,26.2423881 7.44426903,26.2766654 7.57216607,26.3202907 C7.44426903,26.2766654 7.31483116,26.2423881 7.18385246,26.2127855 Z"
                                            fill="#FBB868"
                                        />
                                        <path
                                            d="M7.15137005,26.2249529 C7.21763001,26.2327431 7.28388997,26.2420916 7.34860871,26.252998 C7.28388997,26.2420916 7.21763001,26.2327431 7.15137005,26.2249529 Z"
                                            fill="#FBB868"
                                        />
                                        <path
                                            d="M22.7798092,20.2232165 C20.2949315,20.2232165 18.2732677,18.1790898 18.2732677,15.6666023 C18.2732677,13.1541149 20.2949315,11.1099882 22.7798092,11.1099882 C25.2646868,11.1099882 27.2863507,13.1541149 27.2863507,15.6666023 C27.2863507,18.1790898 25.2646868,20.2232165 22.7798092,20.2232165 L22.7798092,20.2232165 Z M22.7798092,13.2006652 C21.4349949,13.2006652 20.3409702,14.3068456 20.3409702,15.6666023 C20.3409702,17.0263591 21.4349949,18.1325395 22.7798092,18.1325395 C24.1246234,18.1325395 25.2186482,17.0263591 25.2186482,15.6666023 C25.2186482,14.3068456 24.1246234,13.2006652 22.7798092,13.2006652 Z"
                                            id="Shape"
                                            fill="#576574"
                                            fillRule="nonzero"
                                        />
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

Design.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Design.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Design;
