import React from 'react';
import PropTypes from 'prop-types';

const CompressArrow = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="24px"
            height="24px"
            viewBox="0 0 20 20"
            version="1.1"
        >
            <g id="pages" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="compress-icon">
                    <path
                        d="M3.88956522,-3.10862447e-15 C4.14169521,-3.10862447e-15 4.34608696,0.204391745 4.34608696,0.456521739 C4.34608696,0.708651734 4.14169521,0.913043478 3.88956522,0.913043478 L3.88956522,0.913043478 L1.62,0.913 L4.72850931,4.02140253 C4.9020973,4.19494724 4.92141604,4.46436924 4.78644428,4.65925421 L4.72859747,4.72850931 C4.53335967,4.9237958 4.21677718,4.92383527 4.02149069,4.72859747 L4.02149069,4.72859747 L0.913,1.621 L0.913043478,3.88956522 C0.913043478,4.11368077 0.751548766,4.30007721 0.538582099,4.33873178 L0.456521739,4.34608696 C0.204391745,4.34608696 4.51638726e-13,4.14169521 4.51638726e-13,3.88956522 L4.51638726e-13,3.88956522 L4.51638726e-13,0.456521739 C4.51638726e-13,0.204391745 0.204391745,-3.10862447e-15 0.456521739,-3.10862447e-15 L0.456521739,-3.10862447e-15 Z"
                        id="Combined-Shape"
                        fill="#A4A7B5"
                        fillRule="nonzero"
                        transform="translate(2.437500, 2.437500) scale(-1, -1) translate(-2.437500, -2.437500) "
                    />
                    <path
                        d="M3.88956522,15 C4.14169521,15 4.34608696,15.2043917 4.34608696,15.4565217 C4.34608696,15.7086517 4.14169521,15.9130435 3.88956522,15.9130435 L3.88956522,15.9130435 L1.62,15.913 L4.72850931,19.0214025 C4.9020973,19.1949472 4.92141604,19.4643692 4.78644428,19.6592542 L4.72859747,19.7285093 C4.53335967,19.9237958 4.21677718,19.9238353 4.02149069,19.7285975 L4.02149069,19.7285975 L0.913,16.621 L0.913043478,18.8895652 C0.913043478,19.1136808 0.751548766,19.3000772 0.538582099,19.3387318 L0.456521739,19.346087 C0.204391745,19.346087 4.51638726e-13,19.1416952 4.51638726e-13,18.8895652 L4.51638726e-13,18.8895652 L4.51638726e-13,15.4565217 C4.51638726e-13,15.2043917 0.204391745,15 0.456521739,15 L0.456521739,15 Z"
                        id="Combined-Shape"
                        fill="#A4A7B5"
                        fillRule="nonzero"
                        transform="translate(2.437500, 17.437500) scale(-1, 1) translate(-2.437500, -17.437500) "
                    />
                    <path
                        d="M18.8895652,-3.10862447e-15 C19.1416952,-3.10862447e-15 19.346087,0.204391745 19.346087,0.456521739 C19.346087,0.708651734 19.1416952,0.913043478 18.8895652,0.913043478 L18.8895652,0.913043478 L16.62,0.913 L19.7285093,4.02140253 C19.9020973,4.19494724 19.921416,4.46436924 19.7864443,4.65925421 L19.7285975,4.72850931 C19.5333597,4.9237958 19.2167772,4.92383527 19.0214907,4.72859747 L19.0214907,4.72859747 L15.913,1.621 L15.9130435,3.88956522 C15.9130435,4.11368077 15.7515488,4.30007721 15.5385821,4.33873178 L15.4565217,4.34608696 C15.2043917,4.34608696 15,4.14169521 15,3.88956522 L15,3.88956522 L15,0.456521739 C15,0.204391745 15.2043917,-3.10862447e-15 15.4565217,-3.10862447e-15 L15.4565217,-3.10862447e-15 Z"
                        id="Combined-Shape-Copy"
                        fill="#A4A7B5"
                        fillRule="nonzero"
                        transform="translate(17.437500, 2.437500) scale(1, -1) translate(-17.437500, -2.437500) "
                    />
                    <path
                        d="M18.8895652,15 C19.1416952,15 19.346087,15.2043917 19.346087,15.4565217 C19.346087,15.7086517 19.1416952,15.9130435 18.8895652,15.9130435 L18.8895652,15.9130435 L16.62,15.913 L19.7285093,19.0214025 C19.9020973,19.1949472 19.921416,19.4643692 19.7864443,19.6592542 L19.7285975,19.7285093 C19.5333597,19.9237958 19.2167772,19.9238353 19.0214907,19.7285975 L19.0214907,19.7285975 L15.913,16.621 L15.9130435,18.8895652 C15.9130435,19.1136808 15.7515488,19.3000772 15.5385821,19.3387318 L15.4565217,19.346087 C15.2043917,19.346087 15,19.1416952 15,18.8895652 L15,18.8895652 L15,15.4565217 C15,15.2043917 15.2043917,15 15.4565217,15 L15.4565217,15 Z"
                        id="Combined-Shape-Copy"
                        fill="#A4A7B5"
                        fillRule="nonzero"
                    />
                    <line
                        x1="4.375"
                        y1="3.125"
                        x2="4.375"
                        y2="3.125"
                        id="Line-19"
                        stroke="#979797"
                        strokeLinecap="square"
                    />
                </g>
            </g>
        </svg>
    );
};

CompressArrow.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

CompressArrow.defaultProps = {
    className: undefined,
    style: undefined,
};

export default CompressArrow;
