import React from 'react';
import PropTypes from 'prop-types';

const Company = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="20px"
            height="21px"
            viewBox="0 0 20 21"
            version="1.1"
        >
            <defs>
                <circle id="path-1" cx="9.83002253" cy="9.83002253" r="9.83002253" />
            </defs>
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="Components-Accordion" transform="translate(-367.000000, -2298.000000)">
                    <g id="Group-15-Copy-4" transform="translate(291.000000, 2010.000000)">
                        <g id="Group-14" transform="translate(62.000000, 131.000000)">
                            <g id="item-1-copy-3" transform="translate(0.000000, 144.000000)">
                                <g id="Desktop-/-Accordion-/-Section">
                                    <g id="company" transform="translate(14.000000, 13.000000)">
                                        <mask id="mask-2" fill="white">
                                            <use href="#path-1" />
                                        </mask>
                                        <use
                                            id="Mask"
                                            fill="#F0F2F6"
                                            fillRule="nonzero"
                                            href="#path-1"
                                        />
                                        <g id="building" mask="url(#mask-2)" fillRule="nonzero">
                                            <g transform="translate(4.000000, 4.000000)">
                                                <polygon
                                                    id="Path"
                                                    fill="#DA8C36"
                                                    points="0.984602976 9.87291636 1.19881785 9.87291636 1.19881785 11.7770486 0.984602976 11.7770486"
                                                />
                                                <path
                                                    d="M1.09249587,7.31345322 C1.70181818,7.31345322 1.90491769,8.93832066 1.90491769,9.75074248 C1.90491769,10.1975709 1.5393243,10.5631643 1.09249587,10.5631643 C0.645667438,10.5631643 0.28007405,10.1975709 0.28007405,9.75074248 C0.28007405,8.93829686 0.483173554,7.31345322 1.09249587,7.31345322 Z"
                                                    id="Path"
                                                    fill="#89C763"
                                                />
                                                <path
                                                    d="M9.95265719,11.0302955 C9.89172496,10.9896661 9.81048992,10.9693633 9.72923107,10.9693633 C9.50580496,10.9693633 9.32300826,11.15216 9.32300826,11.3755861 L9.32300826,10.1569415 L9.32300826,8.53207405 L9.32300826,6.90723041 L9.32300826,5.28236298 L9.32300826,3.65749554 L9.32300826,2.0326519 L8.10436364,2.0326519 L6.88571901,2.0326519 L5.66707438,2.0326519 L4.44842975,2.0326519 L3.22978512,2.0326519 L3.22978512,3.65751934 L3.22978512,5.28238678 L3.22978512,6.90723041 L3.22978512,8.53209785 L3.22978512,10.1569653 L3.22978512,11.7818089 L2.41736331,11.7818089 L2.41736331,1.22023008 L4.04223074,1.22023008 L8.51058645,1.22023008 L10.1354539,1.22023008 L10.1354539,10.7053316 C10.0542188,10.7865666 9.97296,10.9084311 9.95265719,11.0302955 Z"
                                                    id="Path"
                                                    fill="#CFDAE8"
                                                />
                                                <polygon
                                                    id="Path"
                                                    fill="#CFDAE8"
                                                    points="8.51058645 0.407784463 8.51058645 1.22020628 4.04223074 1.22020628 4.04223074 0.407784463 5.66709818 0.407784463 5.66709818 0.00158545455 6.88574281 0.00158545455 6.88574281 0.407808264 8.51058645 0.407808264"
                                                />
                                                <rect
                                                    id="Rectangle"
                                                    fill="#4C9CD6"
                                                    x="3.22978512"
                                                    y="2.0326519"
                                                    width="6.09322314"
                                                    height="9.95225653"
                                                />
                                                <path
                                                    d="M9.72920727,11.6802473 C9.7901395,11.6802473 9.83076893,11.7208767 9.83076893,11.7818089 C9.83076893,11.8427412 9.7901395,11.8833706 9.72920727,11.8833706 L3.22978512,11.8833706 C3.16885289,11.8833706 3.12822347,11.8427412 3.12822347,11.7818089 L3.12822347,2.0326519 C3.12822347,1.97171967 3.16885289,1.93109025 3.22978512,1.93109025 L9.32300826,1.93109025 C9.3839405,1.93109025 9.42456992,1.97171967 9.42456992,2.0326519 L9.42456992,11.4787425 C9.42456992,11.5396747 9.3839405,11.5803041 9.32300826,11.5803041 C9.26207603,11.5803041 9.22144661,11.5396747 9.22144661,11.4787425 L9.22144661,10.2585031 L8.20592529,10.2585031 L8.20592529,11.6802473 C9.11311736,11.6802473 9.62087802,11.6802473 9.72920727,11.6802473 Z M6.98728066,11.6802473 L8.00282579,11.6802473 L8.00282579,10.2585031 L6.98728066,10.2585031 L6.98728066,11.6802473 Z M5.76863603,11.6802473 L6.78418116,11.6802473 L6.78418116,10.2585031 L5.76863603,10.2585031 L5.76863603,11.6802473 Z M4.54999141,11.6802473 L5.56553653,11.6802473 L5.56553653,10.2585031 L4.54999141,10.2585031 L4.54999141,11.6802473 Z M3.33134678,11.6802473 L4.3468919,11.6802473 L4.3468919,10.2585031 L3.33134678,10.2585031 L3.33134678,11.6802473 Z M8.20592529,10.0554036 L9.22147041,10.0554036 L9.22147041,8.6336595 L8.20592529,8.6336595 L8.20592529,10.0554036 Z M6.98728066,10.0554036 L8.00282579,10.0554036 L8.00282579,8.6336595 L6.98728066,8.6336595 L6.98728066,10.0554036 Z M5.76863603,10.0554036 L6.78418116,10.0554036 L6.78418116,8.6336595 L5.76863603,8.6336595 L5.76863603,10.0554036 Z M4.54999141,10.0554036 L5.56553653,10.0554036 L5.56553653,8.6336595 L4.54999141,8.6336595 L4.54999141,10.0554036 Z M3.33134678,10.0554036 L4.3468919,10.0554036 L4.3468919,8.6336595 L3.33134678,8.6336595 L3.33134678,10.0554036 Z M8.20592529,8.4305362 L9.22147041,8.4305362 L9.22147041,7.00879207 L8.20592529,7.00879207 L8.20592529,8.4305362 Z M6.98728066,8.4305362 L8.00282579,8.4305362 L8.00282579,7.00879207 L6.98728066,7.00879207 L6.98728066,8.4305362 Z M5.76863603,8.4305362 L6.78418116,8.4305362 L6.78418116,7.00879207 L5.76863603,7.00879207 L5.76863603,8.4305362 Z M4.54999141,8.4305362 L5.56553653,8.4305362 L5.56553653,7.00879207 L4.54999141,7.00879207 L4.54999141,8.4305362 Z M3.33134678,8.4305362 L4.3468919,8.4305362 L4.3468919,7.00879207 L3.33134678,7.00879207 L3.33134678,8.4305362 Z M8.20592529,6.80566876 L9.22147041,6.80566876 L9.22147041,5.38392463 L8.20592529,5.38392463 L8.20592529,6.80566876 Z M6.98728066,6.80566876 L8.00282579,6.80566876 L8.00282579,5.38392463 L6.98728066,5.38392463 L6.98728066,6.80566876 Z M5.76863603,6.80566876 L6.78418116,6.80566876 L6.78418116,5.38392463 L5.76863603,5.38392463 L5.76863603,6.80566876 Z M4.54999141,6.80566876 L5.56553653,6.80566876 L5.56553653,5.38392463 L4.54999141,5.38392463 L4.54999141,6.80566876 Z M3.33134678,6.80566876 L4.3468919,6.80566876 L4.3468919,5.38392463 L3.33134678,5.38392463 L3.33134678,6.80566876 Z M8.20592529,5.18082512 L9.22147041,5.18082512 L9.22147041,3.75908099 L8.20592529,3.75908099 L8.20592529,5.18082512 Z M6.98728066,5.18082512 L8.00282579,5.18082512 L8.00282579,3.75908099 L6.98728066,3.75908099 L6.98728066,5.18082512 Z M5.76863603,5.18082512 L6.78418116,5.18082512 L6.78418116,3.75908099 L5.76863603,3.75908099 L5.76863603,5.18082512 Z M4.54999141,5.18082512 L5.56553653,5.18082512 L5.56553653,3.75908099 L4.54999141,3.75908099 L4.54999141,5.18082512 Z M3.33134678,5.18082512 L4.3468919,5.18082512 L4.3468919,3.75908099 L3.33134678,3.75908099 L3.33134678,5.18082512 Z M8.20592529,3.55595769 L9.22147041,3.55595769 L9.22147041,2.13421355 L8.20592529,2.13421355 L8.20592529,3.55595769 Z M6.98728066,3.55595769 L8.00282579,3.55595769 L8.00282579,2.13421355 L6.98728066,2.13421355 L6.98728066,3.55595769 Z M5.76863603,3.55595769 L6.78418116,3.55595769 L6.78418116,2.13421355 L5.76863603,2.13421355 L5.76863603,3.55595769 Z M4.54999141,3.55595769 L5.56553653,3.55595769 L5.56553653,2.13421355 L4.54999141,2.13421355 L4.54999141,3.55595769 Z M3.33134678,3.55595769 L4.3468919,3.55595769 L4.3468919,2.13421355 L3.33134678,2.13421355 L3.33134678,3.55595769 Z M2.41736331,11.8833706 L2.31580165,11.6802711 L2.31580165,1.32023008 C2.31580165,1.25929785 2.35643107,1.21866843 2.41736331,1.21866843 L3.94066909,1.21866843 L3.94066909,0.507784463 C3.94066909,0.446852231 3.98129851,0.40622281 4.04223074,0.40622281 L5.56553653,0.40622281 L5.56553653,0.101561653 C5.56553653,0.0406294215 5.60616595,0 5.66709818,0 L6.88574281,0 C6.94667504,0 6.98730446,0.0406294215 6.98730446,0.101561653 L6.98730446,0.40622281 L8.51061025,0.40622281 C8.57154248,0.40622281 8.6121719,0.446852231 8.6121719,0.507784463 L8.6121719,1.21866843 L10.1354777,1.21866843 C10.1964099,1.21866843 10.2370393,1.25929785 10.2370393,1.32023008 L10.2370393,11.0661884 C10.2370393,11.1271207 10.1964099,11.1677501 10.1354777,11.1677501 C10.0745455,11.1677501 10.033916,11.1271207 10.033916,11.0661884 L10.033916,1.42179174 L4.85465256,1.42179174 C4.79372033,1.42179174 4.75309091,1.38116231 4.75309091,1.32023008 C4.75309091,1.25929785 4.79372033,1.21866843 4.85465256,1.21866843 L8.40902479,1.21866843 L8.40902479,0.609346116 L6.88571901,0.609346116 C6.82478678,0.609346116 6.78415736,0.568716694 6.78415736,0.507784463 L6.78415736,0.203123306 L5.76863603,0.203123306 L5.76863603,0.507784463 C5.76863603,0.568716694 5.72800661,0.609346116 5.66707438,0.609346116 L4.1437686,0.609346116 L4.1437686,1.32023008 C4.1437686,1.38116231 4.10313917,1.42179174 4.04220694,1.42179174 L2.51890116,1.42179174 L2.51890116,11.7818089 C2.51892496,11.8427412 2.47829554,11.8833706 2.41736331,11.8833706 Z"
                                                    id="Shape"
                                                    fill="#CFDAE8"
                                                />
                                                <path
                                                    d="M11.0606519,10.9693633 C11.284078,10.9693633 11.4668747,11.15216 11.4668747,11.3755861 C11.4668747,11.5990122 11.284078,11.7818089 11.0606519,11.7818089 L9.43578446,11.7818089 C9.21235835,11.7818089 9.02956165,11.5990122 9.02956165,11.3755861 C9.02956165,11.15216 9.21235835,10.9693633 9.43578446,10.9693633 C9.5170195,10.9693633 9.59827835,10.9896661 9.65921058,11.0302955 C9.67951339,10.9084311 9.76077223,10.7865666 9.84200727,10.7053316 C9.94356893,10.6037699 10.0857362,10.5631643 10.2482301,10.5631643 C10.5325884,10.5631643 10.7763174,10.7662638 10.8372496,11.0303193 C10.898158,10.9896661 10.9793931,10.9693633 11.0606519,10.9693633 Z"
                                                    id="Path"
                                                    fill="#89C763"
                                                />
                                                <path
                                                    d="M0.173595791,12.5636364 L11.8035429,12.5572103 C11.8993788,12.5571005 11.9769997,12.3345925 11.9769997,12.060225 C11.9769997,11.7858574 11.8992398,11.5635276 11.8034039,11.5636364 L0.173456794,11.5700623 C0.0776208768,11.5701722 0,11.7926802 0,12.0670477 C0,12.3414153 0.0777598738,12.5637451 0.173595791,12.5636364 Z"
                                                    id="Line"
                                                    fill="#73747A"
                                                />
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

Company.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Company.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Company;
