import React from 'react';
import PropTypes from 'prop-types';

const Chat = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="36px"
            height="35px"
            viewBox="0 0 36 35"
            version="1.1"
        >
            <g stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <path
                    d="M33.1391555,24.9623665 C33.493755,28.8845612 34.4441537,31.7957573 35.8241519,33.1757554 C36.0065516,33.3575552 36.0521516,33.6365548 35.9369517,33.8675545 C35.8349518,34.0733542 35.6249521,34.199954 35.3999524,34.199954 C35.3723525,34.199954 35.3447525,34.198154 35.3165525,34.193954 C35.0735529,34.1597541 29.4287605,33.3473552 25.3457659,30.9911584 C23.0267691,31.9259571 20.5571724,32.3999565 17.9999758,32.3999565 C8.07478915,32.3999565 0,25.1327662 0,16.1999782 C0,7.26719023 8.07478915,-1.31450406e-13 17.9999758,-1.31450406e-13 C27.9251625,-1.31450406e-13 35.9999516,7.26719023 35.9999516,16.1999782 C35.9999516,19.322974 35.0123529,22.34757 33.1391555,24.9623665 Z M26.5353705,23.6601892 C26.8999829,23.3644974 26.9558541,22.8292151 26.6601623,22.4646027 C26.3644706,22.0999903 25.8291883,22.0441191 25.4645759,22.3398108 C23.315188,24.082912 20.8377937,24.95 17.9999732,24.95 C14.6777489,24.95 12.2328084,24.0942708 10.6124158,22.4105816 C10.286889,22.0723389 9.74879746,22.0620306 9.41055476,22.3875574 C9.07231206,22.7130842 9.0620038,23.2511757 9.38753061,23.5894184 C11.3601204,25.6390625 14.2485132,26.65 17.9999732,26.65 C21.2253105,26.65 24.0812497,25.6504213 26.5353705,23.6601892 Z"
                    fill="currentColor"
                />
            </g>
        </svg>
    );
};

Chat.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Chat.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Chat;
