import React from 'react';
import PropTypes from 'prop-types';

export default function CalendarIcon(props) {
    const { className, style } = props;

    return (
        <svg className={className} style={style} width="20px" height="20px" viewBox="0 0 20 20">
            <g transform="translate(-899.000000, -597.000000)">
                <g transform="translate(899.000000, 597.000000)">
                    <path
                        d="M20,5.55175781 L20,17.7244568 C20,18.9811707 18.9811707,19.9998474 17.7241516,19.9998474 L2.2755432,19.9998474 C1.01882934,19.9998474 0.000152587891,18.9811707 0.000152587891,17.7244568 L0.000152587891,5.55175781"
                        fill="#E3E5ED"
                    />
                    <path
                        d="M18.7379455,8.3503723 L1.26190187,8.3503723 C0.565032969,8.3503723 0,7.78549195 0,7.08847047 L0,4.46975707 C0,3.7728882 0.565032969,3.20785523 1.26190187,3.20785523 L18.7379455,3.20785523 C19.434967,3.20785523 19.9998474,3.7728882 19.9998474,4.46975707 L19.9998474,7.08847047 C19.9998474,7.78549195 19.434967,8.3503723 18.7379455,8.3503723 Z"
                        fill="#EA4243"
                    />
                    <path
                        d="M18.7379455,7.04437258 L1.26190187,7.04437258 C0.565032969,7.04437258 0,6.47949219 0,5.7824707 L0,3.16375734 C0,2.46688844 0.565032969,1.90185547 1.26190187,1.90185547 L18.7379455,1.90185547 C19.434967,1.90185547 19.9998474,2.46688844 19.9998474,3.16375734 L19.9998474,5.7824707 C19.9998474,6.47949219 19.434967,7.04437258 18.7379455,7.04437258 Z"
                        fill="#FE4849"
                    />
                    <path
                        d="M5.83435059,1.19384766 L5.83435059,3.46282961 C5.83435059,3.79257203 5.70053102,4.09103395 5.48461914,4.30725098 C5.26870727,4.52316285 4.9699402,4.65667727 4.64050293,4.65667727 C3.98086547,4.65667727 3.44665527,4.12246703 3.44665527,3.46282961 L3.44665527,1.19384766 C3.44665527,0.534667969 3.98086547,0 4.64050293,0 C5.29968262,0 5.83435059,0.534667969 5.83435059,1.19384766 Z"
                        fill="#000000"
                    />
                    <path
                        d="M16.5534973,1.19384766 L16.5534973,3.46282961 C16.5534973,3.79257203 16.4196777,4.09103395 16.2037659,4.30725098 C15.987854,4.52316285 15.6889343,4.65667727 15.3596496,4.65667727 C14.7000122,4.65667727 14.165802,4.12246703 14.165802,3.46282961 L14.165802,1.19384766 C14.165802,0.534667969 14.7000122,0 15.3596496,0 C16.0188293,0 16.5534973,0.534667969 16.5534973,1.19384766 Z"
                        fill="#000000"
                    />
                    <path
                        d="M5.83435059,1.19384766 L5.83435059,2.99188234 C5.83435059,3.32116699 5.70053102,3.61993406 5.48461914,3.83584594 C5.26870727,4.05175781 4.9699402,4.18573 4.64050293,4.18573 C3.98086547,4.18573 3.44665527,3.65106203 3.44665527,2.99188234 L3.44665527,1.19384766 C3.44665527,0.534667969 3.98086547,0 4.64050293,0 C5.29968262,0 5.83435059,0.534667969 5.83435059,1.19384766 Z"
                        fill="#061C3F"
                    />
                    <path
                        d="M16.5534973,1.19384766 L16.5534973,2.99188234 C16.5534973,3.32116699 16.4196777,3.61993406 16.2037659,3.83584594 C15.987854,4.05175781 15.6889343,4.18573 15.3596496,4.18573 C14.7000122,4.18573 14.165802,3.65106203 14.165802,2.99188234 L14.165802,1.19384766 C14.165802,0.534667969 14.7000122,0 15.3596496,0 C16.0188293,0 16.5534973,0.534667969 16.5534973,1.19384766 Z"
                        fill="#061C3F"
                    />
                    <path
                        d="M9.59966739,13.001508 C9.59966739,13.2938921 9.36576015,13.5277993 9.07337609,13.5277993 L7.09815936,13.5277993 C6.80577531,13.5277993 6.57186806,13.2938921 6.57186806,13.001508 L6.57186806,11.0262913 C6.57186806,10.7339072 6.80577531,10.5 7.09815936,10.5 L9.07337609,10.5 C9.36576015,10.5 9.59966739,10.7339072 9.59966739,11.0262913 L9.59966739,13.001508 Z"
                        fillOpacity="0.203096694"
                        fill="#061C3F"
                    />
                    <path
                        d="M13.7759423,11.0262913 C13.7759423,10.7339072 13.5420351,10.5 13.249651,10.5 L11.2744343,10.5 C10.9820502,10.5 10.748143,10.7339072 10.748143,11.0262913 L10.748143,13.001508 C10.748143,13.2938921 10.9820502,13.5277993 11.2744343,13.5277993 L13.249651,13.5277993 C13.5420351,13.5277993 13.7759423,13.2938921 13.7759423,13.001508 L13.7759423,11.0262913 Z"
                        fill="#061C3F"
                    />
                    <path
                        d="M17.8478104,11.0262913 C17.8478104,10.7339072 17.6139031,10.5 17.3215191,10.5 L15.3463024,10.5 C15.0539183,10.5 14.8200111,10.7339072 14.8200111,11.0262913 L14.8200111,13.001508 C14.8200111,13.2938921 15.0539183,13.5277993 15.3463024,13.5277993 L17.3215191,13.5277993 C17.6139031,13.5277993 17.8478104,13.2938921 17.8478104,13.001508 L17.8478104,11.0262913 Z"
                        fillOpacity="0.203096694"
                        fill="#061C3F"
                    />
                    <path
                        d="M9.59966739,15.0459559 C9.59966739,14.7535719 9.36576015,14.5196646 9.07337609,14.5196646 L7.09815936,14.5196646 C6.80577531,14.5196646 6.57186806,14.7535719 6.57186806,15.0459559 L6.57186806,17.0211727 C6.57186806,17.3135567 6.80577531,17.547464 7.09815936,17.547464 L9.07337609,17.547464 C9.36576015,17.547464 9.59966739,17.3135567 9.59966739,17.0211727 L9.59966739,15.0459559 Z"
                        fillOpacity="0.203096694"
                        fill="#061C3F"
                    />
                    <path
                        d="M13.7759423,15.0459559 C13.7759423,14.7535719 13.5420351,14.5196646 13.249651,14.5196646 L11.2744343,14.5196646 C10.9820502,14.5196646 10.748143,14.7535719 10.748143,15.0459559 L10.748143,17.0211727 C10.748143,17.3135567 10.9820502,17.547464 11.2744343,17.547464 L13.249651,17.547464 C13.5420351,17.547464 13.7759423,17.3135567 13.7759423,17.0211727 L13.7759423,15.0459559 Z"
                        fillOpacity="0.203096694"
                        fill="#061C3F"
                    />
                    <path
                        d="M5.52779933,15.0459559 C5.52779933,14.7535719 5.29389208,14.5196646 5.00150803,14.5196646 L3.0262913,14.5196646 C2.73390724,14.5196646 2.5,14.7535719 2.5,15.0459559 L2.5,17.0211727 C2.5,17.3135567 2.73390724,17.547464 3.0262913,17.547464 L5.00150803,17.547464 C5.29389208,17.547464 5.52779933,17.3135567 5.52779933,17.0211727 L5.52779933,15.0459559 L5.52779933,15.0459559 Z"
                        fillOpacity="0.203096694"
                        fill="#061C3F"
                    />
                </g>
            </g>
        </svg>
    );
}

CalendarIcon.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

CalendarIcon.defaultProps = {
    className: undefined,
    style: undefined,
};
