import React from 'react';
import PropTypes from 'prop-types';

const Building = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="20px"
            height="21px"
            viewBox="0 0 20 21"
            version="1.1"
        >
            <g fill="none" fillRule="nonzero">
                <path fill="#DA8C36" d="M1.641 16.455h.357v3.173h-.357z" />
                <path
                    fill="#89C763"
                    d="M1.82 12.19c1.016 0 1.355 2.707 1.355 4.061 0 .745-.61 1.354-1.354 1.354-.745 0-1.354-.609-1.354-1.354 0-1.354.338-4.062 1.354-4.062z"
                />
                <path
                    fill="#D5E3EF"
                    d="M16.892 17.842c-.135.136-.27.339-.304.542a.682.682 0 0 0-.373-.102.679.679 0 0 0-.677.677V3.388H5.383v16.248H4.029V2.034H16.892v15.808zM14.184.68v1.354H6.737V.68h2.708V.003h2.031V.68h2.708z"
                />
                <path fill="#70B7E5" d="M5.383 3.388h10.155v16.587H5.383z" />
                <path
                    fill="#73747A"
                    d="M16.215 19.467c.102 0 .17.068.17.17 0 .1-.068.169-.17.169H5.383c-.102 0-.17-.068-.17-.17V3.388c0-.102.068-.17.17-.17h10.155c.102 0 .17.068.17.17V19.13c0 .102-.068.17-.17.17-.101 0-.169-.068-.169-.17v-2.033h-1.692v2.37h2.538zm-4.57 0h1.693v-2.37h-1.693v2.37zm-2.03 0h1.692v-2.37H9.614v2.37zm-2.032 0h1.693v-2.37H7.583v2.37zm-2.03 0h1.692v-2.37H5.552v2.37zm8.124-2.708h1.692v-2.37h-1.692v2.37zm-2.032 0h1.693v-2.37h-1.693v2.37zm-2.03 0h1.692v-2.37H9.614v2.37zm-2.032 0h1.693v-2.37H7.583v2.37zm-2.03 0h1.692v-2.37H5.552v2.37zm8.124-2.708h1.692v-2.37h-1.692v2.37zm-2.032 0h1.693v-2.37h-1.693v2.37zm-2.03 0h1.692v-2.37H9.614v2.37zm-2.032 0h1.693v-2.37H7.583v2.37zm-2.03 0h1.692v-2.37H5.552v2.37zm8.124-2.708h1.692v-2.37h-1.692v2.37zm-2.032 0h1.693v-2.37h-1.693v2.37zm-2.03 0h1.692v-2.37H9.614v2.37zm-2.032 0h1.693v-2.37H7.583v2.37zm-2.03 0h1.692v-2.37H5.552v2.37zm8.124-2.708h1.692v-2.37h-1.692v2.37zm-2.032 0h1.693v-2.37h-1.693v2.37zm-2.03 0h1.692v-2.37H9.614v2.37zm-2.032 0h1.693v-2.37H7.583v2.37zm-2.03 0h1.692v-2.37H5.552v2.37zm8.124-2.708h1.692v-2.37h-1.692v2.37zm-2.032 0h1.693v-2.37h-1.693v2.37zm-2.03 0h1.692v-2.37H9.614v2.37zm-2.032 0h1.693v-2.37H7.583v2.37zm-2.03 0h1.692v-2.37H5.552v2.37zM4.028 19.806l-.17-.339V2.2c0-.101.068-.169.17-.169h2.539V.846c0-.101.067-.169.17-.169h2.538V.169c0-.101.068-.169.17-.169h2.03c.102 0 .17.068.17.17v.507h2.538c.102 0 .17.068.17.17V2.03h2.538c.102 0 .17.068.17.17v16.243c0 .101-.068.169-.17.169-.101 0-.169-.068-.169-.17V2.37H8.091c-.101 0-.17-.068-.17-.17 0-.101.069-.169.17-.169h5.924V1.016h-2.539c-.101 0-.17-.068-.17-.17V.34H9.615v.507c0 .102-.067.17-.169.17H6.906V2.2c0 .102-.067.17-.169.17H4.198v17.266c0 .102-.068.17-.17.17z"
                />
                <path
                    fill="#89C763"
                    d="M18.434 18.282c.373 0 .677.305.677.677a.679.679 0 0 1-.677.677h-2.708a.679.679 0 0 1-.677-.677c0-.372.305-.677.677-.677.136 0 .271.034.373.102.034-.203.169-.406.304-.542.17-.17.407-.237.677-.237.474 0 .88.339.982.779a.682.682 0 0 1 .372-.102z"
                />
                <path
                    fill="#73747A"
                    d="M.29 20.333l19.383-.006c.16 0 .289-.223.289-.497s-.13-.497-.29-.497L.29 19.34c-.16 0-.289.222-.289.497 0 .274.13.496.29.496z"
                />
            </g>
        </svg>
    );
};

Building.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

Building.defaultProps = {
    className: undefined,
    style: undefined,
};

export default Building;
