import React from 'react';
import PropTypes from 'prop-types';

const Avatar = props => {
    const { className } = props;
    return (
        <svg className={className} width="20px" height="20px" viewBox="0 0 20 20" version="1.1">
            <g id="pages" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g
                    id="react-rainbow-custom-work-form"
                    transform="translate(-132.000000, -418.000000)"
                    fillRule="nonzero"
                >
                    <g id="Group-22" transform="translate(79.000000, 280.000000)">
                        <g id="avatar" transform="translate(53.000000, 138.000105)">
                            <circle id="Mask" fill="#EDF0F4" cx="10" cy="10" r="10" />
                            <path
                                d="M13.3552569,17.726087 C13.1380237,17.5632411 12.91278,17.418419 12.6755204,17.2877207 C12.6694071,17.2837154 12.6633992,17.2797101 12.6553887,17.2777075 C11.5332806,16.6583663 10.7732279,15.4638472 10.7732279,14.0904611 L9.0740448,14.0823452 C9.0740448,15.4598419 8.30787879,16.6603689 7.17575758,17.2776021 C6.93238472,17.410303 6.70324111,17.5571278 6.48600791,17.717971 C5.98778478,18.0887938 7.37856212,18.6324357 9.92835277,18.6942958 C12.4841733,18.7563022 13.9363109,18.16037 13.3552569,17.726087 Z"
                                id="Path"
                                fill="#ECC19C"
                            />
                            <path
                                d="M9.91567852,20 C7.17607378,20 5.32606506,18.8486953 5.32606506,18.8486953 C5.65421292,18.4166418 6.05038438,18.0414906 6.4859025,17.7173386 C6.7031357,17.5564954 6.93227931,17.4096706 7.1715415,17.2789723 C7.36063241,17.1744137 7.53760211,17.0577339 7.70044796,16.9250329 C8.26350461,17.5022134 9.04980237,17.8601581 9.92052701,17.8601581 C10.789249,17.8601581 11.5735441,17.5022134 12.1364954,16.9270356 C12.2973386,17.0597365 12.4724111,17.1764163 12.6552833,17.2769697 C12.6632938,17.2789723 12.6694071,17.2829776 12.675415,17.2869829 C12.9126746,17.4176812 13.1379183,17.5625033 13.3530435,17.7253491 C13.7979571,18.0563378 14.2102234,18.4667247 14.541275,18.9092726 C14.541275,18.9092726 12.6552833,20 9.91567852,20 Z"
                                id="Path"
                                fill="#01AEEB"
                            />
                            <path
                                d="M5.50376812,5.51475626 L5.50376812,10.0297497 C5.50376812,13.0838735 8.18487484,15.5596574 9.91567852,15.5596574 C11.6462714,15.5596574 14.3275889,13.0838735 14.3275889,10.0297497 L14.3275889,5.51475626 L5.50376812,5.51475626 Z"
                                id="Path"
                                fill="#ECC19C"
                            />
                            <path
                                d="M13.6088538,4.68376812 C12.6472727,3.47976285 11.1875626,2.71001318 9.55478261,2.71001318 C6.65401845,2.71001318 4.30471673,5.13130435 4.30471673,8.1172332 C4.30471673,9.70205534 4.96527009,11.1270883 6.02002635,12.115336 C5.7483004,11.433386 5.59652174,10.6690119 5.59652174,9.86184453 C5.59652174,8.56466403 5.99072464,7.37667984 6.64600791,6.46305665 C7.34123847,6.77209486 8.46798419,6.88392622 9.70382082,6.71349144 C10.9291173,6.5456917 11.9732279,6.14084321 12.5618972,5.65873518 C13.635415,6.60693017 14.3332806,8.13588933 14.3332806,9.86184453 C14.3332806,10.746166 14.1520949,11.5772596 13.827141,12.3070619 C14.8632411,11.8781818 15.6250856,10.3493281 15.6250856,8.52998682 C15.6250856,6.58289855 14.7514097,4.97678524 13.6088538,4.68376812 Z"
                                id="Path"
                                fill="#494846"
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

Avatar.propTypes = {
    className: PropTypes.string,
};

Avatar.defaultProps = {
    className: undefined,
};

export default Avatar;
