import React from 'react';
import PropTypes from 'prop-types';

const AdvancedSettings = props => {
    const { className, style } = props;
    return (
        <svg
            className={className}
            style={style}
            width="20px"
            height="21px"
            viewBox="0 0 20 21"
            version="1.1"
        >
            <g id="components" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
                <g id="Components-Accordion" transform="translate(-367.000000, -2203.000000)">
                    <g id="advanced-settings" transform="translate(367.000000, 2203.000000)">
                        <rect
                            id="Rectangle"
                            fillOpacity="0.01"
                            fill="#FFFFFF"
                            x="0"
                            y="0"
                            width="20"
                            height="20"
                        />
                        <g
                            id="Group-30"
                            transform="translate(0.833333, 0.000000)"
                            fillRule="nonzero"
                        >
                            <path
                                d="M14.4392954,9.08928713 L15.6926799,9.40179099 L15.7745874,10.4576688 C15.9835363,10.608365 16.1750724,10.7300815 16.3550307,10.8982341 L16.3550307,10.8982341 L17.3992113,10.665511 L18.0787362,11.7964304 L17.2901848,12.5860018 C17.3541532,12.8238112 17.3891308,13.0790769 17.4066793,13.3053356 L17.4066793,13.3053356 L18.3005488,13.8733004 L17.988045,15.1266849 L16.9321672,15.2085924 C16.8104508,15.4001285 16.6887343,15.5916646 16.5205817,15.7716229 L16.5205817,15.7716229 L16.7533048,16.8158035 L15.6223854,17.4953284 L14.8386925,16.7822038 C14.629863,16.8287593 14.3745972,16.863737 14.1483385,16.8812855 L14.1483385,16.8812855 L13.5803139,17.775117 L12.3269293,17.4626131 L12.2450382,16.4067625 C12.0360893,16.2560663 11.8445532,16.1343498 11.6645949,15.9661972 L11.6645949,15.9661972 L10.6204143,16.1989203 L9.94088938,15.0680009 L10.6540139,14.284308 C10.6074584,14.0754784 10.5724808,13.8202127 10.5549323,13.593954 L10.5549323,13.593954 L9.66110079,13.0259294 L9.97360465,11.7725448 L11.0294988,11.6906645 C11.180195,11.4817156 11.3019115,11.2901795 11.4700641,11.1102212 L11.4700641,11.1102212 L11.237341,10.0660407 L12.3682604,9.38651573 L13.1519532,10.0996403 C13.3897626,10.035672 13.6450284,10.0006943 13.8712871,9.9831458 L13.8712871,9.9831458 L14.4392954,9.08928713 Z M15.3408499,12.6916671 C14.9226807,11.9957167 13.9942623,11.764236 13.2983119,12.1824051 C12.6023615,12.6005743 12.3708808,13.5289928 12.7890499,14.2249432 C13.2072191,14.9208936 14.1356376,15.1523743 14.831588,14.7342051 C15.5565454,14.2986068 15.7590028,13.3875903 15.3408499,12.6916671 Z"
                                id="Combined-Shape"
                                fill="#8AD7F8"
                                transform="translate(13.980825, 13.432202) scale(-1, 1) translate(-13.980825, -13.432202) "
                            />
                            <path
                                d="M13.896716,11.1240109 C12.6111882,11.1240109 11.562449,12.1727502 11.562449,13.458278 C11.562449,14.7438058 12.6111882,15.792545 13.896716,15.792545 C15.1822438,15.792545 16.2309831,14.7438058 16.2309831,13.458278 C16.2309831,12.1727502 15.1822438,11.1240109 13.896716,11.1240109 Z M13.896716,14.9468172 C13.0847971,14.9468172 12.4082085,14.2702286 12.4082085,13.4583097 C12.4082085,12.6463907 13.0847971,11.9698021 13.896716,11.9698021 C14.708635,11.9698021 15.3852236,12.6463907 15.3852236,13.4583097 C15.3852236,14.2701969 14.7424755,14.9468172 13.896716,14.9468172 Z"
                                id="Shape"
                                fill="#55C0EB"
                                transform="translate(13.896716, 13.458278) scale(-1, 1) rotate(-31.000000) translate(-13.896716, -13.458278) "
                            />
                            <path
                                d="M4.75636435,10.8595558 L6.0365418,11.1787399 L6.11927647,12.2453364 C6.33269631,12.3682682 6.50509406,12.5158487 6.71029637,12.6716082 L7.7439924,12.4411972 L8.4092955,13.5484475 L7.72059451,14.3529831 C7.76996446,14.5744861 7.81114764,14.8288245 7.82768226,15.0421407 L8.73877628,15.5830925 L8.41959219,16.8632699 L7.35299568,16.9460046 C7.2300638,17.1594244 7.08248337,17.3318222 6.92672384,17.5370245 L7.15711177,18.5706821 L6.04986148,19.2359852 L5.24532581,18.5472842 C5.02382281,18.5966541 4.76948449,18.6378373 4.55616826,18.6543719 L4.01521647,19.565466 L2.73503902,19.2462819 L2.65230436,18.1796854 C2.43888452,18.0567535 2.26648676,17.909173 2.09408901,17.7615926 L1.06040064,17.9919729 L0.395097547,16.8847226 L1.08385241,16.080233 C1.03448246,15.85873 0.993299283,15.6043917 0.984943751,15.3582709 L-1.20525812e-12,14.8337502 L0.319184087,13.5535727 L1.3857806,13.470838 C1.50871248,13.2574182 1.65629291,13.0850204 1.81205244,12.8798181 L1.58167218,11.8461298 L2.68892247,11.1808267 L3.49345047,11.8695584 C3.71495347,11.8201885 3.96929179,11.7790053 4.21541257,11.7706498 L4.75636435,10.8595558 Z M2.87999555,14.8893888 C2.68358225,15.6771595 3.14354866,16.4891761 3.96418549,16.6937839 C4.751987,16.8902049 5.57215959,16.3973954 5.76858056,15.6095939 C5.96500154,14.8217924 5.47219213,14.0016198 4.68439062,13.8051989 C3.89658912,13.6087779 3.07641653,14.1015873 2.87999555,14.8893888 Z"
                                id="Combined-Shape"
                                fill="#8AD7F8"
                            />
                            <path
                                d="M4.32429573,12.9151936 C3.03876793,12.9151936 1.99002869,13.9639328 1.99002869,15.2494606 C1.99002869,16.5349884 3.03876793,17.5837276 4.32429573,17.5837276 C5.60982353,17.5837276 6.65856277,16.5349884 6.65856277,15.2494606 C6.65856277,13.9639328 5.60982353,12.9151936 4.32429573,12.9151936 Z M4.32429573,16.7379999 C3.51237676,16.7379999 2.83578819,16.0614113 2.83578819,15.2494923 C2.83578819,14.4375733 3.51237676,13.7609848 4.32429573,13.7609848 C5.1362147,13.7609848 5.81280327,14.4375733 5.81280327,15.2494923 C5.81280327,16.0613796 5.17005523,16.7379999 4.32429573,16.7379999 Z"
                                id="Shape"
                                fill="#55C0EB"
                                transform="translate(4.324296, 15.249461) scale(-1, 1) rotate(-14.000000) translate(-4.324296, -15.249461) "
                            />
                            <path
                                d="M6.94286264,1.13509202e-12 L7.55543318,1.26918258 C7.88493794,1.3193558 8.16934944,1.39556363 8.44426493,1.50734432 L9.57376061,0.704946987 L10.9310689,1.75453391 L10.4624121,3.07695111 C10.6636642,3.32139156 10.819823,3.59186662 10.9308886,3.88837629 L12.3199932,4.10815223 L12.550308,5.80840915 L11.2811255,6.4209797 C11.2309522,6.75048446 11.1547444,7.03489595 11.0429637,7.30981145 L11.8453521,8.43934045 L10.7957652,9.79664874 L9.47334799,9.32799191 C9.22890754,9.52924402 8.95843249,9.68540287 8.66192282,9.79646845 L8.40658294,11.1760438 L6.70632602,11.4063586 L6.09375547,10.137176 C5.76425072,10.0870028 5.47983922,10.0107949 5.20492373,9.89901423 L4.07539472,10.7014026 L2.71808643,9.65181572 L3.18674326,8.32939851 C2.98549115,8.08495806 2.8293323,7.814483 2.71826672,7.51797334 L1.37429761,7.27213839 L1.14398281,5.57188147 L2.41315646,4.95934425 C2.46332968,4.62983949 2.53953751,4.345428 2.65131821,4.0705125 L1.8489298,2.94098349 L2.89851672,1.58367521 L4.22093393,2.05233204 C4.46537438,1.85107993 4.73584943,1.69492108 5.0323591,1.5838555 L5.24261465,0.230281463 L6.94286264,1.13509202e-12 Z M6.66506652,4.30769806 C5.87777996,4.40157658 5.33870143,5.1335433 5.44210928,5.88526592 C5.53603007,6.67252808 6.23243285,7.20207728 7.01971941,7.10819875 C7.80697264,7.0143113 8.34606009,6.28231125 8.24264331,5.53062196 C8.14875586,4.74336873 7.41675581,4.20428128 6.66506652,4.30769806 Z"
                                id="Combined-Shape"
                                fill="#01B6F5"
                            />
                            <path
                                d="M7.75982356,3.47833314 C6.50837428,2.96304673 5.10972004,3.55193562 4.59443363,4.8033849 C4.07914723,6.05483417 4.66803612,7.45348842 5.91948539,7.96877482 C7.17093467,8.48406122 8.56958891,7.89517234 9.08487532,6.64372306 C9.56337773,5.39230829 8.97445434,3.95683555 7.75982356,3.47833314 Z M6.28753232,7.0118045 C5.55140396,6.71736005 5.22014102,5.8707762 5.51458546,5.17146633 C5.8090299,4.43533797 6.65561376,4.10407503 7.35492362,4.39851947 C8.0910865,4.69296392 8.42234944,5.53951326 8.12790499,6.23885764 C7.83342604,6.974986 7.02369519,7.30624894 6.28753232,7.0118045 Z"
                                id="Shape"
                                fill="#009ACF"
                                transform="translate(6.829573, 5.723554) scale(-1, 1) rotate(-15.000000) translate(-6.829573, -5.723554) "
                            />
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    );
};

AdvancedSettings.propTypes = {
    className: PropTypes.string,
    style: PropTypes.object,
};

AdvancedSettings.defaultProps = {
    className: undefined,
    style: undefined,
};

export default AdvancedSettings;
