const PageTable = require('../../../src/components/Table/pageObject');
const { SHIFT_KEY_UNICODE } = require('../../constants');
const holdDownKey = require('../../helpers/holdDownKey');
const releaseKey = require('../../helpers/releaseKey');

const TABLE = '#table-5';

describe('Table with selection', () => {
    beforeAll(async () => {
        await browser.url('/#!/Table/5');
    });
    beforeEach(async () => {
        await browser.refresh();
        const component = await $(TABLE);
        await component.waitForExist();
    });

    it('should select and then deselect a row', async () => {
        const table = new PageTable(TABLE);
        await table.waitUntilDataIsLoaded();
        const row5 = await table.getRow(4);
        await expect(await row5.isRowSelected()).toBe(false);
        await row5.selectRow();
        await expect(await row5.isRowSelected()).toBe(true);
        await row5.deselectRow();
        await expect(await row5.isRowSelected()).toBe(false);
    });
    it('should select all rows', async () => {
        const table = new PageTable(TABLE);
        await table.waitUntilDataIsLoaded();
        const row1 = await table.getRow(0);
        const row2 = await table.getRow(1);
        const row3 = await table.getRow(2);
        const row4 = await table.getRow(3);
        const row5 = await table.getRow(4);
        const row6 = await table.getRow(5);
        const row7 = await table.getRow(6);
        await expect(await row1.isRowSelected()).toBe(false);
        await expect(await row2.isRowSelected()).toBe(false);
        await expect(await row3.isRowSelected()).toBe(false);
        await expect(await row4.isRowSelected()).toBe(false);
        await expect(await row5.isRowSelected()).toBe(false);
        await expect(await row6.isRowSelected()).toBe(false);
        await expect(await row7.isRowSelected()).toBe(false);
        await table.selectAllRows();
        await expect(await row1.isRowSelected()).toBe(true);
        await expect(await row2.isRowSelected()).toBe(true);
        await expect(await row3.isRowSelected()).toBe(true);
        await expect(await row4.isRowSelected()).toBe(true);
        await expect(await row5.isRowSelected()).toBe(true);
        await expect(await row6.isRowSelected()).toBe(true);
        await expect(await row7.isRowSelected()).toBe(true);
    });
    it('should deselect all rows', async () => {
        const table = new PageTable(TABLE);
        await table.waitUntilDataIsLoaded();
        const row1 = await table.getRow(0);
        const row2 = await table.getRow(1);
        const row3 = await table.getRow(2);
        const row4 = await table.getRow(3);
        const row5 = await table.getRow(4);
        const row6 = await table.getRow(5);
        const row7 = await table.getRow(6);
        await table.selectAllRows();
        await table.deselectAllRows();
        await expect(await row1.isRowSelected()).toBe(false);
        await expect(await row2.isRowSelected()).toBe(false);
        await expect(await row3.isRowSelected()).toBe(false);
        await expect(await row4.isRowSelected()).toBe(false);
        await expect(await row5.isRowSelected()).toBe(false);
        await expect(await row6.isRowSelected()).toBe(false);
        await expect(await row7.isRowSelected()).toBe(false);
    });
    it('should select the second and fifth row', async () => {
        const table = new PageTable(TABLE);
        await table.waitUntilDataIsLoaded();
        const row1 = await table.getRow(0);
        const row2 = await table.getRow(1);
        const row3 = await table.getRow(2);
        const row4 = await table.getRow(3);
        const row5 = await table.getRow(4);
        const row6 = await table.getRow(5);
        const row7 = await table.getRow(6);
        await row2.selectRow();
        await row5.selectRow();
        await expect(await row1.isRowSelected()).toBe(false);
        await expect(await row2.isRowSelected()).toBe(true);
        await expect(await row3.isRowSelected()).toBe(false);
        await expect(await row4.isRowSelected()).toBe(false);
        await expect(await row5.isRowSelected()).toBe(true);
        await expect(await row6.isRowSelected()).toBe(false);
        await expect(await row7.isRowSelected()).toBe(false);
    });
    it('should deselect all rows when the second and fifth row are selected and then deselect all rows', async () => {
        const table = new PageTable(TABLE);
        await table.waitUntilDataIsLoaded();
        const row1 = await table.getRow(0);
        const row2 = await table.getRow(1);
        const row3 = await table.getRow(2);
        const row4 = await table.getRow(3);
        const row5 = await table.getRow(4);
        const row6 = await table.getRow(5);
        const row7 = await table.getRow(6);
        await row2.selectRow();
        await row5.selectRow();
        await table.deselectAllRows();
        await expect(await row1.isRowSelected()).toBe(false);
        await expect(await row2.isRowSelected()).toBe(false);
        await expect(await row3.isRowSelected()).toBe(false);
        await expect(await row4.isRowSelected()).toBe(false);
        await expect(await row5.isRowSelected()).toBe(false);
        await expect(await row6.isRowSelected()).toBe(false);
        await expect(await row7.isRowSelected()).toBe(false);
    });
    it('should select all rows between selected rows while press shift key', async () => {
        const table = new PageTable(TABLE);
        await table.waitUntilDataIsLoaded();
        const row1 = await table.getRow(0);
        const row2 = await table.getRow(1);
        const row3 = await table.getRow(2);
        const row4 = await table.getRow(3);
        const row5 = await table.getRow(4);
        const row6 = await table.getRow(5);
        const row7 = await table.getRow(6);
        await row1.selectRow();
        await holdDownKey(SHIFT_KEY_UNICODE);
        await row5.selectRow();
        await releaseKey(SHIFT_KEY_UNICODE);
        await expect(await row1.isRowSelected()).toBe(true);
        await expect(await row2.isRowSelected()).toBe(true);
        await expect(await row3.isRowSelected()).toBe(true);
        await expect(await row4.isRowSelected()).toBe(true);
        await expect(await row5.isRowSelected()).toBe(true);
        await expect(await row6.isRowSelected()).toBe(false);
        await expect(await row7.isRowSelected()).toBe(false);
    });
    it('should deselect all rows between the two rows deselected while press shift key', async () => {
        const table = new PageTable(TABLE);
        await table.waitUntilDataIsLoaded();
        const row1 = await table.getRow(0);
        const row2 = await table.getRow(1);
        const row3 = await table.getRow(2);
        const row4 = await table.getRow(3);
        const row5 = await table.getRow(4);
        const row6 = await table.getRow(5);
        const row7 = await table.getRow(6);
        await table.selectAllRows();
        await row1.deselectRow();
        await holdDownKey(SHIFT_KEY_UNICODE);
        await row4.deselectRow();
        await releaseKey(SHIFT_KEY_UNICODE);
        await expect(await row1.isRowSelected()).toBe(false);
        await expect(await row2.isRowSelected()).toBe(false);
        await expect(await row3.isRowSelected()).toBe(false);
        await expect(await row4.isRowSelected()).toBe(false);
        await expect(await row5.isRowSelected()).toBe(true);
        await expect(await row6.isRowSelected()).toBe(true);
        await expect(await row7.isRowSelected()).toBe(true);
    });
});
